"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReleaseLabel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const python_version_1 = require("./python-version");
const scala_version_1 = require("./scala-version");
const spark_version_1 = require("./spark-version");
class ReleaseLabel {
    constructor(label, sparkVersion, pythonVersion, scalaVersion) {
        this.label = label;
        this.sparkVersion = sparkVersion;
        this.pythonVersion = pythonVersion;
        this.scalaVersion = scalaVersion;
    }
    get majorVersion() {
        return Number(this.label.split("-")[1].split(".")[0]);
    }
}
exports.ReleaseLabel = ReleaseLabel;
_a = ReleaseLabel, _b = JSII_RTTI_SYMBOL_1;
ReleaseLabel[_b] = { fqn: "@packyak/aws-cdk.ReleaseLabel", version: "0.4.20" };
ReleaseLabel.EMR_7_0_0 = new _a("emr-7.0.0", new spark_version_1.SparkVersion("3.5.0"), new python_version_1.PythonVersion("3.9"), new scala_version_1.ScalaVersion("2.12.17"));
ReleaseLabel.EMR_6_15_0 = new _a("emr-6.15.0", new spark_version_1.SparkVersion("3.4.1"), new python_version_1.PythonVersion("3.7"), new scala_version_1.ScalaVersion("2.12.17"));
ReleaseLabel.EMR_6 = _a.EMR_6_15_0;
ReleaseLabel.LATEST = _a.EMR_7_0_0;
//# sourceMappingURL=data:application/json;base64,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