"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UniformCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cluster_1 = require("./cluster");
const managed_scaling_1 = require("./managed-scaling");
/**
 * Creates an EMR Cluster that is comprised of {@link InstanceGroup}s.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-cluster-jobflowinstancesconfig.html
 * @see https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-uniform-instance-group.html
 * @see https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-instances-guidelines.html
 */
class UniformCluster extends cluster_1.Cluster {
    constructor(scope, id, props) {
        if (props.managedScalingPolicy) {
            if (props.managedScalingPolicy.computeLimits.unitType ===
                managed_scaling_1.ComputeUnit.INSTANCE_FLEET_UNITS) {
                throw new Error(`Uniform Clusters must use either Instances or VCPU as ComputeLimitsUnitType`);
            }
        }
        super(scope, id, props);
    }
}
exports.UniformCluster = UniformCluster;
_a = JSII_RTTI_SYMBOL_1;
UniformCluster[_a] = { fqn: "@packyak/aws-cdk.UniformCluster", version: "0.4.20" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidW5pZm9ybS1jbHVzdGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2Vtci91bmlmb3JtLWNsdXN0ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSx1Q0FBMkQ7QUFFM0QsdURBQWdEO0FBNkJoRDs7Ozs7O0dBTUc7QUFDSCxNQUFhLGNBQWUsU0FBUSxpQkFBTztJQUN6QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTBCO1FBQ2xFLElBQUksS0FBSyxDQUFDLG9CQUFvQixFQUFFLENBQUM7WUFDL0IsSUFDRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsYUFBYSxDQUFDLFFBQVE7Z0JBQ2pELDZCQUFXLENBQUMsb0JBQW9CLEVBQ2hDLENBQUM7Z0JBQ0QsTUFBTSxJQUFJLEtBQUssQ0FDYiw2RUFBNkUsQ0FDOUUsQ0FBQztZQUNKLENBQUM7UUFDSCxDQUFDO1FBQ0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDMUIsQ0FBQzs7QUFiSCx3Q0FjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyB0eXBlIEJhc2VDbHVzdGVyUHJvcHMsIENsdXN0ZXIgfSBmcm9tIFwiLi9jbHVzdGVyXCI7XG5pbXBvcnQgdHlwZSB7IEluc3RhbmNlR3JvdXAsIFByaW1hcnlJbnN0YW5jZUdyb3VwIH0gZnJvbSBcIi4vaW5zdGFuY2UtZ3JvdXBcIjtcbmltcG9ydCB7IENvbXB1dGVVbml0IH0gZnJvbSBcIi4vbWFuYWdlZC1zY2FsaW5nXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgVW5pZm9ybUNsdXN0ZXJQcm9wcyBleHRlbmRzIEJhc2VDbHVzdGVyUHJvcHMge1xuICAvKipcbiAgICogRGVzY3JpYmVzIHRoZSBFQzIgaW5zdGFuY2VzIGFuZCBpbnN0YW5jZSBjb25maWd1cmF0aW9ucyBmb3IgdGhlIHByaW1hcnkge0BsaW5rIEluc3RhbmNlR3JvdXB9LlxuICAgKlxuICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZW1yLWNsdXN0ZXItam9iZmxvd2luc3RhbmNlc2NvbmZpZy5odG1sI2Nmbi1lbXItY2x1c3Rlci1qb2JmbG93aW5zdGFuY2VzY29uZmlnLW1hc3Rlcmluc3RhbmNlZ3JvdXBcbiAgICovXG4gIHJlYWRvbmx5IHByaW1hcnlJbnN0YW5jZUdyb3VwOiBQcmltYXJ5SW5zdGFuY2VHcm91cDtcbiAgLyoqXG4gICAqIERlc2NyaWJlcyB0aGUgRUMyIGluc3RhbmNlcyBhbmQgaW5zdGFuY2UgY29uZmlndXJhdGlvbnMgZm9yIGNvcmUge0BsaW5rIEluc3RhbmNlR3JvdXB9cy5cbiAgICpcbiAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWVtci1jbHVzdGVyLWpvYmZsb3dpbnN0YW5jZXNjb25maWcuaHRtbCNjZm4tZW1yLWNsdXN0ZXItam9iZmxvd2luc3RhbmNlc2NvbmZpZy1jb3JlaW5zdGFuY2Vncm91cFxuICAgKi9cbiAgcmVhZG9ubHkgY29yZUluc3RhbmNlR3JvdXA6IEluc3RhbmNlR3JvdXA7XG4gIC8qKlxuICAgKiBEZXNjcmliZXMgdGhlIEVDMiBpbnN0YW5jZXMgYW5kIGluc3RhbmNlIGNvbmZpZ3VyYXRpb25zIGZvciB0YXNrIHtAbGluayBJbnN0YW5jZUdyb3VwfXMuXG4gICAqXG4gICAqIFRoZXNlIHRhc2sge0BsaW5rIEluc3RhbmNlR3JvdXB9cyBhcmUgYWRkZWQgdG8gdGhlIGNsdXN0ZXIgYXMgcGFydCBvZiB0aGUgY2x1c3RlciBsYXVuY2guXG4gICAqIEVhY2ggdGFzayB7QGxpbmsgSW5zdGFuY2VHcm91cH0gbXVzdCBoYXZlIGEgdW5pcXVlIG5hbWUgc3BlY2lmaWVkIHNvIHRoYXQgQ2xvdWRGb3JtYXRpb25cbiAgICogY2FuIGRpZmZlcmVudGlhdGUgYmV0d2VlbiB0aGUgdGFzayB7QGxpbmsgSW5zdGFuY2VHcm91cH1zLlxuICAgKlxuICAgKiA+IEFmdGVyIGNyZWF0aW5nIHRoZSBjbHVzdGVyLCB5b3UgY2FuIG9ubHkgbW9kaWZ5IHRoZSBtdXRhYmxlIHByb3BlcnRpZXMgb2YgYEluc3RhbmNlR3JvdXBDb25maWdgICwgd2hpY2ggYXJlIGBBdXRvU2NhbGluZ1BvbGljeWAgYW5kIGBJbnN0YW5jZUNvdW50YCAuIE1vZGlmeWluZyBhbnkgb3RoZXIgcHJvcGVydHkgcmVzdWx0cyBpbiBjbHVzdGVyIHJlcGxhY2VtZW50LlxuICAgKlxuICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZW1yLWNsdXN0ZXItam9iZmxvd2luc3RhbmNlc2NvbmZpZy5odG1sI2Nmbi1lbXItY2x1c3Rlci1qb2JmbG93aW5zdGFuY2VzY29uZmlnLXRhc2tpbnN0YW5jZWdyb3Vwc1xuICAgKi9cbiAgcmVhZG9ubHkgdGFza0luc3RhbmNlR3JvdXBzPzogSW5zdGFuY2VHcm91cFtdO1xufVxuXG4vKipcbiAqIENyZWF0ZXMgYW4gRU1SIENsdXN0ZXIgdGhhdCBpcyBjb21wcmlzZWQgb2Yge0BsaW5rIEluc3RhbmNlR3JvdXB9cy5cbiAqXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWVtci1jbHVzdGVyLWpvYmZsb3dpbnN0YW5jZXNjb25maWcuaHRtbFxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZW1yL2xhdGVzdC9NYW5hZ2VtZW50R3VpZGUvZW1yLXVuaWZvcm0taW5zdGFuY2UtZ3JvdXAuaHRtbFxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZW1yL2xhdGVzdC9NYW5hZ2VtZW50R3VpZGUvZW1yLXBsYW4taW5zdGFuY2VzLWd1aWRlbGluZXMuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgVW5pZm9ybUNsdXN0ZXIgZXh0ZW5kcyBDbHVzdGVyIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFVuaWZvcm1DbHVzdGVyUHJvcHMpIHtcbiAgICBpZiAocHJvcHMubWFuYWdlZFNjYWxpbmdQb2xpY3kpIHtcbiAgICAgIGlmIChcbiAgICAgICAgcHJvcHMubWFuYWdlZFNjYWxpbmdQb2xpY3kuY29tcHV0ZUxpbWl0cy51bml0VHlwZSA9PT1cbiAgICAgICAgQ29tcHV0ZVVuaXQuSU5TVEFOQ0VfRkxFRVRfVU5JVFNcbiAgICAgICkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgICAgYFVuaWZvcm0gQ2x1c3RlcnMgbXVzdCB1c2UgZWl0aGVyIEluc3RhbmNlcyBvciBWQ1BVIGFzIENvbXB1dGVMaW1pdHNVbml0VHlwZWAsXG4gICAgICAgICk7XG4gICAgICB9XG4gICAgfVxuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuICB9XG59XG4iXX0=