"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.exportRequirementsSync = void 0;
const fs = require("fs");
const child_process_1 = require("child_process");
const path = require("path");
function exportRequirementsSync(dir, options) {
    const requirements = path.join(dir, "requirements.txt");
    const command = [
        "poetry export -f requirements.txt",
        arg("with", options?.include),
        arg("without", options?.exclude),
        arg("without-urls", options?.withoutUrls),
        arg("without-hashes", options?.withoutHashes ?? true),
        arg("dev", options?.dev),
        arg("all-extras", options?.allExtras),
        `> ${requirements}`,
    ];
    fs.mkdirSync(dir, { recursive: true });
    (0, child_process_1.execSync)(command.join(" "));
    return requirements;
    function arg(flag, value) {
        if (value === undefined) {
            return "";
        }
        else if (typeof value === "boolean") {
            return value ? ` --${flag}` : "";
        }
        else {
            return ` --${flag}=${Array.isArray(value) ? value.join(",") : value}`;
        }
    }
}
exports.exportRequirementsSync = exportRequirementsSync;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhwb3J0LXJlcXVpcmVtZW50cy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9leHBvcnQtcmVxdWlyZW1lbnRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHlCQUF5QjtBQUN6QixpREFBeUM7QUFDekMsNkJBQTZCO0FBRzdCLFNBQWdCLHNCQUFzQixDQUNwQyxHQUFXLEVBQ1gsT0FBMEI7SUFFMUIsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztJQUN4RCxNQUFNLE9BQU8sR0FBRztRQUNkLG1DQUFtQztRQUNuQyxHQUFHLENBQUMsTUFBTSxFQUFFLE9BQU8sRUFBRSxPQUFPLENBQUM7UUFDN0IsR0FBRyxDQUFDLFNBQVMsRUFBRSxPQUFPLEVBQUUsT0FBTyxDQUFDO1FBQ2hDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsT0FBTyxFQUFFLFdBQVcsQ0FBQztRQUN6QyxHQUFHLENBQUMsZ0JBQWdCLEVBQUUsT0FBTyxFQUFFLGFBQWEsSUFBSSxJQUFJLENBQUM7UUFDckQsR0FBRyxDQUFDLEtBQUssRUFBRSxPQUFPLEVBQUUsR0FBRyxDQUFDO1FBQ3hCLEdBQUcsQ0FBQyxZQUFZLEVBQUUsT0FBTyxFQUFFLFNBQVMsQ0FBQztRQUNyQyxLQUFLLFlBQVksRUFBRTtLQUNwQixDQUFDO0lBRUYsRUFBRSxDQUFDLFNBQVMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztJQUN2QyxJQUFBLHdCQUFRLEVBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQzVCLE9BQU8sWUFBWSxDQUFDO0lBRXBCLFNBQVMsR0FBRyxDQUNWLElBQVksRUFDWixLQUFvQjtRQUVwQixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUUsQ0FBQztZQUN4QixPQUFPLEVBQUUsQ0FBQztRQUNaLENBQUM7YUFBTSxJQUFJLE9BQU8sS0FBSyxLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQ3RDLE9BQU8sS0FBSyxDQUFDLENBQUMsQ0FBQyxNQUFNLElBQUksRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7UUFDbkMsQ0FBQzthQUFNLENBQUM7WUFDTixPQUFPLE1BQU0sSUFBSSxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ3hFLENBQUM7SUFDSCxDQUFDO0FBQ0gsQ0FBQztBQWhDRCx3REFnQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBmcyBmcm9tIFwiZnNcIjtcbmltcG9ydCB7IGV4ZWNTeW5jIH0gZnJvbSBcImNoaWxkX3Byb2Nlc3NcIjtcbmltcG9ydCAqIGFzIHBhdGggZnJvbSBcInBhdGhcIjtcbmltcG9ydCB0eXBlIHsgUHl0aG9uUG9ldHJ5QXJncyB9IGZyb20gXCIuL3B5dGhvbi1wb2V0cnlcIjtcblxuZXhwb3J0IGZ1bmN0aW9uIGV4cG9ydFJlcXVpcmVtZW50c1N5bmMoXG4gIGRpcjogc3RyaW5nLFxuICBvcHRpb25zPzogUHl0aG9uUG9ldHJ5QXJncyxcbik6IHN0cmluZyB7XG4gIGNvbnN0IHJlcXVpcmVtZW50cyA9IHBhdGguam9pbihkaXIsIFwicmVxdWlyZW1lbnRzLnR4dFwiKTtcbiAgY29uc3QgY29tbWFuZCA9IFtcbiAgICBcInBvZXRyeSBleHBvcnQgLWYgcmVxdWlyZW1lbnRzLnR4dFwiLFxuICAgIGFyZyhcIndpdGhcIiwgb3B0aW9ucz8uaW5jbHVkZSksXG4gICAgYXJnKFwid2l0aG91dFwiLCBvcHRpb25zPy5leGNsdWRlKSxcbiAgICBhcmcoXCJ3aXRob3V0LXVybHNcIiwgb3B0aW9ucz8ud2l0aG91dFVybHMpLFxuICAgIGFyZyhcIndpdGhvdXQtaGFzaGVzXCIsIG9wdGlvbnM/LndpdGhvdXRIYXNoZXMgPz8gdHJ1ZSksXG4gICAgYXJnKFwiZGV2XCIsIG9wdGlvbnM/LmRldiksXG4gICAgYXJnKFwiYWxsLWV4dHJhc1wiLCBvcHRpb25zPy5hbGxFeHRyYXMpLFxuICAgIGA+ICR7cmVxdWlyZW1lbnRzfWAsXG4gIF07XG5cbiAgZnMubWtkaXJTeW5jKGRpciwgeyByZWN1cnNpdmU6IHRydWUgfSk7XG4gIGV4ZWNTeW5jKGNvbW1hbmQuam9pbihcIiBcIikpO1xuICByZXR1cm4gcmVxdWlyZW1lbnRzO1xuXG4gIGZ1bmN0aW9uIGFyZzxUIGV4dGVuZHMgc3RyaW5nW10gfCBzdHJpbmcgfCBib29sZWFuIHwgbnVtYmVyPihcbiAgICBmbGFnOiBzdHJpbmcsXG4gICAgdmFsdWU6IFQgfCB1bmRlZmluZWQsXG4gICkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXR1cm4gXCJcIjtcbiAgICB9IGVsc2UgaWYgKHR5cGVvZiB2YWx1ZSA9PT0gXCJib29sZWFuXCIpIHtcbiAgICAgIHJldHVybiB2YWx1ZSA/IGAgLS0ke2ZsYWd9YCA6IFwiXCI7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiBgIC0tJHtmbGFnfT0ke0FycmF5LmlzQXJyYXkodmFsdWUpID8gdmFsdWUuam9pbihcIixcIikgOiB2YWx1ZX1gO1xuICAgIH1cbiAgfVxufVxuIl19