"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NessieECSCatalog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecr_assets_1 = require("aws-cdk-lib/aws-ecr-assets");
const aws_ecs_1 = require("aws-cdk-lib/aws-ecs");
const aws_ecs_patterns_1 = require("aws-cdk-lib/aws-ecs-patterns");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const base_nessie_catalog_1 = require("./base-nessie-catalog");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
class NessieECSCatalog extends base_nessie_catalog_1.BaseNessieCatalog {
    constructor(scope, id, props) {
        super(scope, id, props);
        const platform = props?.platform ?? aws_ecr_assets_1.Platform.LINUX_AMD64;
        const taskRole = new aws_iam_1.Role(this, "TaskRole", {
            assumedBy: new aws_iam_1.ServicePrincipal("ecs-tasks.amazonaws.com"),
        });
        // TODO: logs
        this.grantPrincipal = taskRole;
        this.logGroup =
            props.logGroup ??
                new aws_logs_1.LogGroup(this, "LogGroup", {
                    logGroupName: `/nessie/${this.catalogName}`,
                });
        this.service = new aws_ecs_patterns_1.ApplicationLoadBalancedFargateService(this, "Service", {
            cluster: props?.cluster,
            vpc: props.vpc,
            serviceName: props.serviceName,
            runtimePlatform: {
                cpuArchitecture: platform === aws_ecr_assets_1.Platform.LINUX_AMD64
                    ? aws_ecs_1.CpuArchitecture.X86_64
                    : aws_ecs_1.CpuArchitecture.ARM64,
                operatingSystemFamily: aws_ecs_1.OperatingSystemFamily.LINUX,
            },
            cpu: props?.cpu ?? 256,
            memoryLimitMiB: props?.memoryLimitMiB ?? 512,
            publicLoadBalancer: props?.publicLoadBalancer,
            certificate: props?.dns?.certificate,
            domainName: props?.dns?.domainName,
            domainZone: props?.dns?.hostedZone,
            taskImageOptions: {
                ...(props?.taskImageOptions ?? {}),
                environment: {
                    ...this.configAsEnvVars(),
                    ...props?.taskImageOptions?.environment,
                },
                logDriver: aws_ecs_1.AwsLogDriver.awsLogs({
                    streamPrefix: "nessie",
                    logGroup: this.logGroup,
                }),
                containerPort: props?.taskImageOptions?.containerPort ?? 19120,
                taskRole,
                image: props?.taskImageOptions?.image ??
                    aws_ecs_1.ContainerImage.fromRegistry("ghcr.io/projectnessie/nessie"),
            },
        });
        // this.service.loadBalancer.addListener("HTTPS", {
        //   port: 443,
        //   protocol: ApplicationProtocol.HTTPS,
        // });
        this.versionStore.grantReadWriteData(taskRole);
        this.service.targetGroup.configureHealthCheck({
            // uses smallrye-health:
            // see: https://redhat-developer-demos.github.io/quarkus-tutorial/quarkus-tutorial/health.html
            path: "/q/health",
        });
        if (props?.dns) {
            this.endpoint = `https://${props.dns.domainName}`;
        }
        else {
            this.endpoint = `http://${this.service.loadBalancer.loadBalancerDnsName}`;
        }
    }
}
exports.NessieECSCatalog = NessieECSCatalog;
_a = JSII_RTTI_SYMBOL_1;
NessieECSCatalog[_a] = { fqn: "@packyak/aws-cdk.NessieECSCatalog", version: "0.4.20" };
//# sourceMappingURL=data:application/json;base64,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