"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NessieLambdaCatalog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const path = require("path");
const base_nessie_catalog_1 = require("./base-nessie-catalog");
class NessieLambdaCatalog extends base_nessie_catalog_1.BaseNessieCatalog {
    constructor(scope, id, props) {
        super(scope, id, props);
        // TODO: none of this is right
        // see: https://project-nessie.zulipchat.com/#narrow/stream/371187-general/topic/AWS.20Lambda.20with.20SnapStart
        this.function = new aws_lambda_1.Function(this, "Function", {
            runtime: aws_lambda_1.Runtime.JAVA_17,
            snapStart: aws_lambda_1.SnapStartConf.ON_PUBLISHED_VERSIONS,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, "lambda")),
            handler: "io.quarkus.amazon.lambda.runtime.QuarkusStreamHandler::handleRequest",
        });
        this.functionUrl = this.function.addFunctionUrl({
            authType: aws_lambda_1.FunctionUrlAuthType.AWS_IAM,
            // TODO: what's right here? Maybe streaming?
            invokeMode: aws_lambda_1.InvokeMode.BUFFERED,
        });
        this.endpoint = this.functionUrl.url;
    }
}
exports.NessieLambdaCatalog = NessieLambdaCatalog;
_a = JSII_RTTI_SYMBOL_1;
NessieLambdaCatalog[_a] = { fqn: "@packyak/aws-cdk.NessieLambdaCatalog", version: "0.4.20" };
//# sourceMappingURL=data:application/json;base64,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