"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBNessieVersionStore = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_dynamodb_1 = require("aws-cdk-lib/aws-dynamodb");
const core_1 = require("aws-cdk-lib/core");
const constructs_1 = require("constructs");
/**
 * @see https://projectnessie.org/try/configuration/#dynamodb-version-store-settings
 */
class DynamoDBNessieVersionStore extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.tablePrefix = props?.versionStoreName ?? "nessie";
        this.objs = new NessieVersionStoreTable(this, "objs", {
            tableName: `${this.tablePrefix}_objs`,
            removalPolicy: props?.removalPolicy,
        });
        this.refs = new NessieVersionStoreTable(this, "refs", {
            tableName: `${this.tablePrefix}_refs`,
            removalPolicy: props?.removalPolicy,
        });
    }
    grantReadData(grantee) {
        this.objs.grantReadData(grantee);
        this.refs.grantReadData(grantee);
    }
    grantWriteData(grantee) {
        this.objs.grantWriteData(grantee);
        this.refs.grantWriteData(grantee);
    }
    grantReadWriteData(grantee) {
        this.objs.grantReadWriteData(grantee);
        this.refs.grantReadWriteData(grantee);
    }
}
exports.DynamoDBNessieVersionStore = DynamoDBNessieVersionStore;
_a = JSII_RTTI_SYMBOL_1;
DynamoDBNessieVersionStore[_a] = { fqn: "@packyak/aws-cdk.DynamoDBNessieVersionStore", version: "0.4.20" };
class NessieVersionStoreTable extends aws_dynamodb_1.Table {
    constructor(scope, id, props) {
        super(scope, id, {
            tableName: props.tableName,
            partitionKey: {
                name: "k",
                type: aws_dynamodb_1.AttributeType.STRING,
            },
            billingMode: aws_dynamodb_1.BillingMode.PAY_PER_REQUEST,
        });
        this.applyRemovalPolicy(props.removalPolicy ?? core_1.RemovalPolicy.DESTROY);
    }
}
//# sourceMappingURL=data:application/json;base64,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