"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackYakResource = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
class PackYakResource extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            code: props.code,
            architecture: props.architecture ?? aws_lambda_1.Architecture.ARM_64,
            runtime: props.runtime ?? aws_lambda_1.Runtime.NODEJS_20_X,
            handler: props.handler ?? "index.handler",
            timeout: props.timeout ?? aws_cdk_lib_1.Duration.minutes(1),
            environment: {
                NODE_OPTIONS: "--enable-source-maps",
                ...props.environment,
            },
        });
        const provider = new custom_resources_1.Provider(this, "CreateUsers", {
            onEventHandler: this,
        });
        new aws_cdk_lib_1.CustomResource(this, "Users", {
            serviceToken: provider.serviceToken,
            resourceType: "Custom::CreateUsers",
            properties: props.properties,
        });
    }
}
exports.PackYakResource = PackYakResource;
//# sourceMappingURL=data:application/json;base64,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