import { Connections, IConnectable, IVpc, SecurityGroup, SubnetSelection } from "aws-cdk-lib/aws-ec2";
import { IGrantable, IPrincipal, IRole } from "aws-cdk-lib/aws-iam";
import { CfnDomain } from "aws-cdk-lib/aws-sagemaker";
import { RemovalPolicy, Resource } from "aws-cdk-lib/core";
import { Construct } from "constructs";
import { SageMakerImage } from "./sage-maker-image";
import { UserProfile } from "./user-profile";
export declare enum AuthMode {
    SSO = "SSO",
    IAM = "IAM"
}
export declare enum AppNetworkAccessType {
    VPC_ONLY = "VpcOnly",
    PUBLIC_INTERNET_ONLY = "PublicInternetOnly"
}
export interface DefaultUserSettings {
    /**
     * The execution role for the user.
     */
    readonly executionRole?: IRole;
    /**
     * Whether users can access the Studio by default.
     *
     * @default true
     */
    readonly studioWebPortal?: boolean;
}
export interface DomainProps {
    /**
     * The authentication mode for the domain.
     *
     * @default AuthMode.SSO
     */
    readonly authMode?: AuthMode;
    /**
     * The name of the domain to create.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainname
     */
    readonly domainName: string;
    /**
     * The VPC where the Domain (and its resources) will be deployed to.
     */
    readonly vpc: IVpc;
    /**
     * The subnets to deploy the Domain to.
     *
     * @default SubnetSelection.PrimaryContainer
     */
    readonly subnetSelection?: SubnetSelection;
    /**
     * Specifies the VPC used for non-EFS traffic.
     *
     * @default AppNetworkAccessType.VpcOnly
     */
    readonly appNetworkAccessType?: AppNetworkAccessType;
    /**
     * The default settings for user profiles in the domain.
     */
    readonly defaultUserSettings?: DefaultUserSettings;
    /**
     * The default image for user profiles in the domain.
     *
     * @default {@link SageMakerImage.CPU_V1}
     */
    readonly defaultImage?: SageMakerImage;
    /**
     * @default {@link RemovalPolicy.DESTROY}
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * The security group for SageMaker to use.
     */
    readonly sageMakerSg?: SecurityGroup;
}
export declare class Domain extends Resource implements IConnectable, IGrantable {
    readonly domainId: string;
    readonly domainArn: string;
    readonly domainUrl: string;
    readonly homeEfsFileSystemId: string;
    readonly homeEfsFileSystemArn: string;
    readonly singleSignOnManagedApplicationInstanceId: string;
    readonly singleSignOnApplicationArn: string;
    protected readonly resource: CfnDomain;
    private readonly users;
    readonly sageMakerSg: SecurityGroup;
    readonly connections: Connections;
    readonly grantPrincipal: IPrincipal;
    constructor(scope: Construct, id: string, props: DomainProps);
    grantGlueInteractiveSession(grantee: IGrantable): void;
    private cleanup;
    /**
     * Creates a CustomResource that will clean up the domain prior to it being destroyed:
     * 1. Delete any running Apps (i.e. instances of a Space)
     * 2. Delete the Domain's spaces.
     * 2. Delete the Domain's EFS file system (first, by deleting any mounted access points, then the FS).
     */
    enableCleanup(removalPolicy: RemovalPolicy): void;
    grantStudioAccess(grantee: IGrantable): void;
    /**
     * Grants access to list and describe clusters in the JupyterNotebook.
     */
    grantEMRClusterAccess(grantee: IGrantable): void;
    grantSageMakerSearch(grantee: IGrantable): void;
    grantListApps(grantee: IGrantable): void;
    grantListSessions(grantee: IGrantable): void;
    grantListTags(grantee: IGrantable): void;
    grantSearchServiceCatalogProducts(grantee: IGrantable): void;
    grantListSpaces(grantee: IGrantable): void;
    grantCreateApp(grantee: IGrantable): void;
    grantCreatePresignedDomainUrl(grantee: IGrantable): void;
    grantCreateSpace(grantee: IGrantable): void;
    grantDeleteApp(grantee: IGrantable): void;
    grantDeleteSpace(grantee: IGrantable): void;
    grantDescribeApp(grantee: IGrantable): void;
    grantDescribeDomain(grantee: IGrantable): void;
    grantDescribeSpace(grantee: IGrantable): void;
    grantDescribeUserProfile(grantee: IGrantable): void;
    grantUpdateSpace(grantee: IGrantable): void;
    private grant;
    addUserProfile(username: string, props?: AddUserProfileProps): UserProfile;
}
export interface AddUserProfileProps {
    readonly executionRole?: IRole;
}
