import { Platform } from "aws-cdk-lib/aws-ecr-assets";
import { ApplicationLoadBalancedFargateService, ApplicationLoadBalancedFargateServiceProps } from "aws-cdk-lib/aws-ecs-patterns";
import { HealthCheck } from "aws-cdk-lib/aws-elasticloadbalancingv2";
import { Construct } from "constructs";
import type { PythonPoetryArgs } from "./python-poetry";
export interface StreamlitSiteProps extends ApplicationLoadBalancedFargateServiceProps {
    /**
     * The {@link LakeHouse} that this Streamlit application will source and contribute data to.
     */
    /**
     * Entrypoint to the streamlit application.
     *
     * @example "my/app.py"
     */
    readonly home: string;
    /**
     * The name of the Dockerfile to use to build this Streamlit site.
     *
     * @default "Dockerfile"
     */
    readonly dockerfile?: string;
    /**
     * The platform to use to build this Streamlit site.
     *
     * @default {@link Platform.LINUX_AMD64}
     */
    readonly platform?: Platform;
    /**
     * Override the {@link HealthCheck} for this Streamlit site.
     *
     * @default /_stcore/health
     * @see https://docs.streamlit.io/knowledge-base/tutorials/deploy/docker
     */
    readonly healthCheck?: HealthCheck;
    /**
     * Override how the `requirements.txt` file is generated with Python Poetry
     *
     * @default - see {@link exportRequirementsSync}
     */
    readonly pythonPoetryArgs?: PythonPoetryArgs;
}
export declare class StreamlitSite extends Construct {
    readonly service: ApplicationLoadBalancedFargateService;
    readonly url: string;
    constructor(scope: Construct, id: string, props: StreamlitSiteProps);
}
