"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamlitSite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ecr_assets_1 = require("aws-cdk-lib/aws-ecr-assets");
const aws_ecs_1 = require("aws-cdk-lib/aws-ecs");
const aws_ecs_patterns_1 = require("aws-cdk-lib/aws-ecs-patterns");
const constructs_1 = require("constructs");
const export_requirements_1 = require("./export-requirements");
const path = require("path");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
class StreamlitSite extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const requirementsPath = (0, export_requirements_1.exportRequirementsSync)(path.join(".packyak", this.node.addr), props.pythonPoetryArgs);
        // enumerate over the module specs to discover what the home and pages/*.py depend on
        // const homeFilePath = path.resolve(props.home);
        // const pagesDirPath = path.join(path.dirname(homeFilePath), "pages");
        // const homeAndPagesModules = props.lakeHouse.spec.modules.flatMap((module) =>
        //   module.file_name === homeFilePath ||
        //   module.file_name.startsWith(path.join(pagesDirPath, ""))
        //     ? [module]
        //     : [],
        // );
        const platform = props.platform ?? aws_ecr_assets_1.Platform.LINUX_AMD64;
        const taskRole = props.taskImageOptions?.taskRole ??
            new aws_iam_1.Role(this, "TaskRole", {
                assumedBy: new aws_iam_1.ServicePrincipal("ecs-tasks.amazonaws.com"),
            });
        const environment = {
            ...props.taskImageOptions?.environment,
        };
        // props.lakeHouse.bind(
        //   {
        //     grantPrincipal: taskRole,
        //     addEnvironment: (key, value) => {
        //       environment[key] = value;
        //     },
        //   },
        //   homeAndPagesModules,
        // );
        this.service = new aws_ecs_patterns_1.ApplicationLoadBalancedFargateService(this, "Service", {
            ...props,
            cluster: props.cluster,
            vpc: props.vpc,
            // cluster: props.lakeHouse.cluster,
            runtimePlatform: {
                cpuArchitecture: platform === aws_ecr_assets_1.Platform.LINUX_AMD64
                    ? aws_ecs_1.CpuArchitecture.X86_64
                    : aws_ecs_1.CpuArchitecture.ARM64,
                operatingSystemFamily: aws_ecs_1.OperatingSystemFamily.LINUX,
            },
            cpu: props.cpu ?? 256,
            memoryLimitMiB: props.memoryLimitMiB ?? 512,
            taskImageOptions: {
                ...(props.taskImageOptions ?? {}),
                environment,
                containerPort: props.taskImageOptions?.containerPort ?? 8501,
                taskRole,
                image: props.taskImageOptions?.image ??
                    aws_ecs_1.ContainerImage.fromAsset(".", {
                        ignoreMode: aws_cdk_lib_1.IgnoreMode.DOCKER,
                        platform,
                        buildArgs: {
                            REQUIREMENTS_PATH: requirementsPath,
                        },
                    }),
            },
        });
        this.service.targetGroup.configureHealthCheck(props.healthCheck ?? {
            path: "/_stcore/health",
        });
        this.url = `https://${this.service.loadBalancer.loadBalancerDnsName}`;
    }
}
exports.StreamlitSite = StreamlitSite;
_a = JSII_RTTI_SYMBOL_1;
StreamlitSite[_a] = { fqn: "@packyak/aws-cdk.StreamlitSite", version: "0.4.20" };
//# sourceMappingURL=data:application/json;base64,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