import { type FileSystem, AccessPoint } from "aws-cdk-lib/aws-efs";
import { Construct } from "constructs";
import { type IGrantable } from "aws-cdk-lib/aws-iam";
import type { Connections, IConnectable } from "aws-cdk-lib/aws-ec2";
import type { PosixGroup } from "./group";
export interface HomeProps {
    /**
     * The file system associated with the user.
     */
    readonly fileSystem: FileSystem;
    /**
     * The username for the user. This should be unique across all users.
     */
    readonly username: string;
    /**
     * The POSIX user ID for the user. This should be a unique identifier.
     */
    readonly uid: string;
    /**
     * The POSIX group ID for the user. This is used for file system permissions.
     *
     * @default - same as the uid
     */
    readonly gid?: string;
    /**
     * Secondary groups to assign to files written to this home directory.
     */
    readonly secondaryGroups?: PosixGroup[];
}
/**
 * A Home directory is a secure directory in a {@link Workspace} only
 * accessible by the User who owns it.
 */
export declare class Home extends Construct implements IConnectable {
    /**
     * The connections for the EFS file system.
     */
    readonly connections: Connections;
    /**
     * An {@link AccessPoint} to the user's home directory
     */
    readonly accessPoint: AccessPoint;
    /**
     * The username of the user.
     *
     * Should match the AWS SSO username.
     */
    readonly username: string;
    /**
     * The POSIX user ID
     */
    readonly uid: string;
    /**
     * The POSIX group ID
     */
    readonly gid: string;
    /**
     * Absolute path to the home directory
     */
    readonly path: string;
    constructor(scope: Construct, id: string, props: HomeProps);
    allowFrom(connectable: IConnectable): void;
    grantRead({ grantPrincipal }: IGrantable): void;
    grantReadWrite({ grantPrincipal }: IGrantable): void;
    grantRootAccess({ grantPrincipal }: IGrantable): void;
    grant({ grantPrincipal }: IGrantable, actions: string[]): void;
}
