"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Home = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_efs_1 = require("aws-cdk-lib/aws-efs");
const constructs_1 = require("constructs");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
/**
 * A Home directory is a secure directory in a {@link Workspace} only
 * accessible by the User who owns it.
 */
class Home extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.username = props.username;
        this.uid = props.uid;
        this.gid = props.gid ?? props.uid;
        this.path = `/home/${props.username}`;
        this.connections = props.fileSystem.connections;
        this.accessPoint = new aws_efs_1.AccessPoint(this, "AccessPoint", {
            fileSystem: props.fileSystem,
            createAcl: {
                ownerGid: this.gid,
                ownerUid: this.uid,
                // locked down for the user
                // user: rwx
                // group: r-x
                // other: ---
                permissions: "750",
            },
            // TODO: this forces all files written through this file system to have this ownership.
            // TODO: is this right? Or should we force consistent username, gid and uid across all EC2 instances?
            posixUser: {
                uid: this.uid,
                gid: this.gid,
                secondaryGids: props.secondaryGroups?.map((g) => `${g.gid}`),
            },
            path: this.path,
        });
    }
    allowFrom(connectable) {
        this.accessPoint.fileSystem.connections.allowDefaultPortFrom(connectable);
    }
    grantRead({ grantPrincipal }) {
        grantPrincipal.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ["elasticfilesystem:DescribeMountTargets"],
            resources: [
                this.accessPoint.fileSystem.fileSystemArn,
                this.accessPoint.accessPointArn,
            ],
        }));
        this.grant(grantPrincipal, ["elasticfilesystem:ClientMount"]);
    }
    grantReadWrite({ grantPrincipal }) {
        this.grantRead({ grantPrincipal });
        this.grant(grantPrincipal, ["elasticfilesystem:ClientWrite"]);
    }
    grantRootAccess({ grantPrincipal }) {
        this.grantReadWrite({ grantPrincipal });
        this.grant(grantPrincipal, ["elasticfilesystem:ClientRootAccess"]);
    }
    grant({ grantPrincipal }, actions) {
        grantPrincipal.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: actions,
            resources: [this.accessPoint.fileSystem.fileSystemArn],
            conditions: {
                // see: https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonelasticfilesystem.html#amazonelasticfilesystem-resources-for-iam-policies
                StringEquals: {
                    "elasticfilesystem:AccessPointArn": this.accessPoint.accessPointArn,
                },
                Bool: {
                    "elasticfilesystem:AccessedViaMountTarget": true,
                },
            },
        }));
    }
}
exports.Home = Home;
_a = JSII_RTTI_SYMBOL_1;
Home[_a] = { fqn: "@packyak/aws-cdk.Home", version: "0.4.20" };
//# sourceMappingURL=data:application/json;base64,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