import type { Connections, IConnectable } from "aws-cdk-lib/aws-ec2";
import { FileSystem, type FileSystemProps } from "aws-cdk-lib/aws-efs";
import { Construct } from "constructs";
import { PosixGroup } from "./group";
import { Home } from "./home";
export interface MountFileSystemOptions {
    readonly mountPoint: string;
    readonly username: string;
    readonly uid: number;
    readonly gid: number;
}
export interface AddHomeRequest {
    /**
     * The username for the user. This should be unique across all users.
     */
    readonly username: string;
    /**
     * The POSIX user ID for the user. This should be a unique identifier.
     */
    readonly uid: string;
    /**
     * The POSIX group ID for the user. This is used for file system permissions.
     *
     * @default - same as the uid
     */
    readonly gid?: string;
    /**
     * Secondary groups to assign to files written to this home directory.
     */
    readonly secondaryGroups?: PosixGroup[];
}
export interface WorkspaceProps extends FileSystemProps {
}
/**
 * A Workspace is a shared environment for a team of developers to work on a project together.
 *
 * A Workspace contains a shared EFS {@link FileSystem} with {@link AccessPoint}s
 * for each {@link User} granted access to the system.
 *
 * A Workspace can be mounted to EC2 machines, SageMaker Domains and AWS EMR Clusters.
 */
export declare class Workspace extends Construct implements IConnectable {
    /**
     * EFS File System shared by all users of the Workspace.
     */
    readonly fileSystem: FileSystem;
    /**
     * Home directory of the `ssm-user` POSIX user.
     *
     * This is the default user assigned when logging into a machine via SSM.
     */
    readonly ssm: Home;
    /**
     * Connections for the EFS file system
     */
    readonly connections: Connections;
    private readonly homes;
    constructor(scope: Construct, id: string, props: WorkspaceProps);
    /**
     * Allow access to the EFS file system from a connectable, e.g. SecurityGroup.
     *
     * @param connectable the connectable to allow access to the shared EFS file system
     */
    allowFrom(connectable: IConnectable): void;
    /**
     * Add a home directory to the workspace
     */
    addHome(props: AddHomeRequest): Home;
}
