# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SuppressionArgs', 'Suppression']

@pulumi.input_type
class SuppressionArgs:
    def __init__(__self__, *,
                 recommendation_id: pulumi.Input[builtins.str],
                 resource_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Suppression resource.
        :param pulumi.Input[builtins.str] recommendation_id: The ID of the Advisor recommendation to suppress. Changing this forces a new Advisor suppression to be created.
        :param pulumi.Input[builtins.str] resource_id: The ID of the Resource to suppress the Advisor recommendation for. Changing this forces a new Advisor suppression to be created.
        :param pulumi.Input[builtins.str] name: The Name which should be used for this Advisor suppression. Changing this forces a new Advisor suppression to be created.
        :param pulumi.Input[builtins.str] ttl: A optional time to live value. If omitted, the suppression will not expire. Changing this forces a new Advisor suppression to be created.
        """
        pulumi.set(__self__, "recommendation_id", recommendation_id)
        pulumi.set(__self__, "resource_id", resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Advisor recommendation to suppress. Changing this forces a new Advisor suppression to be created.
        """
        return pulumi.get(self, "recommendation_id")

    @recommendation_id.setter
    def recommendation_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recommendation_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Resource to suppress the Advisor recommendation for. Changing this forces a new Advisor suppression to be created.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Name which should be used for this Advisor suppression. Changing this forces a new Advisor suppression to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A optional time to live value. If omitted, the suppression will not expire. Changing this forces a new Advisor suppression to be created.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _SuppressionState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recommendation_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 suppression_id: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Suppression resources.
        :param pulumi.Input[builtins.str] name: The Name which should be used for this Advisor suppression. Changing this forces a new Advisor suppression to be created.
        :param pulumi.Input[builtins.str] recommendation_id: The ID of the Advisor recommendation to suppress. Changing this forces a new Advisor suppression to be created.
        :param pulumi.Input[builtins.str] resource_id: The ID of the Resource to suppress the Advisor recommendation for. Changing this forces a new Advisor suppression to be created.
        :param pulumi.Input[builtins.str] suppression_id: The GUID of the suppression.
        :param pulumi.Input[builtins.str] ttl: A optional time to live value. If omitted, the suppression will not expire. Changing this forces a new Advisor suppression to be created.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recommendation_id is not None:
            pulumi.set(__self__, "recommendation_id", recommendation_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if suppression_id is not None:
            pulumi.set(__self__, "suppression_id", suppression_id)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Name which should be used for this Advisor suppression. Changing this forces a new Advisor suppression to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Advisor recommendation to suppress. Changing this forces a new Advisor suppression to be created.
        """
        return pulumi.get(self, "recommendation_id")

    @recommendation_id.setter
    def recommendation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recommendation_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Resource to suppress the Advisor recommendation for. Changing this forces a new Advisor suppression to be created.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="suppressionId")
    def suppression_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GUID of the suppression.
        """
        return pulumi.get(self, "suppression_id")

    @suppression_id.setter
    def suppression_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "suppression_id", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A optional time to live value. If omitted, the suppression will not expire. Changing this forces a new Advisor suppression to be created.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ttl", value)


@pulumi.type_token("azure:advisor/suppression:Suppression")
class Suppression(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recommendation_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Specifies a suppression for an Azure Advisor recommendation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.advisor.get_recommendations()
        example_suppression = azure.advisor.Suppression("example",
            name="HardcodedSuppressionName",
            recommendation_id=test["recommendations"][0]["recommendationName"],
            resource_id=f"/subscriptions/{current.subscription_id}",
            ttl="01:00:00:00")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Advisor`: 2023-01-01

        ## Import

        Advisor suppressions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:advisor/suppression:Suppression example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Advisor/recommendations/00000000-0000-0000-0000-000000000000/suppressions/name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The Name which should be used for this Advisor suppression. Changing this forces a new Advisor suppression to be created.
        :param pulumi.Input[builtins.str] recommendation_id: The ID of the Advisor recommendation to suppress. Changing this forces a new Advisor suppression to be created.
        :param pulumi.Input[builtins.str] resource_id: The ID of the Resource to suppress the Advisor recommendation for. Changing this forces a new Advisor suppression to be created.
        :param pulumi.Input[builtins.str] ttl: A optional time to live value. If omitted, the suppression will not expire. Changing this forces a new Advisor suppression to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SuppressionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Specifies a suppression for an Azure Advisor recommendation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.advisor.get_recommendations()
        example_suppression = azure.advisor.Suppression("example",
            name="HardcodedSuppressionName",
            recommendation_id=test["recommendations"][0]["recommendationName"],
            resource_id=f"/subscriptions/{current.subscription_id}",
            ttl="01:00:00:00")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Advisor`: 2023-01-01

        ## Import

        Advisor suppressions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:advisor/suppression:Suppression example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Advisor/recommendations/00000000-0000-0000-0000-000000000000/suppressions/name
        ```

        :param str resource_name: The name of the resource.
        :param SuppressionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SuppressionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recommendation_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SuppressionArgs.__new__(SuppressionArgs)

            __props__.__dict__["name"] = name
            if recommendation_id is None and not opts.urn:
                raise TypeError("Missing required property 'recommendation_id'")
            __props__.__dict__["recommendation_id"] = recommendation_id
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["suppression_id"] = None
        super(Suppression, __self__).__init__(
            'azure:advisor/suppression:Suppression',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            recommendation_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_id: Optional[pulumi.Input[builtins.str]] = None,
            suppression_id: Optional[pulumi.Input[builtins.str]] = None,
            ttl: Optional[pulumi.Input[builtins.str]] = None) -> 'Suppression':
        """
        Get an existing Suppression resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The Name which should be used for this Advisor suppression. Changing this forces a new Advisor suppression to be created.
        :param pulumi.Input[builtins.str] recommendation_id: The ID of the Advisor recommendation to suppress. Changing this forces a new Advisor suppression to be created.
        :param pulumi.Input[builtins.str] resource_id: The ID of the Resource to suppress the Advisor recommendation for. Changing this forces a new Advisor suppression to be created.
        :param pulumi.Input[builtins.str] suppression_id: The GUID of the suppression.
        :param pulumi.Input[builtins.str] ttl: A optional time to live value. If omitted, the suppression will not expire. Changing this forces a new Advisor suppression to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SuppressionState.__new__(_SuppressionState)

        __props__.__dict__["name"] = name
        __props__.__dict__["recommendation_id"] = recommendation_id
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["suppression_id"] = suppression_id
        __props__.__dict__["ttl"] = ttl
        return Suppression(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The Name which should be used for this Advisor suppression. Changing this forces a new Advisor suppression to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Advisor recommendation to suppress. Changing this forces a new Advisor suppression to be created.
        """
        return pulumi.get(self, "recommendation_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Resource to suppress the Advisor recommendation for. Changing this forces a new Advisor suppression to be created.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="suppressionId")
    def suppression_id(self) -> pulumi.Output[builtins.str]:
        """
        The GUID of the suppression.
        """
        return pulumi.get(self, "suppression_id")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A optional time to live value. If omitted, the suppression will not expire. Changing this forces a new Advisor suppression to be created.
        """
        return pulumi.get(self, "ttl")

