# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'HubEncryptionArgs',
    'HubEncryptionArgsDict',
    'HubIdentityArgs',
    'HubIdentityArgsDict',
    'HubManagedNetworkArgs',
    'HubManagedNetworkArgsDict',
    'ProjectIdentityArgs',
    'ProjectIdentityArgsDict',
]

MYPY = False

if not MYPY:
    class HubEncryptionArgsDict(TypedDict):
        key_id: pulumi.Input[builtins.str]
        """
        The Key Vault URI to access the encryption key.
        """
        key_vault_id: pulumi.Input[builtins.str]
        """
        The Key Vault ID where the customer owned encryption key exists.
        """
        user_assigned_identity_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The user assigned identity ID that has access to the encryption key.

        > **Note:** `user_assigned_identity_id` must be set when`identity.type` is `UserAssigned` in order for the service to find the assigned permissions.
        """
elif False:
    HubEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HubEncryptionArgs:
    def __init__(__self__, *,
                 key_id: pulumi.Input[builtins.str],
                 key_vault_id: pulumi.Input[builtins.str],
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] key_id: The Key Vault URI to access the encryption key.
        :param pulumi.Input[builtins.str] key_vault_id: The Key Vault ID where the customer owned encryption key exists.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The user assigned identity ID that has access to the encryption key.
               
               > **Note:** `user_assigned_identity_id` must be set when`identity.type` is `UserAssigned` in order for the service to find the assigned permissions.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[builtins.str]:
        """
        The Key Vault URI to access the encryption key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Input[builtins.str]:
        """
        The Key Vault ID where the customer owned encryption key exists.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_vault_id", value)

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user assigned identity ID that has access to the encryption key.

        > **Note:** `user_assigned_identity_id` must be set when`identity.type` is `UserAssigned` in order for the service to find the assigned permissions.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


if not MYPY:
    class HubIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this AI Foundry Hub. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this AI Foundry Hub.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    HubIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HubIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this AI Foundry Hub. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this AI Foundry Hub.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this AI Foundry Hub. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this AI Foundry Hub.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class HubManagedNetworkArgsDict(TypedDict):
        isolation_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The isolation mode of the AI Foundry Hub. Possible values are `Disabled`, `AllowOnlyApprovedOutbound`, and `AllowInternetOutbound`.
        """
elif False:
    HubManagedNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HubManagedNetworkArgs:
    def __init__(__self__, *,
                 isolation_mode: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] isolation_mode: The isolation mode of the AI Foundry Hub. Possible values are `Disabled`, `AllowOnlyApprovedOutbound`, and `AllowInternetOutbound`.
        """
        if isolation_mode is not None:
            pulumi.set(__self__, "isolation_mode", isolation_mode)

    @property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The isolation mode of the AI Foundry Hub. Possible values are `Disabled`, `AllowOnlyApprovedOutbound`, and `AllowInternetOutbound`.
        """
        return pulumi.get(self, "isolation_mode")

    @isolation_mode.setter
    def isolation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "isolation_mode", value)


if not MYPY:
    class ProjectIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this AI Foundry Project. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this AI Foundry Project.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    ProjectIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this AI Foundry Project. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this AI Foundry Project.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this AI Foundry Project. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this AI Foundry Project.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


