# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiDiagnosticArgs', 'ApiDiagnostic']

@pulumi.input_type
class ApiDiagnosticArgs:
    def __init__(__self__, *,
                 api_management_logger_id: pulumi.Input[builtins.str],
                 api_management_name: pulumi.Input[builtins.str],
                 api_name: pulumi.Input[builtins.str],
                 identifier: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 always_log_errors: Optional[pulumi.Input[builtins.bool]] = None,
                 backend_request: Optional[pulumi.Input['ApiDiagnosticBackendRequestArgs']] = None,
                 backend_response: Optional[pulumi.Input['ApiDiagnosticBackendResponseArgs']] = None,
                 frontend_request: Optional[pulumi.Input['ApiDiagnosticFrontendRequestArgs']] = None,
                 frontend_response: Optional[pulumi.Input['ApiDiagnosticFrontendResponseArgs']] = None,
                 http_correlation_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 log_client_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 operation_name_format: Optional[pulumi.Input[builtins.str]] = None,
                 sampling_percentage: Optional[pulumi.Input[builtins.float]] = None,
                 verbosity: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ApiDiagnostic resource.
        :param pulumi.Input[builtins.str] api_management_logger_id: The ID (name) of the Diagnostics Logger.
        :param pulumi.Input[builtins.str] api_management_name: The name of the API Management Service instance. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.str] api_name: The name of the API on which to configure the Diagnostics Logs. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.str] identifier: Identifier of the Diagnostics Logs. Possible values are `applicationinsights` and `azuremonitor`. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the API Management Service API Diagnostics Logs should exist. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.bool] always_log_errors: Always log errors. Send telemetry if there is an erroneous condition, regardless of sampling settings.
        :param pulumi.Input['ApiDiagnosticBackendRequestArgs'] backend_request: A `backend_request` block as defined below.
        :param pulumi.Input['ApiDiagnosticBackendResponseArgs'] backend_response: A `backend_response` block as defined below.
        :param pulumi.Input['ApiDiagnosticFrontendRequestArgs'] frontend_request: A `frontend_request` block as defined below.
        :param pulumi.Input['ApiDiagnosticFrontendResponseArgs'] frontend_response: A `frontend_response` block as defined below.
        :param pulumi.Input[builtins.str] http_correlation_protocol: The HTTP Correlation Protocol to use. Possible values are `None`, `Legacy` or `W3C`.
        :param pulumi.Input[builtins.bool] log_client_ip: Log client IP address.
        :param pulumi.Input[builtins.str] operation_name_format: The format of the Operation Name for Application Insights telemetries. Possible values are `Name`, and `Url`. Defaults to `Name`.
        :param pulumi.Input[builtins.float] sampling_percentage: Sampling (%). For high traffic APIs, please read this [documentation](https://docs.microsoft.com/azure/api-management/api-management-howto-app-insights#performance-implications-and-log-sampling) to understand performance implications and log sampling. Valid values are between `0.0` and `100.0`.
        :param pulumi.Input[builtins.str] verbosity: Logging verbosity. Possible values are `verbose`, `information` or `error`.
        """
        pulumi.set(__self__, "api_management_logger_id", api_management_logger_id)
        pulumi.set(__self__, "api_management_name", api_management_name)
        pulumi.set(__self__, "api_name", api_name)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if always_log_errors is not None:
            pulumi.set(__self__, "always_log_errors", always_log_errors)
        if backend_request is not None:
            pulumi.set(__self__, "backend_request", backend_request)
        if backend_response is not None:
            pulumi.set(__self__, "backend_response", backend_response)
        if frontend_request is not None:
            pulumi.set(__self__, "frontend_request", frontend_request)
        if frontend_response is not None:
            pulumi.set(__self__, "frontend_response", frontend_response)
        if http_correlation_protocol is not None:
            pulumi.set(__self__, "http_correlation_protocol", http_correlation_protocol)
        if log_client_ip is not None:
            pulumi.set(__self__, "log_client_ip", log_client_ip)
        if operation_name_format is not None:
            pulumi.set(__self__, "operation_name_format", operation_name_format)
        if sampling_percentage is not None:
            pulumi.set(__self__, "sampling_percentage", sampling_percentage)
        if verbosity is not None:
            pulumi.set(__self__, "verbosity", verbosity)

    @property
    @pulumi.getter(name="apiManagementLoggerId")
    def api_management_logger_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID (name) of the Diagnostics Logger.
        """
        return pulumi.get(self, "api_management_logger_id")

    @api_management_logger_id.setter
    def api_management_logger_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_management_logger_id", value)

    @property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the API Management Service instance. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_management_name", value)

    @property
    @pulumi.getter(name="apiName")
    def api_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the API on which to configure the Diagnostics Logs. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        """
        return pulumi.get(self, "api_name")

    @api_name.setter
    def api_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_name", value)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the Diagnostics Logs. Possible values are `applicationinsights` and `azuremonitor`. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the API Management Service API Diagnostics Logs should exist. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="alwaysLogErrors")
    def always_log_errors(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Always log errors. Send telemetry if there is an erroneous condition, regardless of sampling settings.
        """
        return pulumi.get(self, "always_log_errors")

    @always_log_errors.setter
    def always_log_errors(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "always_log_errors", value)

    @property
    @pulumi.getter(name="backendRequest")
    def backend_request(self) -> Optional[pulumi.Input['ApiDiagnosticBackendRequestArgs']]:
        """
        A `backend_request` block as defined below.
        """
        return pulumi.get(self, "backend_request")

    @backend_request.setter
    def backend_request(self, value: Optional[pulumi.Input['ApiDiagnosticBackendRequestArgs']]):
        pulumi.set(self, "backend_request", value)

    @property
    @pulumi.getter(name="backendResponse")
    def backend_response(self) -> Optional[pulumi.Input['ApiDiagnosticBackendResponseArgs']]:
        """
        A `backend_response` block as defined below.
        """
        return pulumi.get(self, "backend_response")

    @backend_response.setter
    def backend_response(self, value: Optional[pulumi.Input['ApiDiagnosticBackendResponseArgs']]):
        pulumi.set(self, "backend_response", value)

    @property
    @pulumi.getter(name="frontendRequest")
    def frontend_request(self) -> Optional[pulumi.Input['ApiDiagnosticFrontendRequestArgs']]:
        """
        A `frontend_request` block as defined below.
        """
        return pulumi.get(self, "frontend_request")

    @frontend_request.setter
    def frontend_request(self, value: Optional[pulumi.Input['ApiDiagnosticFrontendRequestArgs']]):
        pulumi.set(self, "frontend_request", value)

    @property
    @pulumi.getter(name="frontendResponse")
    def frontend_response(self) -> Optional[pulumi.Input['ApiDiagnosticFrontendResponseArgs']]:
        """
        A `frontend_response` block as defined below.
        """
        return pulumi.get(self, "frontend_response")

    @frontend_response.setter
    def frontend_response(self, value: Optional[pulumi.Input['ApiDiagnosticFrontendResponseArgs']]):
        pulumi.set(self, "frontend_response", value)

    @property
    @pulumi.getter(name="httpCorrelationProtocol")
    def http_correlation_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The HTTP Correlation Protocol to use. Possible values are `None`, `Legacy` or `W3C`.
        """
        return pulumi.get(self, "http_correlation_protocol")

    @http_correlation_protocol.setter
    def http_correlation_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_correlation_protocol", value)

    @property
    @pulumi.getter(name="logClientIp")
    def log_client_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Log client IP address.
        """
        return pulumi.get(self, "log_client_ip")

    @log_client_ip.setter
    def log_client_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_client_ip", value)

    @property
    @pulumi.getter(name="operationNameFormat")
    def operation_name_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The format of the Operation Name for Application Insights telemetries. Possible values are `Name`, and `Url`. Defaults to `Name`.
        """
        return pulumi.get(self, "operation_name_format")

    @operation_name_format.setter
    def operation_name_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation_name_format", value)

    @property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Sampling (%). For high traffic APIs, please read this [documentation](https://docs.microsoft.com/azure/api-management/api-management-howto-app-insights#performance-implications-and-log-sampling) to understand performance implications and log sampling. Valid values are between `0.0` and `100.0`.
        """
        return pulumi.get(self, "sampling_percentage")

    @sampling_percentage.setter
    def sampling_percentage(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "sampling_percentage", value)

    @property
    @pulumi.getter
    def verbosity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Logging verbosity. Possible values are `verbose`, `information` or `error`.
        """
        return pulumi.get(self, "verbosity")

    @verbosity.setter
    def verbosity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "verbosity", value)


@pulumi.input_type
class _ApiDiagnosticState:
    def __init__(__self__, *,
                 always_log_errors: Optional[pulumi.Input[builtins.bool]] = None,
                 api_management_logger_id: Optional[pulumi.Input[builtins.str]] = None,
                 api_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 api_name: Optional[pulumi.Input[builtins.str]] = None,
                 backend_request: Optional[pulumi.Input['ApiDiagnosticBackendRequestArgs']] = None,
                 backend_response: Optional[pulumi.Input['ApiDiagnosticBackendResponseArgs']] = None,
                 frontend_request: Optional[pulumi.Input['ApiDiagnosticFrontendRequestArgs']] = None,
                 frontend_response: Optional[pulumi.Input['ApiDiagnosticFrontendResponseArgs']] = None,
                 http_correlation_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 log_client_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 operation_name_format: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sampling_percentage: Optional[pulumi.Input[builtins.float]] = None,
                 verbosity: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiDiagnostic resources.
        :param pulumi.Input[builtins.bool] always_log_errors: Always log errors. Send telemetry if there is an erroneous condition, regardless of sampling settings.
        :param pulumi.Input[builtins.str] api_management_logger_id: The ID (name) of the Diagnostics Logger.
        :param pulumi.Input[builtins.str] api_management_name: The name of the API Management Service instance. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.str] api_name: The name of the API on which to configure the Diagnostics Logs. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input['ApiDiagnosticBackendRequestArgs'] backend_request: A `backend_request` block as defined below.
        :param pulumi.Input['ApiDiagnosticBackendResponseArgs'] backend_response: A `backend_response` block as defined below.
        :param pulumi.Input['ApiDiagnosticFrontendRequestArgs'] frontend_request: A `frontend_request` block as defined below.
        :param pulumi.Input['ApiDiagnosticFrontendResponseArgs'] frontend_response: A `frontend_response` block as defined below.
        :param pulumi.Input[builtins.str] http_correlation_protocol: The HTTP Correlation Protocol to use. Possible values are `None`, `Legacy` or `W3C`.
        :param pulumi.Input[builtins.str] identifier: Identifier of the Diagnostics Logs. Possible values are `applicationinsights` and `azuremonitor`. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.bool] log_client_ip: Log client IP address.
        :param pulumi.Input[builtins.str] operation_name_format: The format of the Operation Name for Application Insights telemetries. Possible values are `Name`, and `Url`. Defaults to `Name`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the API Management Service API Diagnostics Logs should exist. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.float] sampling_percentage: Sampling (%). For high traffic APIs, please read this [documentation](https://docs.microsoft.com/azure/api-management/api-management-howto-app-insights#performance-implications-and-log-sampling) to understand performance implications and log sampling. Valid values are between `0.0` and `100.0`.
        :param pulumi.Input[builtins.str] verbosity: Logging verbosity. Possible values are `verbose`, `information` or `error`.
        """
        if always_log_errors is not None:
            pulumi.set(__self__, "always_log_errors", always_log_errors)
        if api_management_logger_id is not None:
            pulumi.set(__self__, "api_management_logger_id", api_management_logger_id)
        if api_management_name is not None:
            pulumi.set(__self__, "api_management_name", api_management_name)
        if api_name is not None:
            pulumi.set(__self__, "api_name", api_name)
        if backend_request is not None:
            pulumi.set(__self__, "backend_request", backend_request)
        if backend_response is not None:
            pulumi.set(__self__, "backend_response", backend_response)
        if frontend_request is not None:
            pulumi.set(__self__, "frontend_request", frontend_request)
        if frontend_response is not None:
            pulumi.set(__self__, "frontend_response", frontend_response)
        if http_correlation_protocol is not None:
            pulumi.set(__self__, "http_correlation_protocol", http_correlation_protocol)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if log_client_ip is not None:
            pulumi.set(__self__, "log_client_ip", log_client_ip)
        if operation_name_format is not None:
            pulumi.set(__self__, "operation_name_format", operation_name_format)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sampling_percentage is not None:
            pulumi.set(__self__, "sampling_percentage", sampling_percentage)
        if verbosity is not None:
            pulumi.set(__self__, "verbosity", verbosity)

    @property
    @pulumi.getter(name="alwaysLogErrors")
    def always_log_errors(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Always log errors. Send telemetry if there is an erroneous condition, regardless of sampling settings.
        """
        return pulumi.get(self, "always_log_errors")

    @always_log_errors.setter
    def always_log_errors(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "always_log_errors", value)

    @property
    @pulumi.getter(name="apiManagementLoggerId")
    def api_management_logger_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID (name) of the Diagnostics Logger.
        """
        return pulumi.get(self, "api_management_logger_id")

    @api_management_logger_id.setter
    def api_management_logger_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_management_logger_id", value)

    @property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the API Management Service instance. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_management_name", value)

    @property
    @pulumi.getter(name="apiName")
    def api_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the API on which to configure the Diagnostics Logs. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        """
        return pulumi.get(self, "api_name")

    @api_name.setter
    def api_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_name", value)

    @property
    @pulumi.getter(name="backendRequest")
    def backend_request(self) -> Optional[pulumi.Input['ApiDiagnosticBackendRequestArgs']]:
        """
        A `backend_request` block as defined below.
        """
        return pulumi.get(self, "backend_request")

    @backend_request.setter
    def backend_request(self, value: Optional[pulumi.Input['ApiDiagnosticBackendRequestArgs']]):
        pulumi.set(self, "backend_request", value)

    @property
    @pulumi.getter(name="backendResponse")
    def backend_response(self) -> Optional[pulumi.Input['ApiDiagnosticBackendResponseArgs']]:
        """
        A `backend_response` block as defined below.
        """
        return pulumi.get(self, "backend_response")

    @backend_response.setter
    def backend_response(self, value: Optional[pulumi.Input['ApiDiagnosticBackendResponseArgs']]):
        pulumi.set(self, "backend_response", value)

    @property
    @pulumi.getter(name="frontendRequest")
    def frontend_request(self) -> Optional[pulumi.Input['ApiDiagnosticFrontendRequestArgs']]:
        """
        A `frontend_request` block as defined below.
        """
        return pulumi.get(self, "frontend_request")

    @frontend_request.setter
    def frontend_request(self, value: Optional[pulumi.Input['ApiDiagnosticFrontendRequestArgs']]):
        pulumi.set(self, "frontend_request", value)

    @property
    @pulumi.getter(name="frontendResponse")
    def frontend_response(self) -> Optional[pulumi.Input['ApiDiagnosticFrontendResponseArgs']]:
        """
        A `frontend_response` block as defined below.
        """
        return pulumi.get(self, "frontend_response")

    @frontend_response.setter
    def frontend_response(self, value: Optional[pulumi.Input['ApiDiagnosticFrontendResponseArgs']]):
        pulumi.set(self, "frontend_response", value)

    @property
    @pulumi.getter(name="httpCorrelationProtocol")
    def http_correlation_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The HTTP Correlation Protocol to use. Possible values are `None`, `Legacy` or `W3C`.
        """
        return pulumi.get(self, "http_correlation_protocol")

    @http_correlation_protocol.setter
    def http_correlation_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_correlation_protocol", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the Diagnostics Logs. Possible values are `applicationinsights` and `azuremonitor`. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="logClientIp")
    def log_client_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Log client IP address.
        """
        return pulumi.get(self, "log_client_ip")

    @log_client_ip.setter
    def log_client_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_client_ip", value)

    @property
    @pulumi.getter(name="operationNameFormat")
    def operation_name_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The format of the Operation Name for Application Insights telemetries. Possible values are `Name`, and `Url`. Defaults to `Name`.
        """
        return pulumi.get(self, "operation_name_format")

    @operation_name_format.setter
    def operation_name_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation_name_format", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the API Management Service API Diagnostics Logs should exist. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Sampling (%). For high traffic APIs, please read this [documentation](https://docs.microsoft.com/azure/api-management/api-management-howto-app-insights#performance-implications-and-log-sampling) to understand performance implications and log sampling. Valid values are between `0.0` and `100.0`.
        """
        return pulumi.get(self, "sampling_percentage")

    @sampling_percentage.setter
    def sampling_percentage(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "sampling_percentage", value)

    @property
    @pulumi.getter
    def verbosity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Logging verbosity. Possible values are `verbose`, `information` or `error`.
        """
        return pulumi.get(self, "verbosity")

    @verbosity.setter
    def verbosity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "verbosity", value)


@pulumi.type_token("azure:apimanagement/apiDiagnostic:ApiDiagnostic")
class ApiDiagnostic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_log_errors: Optional[pulumi.Input[builtins.bool]] = None,
                 api_management_logger_id: Optional[pulumi.Input[builtins.str]] = None,
                 api_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 api_name: Optional[pulumi.Input[builtins.str]] = None,
                 backend_request: Optional[pulumi.Input[Union['ApiDiagnosticBackendRequestArgs', 'ApiDiagnosticBackendRequestArgsDict']]] = None,
                 backend_response: Optional[pulumi.Input[Union['ApiDiagnosticBackendResponseArgs', 'ApiDiagnosticBackendResponseArgsDict']]] = None,
                 frontend_request: Optional[pulumi.Input[Union['ApiDiagnosticFrontendRequestArgs', 'ApiDiagnosticFrontendRequestArgsDict']]] = None,
                 frontend_response: Optional[pulumi.Input[Union['ApiDiagnosticFrontendResponseArgs', 'ApiDiagnosticFrontendResponseArgsDict']]] = None,
                 http_correlation_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 log_client_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 operation_name_format: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sampling_percentage: Optional[pulumi.Input[builtins.float]] = None,
                 verbosity: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a API Management Service API Diagnostics Logs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@mycompany.io",
            sku_name="Developer_1")
        example_api = azure.apimanagement.Api("example",
            name="example-api",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            revision="1",
            display_name="Example API",
            path="example",
            protocols=["https"],
            import_={
                "content_format": "swagger-link-json",
                "content_value": "https://raw.githubusercontent.com/hashicorp/terraform-provider-azurerm/refs/heads/main/internal/services/apimanagement/testdata/api_management_api_swagger.json",
            })
        example_logger = azure.apimanagement.Logger("example",
            name="example-apimlogger",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            application_insights={
                "instrumentation_key": example_insights.instrumentation_key,
            })
        example_api_diagnostic = azure.apimanagement.ApiDiagnostic("example",
            identifier="applicationinsights",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            api_name=example_api.name,
            api_management_logger_id=example_logger.id,
            sampling_percentage=5,
            always_log_errors=True,
            log_client_ip=True,
            verbosity="verbose",
            http_correlation_protocol="W3C",
            frontend_request={
                "body_bytes": 32,
                "headers_to_logs": [
                    "content-type",
                    "accept",
                    "origin",
                ],
            },
            frontend_response={
                "body_bytes": 32,
                "headers_to_logs": [
                    "content-type",
                    "content-length",
                    "origin",
                ],
            },
            backend_request={
                "body_bytes": 32,
                "headers_to_logs": [
                    "content-type",
                    "accept",
                    "origin",
                ],
            },
            backend_response={
                "body_bytes": 32,
                "headers_to_logs": [
                    "content-type",
                    "content-length",
                    "origin",
                ],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Service API Diagnostics Logs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/apiDiagnostic:ApiDiagnostic example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/instance1/apis/api1/diagnostics/diagnostic1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] always_log_errors: Always log errors. Send telemetry if there is an erroneous condition, regardless of sampling settings.
        :param pulumi.Input[builtins.str] api_management_logger_id: The ID (name) of the Diagnostics Logger.
        :param pulumi.Input[builtins.str] api_management_name: The name of the API Management Service instance. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.str] api_name: The name of the API on which to configure the Diagnostics Logs. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[Union['ApiDiagnosticBackendRequestArgs', 'ApiDiagnosticBackendRequestArgsDict']] backend_request: A `backend_request` block as defined below.
        :param pulumi.Input[Union['ApiDiagnosticBackendResponseArgs', 'ApiDiagnosticBackendResponseArgsDict']] backend_response: A `backend_response` block as defined below.
        :param pulumi.Input[Union['ApiDiagnosticFrontendRequestArgs', 'ApiDiagnosticFrontendRequestArgsDict']] frontend_request: A `frontend_request` block as defined below.
        :param pulumi.Input[Union['ApiDiagnosticFrontendResponseArgs', 'ApiDiagnosticFrontendResponseArgsDict']] frontend_response: A `frontend_response` block as defined below.
        :param pulumi.Input[builtins.str] http_correlation_protocol: The HTTP Correlation Protocol to use. Possible values are `None`, `Legacy` or `W3C`.
        :param pulumi.Input[builtins.str] identifier: Identifier of the Diagnostics Logs. Possible values are `applicationinsights` and `azuremonitor`. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.bool] log_client_ip: Log client IP address.
        :param pulumi.Input[builtins.str] operation_name_format: The format of the Operation Name for Application Insights telemetries. Possible values are `Name`, and `Url`. Defaults to `Name`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the API Management Service API Diagnostics Logs should exist. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.float] sampling_percentage: Sampling (%). For high traffic APIs, please read this [documentation](https://docs.microsoft.com/azure/api-management/api-management-howto-app-insights#performance-implications-and-log-sampling) to understand performance implications and log sampling. Valid values are between `0.0` and `100.0`.
        :param pulumi.Input[builtins.str] verbosity: Logging verbosity. Possible values are `verbose`, `information` or `error`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiDiagnosticArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a API Management Service API Diagnostics Logs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@mycompany.io",
            sku_name="Developer_1")
        example_api = azure.apimanagement.Api("example",
            name="example-api",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            revision="1",
            display_name="Example API",
            path="example",
            protocols=["https"],
            import_={
                "content_format": "swagger-link-json",
                "content_value": "https://raw.githubusercontent.com/hashicorp/terraform-provider-azurerm/refs/heads/main/internal/services/apimanagement/testdata/api_management_api_swagger.json",
            })
        example_logger = azure.apimanagement.Logger("example",
            name="example-apimlogger",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            application_insights={
                "instrumentation_key": example_insights.instrumentation_key,
            })
        example_api_diagnostic = azure.apimanagement.ApiDiagnostic("example",
            identifier="applicationinsights",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            api_name=example_api.name,
            api_management_logger_id=example_logger.id,
            sampling_percentage=5,
            always_log_errors=True,
            log_client_ip=True,
            verbosity="verbose",
            http_correlation_protocol="W3C",
            frontend_request={
                "body_bytes": 32,
                "headers_to_logs": [
                    "content-type",
                    "accept",
                    "origin",
                ],
            },
            frontend_response={
                "body_bytes": 32,
                "headers_to_logs": [
                    "content-type",
                    "content-length",
                    "origin",
                ],
            },
            backend_request={
                "body_bytes": 32,
                "headers_to_logs": [
                    "content-type",
                    "accept",
                    "origin",
                ],
            },
            backend_response={
                "body_bytes": 32,
                "headers_to_logs": [
                    "content-type",
                    "content-length",
                    "origin",
                ],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Service API Diagnostics Logs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/apiDiagnostic:ApiDiagnostic example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/instance1/apis/api1/diagnostics/diagnostic1
        ```

        :param str resource_name: The name of the resource.
        :param ApiDiagnosticArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiDiagnosticArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_log_errors: Optional[pulumi.Input[builtins.bool]] = None,
                 api_management_logger_id: Optional[pulumi.Input[builtins.str]] = None,
                 api_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 api_name: Optional[pulumi.Input[builtins.str]] = None,
                 backend_request: Optional[pulumi.Input[Union['ApiDiagnosticBackendRequestArgs', 'ApiDiagnosticBackendRequestArgsDict']]] = None,
                 backend_response: Optional[pulumi.Input[Union['ApiDiagnosticBackendResponseArgs', 'ApiDiagnosticBackendResponseArgsDict']]] = None,
                 frontend_request: Optional[pulumi.Input[Union['ApiDiagnosticFrontendRequestArgs', 'ApiDiagnosticFrontendRequestArgsDict']]] = None,
                 frontend_response: Optional[pulumi.Input[Union['ApiDiagnosticFrontendResponseArgs', 'ApiDiagnosticFrontendResponseArgsDict']]] = None,
                 http_correlation_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 log_client_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 operation_name_format: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sampling_percentage: Optional[pulumi.Input[builtins.float]] = None,
                 verbosity: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiDiagnosticArgs.__new__(ApiDiagnosticArgs)

            __props__.__dict__["always_log_errors"] = always_log_errors
            if api_management_logger_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_logger_id'")
            __props__.__dict__["api_management_logger_id"] = api_management_logger_id
            if api_management_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_name'")
            __props__.__dict__["api_management_name"] = api_management_name
            if api_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_name'")
            __props__.__dict__["api_name"] = api_name
            __props__.__dict__["backend_request"] = backend_request
            __props__.__dict__["backend_response"] = backend_response
            __props__.__dict__["frontend_request"] = frontend_request
            __props__.__dict__["frontend_response"] = frontend_response
            __props__.__dict__["http_correlation_protocol"] = http_correlation_protocol
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["log_client_ip"] = log_client_ip
            __props__.__dict__["operation_name_format"] = operation_name_format
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["sampling_percentage"] = sampling_percentage
            __props__.__dict__["verbosity"] = verbosity
        super(ApiDiagnostic, __self__).__init__(
            'azure:apimanagement/apiDiagnostic:ApiDiagnostic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            always_log_errors: Optional[pulumi.Input[builtins.bool]] = None,
            api_management_logger_id: Optional[pulumi.Input[builtins.str]] = None,
            api_management_name: Optional[pulumi.Input[builtins.str]] = None,
            api_name: Optional[pulumi.Input[builtins.str]] = None,
            backend_request: Optional[pulumi.Input[Union['ApiDiagnosticBackendRequestArgs', 'ApiDiagnosticBackendRequestArgsDict']]] = None,
            backend_response: Optional[pulumi.Input[Union['ApiDiagnosticBackendResponseArgs', 'ApiDiagnosticBackendResponseArgsDict']]] = None,
            frontend_request: Optional[pulumi.Input[Union['ApiDiagnosticFrontendRequestArgs', 'ApiDiagnosticFrontendRequestArgsDict']]] = None,
            frontend_response: Optional[pulumi.Input[Union['ApiDiagnosticFrontendResponseArgs', 'ApiDiagnosticFrontendResponseArgsDict']]] = None,
            http_correlation_protocol: Optional[pulumi.Input[builtins.str]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            log_client_ip: Optional[pulumi.Input[builtins.bool]] = None,
            operation_name_format: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            sampling_percentage: Optional[pulumi.Input[builtins.float]] = None,
            verbosity: Optional[pulumi.Input[builtins.str]] = None) -> 'ApiDiagnostic':
        """
        Get an existing ApiDiagnostic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] always_log_errors: Always log errors. Send telemetry if there is an erroneous condition, regardless of sampling settings.
        :param pulumi.Input[builtins.str] api_management_logger_id: The ID (name) of the Diagnostics Logger.
        :param pulumi.Input[builtins.str] api_management_name: The name of the API Management Service instance. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.str] api_name: The name of the API on which to configure the Diagnostics Logs. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[Union['ApiDiagnosticBackendRequestArgs', 'ApiDiagnosticBackendRequestArgsDict']] backend_request: A `backend_request` block as defined below.
        :param pulumi.Input[Union['ApiDiagnosticBackendResponseArgs', 'ApiDiagnosticBackendResponseArgsDict']] backend_response: A `backend_response` block as defined below.
        :param pulumi.Input[Union['ApiDiagnosticFrontendRequestArgs', 'ApiDiagnosticFrontendRequestArgsDict']] frontend_request: A `frontend_request` block as defined below.
        :param pulumi.Input[Union['ApiDiagnosticFrontendResponseArgs', 'ApiDiagnosticFrontendResponseArgsDict']] frontend_response: A `frontend_response` block as defined below.
        :param pulumi.Input[builtins.str] http_correlation_protocol: The HTTP Correlation Protocol to use. Possible values are `None`, `Legacy` or `W3C`.
        :param pulumi.Input[builtins.str] identifier: Identifier of the Diagnostics Logs. Possible values are `applicationinsights` and `azuremonitor`. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.bool] log_client_ip: Log client IP address.
        :param pulumi.Input[builtins.str] operation_name_format: The format of the Operation Name for Application Insights telemetries. Possible values are `Name`, and `Url`. Defaults to `Name`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the API Management Service API Diagnostics Logs should exist. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        :param pulumi.Input[builtins.float] sampling_percentage: Sampling (%). For high traffic APIs, please read this [documentation](https://docs.microsoft.com/azure/api-management/api-management-howto-app-insights#performance-implications-and-log-sampling) to understand performance implications and log sampling. Valid values are between `0.0` and `100.0`.
        :param pulumi.Input[builtins.str] verbosity: Logging verbosity. Possible values are `verbose`, `information` or `error`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiDiagnosticState.__new__(_ApiDiagnosticState)

        __props__.__dict__["always_log_errors"] = always_log_errors
        __props__.__dict__["api_management_logger_id"] = api_management_logger_id
        __props__.__dict__["api_management_name"] = api_management_name
        __props__.__dict__["api_name"] = api_name
        __props__.__dict__["backend_request"] = backend_request
        __props__.__dict__["backend_response"] = backend_response
        __props__.__dict__["frontend_request"] = frontend_request
        __props__.__dict__["frontend_response"] = frontend_response
        __props__.__dict__["http_correlation_protocol"] = http_correlation_protocol
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["log_client_ip"] = log_client_ip
        __props__.__dict__["operation_name_format"] = operation_name_format
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sampling_percentage"] = sampling_percentage
        __props__.__dict__["verbosity"] = verbosity
        return ApiDiagnostic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alwaysLogErrors")
    def always_log_errors(self) -> pulumi.Output[builtins.bool]:
        """
        Always log errors. Send telemetry if there is an erroneous condition, regardless of sampling settings.
        """
        return pulumi.get(self, "always_log_errors")

    @property
    @pulumi.getter(name="apiManagementLoggerId")
    def api_management_logger_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID (name) of the Diagnostics Logger.
        """
        return pulumi.get(self, "api_management_logger_id")

    @property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the API Management Service instance. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        """
        return pulumi.get(self, "api_management_name")

    @property
    @pulumi.getter(name="apiName")
    def api_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the API on which to configure the Diagnostics Logs. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        """
        return pulumi.get(self, "api_name")

    @property
    @pulumi.getter(name="backendRequest")
    def backend_request(self) -> pulumi.Output['outputs.ApiDiagnosticBackendRequest']:
        """
        A `backend_request` block as defined below.
        """
        return pulumi.get(self, "backend_request")

    @property
    @pulumi.getter(name="backendResponse")
    def backend_response(self) -> pulumi.Output['outputs.ApiDiagnosticBackendResponse']:
        """
        A `backend_response` block as defined below.
        """
        return pulumi.get(self, "backend_response")

    @property
    @pulumi.getter(name="frontendRequest")
    def frontend_request(self) -> pulumi.Output['outputs.ApiDiagnosticFrontendRequest']:
        """
        A `frontend_request` block as defined below.
        """
        return pulumi.get(self, "frontend_request")

    @property
    @pulumi.getter(name="frontendResponse")
    def frontend_response(self) -> pulumi.Output['outputs.ApiDiagnosticFrontendResponse']:
        """
        A `frontend_response` block as defined below.
        """
        return pulumi.get(self, "frontend_response")

    @property
    @pulumi.getter(name="httpCorrelationProtocol")
    def http_correlation_protocol(self) -> pulumi.Output[builtins.str]:
        """
        The HTTP Correlation Protocol to use. Possible values are `None`, `Legacy` or `W3C`.
        """
        return pulumi.get(self, "http_correlation_protocol")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of the Diagnostics Logs. Possible values are `applicationinsights` and `azuremonitor`. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="logClientIp")
    def log_client_ip(self) -> pulumi.Output[builtins.bool]:
        """
        Log client IP address.
        """
        return pulumi.get(self, "log_client_ip")

    @property
    @pulumi.getter(name="operationNameFormat")
    def operation_name_format(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The format of the Operation Name for Application Insights telemetries. Possible values are `Name`, and `Url`. Defaults to `Name`.
        """
        return pulumi.get(self, "operation_name_format")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the API Management Service API Diagnostics Logs should exist. Changing this forces a new API Management Service API Diagnostics Logs to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> pulumi.Output[builtins.float]:
        """
        Sampling (%). For high traffic APIs, please read this [documentation](https://docs.microsoft.com/azure/api-management/api-management-howto-app-insights#performance-implications-and-log-sampling) to understand performance implications and log sampling. Valid values are between `0.0` and `100.0`.
        """
        return pulumi.get(self, "sampling_percentage")

    @property
    @pulumi.getter
    def verbosity(self) -> pulumi.Output[builtins.str]:
        """
        Logging verbosity. Possible values are `verbose`, `information` or `error`.
        """
        return pulumi.get(self, "verbosity")

