# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ApiReleaseArgs', 'ApiRelease']

@pulumi.input_type
class ApiReleaseArgs:
    def __init__(__self__, *,
                 api_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ApiRelease resource.
        :param pulumi.Input[builtins.str] api_id: The ID of the API Management API. Changing this forces a new API Management API Release to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this API Management API Release. Changing this forces a new API Management API Release to be created.
        :param pulumi.Input[builtins.str] notes: The Release Notes.
        """
        pulumi.set(__self__, "api_id", api_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the API Management API. Changing this forces a new API Management API Release to be created.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this API Management API Release. Changing this forces a new API Management API Release to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Release Notes.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notes", value)


@pulumi.input_type
class _ApiReleaseState:
    def __init__(__self__, *,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiRelease resources.
        :param pulumi.Input[builtins.str] api_id: The ID of the API Management API. Changing this forces a new API Management API Release to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this API Management API Release. Changing this forces a new API Management API Release to be created.
        :param pulumi.Input[builtins.str] notes: The Release Notes.
        """
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the API Management API. Changing this forces a new API Management API Release to be created.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this API Management API Release. Changing this forces a new API Management API Release to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Release Notes.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notes", value)


@pulumi.type_token("azure:apimanagement/apiRelease:ApiRelease")
class ApiRelease(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a API Management API Release.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@terraform.io",
            sku_name="Developer_1")
        example_api = azure.apimanagement.Api("example",
            name="example-api",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            revision="1",
            display_name="Example API",
            path="example",
            protocols=["https"],
            import_={
                "content_format": "swagger-link-json",
                "content_value": "https://raw.githubusercontent.com/hashicorp/terraform-provider-azurerm/refs/heads/main/internal/services/apimanagement/testdata/api_management_api_swagger.json",
            })
        example_api_release = azure.apimanagement.ApiRelease("example",
            name="example-Api-Release",
            api_id=example_api.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management API Releases can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/apiRelease:ApiRelease example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1/apis/api1/releases/release1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_id: The ID of the API Management API. Changing this forces a new API Management API Release to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this API Management API Release. Changing this forces a new API Management API Release to be created.
        :param pulumi.Input[builtins.str] notes: The Release Notes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiReleaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a API Management API Release.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@terraform.io",
            sku_name="Developer_1")
        example_api = azure.apimanagement.Api("example",
            name="example-api",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            revision="1",
            display_name="Example API",
            path="example",
            protocols=["https"],
            import_={
                "content_format": "swagger-link-json",
                "content_value": "https://raw.githubusercontent.com/hashicorp/terraform-provider-azurerm/refs/heads/main/internal/services/apimanagement/testdata/api_management_api_swagger.json",
            })
        example_api_release = azure.apimanagement.ApiRelease("example",
            name="example-Api-Release",
            api_id=example_api.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management API Releases can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/apiRelease:ApiRelease example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1/apis/api1/releases/release1
        ```

        :param str resource_name: The name of the resource.
        :param ApiReleaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiReleaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiReleaseArgs.__new__(ApiReleaseArgs)

            if api_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_id'")
            __props__.__dict__["api_id"] = api_id
            __props__.__dict__["name"] = name
            __props__.__dict__["notes"] = notes
        super(ApiRelease, __self__).__init__(
            'azure:apimanagement/apiRelease:ApiRelease',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            notes: Optional[pulumi.Input[builtins.str]] = None) -> 'ApiRelease':
        """
        Get an existing ApiRelease resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_id: The ID of the API Management API. Changing this forces a new API Management API Release to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this API Management API Release. Changing this forces a new API Management API Release to be created.
        :param pulumi.Input[builtins.str] notes: The Release Notes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiReleaseState.__new__(_ApiReleaseState)

        __props__.__dict__["api_id"] = api_id
        __props__.__dict__["name"] = name
        __props__.__dict__["notes"] = notes
        return ApiRelease(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the API Management API. Changing this forces a new API Management API Release to be created.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this API Management API Release. Changing this forces a new API Management API Release to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Release Notes.
        """
        return pulumi.get(self, "notes")

