# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ApiTagDescriptionArgs', 'ApiTagDescription']

@pulumi.input_type
class ApiTagDescriptionArgs:
    def __init__(__self__, *,
                 api_tag_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_documentation_description: Optional[pulumi.Input[builtins.str]] = None,
                 external_documentation_url: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ApiTagDescription resource.
        :param pulumi.Input[builtins.str] api_tag_id: The The ID of the API Management API Tag. Changing this forces a new API Management API Tag Description to be created.
        :param pulumi.Input[builtins.str] description: The description of the Tag.
        :param pulumi.Input[builtins.str] external_documentation_description: The description of the external documentation resources describing the tag.
        :param pulumi.Input[builtins.str] external_documentation_url: The URL of external documentation resources describing the tag.
        """
        pulumi.set(__self__, "api_tag_id", api_tag_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_documentation_description is not None:
            pulumi.set(__self__, "external_documentation_description", external_documentation_description)
        if external_documentation_url is not None:
            pulumi.set(__self__, "external_documentation_url", external_documentation_url)

    @property
    @pulumi.getter(name="apiTagId")
    def api_tag_id(self) -> pulumi.Input[builtins.str]:
        """
        The The ID of the API Management API Tag. Changing this forces a new API Management API Tag Description to be created.
        """
        return pulumi.get(self, "api_tag_id")

    @api_tag_id.setter
    def api_tag_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_tag_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Tag.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalDocumentationDescription")
    def external_documentation_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the external documentation resources describing the tag.
        """
        return pulumi.get(self, "external_documentation_description")

    @external_documentation_description.setter
    def external_documentation_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_documentation_description", value)

    @property
    @pulumi.getter(name="externalDocumentationUrl")
    def external_documentation_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of external documentation resources describing the tag.
        """
        return pulumi.get(self, "external_documentation_url")

    @external_documentation_url.setter
    def external_documentation_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_documentation_url", value)


@pulumi.input_type
class _ApiTagDescriptionState:
    def __init__(__self__, *,
                 api_tag_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_documentation_description: Optional[pulumi.Input[builtins.str]] = None,
                 external_documentation_url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiTagDescription resources.
        :param pulumi.Input[builtins.str] api_tag_id: The The ID of the API Management API Tag. Changing this forces a new API Management API Tag Description to be created.
        :param pulumi.Input[builtins.str] description: The description of the Tag.
        :param pulumi.Input[builtins.str] external_documentation_description: The description of the external documentation resources describing the tag.
        :param pulumi.Input[builtins.str] external_documentation_url: The URL of external documentation resources describing the tag.
        """
        if api_tag_id is not None:
            pulumi.set(__self__, "api_tag_id", api_tag_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_documentation_description is not None:
            pulumi.set(__self__, "external_documentation_description", external_documentation_description)
        if external_documentation_url is not None:
            pulumi.set(__self__, "external_documentation_url", external_documentation_url)

    @property
    @pulumi.getter(name="apiTagId")
    def api_tag_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The The ID of the API Management API Tag. Changing this forces a new API Management API Tag Description to be created.
        """
        return pulumi.get(self, "api_tag_id")

    @api_tag_id.setter
    def api_tag_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_tag_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Tag.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalDocumentationDescription")
    def external_documentation_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the external documentation resources describing the tag.
        """
        return pulumi.get(self, "external_documentation_description")

    @external_documentation_description.setter
    def external_documentation_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_documentation_description", value)

    @property
    @pulumi.getter(name="externalDocumentationUrl")
    def external_documentation_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of external documentation resources describing the tag.
        """
        return pulumi.get(self, "external_documentation_url")

    @external_documentation_url.setter
    def external_documentation_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_documentation_url", value)


@pulumi.type_token("azure:apimanagement/apiTagDescription:ApiTagDescription")
class ApiTagDescription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_tag_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_documentation_description: Optional[pulumi.Input[builtins.str]] = None,
                 external_documentation_url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an API Tag Description within an API Management Service.

        ## Import

        API Management API Schema's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/apiTagDescription:ApiTagDescription example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/apis/api1/tagDescriptions/tagDescriptionId1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_tag_id: The The ID of the API Management API Tag. Changing this forces a new API Management API Tag Description to be created.
        :param pulumi.Input[builtins.str] description: The description of the Tag.
        :param pulumi.Input[builtins.str] external_documentation_description: The description of the external documentation resources describing the tag.
        :param pulumi.Input[builtins.str] external_documentation_url: The URL of external documentation resources describing the tag.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiTagDescriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Tag Description within an API Management Service.

        ## Import

        API Management API Schema's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/apiTagDescription:ApiTagDescription example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/apis/api1/tagDescriptions/tagDescriptionId1
        ```

        :param str resource_name: The name of the resource.
        :param ApiTagDescriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiTagDescriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_tag_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_documentation_description: Optional[pulumi.Input[builtins.str]] = None,
                 external_documentation_url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiTagDescriptionArgs.__new__(ApiTagDescriptionArgs)

            if api_tag_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_tag_id'")
            __props__.__dict__["api_tag_id"] = api_tag_id
            __props__.__dict__["description"] = description
            __props__.__dict__["external_documentation_description"] = external_documentation_description
            __props__.__dict__["external_documentation_url"] = external_documentation_url
        super(ApiTagDescription, __self__).__init__(
            'azure:apimanagement/apiTagDescription:ApiTagDescription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_tag_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            external_documentation_description: Optional[pulumi.Input[builtins.str]] = None,
            external_documentation_url: Optional[pulumi.Input[builtins.str]] = None) -> 'ApiTagDescription':
        """
        Get an existing ApiTagDescription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_tag_id: The The ID of the API Management API Tag. Changing this forces a new API Management API Tag Description to be created.
        :param pulumi.Input[builtins.str] description: The description of the Tag.
        :param pulumi.Input[builtins.str] external_documentation_description: The description of the external documentation resources describing the tag.
        :param pulumi.Input[builtins.str] external_documentation_url: The URL of external documentation resources describing the tag.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiTagDescriptionState.__new__(_ApiTagDescriptionState)

        __props__.__dict__["api_tag_id"] = api_tag_id
        __props__.__dict__["description"] = description
        __props__.__dict__["external_documentation_description"] = external_documentation_description
        __props__.__dict__["external_documentation_url"] = external_documentation_url
        return ApiTagDescription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiTagId")
    def api_tag_id(self) -> pulumi.Output[builtins.str]:
        """
        The The ID of the API Management API Tag. Changing this forces a new API Management API Tag Description to be created.
        """
        return pulumi.get(self, "api_tag_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Tag.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalDocumentationDescription")
    def external_documentation_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the external documentation resources describing the tag.
        """
        return pulumi.get(self, "external_documentation_description")

    @property
    @pulumi.getter(name="externalDocumentationUrl")
    def external_documentation_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URL of external documentation resources describing the tag.
        """
        return pulumi.get(self, "external_documentation_url")

