# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IdentityProviderFacebookArgs', 'IdentityProviderFacebook']

@pulumi.input_type
class IdentityProviderFacebookArgs:
    def __init__(__self__, *,
                 api_management_name: pulumi.Input[builtins.str],
                 app_id: pulumi.Input[builtins.str],
                 app_secret: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a IdentityProviderFacebook resource.
        :param pulumi.Input[builtins.str] api_management_name: The Name of the API Management Service where this Facebook Identity Provider should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] app_id: App ID for Facebook.
        :param pulumi.Input[builtins.str] app_secret: App Secret for Facebook.
        :param pulumi.Input[builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "api_management_name", api_management_name)
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "app_secret", app_secret)
        pulumi.set(__self__, "resource_group_name", resource_group_name)

    @property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Input[builtins.str]:
        """
        The Name of the API Management Service where this Facebook Identity Provider should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_management_name", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[builtins.str]:
        """
        App ID for Facebook.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appSecret")
    def app_secret(self) -> pulumi.Input[builtins.str]:
        """
        App Secret for Facebook.
        """
        return pulumi.get(self, "app_secret")

    @app_secret.setter
    def app_secret(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "app_secret", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.input_type
class _IdentityProviderFacebookState:
    def __init__(__self__, *,
                 api_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 app_secret: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering IdentityProviderFacebook resources.
        :param pulumi.Input[builtins.str] api_management_name: The Name of the API Management Service where this Facebook Identity Provider should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] app_id: App ID for Facebook.
        :param pulumi.Input[builtins.str] app_secret: App Secret for Facebook.
        :param pulumi.Input[builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        if api_management_name is not None:
            pulumi.set(__self__, "api_management_name", api_management_name)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_secret is not None:
            pulumi.set(__self__, "app_secret", app_secret)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Name of the API Management Service where this Facebook Identity Provider should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_management_name", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        App ID for Facebook.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appSecret")
    def app_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        App Secret for Facebook.
        """
        return pulumi.get(self, "app_secret")

    @app_secret.setter
    def app_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_secret", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:apimanagement/identityProviderFacebook:IdentityProviderFacebook")
class IdentityProviderFacebook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 app_secret: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an API Management Facebook Identity Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@mycompany.io",
            sku_name="Developer_1")
        example_identity_provider_facebook = azure.apimanagement.IdentityProviderFacebook("example",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            app_id="00000000000000000000000000000000",
            app_secret="00000000000000000000000000000000")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Facebook Identity Provider can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/identityProviderFacebook:IdentityProviderFacebook example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/identityProviders/facebook
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_management_name: The Name of the API Management Service where this Facebook Identity Provider should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] app_id: App ID for Facebook.
        :param pulumi.Input[builtins.str] app_secret: App Secret for Facebook.
        :param pulumi.Input[builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentityProviderFacebookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Management Facebook Identity Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@mycompany.io",
            sku_name="Developer_1")
        example_identity_provider_facebook = azure.apimanagement.IdentityProviderFacebook("example",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            app_id="00000000000000000000000000000000",
            app_secret="00000000000000000000000000000000")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Facebook Identity Provider can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/identityProviderFacebook:IdentityProviderFacebook example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/identityProviders/facebook
        ```

        :param str resource_name: The name of the resource.
        :param IdentityProviderFacebookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentityProviderFacebookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 app_secret: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentityProviderFacebookArgs.__new__(IdentityProviderFacebookArgs)

            if api_management_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_name'")
            __props__.__dict__["api_management_name"] = api_management_name
            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            if app_secret is None and not opts.urn:
                raise TypeError("Missing required property 'app_secret'")
            __props__.__dict__["app_secret"] = None if app_secret is None else pulumi.Output.secret(app_secret)
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["appSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IdentityProviderFacebook, __self__).__init__(
            'azure:apimanagement/identityProviderFacebook:IdentityProviderFacebook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_name: Optional[pulumi.Input[builtins.str]] = None,
            app_id: Optional[pulumi.Input[builtins.str]] = None,
            app_secret: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None) -> 'IdentityProviderFacebook':
        """
        Get an existing IdentityProviderFacebook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_management_name: The Name of the API Management Service where this Facebook Identity Provider should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] app_id: App ID for Facebook.
        :param pulumi.Input[builtins.str] app_secret: App Secret for Facebook.
        :param pulumi.Input[builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IdentityProviderFacebookState.__new__(_IdentityProviderFacebookState)

        __props__.__dict__["api_management_name"] = api_management_name
        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["app_secret"] = app_secret
        __props__.__dict__["resource_group_name"] = resource_group_name
        return IdentityProviderFacebook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Output[builtins.str]:
        """
        The Name of the API Management Service where this Facebook Identity Provider should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[builtins.str]:
        """
        App ID for Facebook.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appSecret")
    def app_secret(self) -> pulumi.Output[builtins.str]:
        """
        App Secret for Facebook.
        """
        return pulumi.get(self, "app_secret")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

