# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApiContact',
    'ApiDiagnosticBackendRequest',
    'ApiDiagnosticBackendRequestDataMasking',
    'ApiDiagnosticBackendRequestDataMaskingHeader',
    'ApiDiagnosticBackendRequestDataMaskingQueryParam',
    'ApiDiagnosticBackendResponse',
    'ApiDiagnosticBackendResponseDataMasking',
    'ApiDiagnosticBackendResponseDataMaskingHeader',
    'ApiDiagnosticBackendResponseDataMaskingQueryParam',
    'ApiDiagnosticFrontendRequest',
    'ApiDiagnosticFrontendRequestDataMasking',
    'ApiDiagnosticFrontendRequestDataMaskingHeader',
    'ApiDiagnosticFrontendRequestDataMaskingQueryParam',
    'ApiDiagnosticFrontendResponse',
    'ApiDiagnosticFrontendResponseDataMasking',
    'ApiDiagnosticFrontendResponseDataMaskingHeader',
    'ApiDiagnosticFrontendResponseDataMaskingQueryParam',
    'ApiImport',
    'ApiImportWsdlSelector',
    'ApiLicense',
    'ApiOauth2Authorization',
    'ApiOpenidAuthentication',
    'ApiOperationRequest',
    'ApiOperationRequestHeader',
    'ApiOperationRequestHeaderExample',
    'ApiOperationRequestQueryParameter',
    'ApiOperationRequestQueryParameterExample',
    'ApiOperationRequestRepresentation',
    'ApiOperationRequestRepresentationExample',
    'ApiOperationRequestRepresentationFormParameter',
    'ApiOperationRequestRepresentationFormParameterExample',
    'ApiOperationResponse',
    'ApiOperationResponseHeader',
    'ApiOperationResponseHeaderExample',
    'ApiOperationResponseRepresentation',
    'ApiOperationResponseRepresentationExample',
    'ApiOperationResponseRepresentationFormParameter',
    'ApiOperationResponseRepresentationFormParameterExample',
    'ApiOperationTemplateParameter',
    'ApiOperationTemplateParameterExample',
    'ApiSubscriptionKeyParameterNames',
    'AuthorizationServerTokenBodyParameter',
    'BackendCredentials',
    'BackendCredentialsAuthorization',
    'BackendProxy',
    'BackendServiceFabricCluster',
    'BackendServiceFabricClusterServerX509Name',
    'BackendTls',
    'CustomDomainDeveloperPortal',
    'CustomDomainGateway',
    'CustomDomainManagement',
    'CustomDomainPortal',
    'CustomDomainScm',
    'DiagnosticBackendRequest',
    'DiagnosticBackendRequestDataMasking',
    'DiagnosticBackendRequestDataMaskingHeader',
    'DiagnosticBackendRequestDataMaskingQueryParam',
    'DiagnosticBackendResponse',
    'DiagnosticBackendResponseDataMasking',
    'DiagnosticBackendResponseDataMaskingHeader',
    'DiagnosticBackendResponseDataMaskingQueryParam',
    'DiagnosticFrontendRequest',
    'DiagnosticFrontendRequestDataMasking',
    'DiagnosticFrontendRequestDataMaskingHeader',
    'DiagnosticFrontendRequestDataMaskingQueryParam',
    'DiagnosticFrontendResponse',
    'DiagnosticFrontendResponseDataMasking',
    'DiagnosticFrontendResponseDataMaskingHeader',
    'DiagnosticFrontendResponseDataMaskingQueryParam',
    'GatewayLocationData',
    'LoggerApplicationInsights',
    'LoggerEventhub',
    'NamedValueValueFromKeyVault',
    'ServiceAdditionalLocation',
    'ServiceAdditionalLocationVirtualNetworkConfiguration',
    'ServiceCertificate',
    'ServiceDelegation',
    'ServiceHostnameConfiguration',
    'ServiceHostnameConfigurationDeveloperPortal',
    'ServiceHostnameConfigurationManagement',
    'ServiceHostnameConfigurationPortal',
    'ServiceHostnameConfigurationProxy',
    'ServiceHostnameConfigurationScm',
    'ServiceIdentity',
    'ServiceProtocols',
    'ServiceSecurity',
    'ServiceSignIn',
    'ServiceSignUp',
    'ServiceSignUpTermsOfService',
    'ServiceTenantAccess',
    'ServiceVirtualNetworkConfiguration',
    'GetApiSubscriptionKeyParameterNameResult',
    'GetGatewayLocationDataResult',
    'GetServiceAdditionalLocationResult',
    'GetServiceHostnameConfigurationResult',
    'GetServiceHostnameConfigurationDeveloperPortalResult',
    'GetServiceHostnameConfigurationManagementResult',
    'GetServiceHostnameConfigurationPortalResult',
    'GetServiceHostnameConfigurationProxyResult',
    'GetServiceHostnameConfigurationScmResult',
    'GetServiceIdentityResult',
    'GetServiceTenantAccessResult',
]

@pulumi.output_type
class ApiContact(dict):
    def __init__(__self__, *,
                 email: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None):
        """
        :param builtins.str email: The email address of the contact person/organization.
        :param builtins.str name: The name of the contact person/organization.
        :param builtins.str url: Absolute URL of the contact information.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        The email address of the contact person/organization.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the contact person/organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        Absolute URL of the contact information.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ApiDiagnosticBackendRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyBytes":
            suggest = "body_bytes"
        elif key == "dataMasking":
            suggest = "data_masking"
        elif key == "headersToLogs":
            suggest = "headers_to_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiDiagnosticBackendRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiDiagnosticBackendRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiDiagnosticBackendRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_bytes: Optional[builtins.int] = None,
                 data_masking: Optional['outputs.ApiDiagnosticBackendRequestDataMasking'] = None,
                 headers_to_logs: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int body_bytes: Number of payload bytes to log (up to 8192).
        :param 'ApiDiagnosticBackendRequestDataMaskingArgs' data_masking: A `data_masking` block as defined below.
        :param Sequence[builtins.str] headers_to_logs: Specifies a list of headers to log.
        """
        if body_bytes is not None:
            pulumi.set(__self__, "body_bytes", body_bytes)
        if data_masking is not None:
            pulumi.set(__self__, "data_masking", data_masking)
        if headers_to_logs is not None:
            pulumi.set(__self__, "headers_to_logs", headers_to_logs)

    @property
    @pulumi.getter(name="bodyBytes")
    def body_bytes(self) -> Optional[builtins.int]:
        """
        Number of payload bytes to log (up to 8192).
        """
        return pulumi.get(self, "body_bytes")

    @property
    @pulumi.getter(name="dataMasking")
    def data_masking(self) -> Optional['outputs.ApiDiagnosticBackendRequestDataMasking']:
        """
        A `data_masking` block as defined below.
        """
        return pulumi.get(self, "data_masking")

    @property
    @pulumi.getter(name="headersToLogs")
    def headers_to_logs(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of headers to log.
        """
        return pulumi.get(self, "headers_to_logs")


@pulumi.output_type
class ApiDiagnosticBackendRequestDataMasking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParams":
            suggest = "query_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiDiagnosticBackendRequestDataMasking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiDiagnosticBackendRequestDataMasking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiDiagnosticBackendRequestDataMasking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.ApiDiagnosticBackendRequestDataMaskingHeader']] = None,
                 query_params: Optional[Sequence['outputs.ApiDiagnosticBackendRequestDataMaskingQueryParam']] = None):
        """
        :param Sequence['ApiDiagnosticBackendRequestDataMaskingHeaderArgs'] headers: A `headers` block as defined below.
        :param Sequence['ApiDiagnosticBackendRequestDataMaskingQueryParamArgs'] query_params: A `query_params` block as defined below.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_params is not None:
            pulumi.set(__self__, "query_params", query_params)

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ApiDiagnosticBackendRequestDataMaskingHeader']]:
        """
        A `headers` block as defined below.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> Optional[Sequence['outputs.ApiDiagnosticBackendRequestDataMaskingQueryParam']]:
        """
        A `query_params` block as defined below.
        """
        return pulumi.get(self, "query_params")


@pulumi.output_type
class ApiDiagnosticBackendRequestDataMaskingHeader(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiDiagnosticBackendRequestDataMaskingQueryParam(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiDiagnosticBackendResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyBytes":
            suggest = "body_bytes"
        elif key == "dataMasking":
            suggest = "data_masking"
        elif key == "headersToLogs":
            suggest = "headers_to_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiDiagnosticBackendResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiDiagnosticBackendResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiDiagnosticBackendResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_bytes: Optional[builtins.int] = None,
                 data_masking: Optional['outputs.ApiDiagnosticBackendResponseDataMasking'] = None,
                 headers_to_logs: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int body_bytes: Number of payload bytes to log (up to 8192).
        :param 'ApiDiagnosticBackendResponseDataMaskingArgs' data_masking: A `data_masking` block as defined below.
        :param Sequence[builtins.str] headers_to_logs: Specifies a list of headers to log.
        """
        if body_bytes is not None:
            pulumi.set(__self__, "body_bytes", body_bytes)
        if data_masking is not None:
            pulumi.set(__self__, "data_masking", data_masking)
        if headers_to_logs is not None:
            pulumi.set(__self__, "headers_to_logs", headers_to_logs)

    @property
    @pulumi.getter(name="bodyBytes")
    def body_bytes(self) -> Optional[builtins.int]:
        """
        Number of payload bytes to log (up to 8192).
        """
        return pulumi.get(self, "body_bytes")

    @property
    @pulumi.getter(name="dataMasking")
    def data_masking(self) -> Optional['outputs.ApiDiagnosticBackendResponseDataMasking']:
        """
        A `data_masking` block as defined below.
        """
        return pulumi.get(self, "data_masking")

    @property
    @pulumi.getter(name="headersToLogs")
    def headers_to_logs(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of headers to log.
        """
        return pulumi.get(self, "headers_to_logs")


@pulumi.output_type
class ApiDiagnosticBackendResponseDataMasking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParams":
            suggest = "query_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiDiagnosticBackendResponseDataMasking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiDiagnosticBackendResponseDataMasking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiDiagnosticBackendResponseDataMasking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.ApiDiagnosticBackendResponseDataMaskingHeader']] = None,
                 query_params: Optional[Sequence['outputs.ApiDiagnosticBackendResponseDataMaskingQueryParam']] = None):
        """
        :param Sequence['ApiDiagnosticBackendResponseDataMaskingHeaderArgs'] headers: A `headers` block as defined below.
        :param Sequence['ApiDiagnosticBackendResponseDataMaskingQueryParamArgs'] query_params: A `query_params` block as defined below.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_params is not None:
            pulumi.set(__self__, "query_params", query_params)

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ApiDiagnosticBackendResponseDataMaskingHeader']]:
        """
        A `headers` block as defined below.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> Optional[Sequence['outputs.ApiDiagnosticBackendResponseDataMaskingQueryParam']]:
        """
        A `query_params` block as defined below.
        """
        return pulumi.get(self, "query_params")


@pulumi.output_type
class ApiDiagnosticBackendResponseDataMaskingHeader(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiDiagnosticBackendResponseDataMaskingQueryParam(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiDiagnosticFrontendRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyBytes":
            suggest = "body_bytes"
        elif key == "dataMasking":
            suggest = "data_masking"
        elif key == "headersToLogs":
            suggest = "headers_to_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiDiagnosticFrontendRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiDiagnosticFrontendRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiDiagnosticFrontendRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_bytes: Optional[builtins.int] = None,
                 data_masking: Optional['outputs.ApiDiagnosticFrontendRequestDataMasking'] = None,
                 headers_to_logs: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int body_bytes: Number of payload bytes to log (up to 8192).
        :param 'ApiDiagnosticFrontendRequestDataMaskingArgs' data_masking: A `data_masking` block as defined below.
        :param Sequence[builtins.str] headers_to_logs: Specifies a list of headers to log.
        """
        if body_bytes is not None:
            pulumi.set(__self__, "body_bytes", body_bytes)
        if data_masking is not None:
            pulumi.set(__self__, "data_masking", data_masking)
        if headers_to_logs is not None:
            pulumi.set(__self__, "headers_to_logs", headers_to_logs)

    @property
    @pulumi.getter(name="bodyBytes")
    def body_bytes(self) -> Optional[builtins.int]:
        """
        Number of payload bytes to log (up to 8192).
        """
        return pulumi.get(self, "body_bytes")

    @property
    @pulumi.getter(name="dataMasking")
    def data_masking(self) -> Optional['outputs.ApiDiagnosticFrontendRequestDataMasking']:
        """
        A `data_masking` block as defined below.
        """
        return pulumi.get(self, "data_masking")

    @property
    @pulumi.getter(name="headersToLogs")
    def headers_to_logs(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of headers to log.
        """
        return pulumi.get(self, "headers_to_logs")


@pulumi.output_type
class ApiDiagnosticFrontendRequestDataMasking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParams":
            suggest = "query_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiDiagnosticFrontendRequestDataMasking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiDiagnosticFrontendRequestDataMasking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiDiagnosticFrontendRequestDataMasking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.ApiDiagnosticFrontendRequestDataMaskingHeader']] = None,
                 query_params: Optional[Sequence['outputs.ApiDiagnosticFrontendRequestDataMaskingQueryParam']] = None):
        """
        :param Sequence['ApiDiagnosticFrontendRequestDataMaskingHeaderArgs'] headers: A `headers` block as defined below.
        :param Sequence['ApiDiagnosticFrontendRequestDataMaskingQueryParamArgs'] query_params: A `query_params` block as defined below.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_params is not None:
            pulumi.set(__self__, "query_params", query_params)

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ApiDiagnosticFrontendRequestDataMaskingHeader']]:
        """
        A `headers` block as defined below.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> Optional[Sequence['outputs.ApiDiagnosticFrontendRequestDataMaskingQueryParam']]:
        """
        A `query_params` block as defined below.
        """
        return pulumi.get(self, "query_params")


@pulumi.output_type
class ApiDiagnosticFrontendRequestDataMaskingHeader(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiDiagnosticFrontendRequestDataMaskingQueryParam(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiDiagnosticFrontendResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyBytes":
            suggest = "body_bytes"
        elif key == "dataMasking":
            suggest = "data_masking"
        elif key == "headersToLogs":
            suggest = "headers_to_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiDiagnosticFrontendResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiDiagnosticFrontendResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiDiagnosticFrontendResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_bytes: Optional[builtins.int] = None,
                 data_masking: Optional['outputs.ApiDiagnosticFrontendResponseDataMasking'] = None,
                 headers_to_logs: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int body_bytes: Number of payload bytes to log (up to 8192).
        :param 'ApiDiagnosticFrontendResponseDataMaskingArgs' data_masking: A `data_masking` block as defined below.
        :param Sequence[builtins.str] headers_to_logs: Specifies a list of headers to log.
        """
        if body_bytes is not None:
            pulumi.set(__self__, "body_bytes", body_bytes)
        if data_masking is not None:
            pulumi.set(__self__, "data_masking", data_masking)
        if headers_to_logs is not None:
            pulumi.set(__self__, "headers_to_logs", headers_to_logs)

    @property
    @pulumi.getter(name="bodyBytes")
    def body_bytes(self) -> Optional[builtins.int]:
        """
        Number of payload bytes to log (up to 8192).
        """
        return pulumi.get(self, "body_bytes")

    @property
    @pulumi.getter(name="dataMasking")
    def data_masking(self) -> Optional['outputs.ApiDiagnosticFrontendResponseDataMasking']:
        """
        A `data_masking` block as defined below.
        """
        return pulumi.get(self, "data_masking")

    @property
    @pulumi.getter(name="headersToLogs")
    def headers_to_logs(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of headers to log.
        """
        return pulumi.get(self, "headers_to_logs")


@pulumi.output_type
class ApiDiagnosticFrontendResponseDataMasking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParams":
            suggest = "query_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiDiagnosticFrontendResponseDataMasking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiDiagnosticFrontendResponseDataMasking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiDiagnosticFrontendResponseDataMasking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.ApiDiagnosticFrontendResponseDataMaskingHeader']] = None,
                 query_params: Optional[Sequence['outputs.ApiDiagnosticFrontendResponseDataMaskingQueryParam']] = None):
        """
        :param Sequence['ApiDiagnosticFrontendResponseDataMaskingHeaderArgs'] headers: A `headers` block as defined below.
        :param Sequence['ApiDiagnosticFrontendResponseDataMaskingQueryParamArgs'] query_params: A `query_params` block as defined below.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_params is not None:
            pulumi.set(__self__, "query_params", query_params)

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ApiDiagnosticFrontendResponseDataMaskingHeader']]:
        """
        A `headers` block as defined below.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> Optional[Sequence['outputs.ApiDiagnosticFrontendResponseDataMaskingQueryParam']]:
        """
        A `query_params` block as defined below.
        """
        return pulumi.get(self, "query_params")


@pulumi.output_type
class ApiDiagnosticFrontendResponseDataMaskingHeader(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiDiagnosticFrontendResponseDataMaskingQueryParam(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiImport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentFormat":
            suggest = "content_format"
        elif key == "contentValue":
            suggest = "content_value"
        elif key == "wsdlSelector":
            suggest = "wsdl_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiImport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiImport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiImport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_format: builtins.str,
                 content_value: builtins.str,
                 wsdl_selector: Optional['outputs.ApiImportWsdlSelector'] = None):
        """
        :param builtins.str content_format: The format of the content from which the API Definition should be imported. Possible values are: `openapi`, `openapi+json`, `openapi+json-link`, `openapi-link`, `swagger-json`, `swagger-link-json`, `wadl-link-json`, `wadl-xml`, `wsdl` and `wsdl-link`.
        :param builtins.str content_value: The Content from which the API Definition should be imported. When a `content_format` of `*-link-*` is specified this must be a URL, otherwise this must be defined inline. The URL must be accessible and return a valid document; otherwise, deployment may fail.
        :param 'ApiImportWsdlSelectorArgs' wsdl_selector: A `wsdl_selector` block as defined below, which allows you to limit the import of a WSDL to only a subset of the document. This can only be specified when `content_format` is `wsdl` or `wsdl-link`.
        """
        pulumi.set(__self__, "content_format", content_format)
        pulumi.set(__self__, "content_value", content_value)
        if wsdl_selector is not None:
            pulumi.set(__self__, "wsdl_selector", wsdl_selector)

    @property
    @pulumi.getter(name="contentFormat")
    def content_format(self) -> builtins.str:
        """
        The format of the content from which the API Definition should be imported. Possible values are: `openapi`, `openapi+json`, `openapi+json-link`, `openapi-link`, `swagger-json`, `swagger-link-json`, `wadl-link-json`, `wadl-xml`, `wsdl` and `wsdl-link`.
        """
        return pulumi.get(self, "content_format")

    @property
    @pulumi.getter(name="contentValue")
    def content_value(self) -> builtins.str:
        """
        The Content from which the API Definition should be imported. When a `content_format` of `*-link-*` is specified this must be a URL, otherwise this must be defined inline. The URL must be accessible and return a valid document; otherwise, deployment may fail.
        """
        return pulumi.get(self, "content_value")

    @property
    @pulumi.getter(name="wsdlSelector")
    def wsdl_selector(self) -> Optional['outputs.ApiImportWsdlSelector']:
        """
        A `wsdl_selector` block as defined below, which allows you to limit the import of a WSDL to only a subset of the document. This can only be specified when `content_format` is `wsdl` or `wsdl-link`.
        """
        return pulumi.get(self, "wsdl_selector")


@pulumi.output_type
class ApiImportWsdlSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointName":
            suggest = "endpoint_name"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiImportWsdlSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiImportWsdlSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiImportWsdlSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_name: builtins.str,
                 service_name: builtins.str):
        """
        :param builtins.str endpoint_name: The name of endpoint (port) to import from WSDL.
        :param builtins.str service_name: The name of service to import from WSDL.
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> builtins.str:
        """
        The name of endpoint (port) to import from WSDL.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        The name of service to import from WSDL.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ApiLicense(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the license .
        :param builtins.str url: Absolute URL of the license.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the license .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        Absolute URL of the license.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ApiOauth2Authorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationServerName":
            suggest = "authorization_server_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOauth2Authorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOauth2Authorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOauth2Authorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_server_name: builtins.str,
                 scope: Optional[builtins.str] = None):
        """
        :param builtins.str authorization_server_name: OAuth authorization server identifier. The name of an OAuth2 Authorization Server.
        :param builtins.str scope: Operations scope.
        """
        pulumi.set(__self__, "authorization_server_name", authorization_server_name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="authorizationServerName")
    def authorization_server_name(self) -> builtins.str:
        """
        OAuth authorization server identifier. The name of an OAuth2 Authorization Server.
        """
        return pulumi.get(self, "authorization_server_name")

    @property
    @pulumi.getter
    def scope(self) -> Optional[builtins.str]:
        """
        Operations scope.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class ApiOpenidAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openidProviderName":
            suggest = "openid_provider_name"
        elif key == "bearerTokenSendingMethods":
            suggest = "bearer_token_sending_methods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOpenidAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOpenidAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOpenidAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 openid_provider_name: builtins.str,
                 bearer_token_sending_methods: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str openid_provider_name: OpenID Connect provider identifier. The name of an OpenID Connect Provider.
        :param Sequence[builtins.str] bearer_token_sending_methods: How to send token to the server. A list of zero or more methods. Valid values are `authorizationHeader` and `query`.
        """
        pulumi.set(__self__, "openid_provider_name", openid_provider_name)
        if bearer_token_sending_methods is not None:
            pulumi.set(__self__, "bearer_token_sending_methods", bearer_token_sending_methods)

    @property
    @pulumi.getter(name="openidProviderName")
    def openid_provider_name(self) -> builtins.str:
        """
        OpenID Connect provider identifier. The name of an OpenID Connect Provider.
        """
        return pulumi.get(self, "openid_provider_name")

    @property
    @pulumi.getter(name="bearerTokenSendingMethods")
    def bearer_token_sending_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        How to send token to the server. A list of zero or more methods. Valid values are `authorizationHeader` and `query`.
        """
        return pulumi.get(self, "bearer_token_sending_methods")


@pulumi.output_type
class ApiOperationRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParameters":
            suggest = "query_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[builtins.str] = None,
                 headers: Optional[Sequence['outputs.ApiOperationRequestHeader']] = None,
                 query_parameters: Optional[Sequence['outputs.ApiOperationRequestQueryParameter']] = None,
                 representations: Optional[Sequence['outputs.ApiOperationRequestRepresentation']] = None):
        """
        :param builtins.str description: A description of the HTTP Request, which may include HTML tags.
        :param Sequence['ApiOperationRequestHeaderArgs'] headers: One or more `header` blocks as defined above.
        :param Sequence['ApiOperationRequestQueryParameterArgs'] query_parameters: One or more `query_parameter` blocks as defined above.
        :param Sequence['ApiOperationRequestRepresentationArgs'] representations: One or more `representation` blocks as defined below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)
        if representations is not None:
            pulumi.set(__self__, "representations", representations)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the HTTP Request, which may include HTML tags.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ApiOperationRequestHeader']]:
        """
        One or more `header` blocks as defined above.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[Sequence['outputs.ApiOperationRequestQueryParameter']]:
        """
        One or more `query_parameter` blocks as defined above.
        """
        return pulumi.get(self, "query_parameters")

    @property
    @pulumi.getter
    def representations(self) -> Optional[Sequence['outputs.ApiOperationRequestRepresentation']]:
        """
        One or more `representation` blocks as defined below.
        """
        return pulumi.get(self, "representations")


@pulumi.output_type
class ApiOperationRequestHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "schemaId":
            suggest = "schema_id"
        elif key == "typeName":
            suggest = "type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationRequestHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationRequestHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationRequestHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 required: builtins.bool,
                 type: builtins.str,
                 default_value: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 examples: Optional[Sequence['outputs.ApiOperationRequestHeaderExample']] = None,
                 schema_id: Optional[builtins.str] = None,
                 type_name: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The Name of this Header.
        :param builtins.bool required: Is this Header Required?
        :param builtins.str type: The Type of this Header, such as a `string`.
        :param builtins.str default_value: The default value for this Header.
        :param builtins.str description: A description of this Header.
        :param Sequence['ApiOperationRequestHeaderExampleArgs'] examples: One or more `example` blocks as defined above.
        :param builtins.str schema_id: The name of the Schema.
        :param builtins.str type_name: The type name defined by the Schema.
        :param Sequence[builtins.str] values: One or more acceptable values for this Header.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if examples is not None:
            pulumi.set(__self__, "examples", examples)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The Name of this Header.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> builtins.bool:
        """
        Is this Header Required?
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Type of this Header, such as a `string`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.str]:
        """
        The default value for this Header.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of this Header.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def examples(self) -> Optional[Sequence['outputs.ApiOperationRequestHeaderExample']]:
        """
        One or more `example` blocks as defined above.
        """
        return pulumi.get(self, "examples")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[builtins.str]:
        """
        The name of the Schema.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[builtins.str]:
        """
        The type name defined by the Schema.
        """
        return pulumi.get(self, "type_name")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more acceptable values for this Header.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ApiOperationRequestHeaderExample(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalValue":
            suggest = "external_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationRequestHeaderExample. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationRequestHeaderExample.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationRequestHeaderExample.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 description: Optional[builtins.str] = None,
                 external_value: Optional[builtins.str] = None,
                 summary: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of this example.
        :param builtins.str description: A long description for this example.
        :param builtins.str external_value: A URL that points to the literal example.
        :param builtins.str summary: A short description for this example.
        :param builtins.str value: The example of the representation.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_value is not None:
            pulumi.set(__self__, "external_value", external_value)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this example.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A long description for this example.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> Optional[builtins.str]:
        """
        A URL that points to the literal example.
        """
        return pulumi.get(self, "external_value")

    @property
    @pulumi.getter
    def summary(self) -> Optional[builtins.str]:
        """
        A short description for this example.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The example of the representation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiOperationRequestQueryParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "schemaId":
            suggest = "schema_id"
        elif key == "typeName":
            suggest = "type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationRequestQueryParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationRequestQueryParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationRequestQueryParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 required: builtins.bool,
                 type: builtins.str,
                 default_value: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 examples: Optional[Sequence['outputs.ApiOperationRequestQueryParameterExample']] = None,
                 schema_id: Optional[builtins.str] = None,
                 type_name: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The Name of this Query Parameter.
        :param builtins.bool required: Is this Query Parameter Required?
        :param builtins.str type: The Type of this Query Parameter, such as a `string`.
        :param builtins.str default_value: The default value for this Query Parameter.
        :param builtins.str description: A description of this Query Parameter.
        :param Sequence['ApiOperationRequestQueryParameterExampleArgs'] examples: One or more `example` blocks as defined above.
        :param builtins.str schema_id: The name of the Schema.
        :param builtins.str type_name: The type name defined by the Schema.
        :param Sequence[builtins.str] values: One or more acceptable values for this Query Parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if examples is not None:
            pulumi.set(__self__, "examples", examples)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The Name of this Query Parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> builtins.bool:
        """
        Is this Query Parameter Required?
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Type of this Query Parameter, such as a `string`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.str]:
        """
        The default value for this Query Parameter.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of this Query Parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def examples(self) -> Optional[Sequence['outputs.ApiOperationRequestQueryParameterExample']]:
        """
        One or more `example` blocks as defined above.
        """
        return pulumi.get(self, "examples")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[builtins.str]:
        """
        The name of the Schema.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[builtins.str]:
        """
        The type name defined by the Schema.
        """
        return pulumi.get(self, "type_name")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more acceptable values for this Query Parameter.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ApiOperationRequestQueryParameterExample(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalValue":
            suggest = "external_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationRequestQueryParameterExample. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationRequestQueryParameterExample.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationRequestQueryParameterExample.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 description: Optional[builtins.str] = None,
                 external_value: Optional[builtins.str] = None,
                 summary: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of this example.
        :param builtins.str description: A long description for this example.
        :param builtins.str external_value: A URL that points to the literal example.
        :param builtins.str summary: A short description for this example.
        :param builtins.str value: The example of the representation.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_value is not None:
            pulumi.set(__self__, "external_value", external_value)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this example.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A long description for this example.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> Optional[builtins.str]:
        """
        A URL that points to the literal example.
        """
        return pulumi.get(self, "external_value")

    @property
    @pulumi.getter
    def summary(self) -> Optional[builtins.str]:
        """
        A short description for this example.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The example of the representation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiOperationRequestRepresentation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "formParameters":
            suggest = "form_parameters"
        elif key == "schemaId":
            suggest = "schema_id"
        elif key == "typeName":
            suggest = "type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationRequestRepresentation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationRequestRepresentation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationRequestRepresentation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: builtins.str,
                 examples: Optional[Sequence['outputs.ApiOperationRequestRepresentationExample']] = None,
                 form_parameters: Optional[Sequence['outputs.ApiOperationRequestRepresentationFormParameter']] = None,
                 schema_id: Optional[builtins.str] = None,
                 type_name: Optional[builtins.str] = None):
        """
        :param builtins.str content_type: The Content Type of this representation, such as `application/json`.
        :param Sequence['ApiOperationRequestRepresentationExampleArgs'] examples: One or more `example` blocks as defined above.
        :param Sequence['ApiOperationRequestRepresentationFormParameterArgs'] form_parameters: One or more `form_parameter` block as defined above.
               
               > **Note:** This is Required when `content_type` is set to `application/x-www-form-urlencoded` or `multipart/form-data`.
        :param builtins.str schema_id: The ID of an API Management Schema which represents this Response.
               
               > **Note:** This can only be specified when `content_type` is not set to `application/x-www-form-urlencoded` or `multipart/form-data`.
        :param builtins.str type_name: The Type Name defined by the Schema.
               
               > **Note:** This can only be specified when `content_type` is not set to `application/x-www-form-urlencoded` or `multipart/form-data`.
        """
        pulumi.set(__self__, "content_type", content_type)
        if examples is not None:
            pulumi.set(__self__, "examples", examples)
        if form_parameters is not None:
            pulumi.set(__self__, "form_parameters", form_parameters)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> builtins.str:
        """
        The Content Type of this representation, such as `application/json`.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def examples(self) -> Optional[Sequence['outputs.ApiOperationRequestRepresentationExample']]:
        """
        One or more `example` blocks as defined above.
        """
        return pulumi.get(self, "examples")

    @property
    @pulumi.getter(name="formParameters")
    def form_parameters(self) -> Optional[Sequence['outputs.ApiOperationRequestRepresentationFormParameter']]:
        """
        One or more `form_parameter` block as defined above.

        > **Note:** This is Required when `content_type` is set to `application/x-www-form-urlencoded` or `multipart/form-data`.
        """
        return pulumi.get(self, "form_parameters")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[builtins.str]:
        """
        The ID of an API Management Schema which represents this Response.

        > **Note:** This can only be specified when `content_type` is not set to `application/x-www-form-urlencoded` or `multipart/form-data`.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[builtins.str]:
        """
        The Type Name defined by the Schema.

        > **Note:** This can only be specified when `content_type` is not set to `application/x-www-form-urlencoded` or `multipart/form-data`.
        """
        return pulumi.get(self, "type_name")


@pulumi.output_type
class ApiOperationRequestRepresentationExample(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalValue":
            suggest = "external_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationRequestRepresentationExample. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationRequestRepresentationExample.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationRequestRepresentationExample.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 description: Optional[builtins.str] = None,
                 external_value: Optional[builtins.str] = None,
                 summary: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of this example.
        :param builtins.str description: A long description for this example.
        :param builtins.str external_value: A URL that points to the literal example.
        :param builtins.str summary: A short description for this example.
        :param builtins.str value: The example of the representation.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_value is not None:
            pulumi.set(__self__, "external_value", external_value)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this example.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A long description for this example.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> Optional[builtins.str]:
        """
        A URL that points to the literal example.
        """
        return pulumi.get(self, "external_value")

    @property
    @pulumi.getter
    def summary(self) -> Optional[builtins.str]:
        """
        A short description for this example.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The example of the representation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiOperationRequestRepresentationFormParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "schemaId":
            suggest = "schema_id"
        elif key == "typeName":
            suggest = "type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationRequestRepresentationFormParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationRequestRepresentationFormParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationRequestRepresentationFormParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 required: builtins.bool,
                 type: builtins.str,
                 default_value: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 examples: Optional[Sequence['outputs.ApiOperationRequestRepresentationFormParameterExample']] = None,
                 schema_id: Optional[builtins.str] = None,
                 type_name: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The Name of this Form Parameter.
        :param builtins.bool required: Is this Form Parameter Required?
        :param builtins.str type: The Type of this Form Parameter, such as a `string`.
        :param builtins.str default_value: The default value for this Form Parameter.
        :param builtins.str description: A description of this Form Parameter.
        :param Sequence['ApiOperationRequestRepresentationFormParameterExampleArgs'] examples: One or more `example` blocks as defined above.
        :param builtins.str schema_id: The name of the Schema.
        :param builtins.str type_name: The type name defined by the Schema.
        :param Sequence[builtins.str] values: One or more acceptable values for this Form Parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if examples is not None:
            pulumi.set(__self__, "examples", examples)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The Name of this Form Parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> builtins.bool:
        """
        Is this Form Parameter Required?
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Type of this Form Parameter, such as a `string`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.str]:
        """
        The default value for this Form Parameter.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of this Form Parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def examples(self) -> Optional[Sequence['outputs.ApiOperationRequestRepresentationFormParameterExample']]:
        """
        One or more `example` blocks as defined above.
        """
        return pulumi.get(self, "examples")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[builtins.str]:
        """
        The name of the Schema.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[builtins.str]:
        """
        The type name defined by the Schema.
        """
        return pulumi.get(self, "type_name")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more acceptable values for this Form Parameter.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ApiOperationRequestRepresentationFormParameterExample(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalValue":
            suggest = "external_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationRequestRepresentationFormParameterExample. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationRequestRepresentationFormParameterExample.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationRequestRepresentationFormParameterExample.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 description: Optional[builtins.str] = None,
                 external_value: Optional[builtins.str] = None,
                 summary: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of this example.
        :param builtins.str description: A long description for this example.
        :param builtins.str external_value: A URL that points to the literal example.
        :param builtins.str summary: A short description for this example.
        :param builtins.str value: The example of the representation.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_value is not None:
            pulumi.set(__self__, "external_value", external_value)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this example.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A long description for this example.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> Optional[builtins.str]:
        """
        A URL that points to the literal example.
        """
        return pulumi.get(self, "external_value")

    @property
    @pulumi.getter
    def summary(self) -> Optional[builtins.str]:
        """
        A short description for this example.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The example of the representation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiOperationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: builtins.int,
                 description: Optional[builtins.str] = None,
                 headers: Optional[Sequence['outputs.ApiOperationResponseHeader']] = None,
                 representations: Optional[Sequence['outputs.ApiOperationResponseRepresentation']] = None):
        """
        :param builtins.int status_code: The HTTP Status Code.
        :param builtins.str description: A description of the HTTP Response, which may include HTML tags.
        :param Sequence['ApiOperationResponseHeaderArgs'] headers: One or more `header` blocks as defined above.
        :param Sequence['ApiOperationResponseRepresentationArgs'] representations: One or more `representation` blocks as defined above.
        """
        pulumi.set(__self__, "status_code", status_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if representations is not None:
            pulumi.set(__self__, "representations", representations)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> builtins.int:
        """
        The HTTP Status Code.
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the HTTP Response, which may include HTML tags.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ApiOperationResponseHeader']]:
        """
        One or more `header` blocks as defined above.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def representations(self) -> Optional[Sequence['outputs.ApiOperationResponseRepresentation']]:
        """
        One or more `representation` blocks as defined above.
        """
        return pulumi.get(self, "representations")


@pulumi.output_type
class ApiOperationResponseHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "schemaId":
            suggest = "schema_id"
        elif key == "typeName":
            suggest = "type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationResponseHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationResponseHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationResponseHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 required: builtins.bool,
                 type: builtins.str,
                 default_value: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 examples: Optional[Sequence['outputs.ApiOperationResponseHeaderExample']] = None,
                 schema_id: Optional[builtins.str] = None,
                 type_name: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The Name of this Header.
        :param builtins.bool required: Is this Header Required?
        :param builtins.str type: The Type of this Header, such as a `string`.
        :param builtins.str default_value: The default value for this Header.
        :param builtins.str description: A description of this Header.
        :param Sequence['ApiOperationResponseHeaderExampleArgs'] examples: One or more `example` blocks as defined above.
        :param builtins.str schema_id: The name of the Schema.
        :param builtins.str type_name: The type name defined by the Schema.
        :param Sequence[builtins.str] values: One or more acceptable values for this Header.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if examples is not None:
            pulumi.set(__self__, "examples", examples)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The Name of this Header.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> builtins.bool:
        """
        Is this Header Required?
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Type of this Header, such as a `string`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.str]:
        """
        The default value for this Header.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of this Header.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def examples(self) -> Optional[Sequence['outputs.ApiOperationResponseHeaderExample']]:
        """
        One or more `example` blocks as defined above.
        """
        return pulumi.get(self, "examples")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[builtins.str]:
        """
        The name of the Schema.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[builtins.str]:
        """
        The type name defined by the Schema.
        """
        return pulumi.get(self, "type_name")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more acceptable values for this Header.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ApiOperationResponseHeaderExample(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalValue":
            suggest = "external_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationResponseHeaderExample. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationResponseHeaderExample.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationResponseHeaderExample.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 description: Optional[builtins.str] = None,
                 external_value: Optional[builtins.str] = None,
                 summary: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of this example.
        :param builtins.str description: A long description for this example.
        :param builtins.str external_value: A URL that points to the literal example.
        :param builtins.str summary: A short description for this example.
        :param builtins.str value: The example of the representation.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_value is not None:
            pulumi.set(__self__, "external_value", external_value)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this example.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A long description for this example.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> Optional[builtins.str]:
        """
        A URL that points to the literal example.
        """
        return pulumi.get(self, "external_value")

    @property
    @pulumi.getter
    def summary(self) -> Optional[builtins.str]:
        """
        A short description for this example.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The example of the representation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiOperationResponseRepresentation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "formParameters":
            suggest = "form_parameters"
        elif key == "schemaId":
            suggest = "schema_id"
        elif key == "typeName":
            suggest = "type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationResponseRepresentation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationResponseRepresentation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationResponseRepresentation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: builtins.str,
                 examples: Optional[Sequence['outputs.ApiOperationResponseRepresentationExample']] = None,
                 form_parameters: Optional[Sequence['outputs.ApiOperationResponseRepresentationFormParameter']] = None,
                 schema_id: Optional[builtins.str] = None,
                 type_name: Optional[builtins.str] = None):
        """
        :param builtins.str content_type: The Content Type of this representation, such as `application/json`.
        :param Sequence['ApiOperationResponseRepresentationExampleArgs'] examples: One or more `example` blocks as defined above.
        :param Sequence['ApiOperationResponseRepresentationFormParameterArgs'] form_parameters: One or more `form_parameter` block as defined above.
               
               > **Note:** This is Required when `content_type` is set to `application/x-www-form-urlencoded` or `multipart/form-data`.
        :param builtins.str schema_id: The ID of an API Management Schema which represents this Response.
               
               > **Note:** This can only be specified when `content_type` is not set to `application/x-www-form-urlencoded` or `multipart/form-data`.
        :param builtins.str type_name: The Type Name defined by the Schema.
               
               > **Note:** This can only be specified when `content_type` is not set to `application/x-www-form-urlencoded` or `multipart/form-data`.
        """
        pulumi.set(__self__, "content_type", content_type)
        if examples is not None:
            pulumi.set(__self__, "examples", examples)
        if form_parameters is not None:
            pulumi.set(__self__, "form_parameters", form_parameters)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> builtins.str:
        """
        The Content Type of this representation, such as `application/json`.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def examples(self) -> Optional[Sequence['outputs.ApiOperationResponseRepresentationExample']]:
        """
        One or more `example` blocks as defined above.
        """
        return pulumi.get(self, "examples")

    @property
    @pulumi.getter(name="formParameters")
    def form_parameters(self) -> Optional[Sequence['outputs.ApiOperationResponseRepresentationFormParameter']]:
        """
        One or more `form_parameter` block as defined above.

        > **Note:** This is Required when `content_type` is set to `application/x-www-form-urlencoded` or `multipart/form-data`.
        """
        return pulumi.get(self, "form_parameters")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[builtins.str]:
        """
        The ID of an API Management Schema which represents this Response.

        > **Note:** This can only be specified when `content_type` is not set to `application/x-www-form-urlencoded` or `multipart/form-data`.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[builtins.str]:
        """
        The Type Name defined by the Schema.

        > **Note:** This can only be specified when `content_type` is not set to `application/x-www-form-urlencoded` or `multipart/form-data`.
        """
        return pulumi.get(self, "type_name")


@pulumi.output_type
class ApiOperationResponseRepresentationExample(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalValue":
            suggest = "external_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationResponseRepresentationExample. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationResponseRepresentationExample.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationResponseRepresentationExample.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 description: Optional[builtins.str] = None,
                 external_value: Optional[builtins.str] = None,
                 summary: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of this example.
        :param builtins.str description: A long description for this example.
        :param builtins.str external_value: A URL that points to the literal example.
        :param builtins.str summary: A short description for this example.
        :param builtins.str value: The example of the representation.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_value is not None:
            pulumi.set(__self__, "external_value", external_value)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this example.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A long description for this example.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> Optional[builtins.str]:
        """
        A URL that points to the literal example.
        """
        return pulumi.get(self, "external_value")

    @property
    @pulumi.getter
    def summary(self) -> Optional[builtins.str]:
        """
        A short description for this example.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The example of the representation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiOperationResponseRepresentationFormParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "schemaId":
            suggest = "schema_id"
        elif key == "typeName":
            suggest = "type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationResponseRepresentationFormParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationResponseRepresentationFormParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationResponseRepresentationFormParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 required: builtins.bool,
                 type: builtins.str,
                 default_value: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 examples: Optional[Sequence['outputs.ApiOperationResponseRepresentationFormParameterExample']] = None,
                 schema_id: Optional[builtins.str] = None,
                 type_name: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The Name of this Form Parameter.
        :param builtins.bool required: Is this Form Parameter Required?
        :param builtins.str type: The Type of this Form Parameter, such as a `string`.
        :param builtins.str default_value: The default value for this Form Parameter.
        :param builtins.str description: A description of this Form Parameter.
        :param Sequence['ApiOperationResponseRepresentationFormParameterExampleArgs'] examples: One or more `example` blocks as defined above.
        :param builtins.str schema_id: The name of the Schema.
        :param builtins.str type_name: The type name defined by the Schema.
        :param Sequence[builtins.str] values: One or more acceptable values for this Form Parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if examples is not None:
            pulumi.set(__self__, "examples", examples)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The Name of this Form Parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> builtins.bool:
        """
        Is this Form Parameter Required?
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Type of this Form Parameter, such as a `string`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.str]:
        """
        The default value for this Form Parameter.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of this Form Parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def examples(self) -> Optional[Sequence['outputs.ApiOperationResponseRepresentationFormParameterExample']]:
        """
        One or more `example` blocks as defined above.
        """
        return pulumi.get(self, "examples")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[builtins.str]:
        """
        The name of the Schema.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[builtins.str]:
        """
        The type name defined by the Schema.
        """
        return pulumi.get(self, "type_name")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more acceptable values for this Form Parameter.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ApiOperationResponseRepresentationFormParameterExample(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalValue":
            suggest = "external_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationResponseRepresentationFormParameterExample. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationResponseRepresentationFormParameterExample.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationResponseRepresentationFormParameterExample.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 description: Optional[builtins.str] = None,
                 external_value: Optional[builtins.str] = None,
                 summary: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of this example.
        :param builtins.str description: A long description for this example.
        :param builtins.str external_value: A URL that points to the literal example.
        :param builtins.str summary: A short description for this example.
        :param builtins.str value: The example of the representation.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_value is not None:
            pulumi.set(__self__, "external_value", external_value)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this example.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A long description for this example.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> Optional[builtins.str]:
        """
        A URL that points to the literal example.
        """
        return pulumi.get(self, "external_value")

    @property
    @pulumi.getter
    def summary(self) -> Optional[builtins.str]:
        """
        A short description for this example.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The example of the representation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiOperationTemplateParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "schemaId":
            suggest = "schema_id"
        elif key == "typeName":
            suggest = "type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationTemplateParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationTemplateParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationTemplateParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 required: builtins.bool,
                 type: builtins.str,
                 default_value: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 examples: Optional[Sequence['outputs.ApiOperationTemplateParameterExample']] = None,
                 schema_id: Optional[builtins.str] = None,
                 type_name: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The Name of this Template Parameter.
        :param builtins.bool required: Is this Template Parameter Required?
        :param builtins.str type: The Type of this Template Parameter, such as a `string`.
        :param builtins.str default_value: The default value for this Template Parameter.
        :param builtins.str description: A description of this Template Parameter.
        :param Sequence['ApiOperationTemplateParameterExampleArgs'] examples: One or more `example` blocks as defined above.
        :param builtins.str schema_id: The name of the Schema.
        :param builtins.str type_name: The type name defined by the Schema.
        :param Sequence[builtins.str] values: One or more acceptable values for this Template Parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if examples is not None:
            pulumi.set(__self__, "examples", examples)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The Name of this Template Parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> builtins.bool:
        """
        Is this Template Parameter Required?
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Type of this Template Parameter, such as a `string`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.str]:
        """
        The default value for this Template Parameter.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of this Template Parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def examples(self) -> Optional[Sequence['outputs.ApiOperationTemplateParameterExample']]:
        """
        One or more `example` blocks as defined above.
        """
        return pulumi.get(self, "examples")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[builtins.str]:
        """
        The name of the Schema.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[builtins.str]:
        """
        The type name defined by the Schema.
        """
        return pulumi.get(self, "type_name")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more acceptable values for this Template Parameter.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ApiOperationTemplateParameterExample(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalValue":
            suggest = "external_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOperationTemplateParameterExample. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOperationTemplateParameterExample.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOperationTemplateParameterExample.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 description: Optional[builtins.str] = None,
                 external_value: Optional[builtins.str] = None,
                 summary: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of this example.
        :param builtins.str description: A long description for this example.
        :param builtins.str external_value: A URL that points to the literal example.
        :param builtins.str summary: A short description for this example.
        :param builtins.str value: The example of the representation.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_value is not None:
            pulumi.set(__self__, "external_value", external_value)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this example.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A long description for this example.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalValue")
    def external_value(self) -> Optional[builtins.str]:
        """
        A URL that points to the literal example.
        """
        return pulumi.get(self, "external_value")

    @property
    @pulumi.getter
    def summary(self) -> Optional[builtins.str]:
        """
        A short description for this example.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The example of the representation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiSubscriptionKeyParameterNames(dict):
    def __init__(__self__, *,
                 header: builtins.str,
                 query: builtins.str):
        """
        :param builtins.str header: The name of the HTTP Header which should be used for the Subscription Key.
        :param builtins.str query: The name of the QueryString parameter which should be used for the Subscription Key.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def header(self) -> builtins.str:
        """
        The name of the HTTP Header which should be used for the Subscription Key.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def query(self) -> builtins.str:
        """
        The name of the QueryString parameter which should be used for the Subscription Key.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class AuthorizationServerTokenBodyParameter(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The Name of the Parameter.
        :param builtins.str value: The Value of the Parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The Name of the Parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The Value of the Parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BackendCredentials(dict):
    def __init__(__self__, *,
                 authorization: Optional['outputs.BackendCredentialsAuthorization'] = None,
                 certificates: Optional[Sequence[builtins.str]] = None,
                 header: Optional[Mapping[str, builtins.str]] = None,
                 query: Optional[Mapping[str, builtins.str]] = None):
        """
        :param 'BackendCredentialsAuthorizationArgs' authorization: An `authorization` block as defined below.
        :param Sequence[builtins.str] certificates: A list of client certificate thumbprints to present to the backend host. The certificates must exist within the API Management Service.
        :param Mapping[str, builtins.str] header: A mapping of header parameters to pass to the backend host. The keys are the header names and the values are a comma separated string of header values. This is converted to a list before being passed to the API.
        :param Mapping[str, builtins.str] query: A mapping of query parameters to pass to the backend host. The keys are the query names and the values are a comma separated string of query values. This is converted to a list before being passed to the API.
        """
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def authorization(self) -> Optional['outputs.BackendCredentialsAuthorization']:
        """
        An `authorization` block as defined below.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter
    def certificates(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of client certificate thumbprints to present to the backend host. The certificates must exist within the API Management Service.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter
    def header(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A mapping of header parameters to pass to the backend host. The keys are the header names and the values are a comma separated string of header values. This is converted to a list before being passed to the API.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def query(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A mapping of query parameters to pass to the backend host. The keys are the query names and the values are a comma separated string of query values. This is converted to a list before being passed to the API.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class BackendCredentialsAuthorization(dict):
    def __init__(__self__, *,
                 parameter: Optional[builtins.str] = None,
                 scheme: Optional[builtins.str] = None):
        """
        :param builtins.str parameter: The authentication Parameter value.
        :param builtins.str scheme: The authentication Scheme name.
        """
        if parameter is not None:
            pulumi.set(__self__, "parameter", parameter)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def parameter(self) -> Optional[builtins.str]:
        """
        The authentication Parameter value.
        """
        return pulumi.get(self, "parameter")

    @property
    @pulumi.getter
    def scheme(self) -> Optional[builtins.str]:
        """
        The authentication Scheme name.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class BackendProxy(dict):
    def __init__(__self__, *,
                 url: builtins.str,
                 username: builtins.str,
                 password: Optional[builtins.str] = None):
        """
        :param builtins.str url: The URL of the proxy server.
        :param builtins.str username: The username to connect to the proxy server.
        :param builtins.str password: The password to connect to the proxy server.
        """
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL of the proxy server.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The username to connect to the proxy server.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        The password to connect to the proxy server.
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class BackendServiceFabricCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managementEndpoints":
            suggest = "management_endpoints"
        elif key == "maxPartitionResolutionRetries":
            suggest = "max_partition_resolution_retries"
        elif key == "clientCertificateId":
            suggest = "client_certificate_id"
        elif key == "clientCertificateThumbprint":
            suggest = "client_certificate_thumbprint"
        elif key == "serverCertificateThumbprints":
            suggest = "server_certificate_thumbprints"
        elif key == "serverX509Names":
            suggest = "server_x509_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServiceFabricCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServiceFabricCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServiceFabricCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 management_endpoints: Sequence[builtins.str],
                 max_partition_resolution_retries: builtins.int,
                 client_certificate_id: Optional[builtins.str] = None,
                 client_certificate_thumbprint: Optional[builtins.str] = None,
                 server_certificate_thumbprints: Optional[Sequence[builtins.str]] = None,
                 server_x509_names: Optional[Sequence['outputs.BackendServiceFabricClusterServerX509Name']] = None):
        """
        :param Sequence[builtins.str] management_endpoints: A list of cluster management endpoints.
        :param builtins.int max_partition_resolution_retries: The maximum number of retries when attempting resolve the partition.
        :param builtins.str client_certificate_id: The client certificate resource id for the management endpoint.
               
               > **Note:** At least one of `client_certificate_thumbprint`, and `client_certificate_id` must be set.
        :param builtins.str client_certificate_thumbprint: The client certificate thumbprint for the management endpoint.
        :param Sequence[builtins.str] server_certificate_thumbprints: A list of thumbprints of the server certificates of the Service Fabric cluster.
        :param Sequence['BackendServiceFabricClusterServerX509NameArgs'] server_x509_names: One or more `server_x509_name` blocks as documented below.
        """
        pulumi.set(__self__, "management_endpoints", management_endpoints)
        pulumi.set(__self__, "max_partition_resolution_retries", max_partition_resolution_retries)
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if client_certificate_thumbprint is not None:
            pulumi.set(__self__, "client_certificate_thumbprint", client_certificate_thumbprint)
        if server_certificate_thumbprints is not None:
            pulumi.set(__self__, "server_certificate_thumbprints", server_certificate_thumbprints)
        if server_x509_names is not None:
            pulumi.set(__self__, "server_x509_names", server_x509_names)

    @property
    @pulumi.getter(name="managementEndpoints")
    def management_endpoints(self) -> Sequence[builtins.str]:
        """
        A list of cluster management endpoints.
        """
        return pulumi.get(self, "management_endpoints")

    @property
    @pulumi.getter(name="maxPartitionResolutionRetries")
    def max_partition_resolution_retries(self) -> builtins.int:
        """
        The maximum number of retries when attempting resolve the partition.
        """
        return pulumi.get(self, "max_partition_resolution_retries")

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[builtins.str]:
        """
        The client certificate resource id for the management endpoint.

        > **Note:** At least one of `client_certificate_thumbprint`, and `client_certificate_id` must be set.
        """
        return pulumi.get(self, "client_certificate_id")

    @property
    @pulumi.getter(name="clientCertificateThumbprint")
    def client_certificate_thumbprint(self) -> Optional[builtins.str]:
        """
        The client certificate thumbprint for the management endpoint.
        """
        return pulumi.get(self, "client_certificate_thumbprint")

    @property
    @pulumi.getter(name="serverCertificateThumbprints")
    def server_certificate_thumbprints(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of thumbprints of the server certificates of the Service Fabric cluster.
        """
        return pulumi.get(self, "server_certificate_thumbprints")

    @property
    @pulumi.getter(name="serverX509Names")
    def server_x509_names(self) -> Optional[Sequence['outputs.BackendServiceFabricClusterServerX509Name']]:
        """
        One or more `server_x509_name` blocks as documented below.
        """
        return pulumi.get(self, "server_x509_names")


@pulumi.output_type
class BackendServiceFabricClusterServerX509Name(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issuerCertificateThumbprint":
            suggest = "issuer_certificate_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServiceFabricClusterServerX509Name. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServiceFabricClusterServerX509Name.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServiceFabricClusterServerX509Name.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer_certificate_thumbprint: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str issuer_certificate_thumbprint: The thumbprint for the issuer of the certificate.
        :param builtins.str name: The common name of the certificate.
        """
        pulumi.set(__self__, "issuer_certificate_thumbprint", issuer_certificate_thumbprint)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="issuerCertificateThumbprint")
    def issuer_certificate_thumbprint(self) -> builtins.str:
        """
        The thumbprint for the issuer of the certificate.
        """
        return pulumi.get(self, "issuer_certificate_thumbprint")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The common name of the certificate.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class BackendTls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "validateCertificateChain":
            suggest = "validate_certificate_chain"
        elif key == "validateCertificateName":
            suggest = "validate_certificate_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendTls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendTls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendTls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 validate_certificate_chain: Optional[builtins.bool] = None,
                 validate_certificate_name: Optional[builtins.bool] = None):
        """
        :param builtins.bool validate_certificate_chain: Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for the backend host.
        :param builtins.bool validate_certificate_name: Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for the backend host.
        """
        if validate_certificate_chain is not None:
            pulumi.set(__self__, "validate_certificate_chain", validate_certificate_chain)
        if validate_certificate_name is not None:
            pulumi.set(__self__, "validate_certificate_name", validate_certificate_name)

    @property
    @pulumi.getter(name="validateCertificateChain")
    def validate_certificate_chain(self) -> Optional[builtins.bool]:
        """
        Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for the backend host.
        """
        return pulumi.get(self, "validate_certificate_chain")

    @property
    @pulumi.getter(name="validateCertificateName")
    def validate_certificate_name(self) -> Optional[builtins.bool]:
        """
        Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for the backend host.
        """
        return pulumi.get(self, "validate_certificate_name")


@pulumi.output_type
class CustomDomainDeveloperPortal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "certificateSource":
            suggest = "certificate_source"
        elif key == "certificateStatus":
            suggest = "certificate_status"
        elif key == "keyVaultCertificateId":
            suggest = "key_vault_certificate_id"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "negotiateClientCertificate":
            suggest = "negotiate_client_certificate"
        elif key == "sslKeyvaultIdentityClientId":
            suggest = "ssl_keyvault_identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDomainDeveloperPortal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDomainDeveloperPortal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDomainDeveloperPortal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: builtins.str,
                 certificate: Optional[builtins.str] = None,
                 certificate_password: Optional[builtins.str] = None,
                 certificate_source: Optional[builtins.str] = None,
                 certificate_status: Optional[builtins.str] = None,
                 expiry: Optional[builtins.str] = None,
                 key_vault_certificate_id: Optional[builtins.str] = None,
                 key_vault_id: Optional[builtins.str] = None,
                 negotiate_client_certificate: Optional[builtins.bool] = None,
                 ssl_keyvault_identity_client_id: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 thumbprint: Optional[builtins.str] = None):
        """
        :param builtins.str host_name: The Hostname to use for the corresponding endpoint.
        :param builtins.str certificate: The Base64 Encoded Certificate. (Mutually exclusive with `key_vault_id`.)
        :param builtins.str certificate_password: The password associated with the certificate provided above.
        :param builtins.str key_vault_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be should be of the type application/x-pkcs12.
        :param builtins.bool negotiate_client_certificate: Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        :param builtins.str ssl_keyvault_identity_client_id: System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.
               
               > **NOTE:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        pulumi.set(__self__, "host_name", host_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if certificate_source is not None:
            pulumi.set(__self__, "certificate_source", certificate_source)
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)
        if ssl_keyvault_identity_client_id is not None:
            pulumi.set(__self__, "ssl_keyvault_identity_client_id", ssl_keyvault_identity_client_id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname to use for the corresponding endpoint.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        The Base64 Encoded Certificate. (Mutually exclusive with `key_vault_id`.)
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[builtins.str]:
        """
        The password associated with the certificate provided above.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.str]:
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    @_utilities.deprecated("""`key_vault_id` has been deprecated in favour of `key_vault_certificate_id` and will be removed in v5.0 of the AzureRM provider""")
    def key_vault_id(self) -> Optional[builtins.str]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be should be of the type application/x-pkcs12.
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[builtins.bool]:
        """
        Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        """
        return pulumi.get(self, "negotiate_client_certificate")

    @property
    @pulumi.getter(name="sslKeyvaultIdentityClientId")
    def ssl_keyvault_identity_client_id(self) -> Optional[builtins.str]:
        """
        System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.

        > **NOTE:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        return pulumi.get(self, "ssl_keyvault_identity_client_id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class CustomDomainGateway(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "certificateSource":
            suggest = "certificate_source"
        elif key == "certificateStatus":
            suggest = "certificate_status"
        elif key == "defaultSslBinding":
            suggest = "default_ssl_binding"
        elif key == "keyVaultCertificateId":
            suggest = "key_vault_certificate_id"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "negotiateClientCertificate":
            suggest = "negotiate_client_certificate"
        elif key == "sslKeyvaultIdentityClientId":
            suggest = "ssl_keyvault_identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDomainGateway. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDomainGateway.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDomainGateway.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: builtins.str,
                 certificate: Optional[builtins.str] = None,
                 certificate_password: Optional[builtins.str] = None,
                 certificate_source: Optional[builtins.str] = None,
                 certificate_status: Optional[builtins.str] = None,
                 default_ssl_binding: Optional[builtins.bool] = None,
                 expiry: Optional[builtins.str] = None,
                 key_vault_certificate_id: Optional[builtins.str] = None,
                 key_vault_id: Optional[builtins.str] = None,
                 negotiate_client_certificate: Optional[builtins.bool] = None,
                 ssl_keyvault_identity_client_id: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 thumbprint: Optional[builtins.str] = None):
        """
        :param builtins.str host_name: The Hostname to use for the API Proxy Endpoint.
        :param builtins.str certificate: The Base64 Encoded Certificate. (Mutually exclusive with `key_vault_id`.)
        :param builtins.str certificate_password: The password associated with the certificate provided above.
        :param builtins.bool default_ssl_binding: Is the certificate associated with this Hostname the Default SSL Certificate? This is used when an SNI header isn't specified by a client. Defaults to `false`.
        :param builtins.str key_vault_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be should be of the type application/x-pkcs12.
        :param builtins.bool negotiate_client_certificate: Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        :param builtins.str ssl_keyvault_identity_client_id: System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.
               
               > **NOTE:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        pulumi.set(__self__, "host_name", host_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if certificate_source is not None:
            pulumi.set(__self__, "certificate_source", certificate_source)
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if default_ssl_binding is not None:
            pulumi.set(__self__, "default_ssl_binding", default_ssl_binding)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)
        if ssl_keyvault_identity_client_id is not None:
            pulumi.set(__self__, "ssl_keyvault_identity_client_id", ssl_keyvault_identity_client_id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname to use for the API Proxy Endpoint.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        The Base64 Encoded Certificate. (Mutually exclusive with `key_vault_id`.)
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[builtins.str]:
        """
        The password associated with the certificate provided above.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter(name="defaultSslBinding")
    def default_ssl_binding(self) -> Optional[builtins.bool]:
        """
        Is the certificate associated with this Hostname the Default SSL Certificate? This is used when an SNI header isn't specified by a client. Defaults to `false`.
        """
        return pulumi.get(self, "default_ssl_binding")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.str]:
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    @_utilities.deprecated("""`key_vault_id` has been deprecated in favour of `key_vault_certificate_id` and will be removed in v5.0 of the AzureRM provider""")
    def key_vault_id(self) -> Optional[builtins.str]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be should be of the type application/x-pkcs12.
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[builtins.bool]:
        """
        Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        """
        return pulumi.get(self, "negotiate_client_certificate")

    @property
    @pulumi.getter(name="sslKeyvaultIdentityClientId")
    def ssl_keyvault_identity_client_id(self) -> Optional[builtins.str]:
        """
        System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.

        > **NOTE:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        return pulumi.get(self, "ssl_keyvault_identity_client_id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class CustomDomainManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "certificateSource":
            suggest = "certificate_source"
        elif key == "certificateStatus":
            suggest = "certificate_status"
        elif key == "keyVaultCertificateId":
            suggest = "key_vault_certificate_id"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "negotiateClientCertificate":
            suggest = "negotiate_client_certificate"
        elif key == "sslKeyvaultIdentityClientId":
            suggest = "ssl_keyvault_identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDomainManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDomainManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDomainManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: builtins.str,
                 certificate: Optional[builtins.str] = None,
                 certificate_password: Optional[builtins.str] = None,
                 certificate_source: Optional[builtins.str] = None,
                 certificate_status: Optional[builtins.str] = None,
                 expiry: Optional[builtins.str] = None,
                 key_vault_certificate_id: Optional[builtins.str] = None,
                 key_vault_id: Optional[builtins.str] = None,
                 negotiate_client_certificate: Optional[builtins.bool] = None,
                 ssl_keyvault_identity_client_id: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 thumbprint: Optional[builtins.str] = None):
        """
        :param builtins.str host_name: The Hostname to use for the corresponding endpoint.
        :param builtins.str certificate: The Base64 Encoded Certificate. (Mutually exclusive with `key_vault_id`.)
        :param builtins.str certificate_password: The password associated with the certificate provided above.
        :param builtins.str key_vault_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be should be of the type application/x-pkcs12.
        :param builtins.bool negotiate_client_certificate: Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        :param builtins.str ssl_keyvault_identity_client_id: System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.
               
               > **NOTE:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        pulumi.set(__self__, "host_name", host_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if certificate_source is not None:
            pulumi.set(__self__, "certificate_source", certificate_source)
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)
        if ssl_keyvault_identity_client_id is not None:
            pulumi.set(__self__, "ssl_keyvault_identity_client_id", ssl_keyvault_identity_client_id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname to use for the corresponding endpoint.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        The Base64 Encoded Certificate. (Mutually exclusive with `key_vault_id`.)
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[builtins.str]:
        """
        The password associated with the certificate provided above.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.str]:
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    @_utilities.deprecated("""`key_vault_id` has been deprecated in favour of `key_vault_certificate_id` and will be removed in v5.0 of the AzureRM provider""")
    def key_vault_id(self) -> Optional[builtins.str]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be should be of the type application/x-pkcs12.
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[builtins.bool]:
        """
        Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        """
        return pulumi.get(self, "negotiate_client_certificate")

    @property
    @pulumi.getter(name="sslKeyvaultIdentityClientId")
    def ssl_keyvault_identity_client_id(self) -> Optional[builtins.str]:
        """
        System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.

        > **NOTE:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        return pulumi.get(self, "ssl_keyvault_identity_client_id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class CustomDomainPortal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "certificateSource":
            suggest = "certificate_source"
        elif key == "certificateStatus":
            suggest = "certificate_status"
        elif key == "keyVaultCertificateId":
            suggest = "key_vault_certificate_id"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "negotiateClientCertificate":
            suggest = "negotiate_client_certificate"
        elif key == "sslKeyvaultIdentityClientId":
            suggest = "ssl_keyvault_identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDomainPortal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDomainPortal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDomainPortal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: builtins.str,
                 certificate: Optional[builtins.str] = None,
                 certificate_password: Optional[builtins.str] = None,
                 certificate_source: Optional[builtins.str] = None,
                 certificate_status: Optional[builtins.str] = None,
                 expiry: Optional[builtins.str] = None,
                 key_vault_certificate_id: Optional[builtins.str] = None,
                 key_vault_id: Optional[builtins.str] = None,
                 negotiate_client_certificate: Optional[builtins.bool] = None,
                 ssl_keyvault_identity_client_id: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 thumbprint: Optional[builtins.str] = None):
        """
        :param builtins.str host_name: The Hostname to use for the corresponding endpoint.
        :param builtins.str certificate: The Base64 Encoded Certificate. (Mutually exclusive with `key_vault_id`.)
        :param builtins.str certificate_password: The password associated with the certificate provided above.
        :param builtins.str key_vault_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be should be of the type application/x-pkcs12.
        :param builtins.bool negotiate_client_certificate: Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        :param builtins.str ssl_keyvault_identity_client_id: System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.
               
               > **NOTE:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        pulumi.set(__self__, "host_name", host_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if certificate_source is not None:
            pulumi.set(__self__, "certificate_source", certificate_source)
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)
        if ssl_keyvault_identity_client_id is not None:
            pulumi.set(__self__, "ssl_keyvault_identity_client_id", ssl_keyvault_identity_client_id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname to use for the corresponding endpoint.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        The Base64 Encoded Certificate. (Mutually exclusive with `key_vault_id`.)
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[builtins.str]:
        """
        The password associated with the certificate provided above.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.str]:
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    @_utilities.deprecated("""`key_vault_id` has been deprecated in favour of `key_vault_certificate_id` and will be removed in v5.0 of the AzureRM provider""")
    def key_vault_id(self) -> Optional[builtins.str]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be should be of the type application/x-pkcs12.
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[builtins.bool]:
        """
        Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        """
        return pulumi.get(self, "negotiate_client_certificate")

    @property
    @pulumi.getter(name="sslKeyvaultIdentityClientId")
    def ssl_keyvault_identity_client_id(self) -> Optional[builtins.str]:
        """
        System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.

        > **NOTE:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        return pulumi.get(self, "ssl_keyvault_identity_client_id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class CustomDomainScm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "certificateSource":
            suggest = "certificate_source"
        elif key == "certificateStatus":
            suggest = "certificate_status"
        elif key == "keyVaultCertificateId":
            suggest = "key_vault_certificate_id"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "negotiateClientCertificate":
            suggest = "negotiate_client_certificate"
        elif key == "sslKeyvaultIdentityClientId":
            suggest = "ssl_keyvault_identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDomainScm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDomainScm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDomainScm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: builtins.str,
                 certificate: Optional[builtins.str] = None,
                 certificate_password: Optional[builtins.str] = None,
                 certificate_source: Optional[builtins.str] = None,
                 certificate_status: Optional[builtins.str] = None,
                 expiry: Optional[builtins.str] = None,
                 key_vault_certificate_id: Optional[builtins.str] = None,
                 key_vault_id: Optional[builtins.str] = None,
                 negotiate_client_certificate: Optional[builtins.bool] = None,
                 ssl_keyvault_identity_client_id: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 thumbprint: Optional[builtins.str] = None):
        """
        :param builtins.str host_name: The Hostname to use for the corresponding endpoint.
        :param builtins.str certificate: The Base64 Encoded Certificate. (Mutually exclusive with `key_vault_id`.)
        :param builtins.str certificate_password: The password associated with the certificate provided above.
        :param builtins.str key_vault_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be should be of the type application/x-pkcs12.
        :param builtins.bool negotiate_client_certificate: Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        :param builtins.str ssl_keyvault_identity_client_id: System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.
               
               > **NOTE:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        pulumi.set(__self__, "host_name", host_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if certificate_source is not None:
            pulumi.set(__self__, "certificate_source", certificate_source)
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)
        if ssl_keyvault_identity_client_id is not None:
            pulumi.set(__self__, "ssl_keyvault_identity_client_id", ssl_keyvault_identity_client_id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname to use for the corresponding endpoint.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        The Base64 Encoded Certificate. (Mutually exclusive with `key_vault_id`.)
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[builtins.str]:
        """
        The password associated with the certificate provided above.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.str]:
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    @_utilities.deprecated("""`key_vault_id` has been deprecated in favour of `key_vault_certificate_id` and will be removed in v5.0 of the AzureRM provider""")
    def key_vault_id(self) -> Optional[builtins.str]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be should be of the type application/x-pkcs12.
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[builtins.bool]:
        """
        Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        """
        return pulumi.get(self, "negotiate_client_certificate")

    @property
    @pulumi.getter(name="sslKeyvaultIdentityClientId")
    def ssl_keyvault_identity_client_id(self) -> Optional[builtins.str]:
        """
        System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.

        > **NOTE:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        return pulumi.get(self, "ssl_keyvault_identity_client_id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class DiagnosticBackendRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyBytes":
            suggest = "body_bytes"
        elif key == "dataMasking":
            suggest = "data_masking"
        elif key == "headersToLogs":
            suggest = "headers_to_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticBackendRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticBackendRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticBackendRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_bytes: Optional[builtins.int] = None,
                 data_masking: Optional['outputs.DiagnosticBackendRequestDataMasking'] = None,
                 headers_to_logs: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int body_bytes: Number of payload bytes to log (up to 8192).
        :param 'DiagnosticBackendRequestDataMaskingArgs' data_masking: A `data_masking` block as defined below.
        :param Sequence[builtins.str] headers_to_logs: Specifies a list of headers to log.
        """
        if body_bytes is not None:
            pulumi.set(__self__, "body_bytes", body_bytes)
        if data_masking is not None:
            pulumi.set(__self__, "data_masking", data_masking)
        if headers_to_logs is not None:
            pulumi.set(__self__, "headers_to_logs", headers_to_logs)

    @property
    @pulumi.getter(name="bodyBytes")
    def body_bytes(self) -> Optional[builtins.int]:
        """
        Number of payload bytes to log (up to 8192).
        """
        return pulumi.get(self, "body_bytes")

    @property
    @pulumi.getter(name="dataMasking")
    def data_masking(self) -> Optional['outputs.DiagnosticBackendRequestDataMasking']:
        """
        A `data_masking` block as defined below.
        """
        return pulumi.get(self, "data_masking")

    @property
    @pulumi.getter(name="headersToLogs")
    def headers_to_logs(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of headers to log.
        """
        return pulumi.get(self, "headers_to_logs")


@pulumi.output_type
class DiagnosticBackendRequestDataMasking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParams":
            suggest = "query_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticBackendRequestDataMasking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticBackendRequestDataMasking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticBackendRequestDataMasking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.DiagnosticBackendRequestDataMaskingHeader']] = None,
                 query_params: Optional[Sequence['outputs.DiagnosticBackendRequestDataMaskingQueryParam']] = None):
        """
        :param Sequence['DiagnosticBackendRequestDataMaskingHeaderArgs'] headers: A `headers` block as defined below.
        :param Sequence['DiagnosticBackendRequestDataMaskingQueryParamArgs'] query_params: A `query_params` block as defined below.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_params is not None:
            pulumi.set(__self__, "query_params", query_params)

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.DiagnosticBackendRequestDataMaskingHeader']]:
        """
        A `headers` block as defined below.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> Optional[Sequence['outputs.DiagnosticBackendRequestDataMaskingQueryParam']]:
        """
        A `query_params` block as defined below.
        """
        return pulumi.get(self, "query_params")


@pulumi.output_type
class DiagnosticBackendRequestDataMaskingHeader(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DiagnosticBackendRequestDataMaskingQueryParam(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DiagnosticBackendResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyBytes":
            suggest = "body_bytes"
        elif key == "dataMasking":
            suggest = "data_masking"
        elif key == "headersToLogs":
            suggest = "headers_to_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticBackendResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticBackendResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticBackendResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_bytes: Optional[builtins.int] = None,
                 data_masking: Optional['outputs.DiagnosticBackendResponseDataMasking'] = None,
                 headers_to_logs: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int body_bytes: Number of payload bytes to log (up to 8192).
        :param 'DiagnosticBackendResponseDataMaskingArgs' data_masking: A `data_masking` block as defined below.
        :param Sequence[builtins.str] headers_to_logs: Specifies a list of headers to log.
        """
        if body_bytes is not None:
            pulumi.set(__self__, "body_bytes", body_bytes)
        if data_masking is not None:
            pulumi.set(__self__, "data_masking", data_masking)
        if headers_to_logs is not None:
            pulumi.set(__self__, "headers_to_logs", headers_to_logs)

    @property
    @pulumi.getter(name="bodyBytes")
    def body_bytes(self) -> Optional[builtins.int]:
        """
        Number of payload bytes to log (up to 8192).
        """
        return pulumi.get(self, "body_bytes")

    @property
    @pulumi.getter(name="dataMasking")
    def data_masking(self) -> Optional['outputs.DiagnosticBackendResponseDataMasking']:
        """
        A `data_masking` block as defined below.
        """
        return pulumi.get(self, "data_masking")

    @property
    @pulumi.getter(name="headersToLogs")
    def headers_to_logs(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of headers to log.
        """
        return pulumi.get(self, "headers_to_logs")


@pulumi.output_type
class DiagnosticBackendResponseDataMasking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParams":
            suggest = "query_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticBackendResponseDataMasking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticBackendResponseDataMasking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticBackendResponseDataMasking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.DiagnosticBackendResponseDataMaskingHeader']] = None,
                 query_params: Optional[Sequence['outputs.DiagnosticBackendResponseDataMaskingQueryParam']] = None):
        """
        :param Sequence['DiagnosticBackendResponseDataMaskingHeaderArgs'] headers: A `headers` block as defined below.
        :param Sequence['DiagnosticBackendResponseDataMaskingQueryParamArgs'] query_params: A `query_params` block as defined below.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_params is not None:
            pulumi.set(__self__, "query_params", query_params)

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.DiagnosticBackendResponseDataMaskingHeader']]:
        """
        A `headers` block as defined below.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> Optional[Sequence['outputs.DiagnosticBackendResponseDataMaskingQueryParam']]:
        """
        A `query_params` block as defined below.
        """
        return pulumi.get(self, "query_params")


@pulumi.output_type
class DiagnosticBackendResponseDataMaskingHeader(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DiagnosticBackendResponseDataMaskingQueryParam(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DiagnosticFrontendRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyBytes":
            suggest = "body_bytes"
        elif key == "dataMasking":
            suggest = "data_masking"
        elif key == "headersToLogs":
            suggest = "headers_to_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticFrontendRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticFrontendRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticFrontendRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_bytes: Optional[builtins.int] = None,
                 data_masking: Optional['outputs.DiagnosticFrontendRequestDataMasking'] = None,
                 headers_to_logs: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int body_bytes: Number of payload bytes to log (up to 8192).
        :param 'DiagnosticFrontendRequestDataMaskingArgs' data_masking: A `data_masking` block as defined below.
        :param Sequence[builtins.str] headers_to_logs: Specifies a list of headers to log.
        """
        if body_bytes is not None:
            pulumi.set(__self__, "body_bytes", body_bytes)
        if data_masking is not None:
            pulumi.set(__self__, "data_masking", data_masking)
        if headers_to_logs is not None:
            pulumi.set(__self__, "headers_to_logs", headers_to_logs)

    @property
    @pulumi.getter(name="bodyBytes")
    def body_bytes(self) -> Optional[builtins.int]:
        """
        Number of payload bytes to log (up to 8192).
        """
        return pulumi.get(self, "body_bytes")

    @property
    @pulumi.getter(name="dataMasking")
    def data_masking(self) -> Optional['outputs.DiagnosticFrontendRequestDataMasking']:
        """
        A `data_masking` block as defined below.
        """
        return pulumi.get(self, "data_masking")

    @property
    @pulumi.getter(name="headersToLogs")
    def headers_to_logs(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of headers to log.
        """
        return pulumi.get(self, "headers_to_logs")


@pulumi.output_type
class DiagnosticFrontendRequestDataMasking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParams":
            suggest = "query_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticFrontendRequestDataMasking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticFrontendRequestDataMasking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticFrontendRequestDataMasking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.DiagnosticFrontendRequestDataMaskingHeader']] = None,
                 query_params: Optional[Sequence['outputs.DiagnosticFrontendRequestDataMaskingQueryParam']] = None):
        """
        :param Sequence['DiagnosticFrontendRequestDataMaskingHeaderArgs'] headers: A `headers` block as defined below.
        :param Sequence['DiagnosticFrontendRequestDataMaskingQueryParamArgs'] query_params: A `query_params` block as defined below.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_params is not None:
            pulumi.set(__self__, "query_params", query_params)

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.DiagnosticFrontendRequestDataMaskingHeader']]:
        """
        A `headers` block as defined below.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> Optional[Sequence['outputs.DiagnosticFrontendRequestDataMaskingQueryParam']]:
        """
        A `query_params` block as defined below.
        """
        return pulumi.get(self, "query_params")


@pulumi.output_type
class DiagnosticFrontendRequestDataMaskingHeader(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DiagnosticFrontendRequestDataMaskingQueryParam(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DiagnosticFrontendResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyBytes":
            suggest = "body_bytes"
        elif key == "dataMasking":
            suggest = "data_masking"
        elif key == "headersToLogs":
            suggest = "headers_to_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticFrontendResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticFrontendResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticFrontendResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_bytes: Optional[builtins.int] = None,
                 data_masking: Optional['outputs.DiagnosticFrontendResponseDataMasking'] = None,
                 headers_to_logs: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int body_bytes: Number of payload bytes to log (up to 8192).
        :param 'DiagnosticFrontendResponseDataMaskingArgs' data_masking: A `data_masking` block as defined below.
        :param Sequence[builtins.str] headers_to_logs: Specifies a list of headers to log.
        """
        if body_bytes is not None:
            pulumi.set(__self__, "body_bytes", body_bytes)
        if data_masking is not None:
            pulumi.set(__self__, "data_masking", data_masking)
        if headers_to_logs is not None:
            pulumi.set(__self__, "headers_to_logs", headers_to_logs)

    @property
    @pulumi.getter(name="bodyBytes")
    def body_bytes(self) -> Optional[builtins.int]:
        """
        Number of payload bytes to log (up to 8192).
        """
        return pulumi.get(self, "body_bytes")

    @property
    @pulumi.getter(name="dataMasking")
    def data_masking(self) -> Optional['outputs.DiagnosticFrontendResponseDataMasking']:
        """
        A `data_masking` block as defined below.
        """
        return pulumi.get(self, "data_masking")

    @property
    @pulumi.getter(name="headersToLogs")
    def headers_to_logs(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of headers to log.
        """
        return pulumi.get(self, "headers_to_logs")


@pulumi.output_type
class DiagnosticFrontendResponseDataMasking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParams":
            suggest = "query_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticFrontendResponseDataMasking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticFrontendResponseDataMasking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticFrontendResponseDataMasking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.DiagnosticFrontendResponseDataMaskingHeader']] = None,
                 query_params: Optional[Sequence['outputs.DiagnosticFrontendResponseDataMaskingQueryParam']] = None):
        """
        :param Sequence['DiagnosticFrontendResponseDataMaskingHeaderArgs'] headers: A `headers` block as defined below.
        :param Sequence['DiagnosticFrontendResponseDataMaskingQueryParamArgs'] query_params: A `query_params` block as defined below.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_params is not None:
            pulumi.set(__self__, "query_params", query_params)

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.DiagnosticFrontendResponseDataMaskingHeader']]:
        """
        A `headers` block as defined below.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> Optional[Sequence['outputs.DiagnosticFrontendResponseDataMaskingQueryParam']]:
        """
        A `query_params` block as defined below.
        """
        return pulumi.get(self, "query_params")


@pulumi.output_type
class DiagnosticFrontendResponseDataMaskingHeader(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DiagnosticFrontendResponseDataMaskingQueryParam(dict):
    def __init__(__self__, *,
                 mode: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str mode: The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        :param builtins.str value: The name of the header or the query parameter to mask.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The data masking mode. Possible values are `Mask` and `Hide` for `query_params`. The only possible value is `Mask` for `headers`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The name of the header or the query parameter to mask.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GatewayLocationData(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 city: Optional[builtins.str] = None,
                 district: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str name: A canonical name for the geographic or physical location.
        :param builtins.str city: The city or locality where the resource is located.
        :param builtins.str district: The district, state, or province where the resource is located.
        :param builtins.str region: The country or region where the resource is located.
        """
        pulumi.set(__self__, "name", name)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if district is not None:
            pulumi.set(__self__, "district", district)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A canonical name for the geographic or physical location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        The city or locality where the resource is located.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def district(self) -> Optional[builtins.str]:
        """
        The district, state, or province where the resource is located.
        """
        return pulumi.get(self, "district")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The country or region where the resource is located.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class LoggerApplicationInsights(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "instrumentationKey":
            suggest = "instrumentation_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggerApplicationInsights. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggerApplicationInsights.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggerApplicationInsights.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Optional[builtins.str] = None,
                 instrumentation_key: Optional[builtins.str] = None):
        """
        :param builtins.str connection_string: The connection string of Application Insights.
        :param builtins.str instrumentation_key: The instrumentation key used to push data to Application Insights.
               
               > **Note:** Either `connection_string` or `instrumentation_key` have to be specified.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if instrumentation_key is not None:
            pulumi.set(__self__, "instrumentation_key", instrumentation_key)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[builtins.str]:
        """
        The connection string of Application Insights.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="instrumentationKey")
    def instrumentation_key(self) -> Optional[builtins.str]:
        """
        The instrumentation key used to push data to Application Insights.

        > **Note:** Either `connection_string` or `instrumentation_key` have to be specified.
        """
        return pulumi.get(self, "instrumentation_key")


@pulumi.output_type
class LoggerEventhub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "userAssignedIdentityClientId":
            suggest = "user_assigned_identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggerEventhub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggerEventhub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggerEventhub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 connection_string: Optional[builtins.str] = None,
                 endpoint_uri: Optional[builtins.str] = None,
                 user_assigned_identity_client_id: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of an EventHub.
        :param builtins.str connection_string: The connection string of an EventHub Namespace.
               
               > **Note:** At least one of `connection_string` or `endpoint_uri` must be specified
        :param builtins.str endpoint_uri: The endpoint address of an EventHub Namespace. Required when `client_id` is set.
        :param builtins.str user_assigned_identity_client_id: The Client Id of the User Assigned Identity with the "Azure Event Hubs Data Sender" role to the target EventHub Namespace. Required when `endpoint_uri` is set. If not specified the System Assigned Identity will be used.
        """
        pulumi.set(__self__, "name", name)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if user_assigned_identity_client_id is not None:
            pulumi.set(__self__, "user_assigned_identity_client_id", user_assigned_identity_client_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of an EventHub.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[builtins.str]:
        """
        The connection string of an EventHub Namespace.

        > **Note:** At least one of `connection_string` or `endpoint_uri` must be specified
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[builtins.str]:
        """
        The endpoint address of an EventHub Namespace. Required when `client_id` is set.
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="userAssignedIdentityClientId")
    def user_assigned_identity_client_id(self) -> Optional[builtins.str]:
        """
        The Client Id of the User Assigned Identity with the "Azure Event Hubs Data Sender" role to the target EventHub Namespace. Required when `endpoint_uri` is set. If not specified the System Assigned Identity will be used.
        """
        return pulumi.get(self, "user_assigned_identity_client_id")


@pulumi.output_type
class NamedValueValueFromKeyVault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretId":
            suggest = "secret_id"
        elif key == "identityClientId":
            suggest = "identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamedValueValueFromKeyVault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamedValueValueFromKeyVault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamedValueValueFromKeyVault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_id: builtins.str,
                 identity_client_id: Optional[builtins.str] = None):
        """
        :param builtins.str secret_id: The resource ID of the Key Vault Secret.
        :param builtins.str identity_client_id: The client ID of User Assigned Identity, for the API Management Service, which will be used to access the key vault secret. The System Assigned Identity will be used in absence.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> builtins.str:
        """
        The resource ID of the Key Vault Secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[builtins.str]:
        """
        The client ID of User Assigned Identity, for the API Management Service, which will be used to access the key vault secret. The System Assigned Identity will be used in absence.
        """
        return pulumi.get(self, "identity_client_id")


@pulumi.output_type
class ServiceAdditionalLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gatewayDisabled":
            suggest = "gateway_disabled"
        elif key == "gatewayRegionalUrl":
            suggest = "gateway_regional_url"
        elif key == "privateIpAddresses":
            suggest = "private_ip_addresses"
        elif key == "publicIpAddressId":
            suggest = "public_ip_address_id"
        elif key == "publicIpAddresses":
            suggest = "public_ip_addresses"
        elif key == "virtualNetworkConfiguration":
            suggest = "virtual_network_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAdditionalLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAdditionalLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAdditionalLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: builtins.str,
                 capacity: Optional[builtins.int] = None,
                 gateway_disabled: Optional[builtins.bool] = None,
                 gateway_regional_url: Optional[builtins.str] = None,
                 private_ip_addresses: Optional[Sequence[builtins.str]] = None,
                 public_ip_address_id: Optional[builtins.str] = None,
                 public_ip_addresses: Optional[Sequence[builtins.str]] = None,
                 virtual_network_configuration: Optional['outputs.ServiceAdditionalLocationVirtualNetworkConfiguration'] = None,
                 zones: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str location: The name of the Azure Region in which the API Management Service should be expanded to.
        :param builtins.int capacity: The number of compute units in this region. Defaults to the capacity of the main region.
        :param builtins.bool gateway_disabled: Only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in this additional location.
        :param builtins.str gateway_regional_url: The URL of the Regional Gateway for the API Management Service in the specified region.
        :param Sequence[builtins.str] private_ip_addresses: The Private IP addresses of the API Management Service. Available only when the API Manager instance is using Virtual Network mode.
        :param builtins.str public_ip_address_id: ID of a standard SKU IPv4 Public IP.
               
               > **Note:** Availability zones and custom public IPs are only supported in the Premium tier.
        :param Sequence[builtins.str] public_ip_addresses: Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard and Premium SKU.
        :param 'ServiceAdditionalLocationVirtualNetworkConfigurationArgs' virtual_network_configuration: A `virtual_network_configuration` block as defined below. Required when `virtual_network_type` is `External` or `Internal`.
        :param Sequence[builtins.str] zones: A list of availability zones.
        """
        pulumi.set(__self__, "location", location)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if gateway_disabled is not None:
            pulumi.set(__self__, "gateway_disabled", gateway_disabled)
        if gateway_regional_url is not None:
            pulumi.set(__self__, "gateway_regional_url", gateway_regional_url)
        if private_ip_addresses is not None:
            pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        if public_ip_address_id is not None:
            pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        if public_ip_addresses is not None:
            pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        if virtual_network_configuration is not None:
            pulumi.set(__self__, "virtual_network_configuration", virtual_network_configuration)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The name of the Azure Region in which the API Management Service should be expanded to.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[builtins.int]:
        """
        The number of compute units in this region. Defaults to the capacity of the main region.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="gatewayDisabled")
    def gateway_disabled(self) -> Optional[builtins.bool]:
        """
        Only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in this additional location.
        """
        return pulumi.get(self, "gateway_disabled")

    @property
    @pulumi.getter(name="gatewayRegionalUrl")
    def gateway_regional_url(self) -> Optional[builtins.str]:
        """
        The URL of the Regional Gateway for the API Management Service in the specified region.
        """
        return pulumi.get(self, "gateway_regional_url")

    @property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Optional[Sequence[builtins.str]]:
        """
        The Private IP addresses of the API Management Service. Available only when the API Manager instance is using Virtual Network mode.
        """
        return pulumi.get(self, "private_ip_addresses")

    @property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> Optional[builtins.str]:
        """
        ID of a standard SKU IPv4 Public IP.

        > **Note:** Availability zones and custom public IPs are only supported in the Premium tier.
        """
        return pulumi.get(self, "public_ip_address_id")

    @property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Optional[Sequence[builtins.str]]:
        """
        Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard and Premium SKU.
        """
        return pulumi.get(self, "public_ip_addresses")

    @property
    @pulumi.getter(name="virtualNetworkConfiguration")
    def virtual_network_configuration(self) -> Optional['outputs.ServiceAdditionalLocationVirtualNetworkConfiguration']:
        """
        A `virtual_network_configuration` block as defined below. Required when `virtual_network_type` is `External` or `Internal`.
        """
        return pulumi.get(self, "virtual_network_configuration")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of availability zones.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class ServiceAdditionalLocationVirtualNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAdditionalLocationVirtualNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAdditionalLocationVirtualNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAdditionalLocationVirtualNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: builtins.str):
        """
        :param builtins.str subnet_id: The id of the subnet that will be used for the API Management.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The id of the subnet that will be used for the API Management.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class ServiceCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encodedCertificate":
            suggest = "encoded_certificate"
        elif key == "storeName":
            suggest = "store_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encoded_certificate: builtins.str,
                 store_name: builtins.str,
                 certificate_password: Optional[builtins.str] = None,
                 expiry: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 thumbprint: Optional[builtins.str] = None):
        """
        :param builtins.str encoded_certificate: The Base64 Encoded PFX or Base64 Encoded X.509 Certificate.
        :param builtins.str store_name: The name of the Certificate Store where this certificate should be stored. Possible values are `CertificateAuthority` and `Root`.
        :param builtins.str certificate_password: The password for the certificate.
        :param builtins.str expiry: The expiration date of the certificate in RFC3339 format: `2000-01-02T03:04:05Z`.
        :param builtins.str subject: The subject of the certificate.
        :param builtins.str thumbprint: The thumbprint of the certificate.
        """
        pulumi.set(__self__, "encoded_certificate", encoded_certificate)
        pulumi.set(__self__, "store_name", store_name)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="encodedCertificate")
    def encoded_certificate(self) -> builtins.str:
        """
        The Base64 Encoded PFX or Base64 Encoded X.509 Certificate.
        """
        return pulumi.get(self, "encoded_certificate")

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> builtins.str:
        """
        The name of the Certificate Store where this certificate should be stored. Possible values are `CertificateAuthority` and `Root`.
        """
        return pulumi.get(self, "store_name")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[builtins.str]:
        """
        The password for the certificate.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.str]:
        """
        The expiration date of the certificate in RFC3339 format: `2000-01-02T03:04:05Z`.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        The subject of the certificate.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[builtins.str]:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class ServiceDelegation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subscriptionsEnabled":
            suggest = "subscriptions_enabled"
        elif key == "userRegistrationEnabled":
            suggest = "user_registration_enabled"
        elif key == "validationKey":
            suggest = "validation_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDelegation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDelegation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDelegation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subscriptions_enabled: Optional[builtins.bool] = None,
                 url: Optional[builtins.str] = None,
                 user_registration_enabled: Optional[builtins.bool] = None,
                 validation_key: Optional[builtins.str] = None):
        """
        :param builtins.bool subscriptions_enabled: Should subscription requests be delegated to an external url? Defaults to `false`.
        :param builtins.str url: The delegation URL.
        :param builtins.bool user_registration_enabled: Should user registration requests be delegated to an external url? Defaults to `false`.
        :param builtins.str validation_key: A base64-encoded validation key to validate, that a request is coming from Azure API Management.
        """
        if subscriptions_enabled is not None:
            pulumi.set(__self__, "subscriptions_enabled", subscriptions_enabled)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_registration_enabled is not None:
            pulumi.set(__self__, "user_registration_enabled", user_registration_enabled)
        if validation_key is not None:
            pulumi.set(__self__, "validation_key", validation_key)

    @property
    @pulumi.getter(name="subscriptionsEnabled")
    def subscriptions_enabled(self) -> Optional[builtins.bool]:
        """
        Should subscription requests be delegated to an external url? Defaults to `false`.
        """
        return pulumi.get(self, "subscriptions_enabled")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        The delegation URL.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userRegistrationEnabled")
    def user_registration_enabled(self) -> Optional[builtins.bool]:
        """
        Should user registration requests be delegated to an external url? Defaults to `false`.
        """
        return pulumi.get(self, "user_registration_enabled")

    @property
    @pulumi.getter(name="validationKey")
    def validation_key(self) -> Optional[builtins.str]:
        """
        A base64-encoded validation key to validate, that a request is coming from Azure API Management.
        """
        return pulumi.get(self, "validation_key")


@pulumi.output_type
class ServiceHostnameConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "developerPortals":
            suggest = "developer_portals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceHostnameConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceHostnameConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceHostnameConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 developer_portals: Optional[Sequence['outputs.ServiceHostnameConfigurationDeveloperPortal']] = None,
                 managements: Optional[Sequence['outputs.ServiceHostnameConfigurationManagement']] = None,
                 portals: Optional[Sequence['outputs.ServiceHostnameConfigurationPortal']] = None,
                 proxies: Optional[Sequence['outputs.ServiceHostnameConfigurationProxy']] = None,
                 scms: Optional[Sequence['outputs.ServiceHostnameConfigurationScm']] = None):
        """
        :param Sequence['ServiceHostnameConfigurationDeveloperPortalArgs'] developer_portals: One or more `developer_portal` blocks as documented below.
        :param Sequence['ServiceHostnameConfigurationManagementArgs'] managements: One or more `management` blocks as documented below.
        :param Sequence['ServiceHostnameConfigurationPortalArgs'] portals: One or more `portal` blocks as documented below.
        :param Sequence['ServiceHostnameConfigurationProxyArgs'] proxies: One or more `proxy` blocks as documented below.
        :param Sequence['ServiceHostnameConfigurationScmArgs'] scms: One or more `scm` blocks as documented below.
        """
        if developer_portals is not None:
            pulumi.set(__self__, "developer_portals", developer_portals)
        if managements is not None:
            pulumi.set(__self__, "managements", managements)
        if portals is not None:
            pulumi.set(__self__, "portals", portals)
        if proxies is not None:
            pulumi.set(__self__, "proxies", proxies)
        if scms is not None:
            pulumi.set(__self__, "scms", scms)

    @property
    @pulumi.getter(name="developerPortals")
    def developer_portals(self) -> Optional[Sequence['outputs.ServiceHostnameConfigurationDeveloperPortal']]:
        """
        One or more `developer_portal` blocks as documented below.
        """
        return pulumi.get(self, "developer_portals")

    @property
    @pulumi.getter
    def managements(self) -> Optional[Sequence['outputs.ServiceHostnameConfigurationManagement']]:
        """
        One or more `management` blocks as documented below.
        """
        return pulumi.get(self, "managements")

    @property
    @pulumi.getter
    def portals(self) -> Optional[Sequence['outputs.ServiceHostnameConfigurationPortal']]:
        """
        One or more `portal` blocks as documented below.
        """
        return pulumi.get(self, "portals")

    @property
    @pulumi.getter
    def proxies(self) -> Optional[Sequence['outputs.ServiceHostnameConfigurationProxy']]:
        """
        One or more `proxy` blocks as documented below.
        """
        return pulumi.get(self, "proxies")

    @property
    @pulumi.getter
    def scms(self) -> Optional[Sequence['outputs.ServiceHostnameConfigurationScm']]:
        """
        One or more `scm` blocks as documented below.
        """
        return pulumi.get(self, "scms")


@pulumi.output_type
class ServiceHostnameConfigurationDeveloperPortal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "certificateSource":
            suggest = "certificate_source"
        elif key == "certificateStatus":
            suggest = "certificate_status"
        elif key == "keyVaultCertificateId":
            suggest = "key_vault_certificate_id"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "negotiateClientCertificate":
            suggest = "negotiate_client_certificate"
        elif key == "sslKeyvaultIdentityClientId":
            suggest = "ssl_keyvault_identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceHostnameConfigurationDeveloperPortal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceHostnameConfigurationDeveloperPortal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceHostnameConfigurationDeveloperPortal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: builtins.str,
                 certificate: Optional[builtins.str] = None,
                 certificate_password: Optional[builtins.str] = None,
                 certificate_source: Optional[builtins.str] = None,
                 certificate_status: Optional[builtins.str] = None,
                 expiry: Optional[builtins.str] = None,
                 key_vault_certificate_id: Optional[builtins.str] = None,
                 key_vault_id: Optional[builtins.str] = None,
                 negotiate_client_certificate: Optional[builtins.bool] = None,
                 ssl_keyvault_identity_client_id: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 thumbprint: Optional[builtins.str] = None):
        """
        :param builtins.str host_name: The Hostname to use for the Management API.
        :param builtins.str certificate: The Base64 Encoded Certificate.
        :param builtins.str certificate_password: The password associated with the certificate provided above.
               
               > **Note:** Either `key_vault_certificate_id` or `certificate` and `certificate_password` must be specified.
        :param builtins.str certificate_source: The source of the certificate.
        :param builtins.str certificate_status: The status of the certificate.
        :param builtins.str expiry: The expiration date of the certificate in RFC3339 format: `2000-01-02T03:04:05Z`.
        :param builtins.str key_vault_certificate_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.
               
               > **Note:** Setting this field requires the `identity` block to be specified, since this identity is used for to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires the Secret version isn't specified.
        :param builtins.bool negotiate_client_certificate: Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        :param builtins.str ssl_keyvault_identity_client_id: System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.
               
               > **Note:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        :param builtins.str subject: The subject of the certificate.
        :param builtins.str thumbprint: The thumbprint of the certificate.
        """
        pulumi.set(__self__, "host_name", host_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if certificate_source is not None:
            pulumi.set(__self__, "certificate_source", certificate_source)
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)
        if ssl_keyvault_identity_client_id is not None:
            pulumi.set(__self__, "ssl_keyvault_identity_client_id", ssl_keyvault_identity_client_id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname to use for the Management API.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        The Base64 Encoded Certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[builtins.str]:
        """
        The password associated with the certificate provided above.

        > **Note:** Either `key_vault_certificate_id` or `certificate` and `certificate_password` must be specified.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> Optional[builtins.str]:
        """
        The source of the certificate.
        """
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[builtins.str]:
        """
        The status of the certificate.
        """
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.str]:
        """
        The expiration date of the certificate in RFC3339 format: `2000-01-02T03:04:05Z`.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[builtins.str]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.

        > **Note:** Setting this field requires the `identity` block to be specified, since this identity is used for to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires the Secret version isn't specified.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    @_utilities.deprecated("""`key_vault_id` has been deprecated in favour of `key_vault_certificate_id` and will be removed in v5.0 of the AzureRM provider""")
    def key_vault_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[builtins.bool]:
        """
        Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        """
        return pulumi.get(self, "negotiate_client_certificate")

    @property
    @pulumi.getter(name="sslKeyvaultIdentityClientId")
    def ssl_keyvault_identity_client_id(self) -> Optional[builtins.str]:
        """
        System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.

        > **Note:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        return pulumi.get(self, "ssl_keyvault_identity_client_id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        The subject of the certificate.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[builtins.str]:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class ServiceHostnameConfigurationManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "certificateSource":
            suggest = "certificate_source"
        elif key == "certificateStatus":
            suggest = "certificate_status"
        elif key == "keyVaultCertificateId":
            suggest = "key_vault_certificate_id"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "negotiateClientCertificate":
            suggest = "negotiate_client_certificate"
        elif key == "sslKeyvaultIdentityClientId":
            suggest = "ssl_keyvault_identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceHostnameConfigurationManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceHostnameConfigurationManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceHostnameConfigurationManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: builtins.str,
                 certificate: Optional[builtins.str] = None,
                 certificate_password: Optional[builtins.str] = None,
                 certificate_source: Optional[builtins.str] = None,
                 certificate_status: Optional[builtins.str] = None,
                 expiry: Optional[builtins.str] = None,
                 key_vault_certificate_id: Optional[builtins.str] = None,
                 key_vault_id: Optional[builtins.str] = None,
                 negotiate_client_certificate: Optional[builtins.bool] = None,
                 ssl_keyvault_identity_client_id: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 thumbprint: Optional[builtins.str] = None):
        """
        :param builtins.str host_name: The Hostname to use for the Management API.
        :param builtins.str certificate: The Base64 Encoded Certificate.
        :param builtins.str certificate_password: The password associated with the certificate provided above.
               
               > **Note:** Either `key_vault_certificate_id` or `certificate` and `certificate_password` must be specified.
        :param builtins.str certificate_source: The source of the certificate.
        :param builtins.str certificate_status: The status of the certificate.
        :param builtins.str expiry: The expiration date of the certificate in RFC3339 format: `2000-01-02T03:04:05Z`.
        :param builtins.str key_vault_certificate_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.
               
               > **Note:** Setting this field requires the `identity` block to be specified, since this identity is used for to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires the Secret version isn't specified.
        :param builtins.bool negotiate_client_certificate: Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        :param builtins.str ssl_keyvault_identity_client_id: System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.
               
               > **Note:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        :param builtins.str subject: The subject of the certificate.
        :param builtins.str thumbprint: The thumbprint of the certificate.
        """
        pulumi.set(__self__, "host_name", host_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if certificate_source is not None:
            pulumi.set(__self__, "certificate_source", certificate_source)
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)
        if ssl_keyvault_identity_client_id is not None:
            pulumi.set(__self__, "ssl_keyvault_identity_client_id", ssl_keyvault_identity_client_id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname to use for the Management API.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        The Base64 Encoded Certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[builtins.str]:
        """
        The password associated with the certificate provided above.

        > **Note:** Either `key_vault_certificate_id` or `certificate` and `certificate_password` must be specified.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> Optional[builtins.str]:
        """
        The source of the certificate.
        """
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[builtins.str]:
        """
        The status of the certificate.
        """
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.str]:
        """
        The expiration date of the certificate in RFC3339 format: `2000-01-02T03:04:05Z`.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[builtins.str]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.

        > **Note:** Setting this field requires the `identity` block to be specified, since this identity is used for to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires the Secret version isn't specified.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    @_utilities.deprecated("""`key_vault_id` has been deprecated in favour of `key_vault_certificate_id` and will be removed in v5.0 of the AzureRM provider""")
    def key_vault_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[builtins.bool]:
        """
        Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        """
        return pulumi.get(self, "negotiate_client_certificate")

    @property
    @pulumi.getter(name="sslKeyvaultIdentityClientId")
    def ssl_keyvault_identity_client_id(self) -> Optional[builtins.str]:
        """
        System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.

        > **Note:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        return pulumi.get(self, "ssl_keyvault_identity_client_id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        The subject of the certificate.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[builtins.str]:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class ServiceHostnameConfigurationPortal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "certificateSource":
            suggest = "certificate_source"
        elif key == "certificateStatus":
            suggest = "certificate_status"
        elif key == "keyVaultCertificateId":
            suggest = "key_vault_certificate_id"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "negotiateClientCertificate":
            suggest = "negotiate_client_certificate"
        elif key == "sslKeyvaultIdentityClientId":
            suggest = "ssl_keyvault_identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceHostnameConfigurationPortal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceHostnameConfigurationPortal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceHostnameConfigurationPortal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: builtins.str,
                 certificate: Optional[builtins.str] = None,
                 certificate_password: Optional[builtins.str] = None,
                 certificate_source: Optional[builtins.str] = None,
                 certificate_status: Optional[builtins.str] = None,
                 expiry: Optional[builtins.str] = None,
                 key_vault_certificate_id: Optional[builtins.str] = None,
                 key_vault_id: Optional[builtins.str] = None,
                 negotiate_client_certificate: Optional[builtins.bool] = None,
                 ssl_keyvault_identity_client_id: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 thumbprint: Optional[builtins.str] = None):
        """
        :param builtins.str host_name: The Hostname to use for the Management API.
        :param builtins.str certificate: The Base64 Encoded Certificate.
        :param builtins.str certificate_password: The password associated with the certificate provided above.
               
               > **Note:** Either `key_vault_certificate_id` or `certificate` and `certificate_password` must be specified.
        :param builtins.str certificate_source: The source of the certificate.
        :param builtins.str certificate_status: The status of the certificate.
        :param builtins.str expiry: The expiration date of the certificate in RFC3339 format: `2000-01-02T03:04:05Z`.
        :param builtins.str key_vault_certificate_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.
               
               > **Note:** Setting this field requires the `identity` block to be specified, since this identity is used for to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires the Secret version isn't specified.
        :param builtins.bool negotiate_client_certificate: Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        :param builtins.str ssl_keyvault_identity_client_id: System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.
               
               > **Note:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        :param builtins.str subject: The subject of the certificate.
        :param builtins.str thumbprint: The thumbprint of the certificate.
        """
        pulumi.set(__self__, "host_name", host_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if certificate_source is not None:
            pulumi.set(__self__, "certificate_source", certificate_source)
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)
        if ssl_keyvault_identity_client_id is not None:
            pulumi.set(__self__, "ssl_keyvault_identity_client_id", ssl_keyvault_identity_client_id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname to use for the Management API.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        The Base64 Encoded Certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[builtins.str]:
        """
        The password associated with the certificate provided above.

        > **Note:** Either `key_vault_certificate_id` or `certificate` and `certificate_password` must be specified.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> Optional[builtins.str]:
        """
        The source of the certificate.
        """
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[builtins.str]:
        """
        The status of the certificate.
        """
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.str]:
        """
        The expiration date of the certificate in RFC3339 format: `2000-01-02T03:04:05Z`.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[builtins.str]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.

        > **Note:** Setting this field requires the `identity` block to be specified, since this identity is used for to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires the Secret version isn't specified.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    @_utilities.deprecated("""`key_vault_id` has been deprecated in favour of `key_vault_certificate_id` and will be removed in v5.0 of the AzureRM provider""")
    def key_vault_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[builtins.bool]:
        """
        Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        """
        return pulumi.get(self, "negotiate_client_certificate")

    @property
    @pulumi.getter(name="sslKeyvaultIdentityClientId")
    def ssl_keyvault_identity_client_id(self) -> Optional[builtins.str]:
        """
        System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.

        > **Note:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        return pulumi.get(self, "ssl_keyvault_identity_client_id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        The subject of the certificate.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[builtins.str]:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class ServiceHostnameConfigurationProxy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "certificateSource":
            suggest = "certificate_source"
        elif key == "certificateStatus":
            suggest = "certificate_status"
        elif key == "defaultSslBinding":
            suggest = "default_ssl_binding"
        elif key == "keyVaultCertificateId":
            suggest = "key_vault_certificate_id"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "negotiateClientCertificate":
            suggest = "negotiate_client_certificate"
        elif key == "sslKeyvaultIdentityClientId":
            suggest = "ssl_keyvault_identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceHostnameConfigurationProxy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceHostnameConfigurationProxy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceHostnameConfigurationProxy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: builtins.str,
                 certificate: Optional[builtins.str] = None,
                 certificate_password: Optional[builtins.str] = None,
                 certificate_source: Optional[builtins.str] = None,
                 certificate_status: Optional[builtins.str] = None,
                 default_ssl_binding: Optional[builtins.bool] = None,
                 expiry: Optional[builtins.str] = None,
                 key_vault_certificate_id: Optional[builtins.str] = None,
                 key_vault_id: Optional[builtins.str] = None,
                 negotiate_client_certificate: Optional[builtins.bool] = None,
                 ssl_keyvault_identity_client_id: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 thumbprint: Optional[builtins.str] = None):
        """
        :param builtins.str host_name: The Hostname to use for the Management API.
        :param builtins.str certificate: The Base64 Encoded Certificate.
        :param builtins.str certificate_password: The password associated with the certificate provided above.
               
               > **Note:** Either `key_vault_certificate_id` or `certificate` and `certificate_password` must be specified.
        :param builtins.str certificate_source: The source of the certificate.
        :param builtins.str certificate_status: The status of the certificate.
        :param builtins.bool default_ssl_binding: Is the certificate associated with this Hostname the Default SSL Certificate? This is used when an SNI header isn't specified by a client. Defaults to `false`.
        :param builtins.str expiry: The expiration date of the certificate in RFC3339 format: `2000-01-02T03:04:05Z`.
        :param builtins.str key_vault_certificate_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.
               
               > **Note:** Setting this field requires the `identity` block to be specified, since this identity is used for to retrieve the Key Vault Certificate. Auto-updating the Certificate from the Key Vault requires the Secret version isn't specified.
        :param builtins.bool negotiate_client_certificate: Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        :param builtins.str ssl_keyvault_identity_client_id: The Managed Identity Client ID to use to access the Key Vault. This Identity must be specified in the `identity` block to be used.
        :param builtins.str subject: The subject of the certificate.
        :param builtins.str thumbprint: The thumbprint of the certificate.
        """
        pulumi.set(__self__, "host_name", host_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if certificate_source is not None:
            pulumi.set(__self__, "certificate_source", certificate_source)
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if default_ssl_binding is not None:
            pulumi.set(__self__, "default_ssl_binding", default_ssl_binding)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)
        if ssl_keyvault_identity_client_id is not None:
            pulumi.set(__self__, "ssl_keyvault_identity_client_id", ssl_keyvault_identity_client_id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname to use for the Management API.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        The Base64 Encoded Certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[builtins.str]:
        """
        The password associated with the certificate provided above.

        > **Note:** Either `key_vault_certificate_id` or `certificate` and `certificate_password` must be specified.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> Optional[builtins.str]:
        """
        The source of the certificate.
        """
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[builtins.str]:
        """
        The status of the certificate.
        """
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter(name="defaultSslBinding")
    def default_ssl_binding(self) -> Optional[builtins.bool]:
        """
        Is the certificate associated with this Hostname the Default SSL Certificate? This is used when an SNI header isn't specified by a client. Defaults to `false`.
        """
        return pulumi.get(self, "default_ssl_binding")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.str]:
        """
        The expiration date of the certificate in RFC3339 format: `2000-01-02T03:04:05Z`.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[builtins.str]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.

        > **Note:** Setting this field requires the `identity` block to be specified, since this identity is used for to retrieve the Key Vault Certificate. Auto-updating the Certificate from the Key Vault requires the Secret version isn't specified.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    @_utilities.deprecated("""`key_vault_id` has been deprecated in favour of `key_vault_certificate_id` and will be removed in v5.0 of the AzureRM provider""")
    def key_vault_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[builtins.bool]:
        """
        Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        """
        return pulumi.get(self, "negotiate_client_certificate")

    @property
    @pulumi.getter(name="sslKeyvaultIdentityClientId")
    def ssl_keyvault_identity_client_id(self) -> Optional[builtins.str]:
        """
        The Managed Identity Client ID to use to access the Key Vault. This Identity must be specified in the `identity` block to be used.
        """
        return pulumi.get(self, "ssl_keyvault_identity_client_id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        The subject of the certificate.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[builtins.str]:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class ServiceHostnameConfigurationScm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "certificateSource":
            suggest = "certificate_source"
        elif key == "certificateStatus":
            suggest = "certificate_status"
        elif key == "keyVaultCertificateId":
            suggest = "key_vault_certificate_id"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "negotiateClientCertificate":
            suggest = "negotiate_client_certificate"
        elif key == "sslKeyvaultIdentityClientId":
            suggest = "ssl_keyvault_identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceHostnameConfigurationScm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceHostnameConfigurationScm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceHostnameConfigurationScm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: builtins.str,
                 certificate: Optional[builtins.str] = None,
                 certificate_password: Optional[builtins.str] = None,
                 certificate_source: Optional[builtins.str] = None,
                 certificate_status: Optional[builtins.str] = None,
                 expiry: Optional[builtins.str] = None,
                 key_vault_certificate_id: Optional[builtins.str] = None,
                 key_vault_id: Optional[builtins.str] = None,
                 negotiate_client_certificate: Optional[builtins.bool] = None,
                 ssl_keyvault_identity_client_id: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 thumbprint: Optional[builtins.str] = None):
        """
        :param builtins.str host_name: The Hostname to use for the Management API.
        :param builtins.str certificate: The Base64 Encoded Certificate.
        :param builtins.str certificate_password: The password associated with the certificate provided above.
               
               > **Note:** Either `key_vault_certificate_id` or `certificate` and `certificate_password` must be specified.
        :param builtins.str certificate_source: The source of the certificate.
        :param builtins.str certificate_status: The status of the certificate.
        :param builtins.str expiry: The expiration date of the certificate in RFC3339 format: `2000-01-02T03:04:05Z`.
        :param builtins.str key_vault_certificate_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.
               
               > **Note:** Setting this field requires the `identity` block to be specified, since this identity is used for to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires the Secret version isn't specified.
        :param builtins.bool negotiate_client_certificate: Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        :param builtins.str ssl_keyvault_identity_client_id: System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.
               
               > **Note:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        :param builtins.str subject: The subject of the certificate.
        :param builtins.str thumbprint: The thumbprint of the certificate.
        """
        pulumi.set(__self__, "host_name", host_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if certificate_source is not None:
            pulumi.set(__self__, "certificate_source", certificate_source)
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)
        if ssl_keyvault_identity_client_id is not None:
            pulumi.set(__self__, "ssl_keyvault_identity_client_id", ssl_keyvault_identity_client_id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname to use for the Management API.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        The Base64 Encoded Certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[builtins.str]:
        """
        The password associated with the certificate provided above.

        > **Note:** Either `key_vault_certificate_id` or `certificate` and `certificate_password` must be specified.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> Optional[builtins.str]:
        """
        The source of the certificate.
        """
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[builtins.str]:
        """
        The status of the certificate.
        """
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.str]:
        """
        The expiration date of the certificate in RFC3339 format: `2000-01-02T03:04:05Z`.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[builtins.str]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.

        > **Note:** Setting this field requires the `identity` block to be specified, since this identity is used for to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires the Secret version isn't specified.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    @_utilities.deprecated("""`key_vault_id` has been deprecated in favour of `key_vault_certificate_id` and will be removed in v5.0 of the AzureRM provider""")
    def key_vault_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[builtins.bool]:
        """
        Should Client Certificate Negotiation be enabled for this Hostname? Defaults to `false`.
        """
        return pulumi.get(self, "negotiate_client_certificate")

    @property
    @pulumi.getter(name="sslKeyvaultIdentityClientId")
    def ssl_keyvault_identity_client_id(self) -> Optional[builtins.str]:
        """
        System or User Assigned Managed identity clientId as generated by Azure AD, which has `GET` access to the keyVault containing the SSL certificate.

        > **Note:** If a User Assigned Managed identity is specified for `ssl_keyvault_identity_client_id` then this identity must be associated to the `apimanagement.Service` within an `identity` block.
        """
        return pulumi.get(self, "ssl_keyvault_identity_client_id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        The subject of the certificate.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[builtins.str]:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class ServiceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this API Management Service. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[builtins.str] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this API Management Service.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param builtins.str tenant_id: The identifier for the tenant access information contract.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this API Management Service. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this API Management Service.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The identifier for the tenant access information contract.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ServiceProtocols(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableHttp2":
            suggest = "enable_http2"
        elif key == "http2Enabled":
            suggest = "http2_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceProtocols. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceProtocols.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceProtocols.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_http2: Optional[builtins.bool] = None,
                 http2_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool http2_enabled: Should HTTP/2 be supported by the API Management Service? Defaults to `false`.
        """
        if enable_http2 is not None:
            pulumi.set(__self__, "enable_http2", enable_http2)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)

    @property
    @pulumi.getter(name="enableHttp2")
    @_utilities.deprecated("""`protocols.enable_http2` has been deprecated in favour of the `protocols.http2_enabled` property and will be removed in v5.0 of the AzureRM Provider""")
    def enable_http2(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enable_http2")

    @property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[builtins.bool]:
        """
        Should HTTP/2 be supported by the API Management Service? Defaults to `false`.
        """
        return pulumi.get(self, "http2_enabled")


@pulumi.output_type
class ServiceSecurity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendSsl30Enabled":
            suggest = "backend_ssl30_enabled"
        elif key == "backendTls10Enabled":
            suggest = "backend_tls10_enabled"
        elif key == "backendTls11Enabled":
            suggest = "backend_tls11_enabled"
        elif key == "enableBackendSsl30":
            suggest = "enable_backend_ssl30"
        elif key == "enableBackendTls10":
            suggest = "enable_backend_tls10"
        elif key == "enableBackendTls11":
            suggest = "enable_backend_tls11"
        elif key == "enableFrontendSsl30":
            suggest = "enable_frontend_ssl30"
        elif key == "enableFrontendTls10":
            suggest = "enable_frontend_tls10"
        elif key == "enableFrontendTls11":
            suggest = "enable_frontend_tls11"
        elif key == "frontendSsl30Enabled":
            suggest = "frontend_ssl30_enabled"
        elif key == "frontendTls10Enabled":
            suggest = "frontend_tls10_enabled"
        elif key == "frontendTls11Enabled":
            suggest = "frontend_tls11_enabled"
        elif key == "tlsEcdheEcdsaWithAes128CbcShaCiphersEnabled":
            suggest = "tls_ecdhe_ecdsa_with_aes128_cbc_sha_ciphers_enabled"
        elif key == "tlsEcdheEcdsaWithAes256CbcShaCiphersEnabled":
            suggest = "tls_ecdhe_ecdsa_with_aes256_cbc_sha_ciphers_enabled"
        elif key == "tlsEcdheRsaWithAes128CbcShaCiphersEnabled":
            suggest = "tls_ecdhe_rsa_with_aes128_cbc_sha_ciphers_enabled"
        elif key == "tlsEcdheRsaWithAes256CbcShaCiphersEnabled":
            suggest = "tls_ecdhe_rsa_with_aes256_cbc_sha_ciphers_enabled"
        elif key == "tlsRsaWithAes128CbcSha256CiphersEnabled":
            suggest = "tls_rsa_with_aes128_cbc_sha256_ciphers_enabled"
        elif key == "tlsRsaWithAes128CbcShaCiphersEnabled":
            suggest = "tls_rsa_with_aes128_cbc_sha_ciphers_enabled"
        elif key == "tlsRsaWithAes128GcmSha256CiphersEnabled":
            suggest = "tls_rsa_with_aes128_gcm_sha256_ciphers_enabled"
        elif key == "tlsRsaWithAes256CbcSha256CiphersEnabled":
            suggest = "tls_rsa_with_aes256_cbc_sha256_ciphers_enabled"
        elif key == "tlsRsaWithAes256CbcShaCiphersEnabled":
            suggest = "tls_rsa_with_aes256_cbc_sha_ciphers_enabled"
        elif key == "tlsRsaWithAes256GcmSha384CiphersEnabled":
            suggest = "tls_rsa_with_aes256_gcm_sha384_ciphers_enabled"
        elif key == "tripleDesCiphersEnabled":
            suggest = "triple_des_ciphers_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSecurity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSecurity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSecurity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_ssl30_enabled: Optional[builtins.bool] = None,
                 backend_tls10_enabled: Optional[builtins.bool] = None,
                 backend_tls11_enabled: Optional[builtins.bool] = None,
                 enable_backend_ssl30: Optional[builtins.bool] = None,
                 enable_backend_tls10: Optional[builtins.bool] = None,
                 enable_backend_tls11: Optional[builtins.bool] = None,
                 enable_frontend_ssl30: Optional[builtins.bool] = None,
                 enable_frontend_tls10: Optional[builtins.bool] = None,
                 enable_frontend_tls11: Optional[builtins.bool] = None,
                 frontend_ssl30_enabled: Optional[builtins.bool] = None,
                 frontend_tls10_enabled: Optional[builtins.bool] = None,
                 frontend_tls11_enabled: Optional[builtins.bool] = None,
                 tls_ecdhe_ecdsa_with_aes128_cbc_sha_ciphers_enabled: Optional[builtins.bool] = None,
                 tls_ecdhe_ecdsa_with_aes256_cbc_sha_ciphers_enabled: Optional[builtins.bool] = None,
                 tls_ecdhe_rsa_with_aes128_cbc_sha_ciphers_enabled: Optional[builtins.bool] = None,
                 tls_ecdhe_rsa_with_aes256_cbc_sha_ciphers_enabled: Optional[builtins.bool] = None,
                 tls_rsa_with_aes128_cbc_sha256_ciphers_enabled: Optional[builtins.bool] = None,
                 tls_rsa_with_aes128_cbc_sha_ciphers_enabled: Optional[builtins.bool] = None,
                 tls_rsa_with_aes128_gcm_sha256_ciphers_enabled: Optional[builtins.bool] = None,
                 tls_rsa_with_aes256_cbc_sha256_ciphers_enabled: Optional[builtins.bool] = None,
                 tls_rsa_with_aes256_cbc_sha_ciphers_enabled: Optional[builtins.bool] = None,
                 tls_rsa_with_aes256_gcm_sha384_ciphers_enabled: Optional[builtins.bool] = None,
                 triple_des_ciphers_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool backend_ssl30_enabled: Should SSL 3.0 be enabled on the backend of the gateway? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30` field
        :param builtins.bool backend_tls10_enabled: Should TLS 1.0 be enabled on the backend of the gateway? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` field
        :param builtins.bool backend_tls11_enabled: Should TLS 1.1 be enabled on the backend of the gateway? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` field
        :param builtins.bool frontend_ssl30_enabled: Should SSL 3.0 be enabled on the frontend of the gateway? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30` field
        :param builtins.bool frontend_tls10_enabled: Should TLS 1.0 be enabled on the frontend of the gateway? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` field
        :param builtins.bool frontend_tls11_enabled: Should TLS 1.1 be enabled on the frontend of the gateway? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` field
        :param builtins.bool tls_ecdhe_ecdsa_with_aes128_cbc_sha_ciphers_enabled: Should the `TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA` cipher be enabled? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA` field
        :param builtins.bool tls_ecdhe_ecdsa_with_aes256_cbc_sha_ciphers_enabled: Should the `TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA` cipher be enabled? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA` field
        :param builtins.bool tls_ecdhe_rsa_with_aes128_cbc_sha_ciphers_enabled: Should the `TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA` cipher be enabled? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA` field
        :param builtins.bool tls_ecdhe_rsa_with_aes256_cbc_sha_ciphers_enabled: Should the `TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA` cipher be enabled? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA` field
        :param builtins.bool tls_rsa_with_aes128_cbc_sha256_ciphers_enabled: Should the `TLS_RSA_WITH_AES_128_CBC_SHA256` cipher be enabled? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256` field
        :param builtins.bool tls_rsa_with_aes128_cbc_sha_ciphers_enabled: Should the `TLS_RSA_WITH_AES_128_CBC_SHA` cipher be enabled? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA` field
        :param builtins.bool tls_rsa_with_aes128_gcm_sha256_ciphers_enabled: Should the `TLS_RSA_WITH_AES_128_GCM_SHA256` cipher be enabled? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_GCM_SHA256` field
        :param builtins.bool tls_rsa_with_aes256_cbc_sha256_ciphers_enabled: Should the `TLS_RSA_WITH_AES_256_CBC_SHA256` cipher be enabled? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_256_CBC_SHA256` field
        :param builtins.bool tls_rsa_with_aes256_cbc_sha_ciphers_enabled: Should the `TLS_RSA_WITH_AES_256_CBC_SHA` cipher be enabled? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_256_CBC_SHA` field
        :param builtins.bool tls_rsa_with_aes256_gcm_sha384_ciphers_enabled: Should the `TLS_RSA_WITH_AES_256_GCM_SHA384` cipher be enabled? Defaults to `false`.
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_256_GCM_SHA384` field
        :param builtins.bool triple_des_ciphers_enabled: Should the `TLS_RSA_WITH_3DES_EDE_CBC_SHA` cipher be enabled for alL TLS versions (1.0, 1.1 and 1.2)? 
               
               > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` field
        """
        if backend_ssl30_enabled is not None:
            pulumi.set(__self__, "backend_ssl30_enabled", backend_ssl30_enabled)
        if backend_tls10_enabled is not None:
            pulumi.set(__self__, "backend_tls10_enabled", backend_tls10_enabled)
        if backend_tls11_enabled is not None:
            pulumi.set(__self__, "backend_tls11_enabled", backend_tls11_enabled)
        if enable_backend_ssl30 is not None:
            pulumi.set(__self__, "enable_backend_ssl30", enable_backend_ssl30)
        if enable_backend_tls10 is not None:
            pulumi.set(__self__, "enable_backend_tls10", enable_backend_tls10)
        if enable_backend_tls11 is not None:
            pulumi.set(__self__, "enable_backend_tls11", enable_backend_tls11)
        if enable_frontend_ssl30 is not None:
            pulumi.set(__self__, "enable_frontend_ssl30", enable_frontend_ssl30)
        if enable_frontend_tls10 is not None:
            pulumi.set(__self__, "enable_frontend_tls10", enable_frontend_tls10)
        if enable_frontend_tls11 is not None:
            pulumi.set(__self__, "enable_frontend_tls11", enable_frontend_tls11)
        if frontend_ssl30_enabled is not None:
            pulumi.set(__self__, "frontend_ssl30_enabled", frontend_ssl30_enabled)
        if frontend_tls10_enabled is not None:
            pulumi.set(__self__, "frontend_tls10_enabled", frontend_tls10_enabled)
        if frontend_tls11_enabled is not None:
            pulumi.set(__self__, "frontend_tls11_enabled", frontend_tls11_enabled)
        if tls_ecdhe_ecdsa_with_aes128_cbc_sha_ciphers_enabled is not None:
            pulumi.set(__self__, "tls_ecdhe_ecdsa_with_aes128_cbc_sha_ciphers_enabled", tls_ecdhe_ecdsa_with_aes128_cbc_sha_ciphers_enabled)
        if tls_ecdhe_ecdsa_with_aes256_cbc_sha_ciphers_enabled is not None:
            pulumi.set(__self__, "tls_ecdhe_ecdsa_with_aes256_cbc_sha_ciphers_enabled", tls_ecdhe_ecdsa_with_aes256_cbc_sha_ciphers_enabled)
        if tls_ecdhe_rsa_with_aes128_cbc_sha_ciphers_enabled is not None:
            pulumi.set(__self__, "tls_ecdhe_rsa_with_aes128_cbc_sha_ciphers_enabled", tls_ecdhe_rsa_with_aes128_cbc_sha_ciphers_enabled)
        if tls_ecdhe_rsa_with_aes256_cbc_sha_ciphers_enabled is not None:
            pulumi.set(__self__, "tls_ecdhe_rsa_with_aes256_cbc_sha_ciphers_enabled", tls_ecdhe_rsa_with_aes256_cbc_sha_ciphers_enabled)
        if tls_rsa_with_aes128_cbc_sha256_ciphers_enabled is not None:
            pulumi.set(__self__, "tls_rsa_with_aes128_cbc_sha256_ciphers_enabled", tls_rsa_with_aes128_cbc_sha256_ciphers_enabled)
        if tls_rsa_with_aes128_cbc_sha_ciphers_enabled is not None:
            pulumi.set(__self__, "tls_rsa_with_aes128_cbc_sha_ciphers_enabled", tls_rsa_with_aes128_cbc_sha_ciphers_enabled)
        if tls_rsa_with_aes128_gcm_sha256_ciphers_enabled is not None:
            pulumi.set(__self__, "tls_rsa_with_aes128_gcm_sha256_ciphers_enabled", tls_rsa_with_aes128_gcm_sha256_ciphers_enabled)
        if tls_rsa_with_aes256_cbc_sha256_ciphers_enabled is not None:
            pulumi.set(__self__, "tls_rsa_with_aes256_cbc_sha256_ciphers_enabled", tls_rsa_with_aes256_cbc_sha256_ciphers_enabled)
        if tls_rsa_with_aes256_cbc_sha_ciphers_enabled is not None:
            pulumi.set(__self__, "tls_rsa_with_aes256_cbc_sha_ciphers_enabled", tls_rsa_with_aes256_cbc_sha_ciphers_enabled)
        if tls_rsa_with_aes256_gcm_sha384_ciphers_enabled is not None:
            pulumi.set(__self__, "tls_rsa_with_aes256_gcm_sha384_ciphers_enabled", tls_rsa_with_aes256_gcm_sha384_ciphers_enabled)
        if triple_des_ciphers_enabled is not None:
            pulumi.set(__self__, "triple_des_ciphers_enabled", triple_des_ciphers_enabled)

    @property
    @pulumi.getter(name="backendSsl30Enabled")
    def backend_ssl30_enabled(self) -> Optional[builtins.bool]:
        """
        Should SSL 3.0 be enabled on the backend of the gateway? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30` field
        """
        return pulumi.get(self, "backend_ssl30_enabled")

    @property
    @pulumi.getter(name="backendTls10Enabled")
    def backend_tls10_enabled(self) -> Optional[builtins.bool]:
        """
        Should TLS 1.0 be enabled on the backend of the gateway? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` field
        """
        return pulumi.get(self, "backend_tls10_enabled")

    @property
    @pulumi.getter(name="backendTls11Enabled")
    def backend_tls11_enabled(self) -> Optional[builtins.bool]:
        """
        Should TLS 1.1 be enabled on the backend of the gateway? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` field
        """
        return pulumi.get(self, "backend_tls11_enabled")

    @property
    @pulumi.getter(name="enableBackendSsl30")
    @_utilities.deprecated("""`security.enable_backend_ssl30` has been deprecated in favour of the `security.backend_ssl30_enabled` property and will be removed in v5.0 of the AzureRM Provider""")
    def enable_backend_ssl30(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enable_backend_ssl30")

    @property
    @pulumi.getter(name="enableBackendTls10")
    @_utilities.deprecated("""`security.enable_backend_tls10` has been deprecated in favour of the `security.backend_tls10_enabled` property and will be removed in v5.0 of the AzureRM Provider""")
    def enable_backend_tls10(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enable_backend_tls10")

    @property
    @pulumi.getter(name="enableBackendTls11")
    @_utilities.deprecated("""`security.enable_backend_tls11` has been deprecated in favour of the `security.backend_tls11_enabled` property and will be removed in v5.0 of the AzureRM Provider""")
    def enable_backend_tls11(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enable_backend_tls11")

    @property
    @pulumi.getter(name="enableFrontendSsl30")
    @_utilities.deprecated("""`security.enable_frontend_ssl30` has been deprecated in favour of the `security.frontend_ssl30_enabled` property and will be removed in v5.0 of the AzureRM Provider""")
    def enable_frontend_ssl30(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enable_frontend_ssl30")

    @property
    @pulumi.getter(name="enableFrontendTls10")
    @_utilities.deprecated("""`security.enable_frontend_tls10` has been deprecated in favour of the `security.frontend_tls10_enabled` property and will be removed in v5.0 of the AzureRM Provider""")
    def enable_frontend_tls10(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enable_frontend_tls10")

    @property
    @pulumi.getter(name="enableFrontendTls11")
    @_utilities.deprecated("""`security.enable_frontend_tls11` has been deprecated in favour of the `security.frontend_tls11_enabled` property and will be removed in v5.0 of the AzureRM Provider""")
    def enable_frontend_tls11(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enable_frontend_tls11")

    @property
    @pulumi.getter(name="frontendSsl30Enabled")
    def frontend_ssl30_enabled(self) -> Optional[builtins.bool]:
        """
        Should SSL 3.0 be enabled on the frontend of the gateway? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30` field
        """
        return pulumi.get(self, "frontend_ssl30_enabled")

    @property
    @pulumi.getter(name="frontendTls10Enabled")
    def frontend_tls10_enabled(self) -> Optional[builtins.bool]:
        """
        Should TLS 1.0 be enabled on the frontend of the gateway? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` field
        """
        return pulumi.get(self, "frontend_tls10_enabled")

    @property
    @pulumi.getter(name="frontendTls11Enabled")
    def frontend_tls11_enabled(self) -> Optional[builtins.bool]:
        """
        Should TLS 1.1 be enabled on the frontend of the gateway? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` field
        """
        return pulumi.get(self, "frontend_tls11_enabled")

    @property
    @pulumi.getter(name="tlsEcdheEcdsaWithAes128CbcShaCiphersEnabled")
    def tls_ecdhe_ecdsa_with_aes128_cbc_sha_ciphers_enabled(self) -> Optional[builtins.bool]:
        """
        Should the `TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA` cipher be enabled? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA` field
        """
        return pulumi.get(self, "tls_ecdhe_ecdsa_with_aes128_cbc_sha_ciphers_enabled")

    @property
    @pulumi.getter(name="tlsEcdheEcdsaWithAes256CbcShaCiphersEnabled")
    def tls_ecdhe_ecdsa_with_aes256_cbc_sha_ciphers_enabled(self) -> Optional[builtins.bool]:
        """
        Should the `TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA` cipher be enabled? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA` field
        """
        return pulumi.get(self, "tls_ecdhe_ecdsa_with_aes256_cbc_sha_ciphers_enabled")

    @property
    @pulumi.getter(name="tlsEcdheRsaWithAes128CbcShaCiphersEnabled")
    def tls_ecdhe_rsa_with_aes128_cbc_sha_ciphers_enabled(self) -> Optional[builtins.bool]:
        """
        Should the `TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA` cipher be enabled? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA` field
        """
        return pulumi.get(self, "tls_ecdhe_rsa_with_aes128_cbc_sha_ciphers_enabled")

    @property
    @pulumi.getter(name="tlsEcdheRsaWithAes256CbcShaCiphersEnabled")
    def tls_ecdhe_rsa_with_aes256_cbc_sha_ciphers_enabled(self) -> Optional[builtins.bool]:
        """
        Should the `TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA` cipher be enabled? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA` field
        """
        return pulumi.get(self, "tls_ecdhe_rsa_with_aes256_cbc_sha_ciphers_enabled")

    @property
    @pulumi.getter(name="tlsRsaWithAes128CbcSha256CiphersEnabled")
    def tls_rsa_with_aes128_cbc_sha256_ciphers_enabled(self) -> Optional[builtins.bool]:
        """
        Should the `TLS_RSA_WITH_AES_128_CBC_SHA256` cipher be enabled? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256` field
        """
        return pulumi.get(self, "tls_rsa_with_aes128_cbc_sha256_ciphers_enabled")

    @property
    @pulumi.getter(name="tlsRsaWithAes128CbcShaCiphersEnabled")
    def tls_rsa_with_aes128_cbc_sha_ciphers_enabled(self) -> Optional[builtins.bool]:
        """
        Should the `TLS_RSA_WITH_AES_128_CBC_SHA` cipher be enabled? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA` field
        """
        return pulumi.get(self, "tls_rsa_with_aes128_cbc_sha_ciphers_enabled")

    @property
    @pulumi.getter(name="tlsRsaWithAes128GcmSha256CiphersEnabled")
    def tls_rsa_with_aes128_gcm_sha256_ciphers_enabled(self) -> Optional[builtins.bool]:
        """
        Should the `TLS_RSA_WITH_AES_128_GCM_SHA256` cipher be enabled? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_GCM_SHA256` field
        """
        return pulumi.get(self, "tls_rsa_with_aes128_gcm_sha256_ciphers_enabled")

    @property
    @pulumi.getter(name="tlsRsaWithAes256CbcSha256CiphersEnabled")
    def tls_rsa_with_aes256_cbc_sha256_ciphers_enabled(self) -> Optional[builtins.bool]:
        """
        Should the `TLS_RSA_WITH_AES_256_CBC_SHA256` cipher be enabled? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_256_CBC_SHA256` field
        """
        return pulumi.get(self, "tls_rsa_with_aes256_cbc_sha256_ciphers_enabled")

    @property
    @pulumi.getter(name="tlsRsaWithAes256CbcShaCiphersEnabled")
    def tls_rsa_with_aes256_cbc_sha_ciphers_enabled(self) -> Optional[builtins.bool]:
        """
        Should the `TLS_RSA_WITH_AES_256_CBC_SHA` cipher be enabled? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_256_CBC_SHA` field
        """
        return pulumi.get(self, "tls_rsa_with_aes256_cbc_sha_ciphers_enabled")

    @property
    @pulumi.getter(name="tlsRsaWithAes256GcmSha384CiphersEnabled")
    def tls_rsa_with_aes256_gcm_sha384_ciphers_enabled(self) -> Optional[builtins.bool]:
        """
        Should the `TLS_RSA_WITH_AES_256_GCM_SHA384` cipher be enabled? Defaults to `false`.

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_256_GCM_SHA384` field
        """
        return pulumi.get(self, "tls_rsa_with_aes256_gcm_sha384_ciphers_enabled")

    @property
    @pulumi.getter(name="tripleDesCiphersEnabled")
    def triple_des_ciphers_enabled(self) -> Optional[builtins.bool]:
        """
        Should the `TLS_RSA_WITH_3DES_EDE_CBC_SHA` cipher be enabled for alL TLS versions (1.0, 1.1 and 1.2)? 

        > **Note:** This maps to the `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` field
        """
        return pulumi.get(self, "triple_des_ciphers_enabled")


@pulumi.output_type
class ServiceSignIn(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: Should anonymous users be redirected to the sign in page?
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Should anonymous users be redirected to the sign in page?
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ServiceSignUp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "termsOfService":
            suggest = "terms_of_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSignUp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSignUp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSignUp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 terms_of_service: 'outputs.ServiceSignUpTermsOfService'):
        """
        :param builtins.bool enabled: Can users sign up on the development portal?
        :param 'ServiceSignUpTermsOfServiceArgs' terms_of_service: A `terms_of_service` block as defined below.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "terms_of_service", terms_of_service)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Can users sign up on the development portal?
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="termsOfService")
    def terms_of_service(self) -> 'outputs.ServiceSignUpTermsOfService':
        """
        A `terms_of_service` block as defined below.
        """
        return pulumi.get(self, "terms_of_service")


@pulumi.output_type
class ServiceSignUpTermsOfService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consentRequired":
            suggest = "consent_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSignUpTermsOfService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSignUpTermsOfService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSignUpTermsOfService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consent_required: builtins.bool,
                 enabled: builtins.bool,
                 text: Optional[builtins.str] = None):
        """
        :param builtins.bool consent_required: Should the user be asked for consent during sign up?
        :param builtins.bool enabled: Should Terms of Service be displayed during sign up?.
        :param builtins.str text: The Terms of Service which users are required to agree to in order to sign up.
        """
        pulumi.set(__self__, "consent_required", consent_required)
        pulumi.set(__self__, "enabled", enabled)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="consentRequired")
    def consent_required(self) -> builtins.bool:
        """
        Should the user be asked for consent during sign up?
        """
        return pulumi.get(self, "consent_required")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Should Terms of Service be displayed during sign up?.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def text(self) -> Optional[builtins.str]:
        """
        The Terms of Service which users are required to agree to in order to sign up.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class ServiceTenantAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryKey":
            suggest = "primary_key"
        elif key == "secondaryKey":
            suggest = "secondary_key"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTenantAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTenantAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTenantAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 primary_key: Optional[builtins.str] = None,
                 secondary_key: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Should the access to the management API be enabled?
        :param builtins.str primary_key: Primary access key for the tenant access information contract.
        :param builtins.str secondary_key: Secondary access key for the tenant access information contract.
        :param builtins.str tenant_id: The identifier for the tenant access information contract.
        """
        pulumi.set(__self__, "enabled", enabled)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Should the access to the management API be enabled?
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[builtins.str]:
        """
        Primary access key for the tenant access information contract.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[builtins.str]:
        """
        Secondary access key for the tenant access information contract.
        """
        return pulumi.get(self, "secondary_key")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The identifier for the tenant access information contract.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ServiceVirtualNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVirtualNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVirtualNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVirtualNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: builtins.str):
        """
        :param builtins.str subnet_id: The id of the subnet that will be used for the API Management.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The id of the subnet that will be used for the API Management.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetApiSubscriptionKeyParameterNameResult(dict):
    def __init__(__self__, *,
                 header: builtins.str,
                 query: builtins.str):
        """
        :param builtins.str header: The name of the HTTP Header which should be used for the Subscription Key.
        :param builtins.str query: The name of the QueryString parameter which should be used for the Subscription Key.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def header(self) -> builtins.str:
        """
        The name of the HTTP Header which should be used for the Subscription Key.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def query(self) -> builtins.str:
        """
        The name of the QueryString parameter which should be used for the Subscription Key.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class GetGatewayLocationDataResult(dict):
    def __init__(__self__, *,
                 city: builtins.str,
                 district: builtins.str,
                 name: builtins.str,
                 region: builtins.str):
        """
        :param builtins.str city: The city or locality where the resource is located.
        :param builtins.str district: The district, state, or province where the resource is located.
        :param builtins.str name: The name of the API Management Gateway.
        """
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "district", district)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        The city or locality where the resource is located.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def district(self) -> builtins.str:
        """
        The district, state, or province where the resource is located.
        """
        return pulumi.get(self, "district")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the API Management Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")


@pulumi.output_type
class GetServiceAdditionalLocationResult(dict):
    def __init__(__self__, *,
                 capacity: builtins.int,
                 gateway_regional_url: builtins.str,
                 location: builtins.str,
                 private_ip_addresses: Sequence[builtins.str],
                 public_ip_address_id: builtins.str,
                 public_ip_addresses: Sequence[builtins.str],
                 zones: Sequence[builtins.str]):
        """
        :param builtins.int capacity: Specifies the number of units associated with this API Management service.
        :param builtins.str gateway_regional_url: Gateway URL of the API Management service in the Region.
        :param builtins.str location: The location name of the additional region among Azure Data center regions.
        :param Sequence[builtins.str] private_ip_addresses: Private IP addresses of the API Management service in the additional location, for instances using virtual network mode.
        :param builtins.str public_ip_address_id: ID of the standard SKU IPv4 Public IP. Available only for Premium SKU deployed in a virtual network.
        :param Sequence[builtins.str] public_ip_addresses: Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard and Premium SKU.
        :param Sequence[builtins.str] zones: List of the availability zones where API Management is deployed in the additional region exists.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "gateway_regional_url", gateway_regional_url)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def capacity(self) -> builtins.int:
        """
        Specifies the number of units associated with this API Management service.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="gatewayRegionalUrl")
    def gateway_regional_url(self) -> builtins.str:
        """
        Gateway URL of the API Management service in the Region.
        """
        return pulumi.get(self, "gateway_regional_url")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location name of the additional region among Azure Data center regions.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Sequence[builtins.str]:
        """
        Private IP addresses of the API Management service in the additional location, for instances using virtual network mode.
        """
        return pulumi.get(self, "private_ip_addresses")

    @property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> builtins.str:
        """
        ID of the standard SKU IPv4 Public IP. Available only for Premium SKU deployed in a virtual network.
        """
        return pulumi.get(self, "public_ip_address_id")

    @property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Sequence[builtins.str]:
        """
        Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard and Premium SKU.
        """
        return pulumi.get(self, "public_ip_addresses")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[builtins.str]:
        """
        List of the availability zones where API Management is deployed in the additional region exists.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class GetServiceHostnameConfigurationResult(dict):
    def __init__(__self__, *,
                 developer_portals: Sequence['outputs.GetServiceHostnameConfigurationDeveloperPortalResult'],
                 managements: Sequence['outputs.GetServiceHostnameConfigurationManagementResult'],
                 portals: Sequence['outputs.GetServiceHostnameConfigurationPortalResult'],
                 proxies: Sequence['outputs.GetServiceHostnameConfigurationProxyResult'],
                 scms: Sequence['outputs.GetServiceHostnameConfigurationScmResult']):
        """
        :param Sequence['GetServiceHostnameConfigurationDeveloperPortalArgs'] developer_portals: One or more `developer_portal` blocks as documented below.
        :param Sequence['GetServiceHostnameConfigurationManagementArgs'] managements: One or more `management` blocks as documented below.
        :param Sequence['GetServiceHostnameConfigurationPortalArgs'] portals: One or more `portal` blocks as documented below.
        :param Sequence['GetServiceHostnameConfigurationProxyArgs'] proxies: One or more `proxy` blocks as documented below.
        :param Sequence['GetServiceHostnameConfigurationScmArgs'] scms: One or more `scm` blocks as documented below.
        """
        pulumi.set(__self__, "developer_portals", developer_portals)
        pulumi.set(__self__, "managements", managements)
        pulumi.set(__self__, "portals", portals)
        pulumi.set(__self__, "proxies", proxies)
        pulumi.set(__self__, "scms", scms)

    @property
    @pulumi.getter(name="developerPortals")
    def developer_portals(self) -> Sequence['outputs.GetServiceHostnameConfigurationDeveloperPortalResult']:
        """
        One or more `developer_portal` blocks as documented below.
        """
        return pulumi.get(self, "developer_portals")

    @property
    @pulumi.getter
    def managements(self) -> Sequence['outputs.GetServiceHostnameConfigurationManagementResult']:
        """
        One or more `management` blocks as documented below.
        """
        return pulumi.get(self, "managements")

    @property
    @pulumi.getter
    def portals(self) -> Sequence['outputs.GetServiceHostnameConfigurationPortalResult']:
        """
        One or more `portal` blocks as documented below.
        """
        return pulumi.get(self, "portals")

    @property
    @pulumi.getter
    def proxies(self) -> Sequence['outputs.GetServiceHostnameConfigurationProxyResult']:
        """
        One or more `proxy` blocks as documented below.
        """
        return pulumi.get(self, "proxies")

    @property
    @pulumi.getter
    def scms(self) -> Sequence['outputs.GetServiceHostnameConfigurationScmResult']:
        """
        One or more `scm` blocks as documented below.
        """
        return pulumi.get(self, "scms")


@pulumi.output_type
class GetServiceHostnameConfigurationDeveloperPortalResult(dict):
    def __init__(__self__, *,
                 host_name: builtins.str,
                 key_vault_certificate_id: builtins.str,
                 key_vault_id: builtins.str,
                 negotiate_client_certificate: builtins.bool):
        """
        :param builtins.str host_name: The Hostname used for the SCM URL.
        :param builtins.str key_vault_certificate_id: The ID of the Key Vault Secret which contains the SSL Certificate.
        :param builtins.bool negotiate_client_certificate: Is Client Certificate Negotiation enabled?
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname used for the SCM URL.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> builtins.str:
        """
        The ID of the Key Vault Secret which contains the SSL Certificate.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> builtins.str:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> builtins.bool:
        """
        Is Client Certificate Negotiation enabled?
        """
        return pulumi.get(self, "negotiate_client_certificate")


@pulumi.output_type
class GetServiceHostnameConfigurationManagementResult(dict):
    def __init__(__self__, *,
                 host_name: builtins.str,
                 key_vault_certificate_id: builtins.str,
                 key_vault_id: builtins.str,
                 negotiate_client_certificate: builtins.bool):
        """
        :param builtins.str host_name: The Hostname used for the SCM URL.
        :param builtins.str key_vault_certificate_id: The ID of the Key Vault Secret which contains the SSL Certificate.
        :param builtins.bool negotiate_client_certificate: Is Client Certificate Negotiation enabled?
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname used for the SCM URL.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> builtins.str:
        """
        The ID of the Key Vault Secret which contains the SSL Certificate.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> builtins.str:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> builtins.bool:
        """
        Is Client Certificate Negotiation enabled?
        """
        return pulumi.get(self, "negotiate_client_certificate")


@pulumi.output_type
class GetServiceHostnameConfigurationPortalResult(dict):
    def __init__(__self__, *,
                 host_name: builtins.str,
                 key_vault_certificate_id: builtins.str,
                 key_vault_id: builtins.str,
                 negotiate_client_certificate: builtins.bool):
        """
        :param builtins.str host_name: The Hostname used for the SCM URL.
        :param builtins.str key_vault_certificate_id: The ID of the Key Vault Secret which contains the SSL Certificate.
        :param builtins.bool negotiate_client_certificate: Is Client Certificate Negotiation enabled?
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname used for the SCM URL.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> builtins.str:
        """
        The ID of the Key Vault Secret which contains the SSL Certificate.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> builtins.str:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> builtins.bool:
        """
        Is Client Certificate Negotiation enabled?
        """
        return pulumi.get(self, "negotiate_client_certificate")


@pulumi.output_type
class GetServiceHostnameConfigurationProxyResult(dict):
    def __init__(__self__, *,
                 default_ssl_binding: builtins.bool,
                 host_name: builtins.str,
                 key_vault_certificate_id: builtins.str,
                 key_vault_id: builtins.str,
                 negotiate_client_certificate: builtins.bool):
        """
        :param builtins.bool default_ssl_binding: Is this the default SSL Binding?
        :param builtins.str host_name: The Hostname used for the SCM URL.
        :param builtins.str key_vault_certificate_id: The ID of the Key Vault Secret which contains the SSL Certificate.
        :param builtins.bool negotiate_client_certificate: Is Client Certificate Negotiation enabled?
        """
        pulumi.set(__self__, "default_ssl_binding", default_ssl_binding)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)

    @property
    @pulumi.getter(name="defaultSslBinding")
    def default_ssl_binding(self) -> builtins.bool:
        """
        Is this the default SSL Binding?
        """
        return pulumi.get(self, "default_ssl_binding")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname used for the SCM URL.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> builtins.str:
        """
        The ID of the Key Vault Secret which contains the SSL Certificate.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> builtins.str:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> builtins.bool:
        """
        Is Client Certificate Negotiation enabled?
        """
        return pulumi.get(self, "negotiate_client_certificate")


@pulumi.output_type
class GetServiceHostnameConfigurationScmResult(dict):
    def __init__(__self__, *,
                 host_name: builtins.str,
                 key_vault_certificate_id: builtins.str,
                 key_vault_id: builtins.str,
                 negotiate_client_certificate: builtins.bool):
        """
        :param builtins.str host_name: The Hostname used for the SCM URL.
        :param builtins.str key_vault_certificate_id: The ID of the Key Vault Secret which contains the SSL Certificate.
        :param builtins.bool negotiate_client_certificate: Is Client Certificate Negotiation enabled?
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        The Hostname used for the SCM URL.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> builtins.str:
        """
        The ID of the Key Vault Secret which contains the SSL Certificate.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> builtins.str:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> builtins.bool:
        """
        Is Client Certificate Negotiation enabled?
        """
        return pulumi.get(self, "negotiate_client_certificate")


@pulumi.output_type
class GetServiceIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: The list of User Assigned Managed Identity IDs assigned to this API Management Service.
        :param builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this API Management Service.
        :param builtins.str tenant_id: The ID of the Tenant which has access to this API Management instance.
        :param builtins.str type: The type of Managed Service Identity that is configured on this API Management Service.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        The list of User Assigned Managed Identity IDs assigned to this API Management Service.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this API Management Service.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The ID of the Tenant which has access to this API Management instance.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of Managed Service Identity that is configured on this API Management Service.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceTenantAccessResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 primary_key: builtins.str,
                 secondary_key: builtins.str,
                 tenant_id: builtins.str):
        """
        :param builtins.bool enabled: Is access to the Management API enabled (presumably "for this Tenant")?
        :param builtins.str primary_key: Primary access key for the tenant access information contract.
        :param builtins.str secondary_key: Secondary access key for the tenant access information contract.
        :param builtins.str tenant_id: The ID of the Tenant which has access to this API Management instance.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "primary_key", primary_key)
        pulumi.set(__self__, "secondary_key", secondary_key)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Is access to the Management API enabled (presumably "for this Tenant")?
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> builtins.str:
        """
        Primary access key for the tenant access information contract.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> builtins.str:
        """
        Secondary access key for the tenant access information contract.
        """
        return pulumi.get(self, "secondary_key")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The ID of the Tenant which has access to this API Management instance.
        """
        return pulumi.get(self, "tenant_id")


