# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 api_management_id: pulumi.Input[builtins.str],
                 xml_content: Optional[pulumi.Input[builtins.str]] = None,
                 xml_link: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[builtins.str] api_management_id: The ID of the API Management service. Changing this forces a new API Management service Policy to be created.
        :param pulumi.Input[builtins.str] xml_content: The XML Content for this Policy as a string. To integrate frontend and backend services in Azure API Management, utilize the [`set-backend-service`](https://learn.microsoft.com/azure/api-management/set-backend-service-policy) policy, specifying the `base-url` value. Typically, this value corresponds to the `url` property defined in the `Backend` resource configuration.
        :param pulumi.Input[builtins.str] xml_link: A link to a Policy XML Document, which must be publicly available.
        """
        pulumi.set(__self__, "api_management_id", api_management_id)
        if xml_content is not None:
            pulumi.set(__self__, "xml_content", xml_content)
        if xml_link is not None:
            pulumi.set(__self__, "xml_link", xml_link)

    @property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the API Management service. Changing this forces a new API Management service Policy to be created.
        """
        return pulumi.get(self, "api_management_id")

    @api_management_id.setter
    def api_management_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_management_id", value)

    @property
    @pulumi.getter(name="xmlContent")
    def xml_content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The XML Content for this Policy as a string. To integrate frontend and backend services in Azure API Management, utilize the [`set-backend-service`](https://learn.microsoft.com/azure/api-management/set-backend-service-policy) policy, specifying the `base-url` value. Typically, this value corresponds to the `url` property defined in the `Backend` resource configuration.
        """
        return pulumi.get(self, "xml_content")

    @xml_content.setter
    def xml_content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "xml_content", value)

    @property
    @pulumi.getter(name="xmlLink")
    def xml_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A link to a Policy XML Document, which must be publicly available.
        """
        return pulumi.get(self, "xml_link")

    @xml_link.setter
    def xml_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "xml_link", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 api_management_id: Optional[pulumi.Input[builtins.str]] = None,
                 xml_content: Optional[pulumi.Input[builtins.str]] = None,
                 xml_link: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[builtins.str] api_management_id: The ID of the API Management service. Changing this forces a new API Management service Policy to be created.
        :param pulumi.Input[builtins.str] xml_content: The XML Content for this Policy as a string. To integrate frontend and backend services in Azure API Management, utilize the [`set-backend-service`](https://learn.microsoft.com/azure/api-management/set-backend-service-policy) policy, specifying the `base-url` value. Typically, this value corresponds to the `url` property defined in the `Backend` resource configuration.
        :param pulumi.Input[builtins.str] xml_link: A link to a Policy XML Document, which must be publicly available.
        """
        if api_management_id is not None:
            pulumi.set(__self__, "api_management_id", api_management_id)
        if xml_content is not None:
            pulumi.set(__self__, "xml_content", xml_content)
        if xml_link is not None:
            pulumi.set(__self__, "xml_link", xml_link)

    @property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the API Management service. Changing this forces a new API Management service Policy to be created.
        """
        return pulumi.get(self, "api_management_id")

    @api_management_id.setter
    def api_management_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_management_id", value)

    @property
    @pulumi.getter(name="xmlContent")
    def xml_content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The XML Content for this Policy as a string. To integrate frontend and backend services in Azure API Management, utilize the [`set-backend-service`](https://learn.microsoft.com/azure/api-management/set-backend-service-policy) policy, specifying the `base-url` value. Typically, this value corresponds to the `url` property defined in the `Backend` resource configuration.
        """
        return pulumi.get(self, "xml_content")

    @xml_content.setter
    def xml_content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "xml_content", value)

    @property
    @pulumi.getter(name="xmlLink")
    def xml_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A link to a Policy XML Document, which must be publicly available.
        """
        return pulumi.get(self, "xml_link")

    @xml_link.setter
    def xml_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "xml_link", value)


@pulumi.type_token("azure:apimanagement/policy:Policy")
class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_id: Optional[pulumi.Input[builtins.str]] = None,
                 xml_content: Optional[pulumi.Input[builtins.str]] = None,
                 xml_link: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a API Management service Policy.

        > **Note:** This resource will, upon creation, **overwrite any existing policy in the API Management service**, as there is no feasible way to test whether the policy has been modified from the default. Similarly, when this resource is destroyed, the API Management service will revert to its default policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Developer_1")
        example_named_value = azure.apimanagement.NamedValue("example",
            name="example-apimg",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            display_name="ExampleProperty",
            value="Example Value")
        example_policy = azure.apimanagement.Policy("example",
            api_management_id=example_service.id,
            xml_content=std.file(input="example.xml").result)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management service Policys can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/policy:Policy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_management_id: The ID of the API Management service. Changing this forces a new API Management service Policy to be created.
        :param pulumi.Input[builtins.str] xml_content: The XML Content for this Policy as a string. To integrate frontend and backend services in Azure API Management, utilize the [`set-backend-service`](https://learn.microsoft.com/azure/api-management/set-backend-service-policy) policy, specifying the `base-url` value. Typically, this value corresponds to the `url` property defined in the `Backend` resource configuration.
        :param pulumi.Input[builtins.str] xml_link: A link to a Policy XML Document, which must be publicly available.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a API Management service Policy.

        > **Note:** This resource will, upon creation, **overwrite any existing policy in the API Management service**, as there is no feasible way to test whether the policy has been modified from the default. Similarly, when this resource is destroyed, the API Management service will revert to its default policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Developer_1")
        example_named_value = azure.apimanagement.NamedValue("example",
            name="example-apimg",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            display_name="ExampleProperty",
            value="Example Value")
        example_policy = azure.apimanagement.Policy("example",
            api_management_id=example_service.id,
            xml_content=std.file(input="example.xml").result)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management service Policys can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/policy:Policy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_id: Optional[pulumi.Input[builtins.str]] = None,
                 xml_content: Optional[pulumi.Input[builtins.str]] = None,
                 xml_link: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            if api_management_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_id'")
            __props__.__dict__["api_management_id"] = api_management_id
            __props__.__dict__["xml_content"] = xml_content
            __props__.__dict__["xml_link"] = xml_link
        super(Policy, __self__).__init__(
            'azure:apimanagement/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_id: Optional[pulumi.Input[builtins.str]] = None,
            xml_content: Optional[pulumi.Input[builtins.str]] = None,
            xml_link: Optional[pulumi.Input[builtins.str]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_management_id: The ID of the API Management service. Changing this forces a new API Management service Policy to be created.
        :param pulumi.Input[builtins.str] xml_content: The XML Content for this Policy as a string. To integrate frontend and backend services in Azure API Management, utilize the [`set-backend-service`](https://learn.microsoft.com/azure/api-management/set-backend-service-policy) policy, specifying the `base-url` value. Typically, this value corresponds to the `url` property defined in the `Backend` resource configuration.
        :param pulumi.Input[builtins.str] xml_link: A link to a Policy XML Document, which must be publicly available.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["api_management_id"] = api_management_id
        __props__.__dict__["xml_content"] = xml_content
        __props__.__dict__["xml_link"] = xml_link
        return Policy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the API Management service. Changing this forces a new API Management service Policy to be created.
        """
        return pulumi.get(self, "api_management_id")

    @property
    @pulumi.getter(name="xmlContent")
    def xml_content(self) -> pulumi.Output[builtins.str]:
        """
        The XML Content for this Policy as a string. To integrate frontend and backend services in Azure API Management, utilize the [`set-backend-service`](https://learn.microsoft.com/azure/api-management/set-backend-service-policy) policy, specifying the `base-url` value. Typically, this value corresponds to the `url` property defined in the `Backend` resource configuration.
        """
        return pulumi.get(self, "xml_content")

    @property
    @pulumi.getter(name="xmlLink")
    def xml_link(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A link to a Policy XML Document, which must be publicly available.
        """
        return pulumi.get(self, "xml_link")

