# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SubscriptionArgs', 'Subscription']

@pulumi.input_type
class SubscriptionArgs:
    def __init__(__self__, *,
                 api_management_name: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 allow_tracing: Optional[pulumi.Input[builtins.bool]] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 primary_key: Optional[pulumi.Input[builtins.str]] = None,
                 product_id: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_key: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Subscription resource.
        :param pulumi.Input[builtins.str] api_management_name: The name of the API Management Service where this Subscription should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] display_name: The display name of this Subscription.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] allow_tracing: Determines whether tracing can be enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] api_id: The ID of the API which should be assigned to this Subscription. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `/apis` scope is used for the subscription and all apis are accessible.
        :param pulumi.Input[builtins.str] primary_key: The primary subscription key to use for the subscription.
        :param pulumi.Input[builtins.str] product_id: The ID of the Product which should be assigned to this Subscription. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `all_apis` scope is used for the subscription.
        :param pulumi.Input[builtins.str] secondary_key: The secondary subscription key to use for the subscription.
        :param pulumi.Input[builtins.str] state: The state of this Subscription. Possible values are `active`, `cancelled`, `expired`, `rejected`, `submitted` and `suspended`. Defaults to `submitted`.
        :param pulumi.Input[builtins.str] subscription_id: An Identifier which should used as the ID of this Subscription. If not specified a new Subscription ID will be generated. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user_id: The ID of the User which should be assigned to this Subscription. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "api_management_name", api_management_name)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if allow_tracing is not None:
            pulumi.set(__self__, "allow_tracing", allow_tracing)
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the API Management Service where this Subscription should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_management_name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name of this Subscription.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="allowTracing")
    def allow_tracing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether tracing can be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "allow_tracing")

    @allow_tracing.setter
    def allow_tracing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_tracing", value)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the API which should be assigned to this Subscription. Changing this forces a new resource to be created.

        > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `/apis` scope is used for the subscription and all apis are accessible.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary subscription key to use for the subscription.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Product which should be assigned to this Subscription. Changing this forces a new resource to be created.

        > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `all_apis` scope is used for the subscription.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secondary subscription key to use for the subscription.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_key", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of this Subscription. Possible values are `active`, `cancelled`, `expired`, `rejected`, `submitted` and `suspended`. Defaults to `submitted`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An Identifier which should used as the ID of this Subscription. If not specified a new Subscription ID will be generated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the User which should be assigned to this Subscription. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _SubscriptionState:
    def __init__(__self__, *,
                 allow_tracing: Optional[pulumi.Input[builtins.bool]] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 api_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_key: Optional[pulumi.Input[builtins.str]] = None,
                 product_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_key: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Subscription resources.
        :param pulumi.Input[builtins.bool] allow_tracing: Determines whether tracing can be enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] api_id: The ID of the API which should be assigned to this Subscription. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `/apis` scope is used for the subscription and all apis are accessible.
        :param pulumi.Input[builtins.str] api_management_name: The name of the API Management Service where this Subscription should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] display_name: The display name of this Subscription.
        :param pulumi.Input[builtins.str] primary_key: The primary subscription key to use for the subscription.
        :param pulumi.Input[builtins.str] product_id: The ID of the Product which should be assigned to this Subscription. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `all_apis` scope is used for the subscription.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_key: The secondary subscription key to use for the subscription.
        :param pulumi.Input[builtins.str] state: The state of this Subscription. Possible values are `active`, `cancelled`, `expired`, `rejected`, `submitted` and `suspended`. Defaults to `submitted`.
        :param pulumi.Input[builtins.str] subscription_id: An Identifier which should used as the ID of this Subscription. If not specified a new Subscription ID will be generated. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user_id: The ID of the User which should be assigned to this Subscription. Changing this forces a new resource to be created.
        """
        if allow_tracing is not None:
            pulumi.set(__self__, "allow_tracing", allow_tracing)
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if api_management_name is not None:
            pulumi.set(__self__, "api_management_name", api_management_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="allowTracing")
    def allow_tracing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether tracing can be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "allow_tracing")

    @allow_tracing.setter
    def allow_tracing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_tracing", value)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the API which should be assigned to this Subscription. Changing this forces a new resource to be created.

        > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `/apis` scope is used for the subscription and all apis are accessible.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the API Management Service where this Subscription should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_management_name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of this Subscription.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary subscription key to use for the subscription.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Product which should be assigned to this Subscription. Changing this forces a new resource to be created.

        > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `all_apis` scope is used for the subscription.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secondary subscription key to use for the subscription.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_key", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of this Subscription. Possible values are `active`, `cancelled`, `expired`, `rejected`, `submitted` and `suspended`. Defaults to `submitted`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An Identifier which should used as the ID of this Subscription. If not specified a new Subscription ID will be generated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the User which should be assigned to this Subscription. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("azure:apimanagement/subscription:Subscription")
class Subscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_tracing: Optional[pulumi.Input[builtins.bool]] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 api_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_key: Optional[pulumi.Input[builtins.str]] = None,
                 product_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_key: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Subscription within a API Management Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.apimanagement.get_service(name="example-apim",
            resource_group_name="example-resources")
        example_get_product = azure.apimanagement.get_product(product_id="00000000-0000-0000-0000-000000000000",
            api_management_name=example.name,
            resource_group_name=example.resource_group_name)
        example_get_user = azure.apimanagement.get_user(user_id="11111111-1111-1111-1111-111111111111",
            api_management_name=example.name,
            resource_group_name=example.resource_group_name)
        example_subscription = azure.apimanagement.Subscription("example",
            api_management_name=example.name,
            resource_group_name=example.resource_group_name,
            user_id=example_get_user.id,
            product_id=example_get_product.id,
            display_name="Parser API")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Subscriptions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/subscription:Subscription example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.ApiManagement/service/example-apim/subscriptions/subscription-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_tracing: Determines whether tracing can be enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] api_id: The ID of the API which should be assigned to this Subscription. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `/apis` scope is used for the subscription and all apis are accessible.
        :param pulumi.Input[builtins.str] api_management_name: The name of the API Management Service where this Subscription should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] display_name: The display name of this Subscription.
        :param pulumi.Input[builtins.str] primary_key: The primary subscription key to use for the subscription.
        :param pulumi.Input[builtins.str] product_id: The ID of the Product which should be assigned to this Subscription. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `all_apis` scope is used for the subscription.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_key: The secondary subscription key to use for the subscription.
        :param pulumi.Input[builtins.str] state: The state of this Subscription. Possible values are `active`, `cancelled`, `expired`, `rejected`, `submitted` and `suspended`. Defaults to `submitted`.
        :param pulumi.Input[builtins.str] subscription_id: An Identifier which should used as the ID of this Subscription. If not specified a new Subscription ID will be generated. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user_id: The ID of the User which should be assigned to this Subscription. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Subscription within a API Management Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.apimanagement.get_service(name="example-apim",
            resource_group_name="example-resources")
        example_get_product = azure.apimanagement.get_product(product_id="00000000-0000-0000-0000-000000000000",
            api_management_name=example.name,
            resource_group_name=example.resource_group_name)
        example_get_user = azure.apimanagement.get_user(user_id="11111111-1111-1111-1111-111111111111",
            api_management_name=example.name,
            resource_group_name=example.resource_group_name)
        example_subscription = azure.apimanagement.Subscription("example",
            api_management_name=example.name,
            resource_group_name=example.resource_group_name,
            user_id=example_get_user.id,
            product_id=example_get_product.id,
            display_name="Parser API")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Subscriptions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/subscription:Subscription example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.ApiManagement/service/example-apim/subscriptions/subscription-name
        ```

        :param str resource_name: The name of the resource.
        :param SubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_tracing: Optional[pulumi.Input[builtins.bool]] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 api_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_key: Optional[pulumi.Input[builtins.str]] = None,
                 product_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_key: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionArgs.__new__(SubscriptionArgs)

            __props__.__dict__["allow_tracing"] = allow_tracing
            __props__.__dict__["api_id"] = api_id
            if api_management_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_name'")
            __props__.__dict__["api_management_name"] = api_management_name
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["primary_key"] = None if primary_key is None else pulumi.Output.secret(primary_key)
            __props__.__dict__["product_id"] = product_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["secondary_key"] = None if secondary_key is None else pulumi.Output.secret(secondary_key)
            __props__.__dict__["state"] = state
            __props__.__dict__["subscription_id"] = subscription_id
            __props__.__dict__["user_id"] = user_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryKey", "secondaryKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Subscription, __self__).__init__(
            'azure:apimanagement/subscription:Subscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_tracing: Optional[pulumi.Input[builtins.bool]] = None,
            api_id: Optional[pulumi.Input[builtins.str]] = None,
            api_management_name: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            primary_key: Optional[pulumi.Input[builtins.str]] = None,
            product_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            secondary_key: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[builtins.str]] = None,
            user_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Subscription':
        """
        Get an existing Subscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_tracing: Determines whether tracing can be enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] api_id: The ID of the API which should be assigned to this Subscription. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `/apis` scope is used for the subscription and all apis are accessible.
        :param pulumi.Input[builtins.str] api_management_name: The name of the API Management Service where this Subscription should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] display_name: The display name of this Subscription.
        :param pulumi.Input[builtins.str] primary_key: The primary subscription key to use for the subscription.
        :param pulumi.Input[builtins.str] product_id: The ID of the Product which should be assigned to this Subscription. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `all_apis` scope is used for the subscription.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_key: The secondary subscription key to use for the subscription.
        :param pulumi.Input[builtins.str] state: The state of this Subscription. Possible values are `active`, `cancelled`, `expired`, `rejected`, `submitted` and `suspended`. Defaults to `submitted`.
        :param pulumi.Input[builtins.str] subscription_id: An Identifier which should used as the ID of this Subscription. If not specified a new Subscription ID will be generated. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user_id: The ID of the User which should be assigned to this Subscription. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriptionState.__new__(_SubscriptionState)

        __props__.__dict__["allow_tracing"] = allow_tracing
        __props__.__dict__["api_id"] = api_id
        __props__.__dict__["api_management_name"] = api_management_name
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["primary_key"] = primary_key
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_key"] = secondary_key
        __props__.__dict__["state"] = state
        __props__.__dict__["subscription_id"] = subscription_id
        __props__.__dict__["user_id"] = user_id
        return Subscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowTracing")
    def allow_tracing(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines whether tracing can be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "allow_tracing")

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the API which should be assigned to this Subscription. Changing this forces a new resource to be created.

        > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `/apis` scope is used for the subscription and all apis are accessible.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the API Management Service where this Subscription should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of this Subscription.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> pulumi.Output[builtins.str]:
        """
        The primary subscription key to use for the subscription.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Product which should be assigned to this Subscription. Changing this forces a new resource to be created.

        > **Note:** Only one of `product_id` and `api_id` can be set. If both are missing `all_apis` scope is used for the subscription.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> pulumi.Output[builtins.str]:
        """
        The secondary subscription key to use for the subscription.
        """
        return pulumi.get(self, "secondary_key")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The state of this Subscription. Possible values are `active`, `cancelled`, `expired`, `rejected`, `submitted` and `suspended`. Defaults to `submitted`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[builtins.str]:
        """
        An Identifier which should used as the ID of this Subscription. If not specified a new Subscription ID will be generated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the User which should be assigned to this Subscription. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_id")

