# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 api_management_name: pulumi.Input[builtins.str],
                 email: pulumi.Input[builtins.str],
                 first_name: pulumi.Input[builtins.str],
                 last_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 user_id: pulumi.Input[builtins.str],
                 confirmation: Optional[pulumi.Input[builtins.str]] = None,
                 note: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[builtins.str] api_management_name: The name of the API Management Service in which the User should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] email: The email address associated with this user.
        :param pulumi.Input[builtins.str] first_name: The first name for this user.
        :param pulumi.Input[builtins.str] last_name: The last name for this user.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user_id: The Identifier for this User, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] confirmation: The kind of confirmation email which will be sent to this user. Possible values are `invite` and `signup`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] note: A note about this user.
        :param pulumi.Input[builtins.str] password: The password associated with this user.
        :param pulumi.Input[builtins.str] state: The state of this user. Possible values are `active`, `blocked` and `pending`.
               
               > **Note:** the State can be changed from Pending > Active/Blocked but not from Active/Blocked > Pending.
        """
        pulumi.set(__self__, "api_management_name", api_management_name)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "user_id", user_id)
        if confirmation is not None:
            pulumi.set(__self__, "confirmation", confirmation)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the API Management Service in which the User should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_management_name", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        The email address associated with this user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Input[builtins.str]:
        """
        The first name for this user.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Input[builtins.str]:
        """
        The last name for this user.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[builtins.str]:
        """
        The Identifier for this User, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def confirmation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind of confirmation email which will be sent to this user. Possible values are `invite` and `signup`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "confirmation")

    @confirmation.setter
    def confirmation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "confirmation", value)

    @property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A note about this user.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "note", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password associated with this user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of this user. Possible values are `active`, `blocked` and `pending`.

        > **Note:** the State can be changed from Pending > Active/Blocked but not from Active/Blocked > Pending.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 api_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 confirmation: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 note: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[builtins.str] api_management_name: The name of the API Management Service in which the User should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] confirmation: The kind of confirmation email which will be sent to this user. Possible values are `invite` and `signup`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] email: The email address associated with this user.
        :param pulumi.Input[builtins.str] first_name: The first name for this user.
        :param pulumi.Input[builtins.str] last_name: The last name for this user.
        :param pulumi.Input[builtins.str] note: A note about this user.
        :param pulumi.Input[builtins.str] password: The password associated with this user.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] state: The state of this user. Possible values are `active`, `blocked` and `pending`.
               
               > **Note:** the State can be changed from Pending > Active/Blocked but not from Active/Blocked > Pending.
        :param pulumi.Input[builtins.str] user_id: The Identifier for this User, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        """
        if api_management_name is not None:
            pulumi.set(__self__, "api_management_name", api_management_name)
        if confirmation is not None:
            pulumi.set(__self__, "confirmation", confirmation)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the API Management Service in which the User should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_management_name", value)

    @property
    @pulumi.getter
    def confirmation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind of confirmation email which will be sent to this user. Possible values are `invite` and `signup`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "confirmation")

    @confirmation.setter
    def confirmation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "confirmation", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email address associated with this user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The first name for this user.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last name for this user.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A note about this user.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "note", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password associated with this user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of this user. Possible values are `active`, `blocked` and `pending`.

        > **Note:** the State can be changed from Pending > Active/Blocked but not from Active/Blocked > Pending.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Identifier for this User, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("azure:apimanagement/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 confirmation: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 note: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an API Management User.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@exmaple.com",
            sku_name="Developer_1")
        example_user = azure.apimanagement.User("example",
            user_id="5931a75ae4bbd512288c680b",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            first_name="Example",
            last_name="User",
            email="user@example.com",
            state="active")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Users can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/user:User example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/users/abc123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_management_name: The name of the API Management Service in which the User should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] confirmation: The kind of confirmation email which will be sent to this user. Possible values are `invite` and `signup`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] email: The email address associated with this user.
        :param pulumi.Input[builtins.str] first_name: The first name for this user.
        :param pulumi.Input[builtins.str] last_name: The last name for this user.
        :param pulumi.Input[builtins.str] note: A note about this user.
        :param pulumi.Input[builtins.str] password: The password associated with this user.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] state: The state of this user. Possible values are `active`, `blocked` and `pending`.
               
               > **Note:** the State can be changed from Pending > Active/Blocked but not from Active/Blocked > Pending.
        :param pulumi.Input[builtins.str] user_id: The Identifier for this User, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Management User.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@exmaple.com",
            sku_name="Developer_1")
        example_user = azure.apimanagement.User("example",
            user_id="5931a75ae4bbd512288c680b",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            first_name="Example",
            last_name="User",
            email="user@example.com",
            state="active")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Users can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/user:User example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/users/abc123
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[builtins.str]] = None,
                 confirmation: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 note: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            if api_management_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_name'")
            __props__.__dict__["api_management_name"] = api_management_name
            __props__.__dict__["confirmation"] = confirmation
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            if first_name is None and not opts.urn:
                raise TypeError("Missing required property 'first_name'")
            __props__.__dict__["first_name"] = first_name
            if last_name is None and not opts.urn:
                raise TypeError("Missing required property 'last_name'")
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["note"] = note
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["state"] = state
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'azure:apimanagement/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_name: Optional[pulumi.Input[builtins.str]] = None,
            confirmation: Optional[pulumi.Input[builtins.str]] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            first_name: Optional[pulumi.Input[builtins.str]] = None,
            last_name: Optional[pulumi.Input[builtins.str]] = None,
            note: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            user_id: Optional[pulumi.Input[builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_management_name: The name of the API Management Service in which the User should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] confirmation: The kind of confirmation email which will be sent to this user. Possible values are `invite` and `signup`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] email: The email address associated with this user.
        :param pulumi.Input[builtins.str] first_name: The first name for this user.
        :param pulumi.Input[builtins.str] last_name: The last name for this user.
        :param pulumi.Input[builtins.str] note: A note about this user.
        :param pulumi.Input[builtins.str] password: The password associated with this user.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] state: The state of this user. Possible values are `active`, `blocked` and `pending`.
               
               > **Note:** the State can be changed from Pending > Active/Blocked but not from Active/Blocked > Pending.
        :param pulumi.Input[builtins.str] user_id: The Identifier for this User, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["api_management_name"] = api_management_name
        __props__.__dict__["confirmation"] = confirmation
        __props__.__dict__["email"] = email
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["note"] = note
        __props__.__dict__["password"] = password
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["state"] = state
        __props__.__dict__["user_id"] = user_id
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the API Management Service in which the User should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @property
    @pulumi.getter
    def confirmation(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The kind of confirmation email which will be sent to this user. Possible values are `invite` and `signup`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "confirmation")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        The email address associated with this user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[builtins.str]:
        """
        The first name for this user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[builtins.str]:
        """
        The last name for this user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def note(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A note about this user.
        """
        return pulumi.get(self, "note")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The password associated with this user.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of this user. Possible values are `active`, `blocked` and `pending`.

        > **Note:** the State can be changed from Pending > Active/Blocked but not from Active/Blocked > Pending.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[builtins.str]:
        """
        The Identifier for this User, which must be unique within the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_id")

