# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationFeatureArgs', 'ConfigurationFeature']

@pulumi.input_type
class ConfigurationFeatureArgs:
    def __init__(__self__, *,
                 configuration_store_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 percentage_filter_value: Optional[pulumi.Input[builtins.float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 targeting_filters: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTargetingFilterArgs']]]] = None,
                 timewindow_filters: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTimewindowFilterArgs']]]] = None):
        """
        The set of arguments for constructing a ConfigurationFeature resource.
        :param pulumi.Input[builtins.str] configuration_store_id: Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] description: The description of the App Configuration Feature.
        :param pulumi.Input[builtins.bool] enabled: The status of the App Configuration Feature. By default, this is set to false.
        :param pulumi.Input[builtins.str] key: The key of the App Configuration Feature. The value for `name` will be used if this is unspecified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] label: The label of the App Configuration Feature. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] locked: Should this App Configuration Feature be Locked to prevent changes?
        :param pulumi.Input[builtins.str] name: The name of the App Configuration Feature. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] percentage_filter_value: A number representing the value of the percentage required to enable this feature.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTargetingFilterArgs']]] targeting_filters: A `targeting_filter` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTimewindowFilterArgs']]] timewindow_filters: A `timewindow_filter` block as defined below.
        """
        pulumi.set(__self__, "configuration_store_id", configuration_store_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if percentage_filter_value is not None:
            pulumi.set(__self__, "percentage_filter_value", percentage_filter_value)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if targeting_filters is not None:
            pulumi.set(__self__, "targeting_filters", targeting_filters)
        if timewindow_filters is not None:
            pulumi.set(__self__, "timewindow_filters", timewindow_filters)

    @property
    @pulumi.getter(name="configurationStoreId")
    def configuration_store_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "configuration_store_id")

    @configuration_store_id.setter
    def configuration_store_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "configuration_store_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the App Configuration Feature.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The status of the App Configuration Feature. By default, this is set to false.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of the App Configuration Feature. The value for `name` will be used if this is unspecified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The label of the App Configuration Feature. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should this App Configuration Feature be Locked to prevent changes?
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the App Configuration Feature. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="percentageFilterValue")
    def percentage_filter_value(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        A number representing the value of the percentage required to enable this feature.
        """
        return pulumi.get(self, "percentage_filter_value")

    @percentage_filter_value.setter
    def percentage_filter_value(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "percentage_filter_value", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetingFilters")
    def targeting_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTargetingFilterArgs']]]]:
        """
        A `targeting_filter` block as defined below.
        """
        return pulumi.get(self, "targeting_filters")

    @targeting_filters.setter
    def targeting_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTargetingFilterArgs']]]]):
        pulumi.set(self, "targeting_filters", value)

    @property
    @pulumi.getter(name="timewindowFilters")
    def timewindow_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTimewindowFilterArgs']]]]:
        """
        A `timewindow_filter` block as defined below.
        """
        return pulumi.get(self, "timewindow_filters")

    @timewindow_filters.setter
    def timewindow_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTimewindowFilterArgs']]]]):
        pulumi.set(self, "timewindow_filters", value)


@pulumi.input_type
class _ConfigurationFeatureState:
    def __init__(__self__, *,
                 configuration_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 percentage_filter_value: Optional[pulumi.Input[builtins.float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 targeting_filters: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTargetingFilterArgs']]]] = None,
                 timewindow_filters: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTimewindowFilterArgs']]]] = None):
        """
        Input properties used for looking up and filtering ConfigurationFeature resources.
        :param pulumi.Input[builtins.str] configuration_store_id: Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] description: The description of the App Configuration Feature.
        :param pulumi.Input[builtins.bool] enabled: The status of the App Configuration Feature. By default, this is set to false.
        :param pulumi.Input[builtins.str] key: The key of the App Configuration Feature. The value for `name` will be used if this is unspecified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] label: The label of the App Configuration Feature. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] locked: Should this App Configuration Feature be Locked to prevent changes?
        :param pulumi.Input[builtins.str] name: The name of the App Configuration Feature. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] percentage_filter_value: A number representing the value of the percentage required to enable this feature.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTargetingFilterArgs']]] targeting_filters: A `targeting_filter` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTimewindowFilterArgs']]] timewindow_filters: A `timewindow_filter` block as defined below.
        """
        if configuration_store_id is not None:
            pulumi.set(__self__, "configuration_store_id", configuration_store_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if percentage_filter_value is not None:
            pulumi.set(__self__, "percentage_filter_value", percentage_filter_value)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if targeting_filters is not None:
            pulumi.set(__self__, "targeting_filters", targeting_filters)
        if timewindow_filters is not None:
            pulumi.set(__self__, "timewindow_filters", timewindow_filters)

    @property
    @pulumi.getter(name="configurationStoreId")
    def configuration_store_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "configuration_store_id")

    @configuration_store_id.setter
    def configuration_store_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "configuration_store_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the App Configuration Feature.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The status of the App Configuration Feature. By default, this is set to false.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of the App Configuration Feature. The value for `name` will be used if this is unspecified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The label of the App Configuration Feature. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should this App Configuration Feature be Locked to prevent changes?
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the App Configuration Feature. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="percentageFilterValue")
    def percentage_filter_value(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        A number representing the value of the percentage required to enable this feature.
        """
        return pulumi.get(self, "percentage_filter_value")

    @percentage_filter_value.setter
    def percentage_filter_value(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "percentage_filter_value", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetingFilters")
    def targeting_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTargetingFilterArgs']]]]:
        """
        A `targeting_filter` block as defined below.
        """
        return pulumi.get(self, "targeting_filters")

    @targeting_filters.setter
    def targeting_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTargetingFilterArgs']]]]):
        pulumi.set(self, "targeting_filters", value)

    @property
    @pulumi.getter(name="timewindowFilters")
    def timewindow_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTimewindowFilterArgs']]]]:
        """
        A `timewindow_filter` block as defined below.
        """
        return pulumi.get(self, "timewindow_filters")

    @timewindow_filters.setter
    def timewindow_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationFeatureTimewindowFilterArgs']]]]):
        pulumi.set(self, "timewindow_filters", value)


@pulumi.type_token("azure:appconfiguration/configurationFeature:ConfigurationFeature")
class ConfigurationFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 percentage_filter_value: Optional[pulumi.Input[builtins.float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 targeting_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationFeatureTargetingFilterArgs', 'ConfigurationFeatureTargetingFilterArgsDict']]]]] = None,
                 timewindow_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationFeatureTimewindowFilterArgs', 'ConfigurationFeatureTimewindowFilterArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages an Azure App Configuration Feature.

        > **Note:** App Configuration Features are provisioned using a Data Plane API which requires the role `App Configuration Data Owner` on either the App Configuration or a parent scope (such as the Resource Group/Subscription). [More information can be found in the Azure Documentation for App Configuration](https://docs.microsoft.com/azure/azure-app-configuration/concept-enable-rbac#azure-built-in-roles-for-azure-app-configuration). This is similar to providing App Configuration Keys.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        appconf = azure.appconfiguration.ConfigurationStore("appconf",
            name="appConf1",
            resource_group_name=example.name,
            location=example.location)
        current = azure.core.get_client_config()
        appconf_dataowner = azure.authorization.Assignment("appconf_dataowner",
            scope=appconf.id,
            role_definition_name="App Configuration Data Owner",
            principal_id=current.object_id)
        test = azure.appconfiguration.ConfigurationFeature("test",
            configuration_store_id=appconf.id,
            description="test description",
            name="test-ackey",
            label="test-ackeylabel",
            enabled=True)
        ```

        ## Import

        App Configuration Features can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appconfiguration/configurationFeature:ConfigurationFeature test https://appconfname1.azconfig.io/kv/.appconfig.featureflag%2FkeyName?label=labelName
        ```

        If you wish to import with an empty label then simply leave the label's name blank:

        ```sh
        $ pulumi import azure:appconfiguration/configurationFeature:ConfigurationFeature test https://appconfname1.azconfig.io/kv/.appconfig.featureflag%2FkeyName?label=
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] configuration_store_id: Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] description: The description of the App Configuration Feature.
        :param pulumi.Input[builtins.bool] enabled: The status of the App Configuration Feature. By default, this is set to false.
        :param pulumi.Input[builtins.str] key: The key of the App Configuration Feature. The value for `name` will be used if this is unspecified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] label: The label of the App Configuration Feature. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] locked: Should this App Configuration Feature be Locked to prevent changes?
        :param pulumi.Input[builtins.str] name: The name of the App Configuration Feature. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] percentage_filter_value: A number representing the value of the percentage required to enable this feature.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationFeatureTargetingFilterArgs', 'ConfigurationFeatureTargetingFilterArgsDict']]]] targeting_filters: A `targeting_filter` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationFeatureTimewindowFilterArgs', 'ConfigurationFeatureTimewindowFilterArgsDict']]]] timewindow_filters: A `timewindow_filter` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure App Configuration Feature.

        > **Note:** App Configuration Features are provisioned using a Data Plane API which requires the role `App Configuration Data Owner` on either the App Configuration or a parent scope (such as the Resource Group/Subscription). [More information can be found in the Azure Documentation for App Configuration](https://docs.microsoft.com/azure/azure-app-configuration/concept-enable-rbac#azure-built-in-roles-for-azure-app-configuration). This is similar to providing App Configuration Keys.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        appconf = azure.appconfiguration.ConfigurationStore("appconf",
            name="appConf1",
            resource_group_name=example.name,
            location=example.location)
        current = azure.core.get_client_config()
        appconf_dataowner = azure.authorization.Assignment("appconf_dataowner",
            scope=appconf.id,
            role_definition_name="App Configuration Data Owner",
            principal_id=current.object_id)
        test = azure.appconfiguration.ConfigurationFeature("test",
            configuration_store_id=appconf.id,
            description="test description",
            name="test-ackey",
            label="test-ackeylabel",
            enabled=True)
        ```

        ## Import

        App Configuration Features can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appconfiguration/configurationFeature:ConfigurationFeature test https://appconfname1.azconfig.io/kv/.appconfig.featureflag%2FkeyName?label=labelName
        ```

        If you wish to import with an empty label then simply leave the label's name blank:

        ```sh
        $ pulumi import azure:appconfiguration/configurationFeature:ConfigurationFeature test https://appconfname1.azconfig.io/kv/.appconfig.featureflag%2FkeyName?label=
        ```

        :param str resource_name: The name of the resource.
        :param ConfigurationFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 percentage_filter_value: Optional[pulumi.Input[builtins.float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 targeting_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationFeatureTargetingFilterArgs', 'ConfigurationFeatureTargetingFilterArgsDict']]]]] = None,
                 timewindow_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationFeatureTimewindowFilterArgs', 'ConfigurationFeatureTimewindowFilterArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationFeatureArgs.__new__(ConfigurationFeatureArgs)

            if configuration_store_id is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_store_id'")
            __props__.__dict__["configuration_store_id"] = configuration_store_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["etag"] = etag
            __props__.__dict__["key"] = key
            __props__.__dict__["label"] = label
            __props__.__dict__["locked"] = locked
            __props__.__dict__["name"] = name
            __props__.__dict__["percentage_filter_value"] = percentage_filter_value
            __props__.__dict__["tags"] = tags
            __props__.__dict__["targeting_filters"] = targeting_filters
            __props__.__dict__["timewindow_filters"] = timewindow_filters
        super(ConfigurationFeature, __self__).__init__(
            'azure:appconfiguration/configurationFeature:ConfigurationFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration_store_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            label: Optional[pulumi.Input[builtins.str]] = None,
            locked: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            percentage_filter_value: Optional[pulumi.Input[builtins.float]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            targeting_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationFeatureTargetingFilterArgs', 'ConfigurationFeatureTargetingFilterArgsDict']]]]] = None,
            timewindow_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationFeatureTimewindowFilterArgs', 'ConfigurationFeatureTimewindowFilterArgsDict']]]]] = None) -> 'ConfigurationFeature':
        """
        Get an existing ConfigurationFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] configuration_store_id: Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] description: The description of the App Configuration Feature.
        :param pulumi.Input[builtins.bool] enabled: The status of the App Configuration Feature. By default, this is set to false.
        :param pulumi.Input[builtins.str] key: The key of the App Configuration Feature. The value for `name` will be used if this is unspecified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] label: The label of the App Configuration Feature. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] locked: Should this App Configuration Feature be Locked to prevent changes?
        :param pulumi.Input[builtins.str] name: The name of the App Configuration Feature. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] percentage_filter_value: A number representing the value of the percentage required to enable this feature.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationFeatureTargetingFilterArgs', 'ConfigurationFeatureTargetingFilterArgsDict']]]] targeting_filters: A `targeting_filter` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationFeatureTimewindowFilterArgs', 'ConfigurationFeatureTimewindowFilterArgsDict']]]] timewindow_filters: A `timewindow_filter` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationFeatureState.__new__(_ConfigurationFeatureState)

        __props__.__dict__["configuration_store_id"] = configuration_store_id
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["etag"] = etag
        __props__.__dict__["key"] = key
        __props__.__dict__["label"] = label
        __props__.__dict__["locked"] = locked
        __props__.__dict__["name"] = name
        __props__.__dict__["percentage_filter_value"] = percentage_filter_value
        __props__.__dict__["tags"] = tags
        __props__.__dict__["targeting_filters"] = targeting_filters
        __props__.__dict__["timewindow_filters"] = timewindow_filters
        return ConfigurationFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configurationStoreId")
    def configuration_store_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "configuration_store_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the App Configuration Feature.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The status of the App Configuration Feature. By default, this is set to false.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        The key of the App Configuration Feature. The value for `name` will be used if this is unspecified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The label of the App Configuration Feature. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def locked(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should this App Configuration Feature be Locked to prevent changes?
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the App Configuration Feature. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="percentageFilterValue")
    def percentage_filter_value(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        A number representing the value of the percentage required to enable this feature.
        """
        return pulumi.get(self, "percentage_filter_value")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetingFilters")
    def targeting_filters(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigurationFeatureTargetingFilter']]]:
        """
        A `targeting_filter` block as defined below.
        """
        return pulumi.get(self, "targeting_filters")

    @property
    @pulumi.getter(name="timewindowFilters")
    def timewindow_filters(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigurationFeatureTimewindowFilter']]]:
        """
        A `timewindow_filter` block as defined below.
        """
        return pulumi.get(self, "timewindow_filters")

