# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ConfigurationKeyArgs', 'ConfigurationKey']

@pulumi.input_type
class ConfigurationKeyArgs:
    def __init__(__self__, *,
                 configuration_store_id: pulumi.Input[builtins.str],
                 key: pulumi.Input[builtins.str],
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 vault_key_reference: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ConfigurationKey resource.
        :param pulumi.Input[builtins.str] configuration_store_id: Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key: The name of the App Configuration Key to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_type: The content type of the App Configuration Key. This should only be set when type is set to `kv`.
        :param pulumi.Input[builtins.str] etag: (Optional) The ETag of the key.
        :param pulumi.Input[builtins.str] label: The label of the App Configuration Key. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] locked: Should this App Configuration Key be Locked to prevent changes?
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] type: The type of the App Configuration Key. It can either be `kv` (simple [key/value](https://docs.microsoft.com/azure/azure-app-configuration/concept-key-value)) or `vault` (where the value is a reference to a [Key Vault Secret](https://azure.microsoft.com/en-gb/services/key-vault/). Defaults to `kv`.
        :param pulumi.Input[builtins.str] value: The value of the App Configuration Key. This should only be set when type is set to `kv`.
               
               > **Note:** `value` and `vault_key_reference` are mutually exclusive.
        :param pulumi.Input[builtins.str] vault_key_reference: The ID of the vault secret this App Configuration Key refers to. This should only be set when `type` is set to `vault`.
               
               > **Note:** `vault_key_reference` and `value` are mutually exclusive.
               
               > **Note:** When setting the `vault_key_reference` using the `id` will pin the value to specific version of the secret, to reference latest secret value use `versionless_id`
        """
        pulumi.set(__self__, "configuration_store_id", configuration_store_id)
        pulumi.set(__self__, "key", key)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if vault_key_reference is not None:
            pulumi.set(__self__, "vault_key_reference", vault_key_reference)

    @property
    @pulumi.getter(name="configurationStoreId")
    def configuration_store_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "configuration_store_id")

    @configuration_store_id.setter
    def configuration_store_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "configuration_store_id", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The name of the App Configuration Key to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content type of the App Configuration Key. This should only be set when type is set to `kv`.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) The ETag of the key.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The label of the App Configuration Key. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should this App Configuration Key be Locked to prevent changes?
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the App Configuration Key. It can either be `kv` (simple [key/value](https://docs.microsoft.com/azure/azure-app-configuration/concept-key-value)) or `vault` (where the value is a reference to a [Key Vault Secret](https://azure.microsoft.com/en-gb/services/key-vault/). Defaults to `kv`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the App Configuration Key. This should only be set when type is set to `kv`.

        > **Note:** `value` and `vault_key_reference` are mutually exclusive.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="vaultKeyReference")
    def vault_key_reference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the vault secret this App Configuration Key refers to. This should only be set when `type` is set to `vault`.

        > **Note:** `vault_key_reference` and `value` are mutually exclusive.

        > **Note:** When setting the `vault_key_reference` using the `id` will pin the value to specific version of the secret, to reference latest secret value use `versionless_id`
        """
        return pulumi.get(self, "vault_key_reference")

    @vault_key_reference.setter
    def vault_key_reference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vault_key_reference", value)


@pulumi.input_type
class _ConfigurationKeyState:
    def __init__(__self__, *,
                 configuration_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 vault_key_reference: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConfigurationKey resources.
        :param pulumi.Input[builtins.str] configuration_store_id: Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_type: The content type of the App Configuration Key. This should only be set when type is set to `kv`.
        :param pulumi.Input[builtins.str] etag: (Optional) The ETag of the key.
        :param pulumi.Input[builtins.str] key: The name of the App Configuration Key to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] label: The label of the App Configuration Key. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] locked: Should this App Configuration Key be Locked to prevent changes?
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] type: The type of the App Configuration Key. It can either be `kv` (simple [key/value](https://docs.microsoft.com/azure/azure-app-configuration/concept-key-value)) or `vault` (where the value is a reference to a [Key Vault Secret](https://azure.microsoft.com/en-gb/services/key-vault/). Defaults to `kv`.
        :param pulumi.Input[builtins.str] value: The value of the App Configuration Key. This should only be set when type is set to `kv`.
               
               > **Note:** `value` and `vault_key_reference` are mutually exclusive.
        :param pulumi.Input[builtins.str] vault_key_reference: The ID of the vault secret this App Configuration Key refers to. This should only be set when `type` is set to `vault`.
               
               > **Note:** `vault_key_reference` and `value` are mutually exclusive.
               
               > **Note:** When setting the `vault_key_reference` using the `id` will pin the value to specific version of the secret, to reference latest secret value use `versionless_id`
        """
        if configuration_store_id is not None:
            pulumi.set(__self__, "configuration_store_id", configuration_store_id)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if vault_key_reference is not None:
            pulumi.set(__self__, "vault_key_reference", vault_key_reference)

    @property
    @pulumi.getter(name="configurationStoreId")
    def configuration_store_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "configuration_store_id")

    @configuration_store_id.setter
    def configuration_store_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "configuration_store_id", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content type of the App Configuration Key. This should only be set when type is set to `kv`.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional) The ETag of the key.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the App Configuration Key to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The label of the App Configuration Key. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should this App Configuration Key be Locked to prevent changes?
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the App Configuration Key. It can either be `kv` (simple [key/value](https://docs.microsoft.com/azure/azure-app-configuration/concept-key-value)) or `vault` (where the value is a reference to a [Key Vault Secret](https://azure.microsoft.com/en-gb/services/key-vault/). Defaults to `kv`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the App Configuration Key. This should only be set when type is set to `kv`.

        > **Note:** `value` and `vault_key_reference` are mutually exclusive.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="vaultKeyReference")
    def vault_key_reference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the vault secret this App Configuration Key refers to. This should only be set when `type` is set to `vault`.

        > **Note:** `vault_key_reference` and `value` are mutually exclusive.

        > **Note:** When setting the `vault_key_reference` using the `id` will pin the value to specific version of the secret, to reference latest secret value use `versionless_id`
        """
        return pulumi.get(self, "vault_key_reference")

    @vault_key_reference.setter
    def vault_key_reference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vault_key_reference", value)


@pulumi.type_token("azure:appconfiguration/configurationKey:ConfigurationKey")
class ConfigurationKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 vault_key_reference: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure App Configuration Key.

        > **Note:** App Configuration Keys are provisioned using a Data Plane API which requires the role `App Configuration Data Owner` on either the App Configuration or a parent scope (such as the Resource Group/Subscription). [More information can be found in the Azure Documentation for App Configuration](https://docs.microsoft.com/azure/azure-app-configuration/concept-enable-rbac#azure-built-in-roles-for-azure-app-configuration).

        ## Example Usage

        ### `Kv` Type

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        appconf = azure.appconfiguration.ConfigurationStore("appconf",
            name="appConf1",
            resource_group_name=example.name,
            location=example.location)
        current = azure.core.get_client_config()
        appconf_dataowner = azure.authorization.Assignment("appconf_dataowner",
            scope=appconf.id,
            role_definition_name="App Configuration Data Owner",
            principal_id=current.object_id)
        test = azure.appconfiguration.ConfigurationKey("test",
            configuration_store_id=appconf.id,
            key="appConfKey1",
            label="somelabel",
            value="a test",
            opts = pulumi.ResourceOptions(depends_on=[appconf_dataowner]))
        ```

        ### `Vault` Type

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        appconf = azure.appconfiguration.ConfigurationStore("appconf",
            name="appConf1",
            resource_group_name=example.name,
            location=example.location)
        current = azure.core.get_client_config()
        kv = azure.keyvault.KeyVault("kv",
            name="kv",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            tenant_id=current.tenant_id,
            sku_name="premium",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "key_permissions": [
                    "Create",
                    "Get",
                ],
                "secret_permissions": [
                    "Set",
                    "Get",
                    "Delete",
                    "Purge",
                    "Recover",
                ],
            }])
        kvs = azure.keyvault.Secret("kvs",
            name="kvs",
            value="szechuan",
            key_vault_id=kv.id)
        appconf_dataowner = azure.authorization.Assignment("appconf_dataowner",
            scope=appconf.id,
            role_definition_name="App Configuration Data Owner",
            principal_id=current.object_id)
        test = azure.appconfiguration.ConfigurationKey("test",
            configuration_store_id=test_azurerm_app_configuration["id"],
            key="key1",
            type="vault",
            label="label1",
            vault_key_reference=kvs.versionless_id,
            opts = pulumi.ResourceOptions(depends_on=[appconf_dataowner]))
        ```

        ## Import

        App Configuration Keys can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appconfiguration/configurationKey:ConfigurationKey test https://appconfname1.azconfig.io/kv/keyName?label=labelName
        ```

        If you wish to import a key with an empty label then simply leave label's name blank:

        ```sh
        $ pulumi import azure:appconfiguration/configurationKey:ConfigurationKey test https://appconfname1.azconfig.io/kv/keyName?label=
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] configuration_store_id: Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_type: The content type of the App Configuration Key. This should only be set when type is set to `kv`.
        :param pulumi.Input[builtins.str] etag: (Optional) The ETag of the key.
        :param pulumi.Input[builtins.str] key: The name of the App Configuration Key to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] label: The label of the App Configuration Key. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] locked: Should this App Configuration Key be Locked to prevent changes?
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] type: The type of the App Configuration Key. It can either be `kv` (simple [key/value](https://docs.microsoft.com/azure/azure-app-configuration/concept-key-value)) or `vault` (where the value is a reference to a [Key Vault Secret](https://azure.microsoft.com/en-gb/services/key-vault/). Defaults to `kv`.
        :param pulumi.Input[builtins.str] value: The value of the App Configuration Key. This should only be set when type is set to `kv`.
               
               > **Note:** `value` and `vault_key_reference` are mutually exclusive.
        :param pulumi.Input[builtins.str] vault_key_reference: The ID of the vault secret this App Configuration Key refers to. This should only be set when `type` is set to `vault`.
               
               > **Note:** `vault_key_reference` and `value` are mutually exclusive.
               
               > **Note:** When setting the `vault_key_reference` using the `id` will pin the value to specific version of the secret, to reference latest secret value use `versionless_id`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure App Configuration Key.

        > **Note:** App Configuration Keys are provisioned using a Data Plane API which requires the role `App Configuration Data Owner` on either the App Configuration or a parent scope (such as the Resource Group/Subscription). [More information can be found in the Azure Documentation for App Configuration](https://docs.microsoft.com/azure/azure-app-configuration/concept-enable-rbac#azure-built-in-roles-for-azure-app-configuration).

        ## Example Usage

        ### `Kv` Type

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        appconf = azure.appconfiguration.ConfigurationStore("appconf",
            name="appConf1",
            resource_group_name=example.name,
            location=example.location)
        current = azure.core.get_client_config()
        appconf_dataowner = azure.authorization.Assignment("appconf_dataowner",
            scope=appconf.id,
            role_definition_name="App Configuration Data Owner",
            principal_id=current.object_id)
        test = azure.appconfiguration.ConfigurationKey("test",
            configuration_store_id=appconf.id,
            key="appConfKey1",
            label="somelabel",
            value="a test",
            opts = pulumi.ResourceOptions(depends_on=[appconf_dataowner]))
        ```

        ### `Vault` Type

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        appconf = azure.appconfiguration.ConfigurationStore("appconf",
            name="appConf1",
            resource_group_name=example.name,
            location=example.location)
        current = azure.core.get_client_config()
        kv = azure.keyvault.KeyVault("kv",
            name="kv",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            tenant_id=current.tenant_id,
            sku_name="premium",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "key_permissions": [
                    "Create",
                    "Get",
                ],
                "secret_permissions": [
                    "Set",
                    "Get",
                    "Delete",
                    "Purge",
                    "Recover",
                ],
            }])
        kvs = azure.keyvault.Secret("kvs",
            name="kvs",
            value="szechuan",
            key_vault_id=kv.id)
        appconf_dataowner = azure.authorization.Assignment("appconf_dataowner",
            scope=appconf.id,
            role_definition_name="App Configuration Data Owner",
            principal_id=current.object_id)
        test = azure.appconfiguration.ConfigurationKey("test",
            configuration_store_id=test_azurerm_app_configuration["id"],
            key="key1",
            type="vault",
            label="label1",
            vault_key_reference=kvs.versionless_id,
            opts = pulumi.ResourceOptions(depends_on=[appconf_dataowner]))
        ```

        ## Import

        App Configuration Keys can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appconfiguration/configurationKey:ConfigurationKey test https://appconfname1.azconfig.io/kv/keyName?label=labelName
        ```

        If you wish to import a key with an empty label then simply leave label's name blank:

        ```sh
        $ pulumi import azure:appconfiguration/configurationKey:ConfigurationKey test https://appconfname1.azconfig.io/kv/keyName?label=
        ```

        :param str resource_name: The name of the resource.
        :param ConfigurationKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 vault_key_reference: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationKeyArgs.__new__(ConfigurationKeyArgs)

            if configuration_store_id is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_store_id'")
            __props__.__dict__["configuration_store_id"] = configuration_store_id
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["etag"] = etag
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["label"] = label
            __props__.__dict__["locked"] = locked
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["value"] = value
            __props__.__dict__["vault_key_reference"] = vault_key_reference
        super(ConfigurationKey, __self__).__init__(
            'azure:appconfiguration/configurationKey:ConfigurationKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration_store_id: Optional[pulumi.Input[builtins.str]] = None,
            content_type: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            label: Optional[pulumi.Input[builtins.str]] = None,
            locked: Optional[pulumi.Input[builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            value: Optional[pulumi.Input[builtins.str]] = None,
            vault_key_reference: Optional[pulumi.Input[builtins.str]] = None) -> 'ConfigurationKey':
        """
        Get an existing ConfigurationKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] configuration_store_id: Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_type: The content type of the App Configuration Key. This should only be set when type is set to `kv`.
        :param pulumi.Input[builtins.str] etag: (Optional) The ETag of the key.
        :param pulumi.Input[builtins.str] key: The name of the App Configuration Key to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] label: The label of the App Configuration Key. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] locked: Should this App Configuration Key be Locked to prevent changes?
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] type: The type of the App Configuration Key. It can either be `kv` (simple [key/value](https://docs.microsoft.com/azure/azure-app-configuration/concept-key-value)) or `vault` (where the value is a reference to a [Key Vault Secret](https://azure.microsoft.com/en-gb/services/key-vault/). Defaults to `kv`.
        :param pulumi.Input[builtins.str] value: The value of the App Configuration Key. This should only be set when type is set to `kv`.
               
               > **Note:** `value` and `vault_key_reference` are mutually exclusive.
        :param pulumi.Input[builtins.str] vault_key_reference: The ID of the vault secret this App Configuration Key refers to. This should only be set when `type` is set to `vault`.
               
               > **Note:** `vault_key_reference` and `value` are mutually exclusive.
               
               > **Note:** When setting the `vault_key_reference` using the `id` will pin the value to specific version of the secret, to reference latest secret value use `versionless_id`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationKeyState.__new__(_ConfigurationKeyState)

        __props__.__dict__["configuration_store_id"] = configuration_store_id
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["etag"] = etag
        __props__.__dict__["key"] = key
        __props__.__dict__["label"] = label
        __props__.__dict__["locked"] = locked
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["value"] = value
        __props__.__dict__["vault_key_reference"] = vault_key_reference
        return ConfigurationKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configurationStoreId")
    def configuration_store_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the id of the App Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "configuration_store_id")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[builtins.str]:
        """
        The content type of the App Configuration Key. This should only be set when type is set to `kv`.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        (Optional) The ETag of the key.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        The name of the App Configuration Key to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The label of the App Configuration Key. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def locked(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should this App Configuration Key be Locked to prevent changes?
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of the App Configuration Key. It can either be `kv` (simple [key/value](https://docs.microsoft.com/azure/azure-app-configuration/concept-key-value)) or `vault` (where the value is a reference to a [Key Vault Secret](https://azure.microsoft.com/en-gb/services/key-vault/). Defaults to `kv`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The value of the App Configuration Key. This should only be set when type is set to `kv`.

        > **Note:** `value` and `vault_key_reference` are mutually exclusive.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vaultKeyReference")
    def vault_key_reference(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the vault secret this App Configuration Key refers to. This should only be set when `type` is set to `vault`.

        > **Note:** `vault_key_reference` and `value` are mutually exclusive.

        > **Note:** When setting the `vault_key_reference` using the `id` will pin the value to specific version of the secret, to reference latest secret value use `versionless_id`
        """
        return pulumi.get(self, "vault_key_reference")

