# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetConfigurationKeysResult',
    'AwaitableGetConfigurationKeysResult',
    'get_configuration_keys',
    'get_configuration_keys_output',
]

@pulumi.output_type
class GetConfigurationKeysResult:
    """
    A collection of values returned by getConfigurationKeys.
    """
    def __init__(__self__, configuration_store_id=None, id=None, items=None, key=None, label=None):
        if configuration_store_id and not isinstance(configuration_store_id, str):
            raise TypeError("Expected argument 'configuration_store_id' to be a str")
        pulumi.set(__self__, "configuration_store_id", configuration_store_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="configurationStoreId")
    def configuration_store_id(self) -> builtins.str:
        return pulumi.get(self, "configuration_store_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigurationKeysItemResult']:
        """
        A list of `items` blocks as defined below.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The name of the App Configuration Key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def label(self) -> Optional[builtins.str]:
        """
        The label of the App Configuration Key.
        """
        return pulumi.get(self, "label")


class AwaitableGetConfigurationKeysResult(GetConfigurationKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigurationKeysResult(
            configuration_store_id=self.configuration_store_id,
            id=self.id,
            items=self.items,
            key=self.key,
            label=self.label)


def get_configuration_keys(configuration_store_id: Optional[builtins.str] = None,
                           key: Optional[builtins.str] = None,
                           label: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigurationKeysResult:
    """
    Use this data source to access information about existing Azure App Configuration Keys.

    > **Note:** App Configuration Keys are provisioned using a Data Plane API which requires the role `App Configuration Data Owner` on either the App Configuration or a parent scope (such as the Resource Group/Subscription). [More information can be found in the Azure Documentation for App Configuration](https://docs.microsoft.com/azure/azure-app-configuration/concept-enable-rbac#azure-built-in-roles-for-azure-app-configuration).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    test = azure.appconfiguration.get_configuration_keys(configuration_store_id=appconf["id"])
    pulumi.export("value", test.items)
    ```


    :param builtins.str configuration_store_id: Specifies the id of the App Configuration.
    :param builtins.str key: The name of the App Configuration Keys to look up.
    :param builtins.str label: The label of the App Configuration Keys tp look up.
    """
    __args__ = dict()
    __args__['configurationStoreId'] = configuration_store_id
    __args__['key'] = key
    __args__['label'] = label
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:appconfiguration/getConfigurationKeys:getConfigurationKeys', __args__, opts=opts, typ=GetConfigurationKeysResult).value

    return AwaitableGetConfigurationKeysResult(
        configuration_store_id=pulumi.get(__ret__, 'configuration_store_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        key=pulumi.get(__ret__, 'key'),
        label=pulumi.get(__ret__, 'label'))
def get_configuration_keys_output(configuration_store_id: Optional[pulumi.Input[builtins.str]] = None,
                                  key: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  label: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConfigurationKeysResult]:
    """
    Use this data source to access information about existing Azure App Configuration Keys.

    > **Note:** App Configuration Keys are provisioned using a Data Plane API which requires the role `App Configuration Data Owner` on either the App Configuration or a parent scope (such as the Resource Group/Subscription). [More information can be found in the Azure Documentation for App Configuration](https://docs.microsoft.com/azure/azure-app-configuration/concept-enable-rbac#azure-built-in-roles-for-azure-app-configuration).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    test = azure.appconfiguration.get_configuration_keys(configuration_store_id=appconf["id"])
    pulumi.export("value", test.items)
    ```


    :param builtins.str configuration_store_id: Specifies the id of the App Configuration.
    :param builtins.str key: The name of the App Configuration Keys to look up.
    :param builtins.str label: The label of the App Configuration Keys tp look up.
    """
    __args__ = dict()
    __args__['configurationStoreId'] = configuration_store_id
    __args__['key'] = key
    __args__['label'] = label
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:appconfiguration/getConfigurationKeys:getConfigurationKeys', __args__, opts=opts, typ=GetConfigurationKeysResult)
    return __ret__.apply(lambda __response__: GetConfigurationKeysResult(
        configuration_store_id=pulumi.get(__response__, 'configuration_store_id'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        key=pulumi.get(__response__, 'key'),
        label=pulumi.get(__response__, 'label')))
