# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetConfigurationStoreResult',
    'AwaitableGetConfigurationStoreResult',
    'get_configuration_store',
    'get_configuration_store_output',
]

@pulumi.output_type
class GetConfigurationStoreResult:
    """
    A collection of values returned by getConfigurationStore.
    """
    def __init__(__self__, data_plane_proxy_authentication_mode=None, data_plane_proxy_private_link_delegation_enabled=None, encryptions=None, endpoint=None, id=None, identities=None, local_auth_enabled=None, location=None, name=None, primary_read_keys=None, primary_write_keys=None, public_network_access=None, public_network_access_enabled=None, purge_protection_enabled=None, replicas=None, resource_group_name=None, secondary_read_keys=None, secondary_write_keys=None, sku=None, soft_delete_retention_days=None, tags=None):
        if data_plane_proxy_authentication_mode and not isinstance(data_plane_proxy_authentication_mode, str):
            raise TypeError("Expected argument 'data_plane_proxy_authentication_mode' to be a str")
        pulumi.set(__self__, "data_plane_proxy_authentication_mode", data_plane_proxy_authentication_mode)
        if data_plane_proxy_private_link_delegation_enabled and not isinstance(data_plane_proxy_private_link_delegation_enabled, bool):
            raise TypeError("Expected argument 'data_plane_proxy_private_link_delegation_enabled' to be a bool")
        pulumi.set(__self__, "data_plane_proxy_private_link_delegation_enabled", data_plane_proxy_private_link_delegation_enabled)
        if encryptions and not isinstance(encryptions, list):
            raise TypeError("Expected argument 'encryptions' to be a list")
        pulumi.set(__self__, "encryptions", encryptions)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if local_auth_enabled and not isinstance(local_auth_enabled, bool):
            raise TypeError("Expected argument 'local_auth_enabled' to be a bool")
        pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if primary_read_keys and not isinstance(primary_read_keys, list):
            raise TypeError("Expected argument 'primary_read_keys' to be a list")
        pulumi.set(__self__, "primary_read_keys", primary_read_keys)
        if primary_write_keys and not isinstance(primary_write_keys, list):
            raise TypeError("Expected argument 'primary_write_keys' to be a list")
        pulumi.set(__self__, "primary_write_keys", primary_write_keys)
        if public_network_access and not isinstance(public_network_access, str):
            raise TypeError("Expected argument 'public_network_access' to be a str")
        pulumi.set(__self__, "public_network_access", public_network_access)
        if public_network_access_enabled and not isinstance(public_network_access_enabled, bool):
            raise TypeError("Expected argument 'public_network_access_enabled' to be a bool")
        pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if purge_protection_enabled and not isinstance(purge_protection_enabled, bool):
            raise TypeError("Expected argument 'purge_protection_enabled' to be a bool")
        pulumi.set(__self__, "purge_protection_enabled", purge_protection_enabled)
        if replicas and not isinstance(replicas, list):
            raise TypeError("Expected argument 'replicas' to be a list")
        pulumi.set(__self__, "replicas", replicas)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_read_keys and not isinstance(secondary_read_keys, list):
            raise TypeError("Expected argument 'secondary_read_keys' to be a list")
        pulumi.set(__self__, "secondary_read_keys", secondary_read_keys)
        if secondary_write_keys and not isinstance(secondary_write_keys, list):
            raise TypeError("Expected argument 'secondary_write_keys' to be a list")
        pulumi.set(__self__, "secondary_write_keys", secondary_write_keys)
        if sku and not isinstance(sku, str):
            raise TypeError("Expected argument 'sku' to be a str")
        pulumi.set(__self__, "sku", sku)
        if soft_delete_retention_days and not isinstance(soft_delete_retention_days, int):
            raise TypeError("Expected argument 'soft_delete_retention_days' to be a int")
        pulumi.set(__self__, "soft_delete_retention_days", soft_delete_retention_days)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataPlaneProxyAuthenticationMode")
    def data_plane_proxy_authentication_mode(self) -> builtins.str:
        """
        The data plane proxy authentication mode.
        """
        return pulumi.get(self, "data_plane_proxy_authentication_mode")

    @property
    @pulumi.getter(name="dataPlaneProxyPrivateLinkDelegationEnabled")
    def data_plane_proxy_private_link_delegation_enabled(self) -> builtins.bool:
        """
        Whether data plane proxy private link delegation is enabled.
        """
        return pulumi.get(self, "data_plane_proxy_private_link_delegation_enabled")

    @property
    @pulumi.getter
    def encryptions(self) -> Sequence['outputs.GetConfigurationStoreEncryptionResult']:
        """
        An `encryption` block as defined below.
        """
        return pulumi.get(self, "encryptions")

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        The URL of the App Configuration Replica.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetConfigurationStoreIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> builtins.bool:
        """
        Whether local authentication methods are enabled.
        """
        return pulumi.get(self, "local_auth_enabled")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The supported Azure location where the App Configuration Replica exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the App Configuration Replica.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryReadKeys")
    def primary_read_keys(self) -> Sequence['outputs.GetConfigurationStorePrimaryReadKeyResult']:
        """
        A `primary_read_key` block as defined below containing the primary read access key.
        """
        return pulumi.get(self, "primary_read_keys")

    @property
    @pulumi.getter(name="primaryWriteKeys")
    def primary_write_keys(self) -> Sequence['outputs.GetConfigurationStorePrimaryWriteKeyResult']:
        """
        A `primary_write_key` block as defined below containing the primary write access key.
        """
        return pulumi.get(self, "primary_write_keys")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> builtins.str:
        """
        The Public Network Access setting of this App Configuration.
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> builtins.bool:
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> builtins.bool:
        """
        Whether Purge Protection is enabled.
        """
        return pulumi.get(self, "purge_protection_enabled")

    @property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.GetConfigurationStoreReplicaResult']:
        """
        One or more `replica` blocks as defined below.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="secondaryReadKeys")
    def secondary_read_keys(self) -> Sequence['outputs.GetConfigurationStoreSecondaryReadKeyResult']:
        """
        A `secondary_read_key` block as defined below containing the secondary read access key.
        """
        return pulumi.get(self, "secondary_read_keys")

    @property
    @pulumi.getter(name="secondaryWriteKeys")
    def secondary_write_keys(self) -> Sequence['outputs.GetConfigurationStoreSecondaryWriteKeyResult']:
        """
        A `secondary_write_key` block as defined below containing the secondary write access key.
        """
        return pulumi.get(self, "secondary_write_keys")

    @property
    @pulumi.getter
    def sku(self) -> builtins.str:
        """
        The name of the SKU used for this App Configuration.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> builtins.int:
        """
        The number of days that items should be retained for once soft-deleted.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the App Configuration.
        """
        return pulumi.get(self, "tags")


class AwaitableGetConfigurationStoreResult(GetConfigurationStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigurationStoreResult(
            data_plane_proxy_authentication_mode=self.data_plane_proxy_authentication_mode,
            data_plane_proxy_private_link_delegation_enabled=self.data_plane_proxy_private_link_delegation_enabled,
            encryptions=self.encryptions,
            endpoint=self.endpoint,
            id=self.id,
            identities=self.identities,
            local_auth_enabled=self.local_auth_enabled,
            location=self.location,
            name=self.name,
            primary_read_keys=self.primary_read_keys,
            primary_write_keys=self.primary_write_keys,
            public_network_access=self.public_network_access,
            public_network_access_enabled=self.public_network_access_enabled,
            purge_protection_enabled=self.purge_protection_enabled,
            replicas=self.replicas,
            resource_group_name=self.resource_group_name,
            secondary_read_keys=self.secondary_read_keys,
            secondary_write_keys=self.secondary_write_keys,
            sku=self.sku,
            soft_delete_retention_days=self.soft_delete_retention_days,
            tags=self.tags)


def get_configuration_store(name: Optional[builtins.str] = None,
                            resource_group_name: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigurationStoreResult:
    """
    Use this data source to access information about an existing App Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appconfiguration.get_configuration_store(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.AppConfiguration`: 2024-05-01


    :param builtins.str name: The Name of this App Configuration.
    :param builtins.str resource_group_name: The name of the Resource Group where the App Configuration exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:appconfiguration/getConfigurationStore:getConfigurationStore', __args__, opts=opts, typ=GetConfigurationStoreResult).value

    return AwaitableGetConfigurationStoreResult(
        data_plane_proxy_authentication_mode=pulumi.get(__ret__, 'data_plane_proxy_authentication_mode'),
        data_plane_proxy_private_link_delegation_enabled=pulumi.get(__ret__, 'data_plane_proxy_private_link_delegation_enabled'),
        encryptions=pulumi.get(__ret__, 'encryptions'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        local_auth_enabled=pulumi.get(__ret__, 'local_auth_enabled'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        primary_read_keys=pulumi.get(__ret__, 'primary_read_keys'),
        primary_write_keys=pulumi.get(__ret__, 'primary_write_keys'),
        public_network_access=pulumi.get(__ret__, 'public_network_access'),
        public_network_access_enabled=pulumi.get(__ret__, 'public_network_access_enabled'),
        purge_protection_enabled=pulumi.get(__ret__, 'purge_protection_enabled'),
        replicas=pulumi.get(__ret__, 'replicas'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        secondary_read_keys=pulumi.get(__ret__, 'secondary_read_keys'),
        secondary_write_keys=pulumi.get(__ret__, 'secondary_write_keys'),
        sku=pulumi.get(__ret__, 'sku'),
        soft_delete_retention_days=pulumi.get(__ret__, 'soft_delete_retention_days'),
        tags=pulumi.get(__ret__, 'tags'))
def get_configuration_store_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                   resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConfigurationStoreResult]:
    """
    Use this data source to access information about an existing App Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appconfiguration.get_configuration_store(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.AppConfiguration`: 2024-05-01


    :param builtins.str name: The Name of this App Configuration.
    :param builtins.str resource_group_name: The name of the Resource Group where the App Configuration exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:appconfiguration/getConfigurationStore:getConfigurationStore', __args__, opts=opts, typ=GetConfigurationStoreResult)
    return __ret__.apply(lambda __response__: GetConfigurationStoreResult(
        data_plane_proxy_authentication_mode=pulumi.get(__response__, 'data_plane_proxy_authentication_mode'),
        data_plane_proxy_private_link_delegation_enabled=pulumi.get(__response__, 'data_plane_proxy_private_link_delegation_enabled'),
        encryptions=pulumi.get(__response__, 'encryptions'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        local_auth_enabled=pulumi.get(__response__, 'local_auth_enabled'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        primary_read_keys=pulumi.get(__response__, 'primary_read_keys'),
        primary_write_keys=pulumi.get(__response__, 'primary_write_keys'),
        public_network_access=pulumi.get(__response__, 'public_network_access'),
        public_network_access_enabled=pulumi.get(__response__, 'public_network_access_enabled'),
        purge_protection_enabled=pulumi.get(__response__, 'purge_protection_enabled'),
        replicas=pulumi.get(__response__, 'replicas'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        secondary_read_keys=pulumi.get(__response__, 'secondary_read_keys'),
        secondary_write_keys=pulumi.get(__response__, 'secondary_write_keys'),
        sku=pulumi.get(__response__, 'sku'),
        soft_delete_retention_days=pulumi.get(__response__, 'soft_delete_retention_days'),
        tags=pulumi.get(__response__, 'tags')))
