# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LicationLoadBalancerFrontendArgs', 'LicationLoadBalancerFrontend']

@pulumi.input_type
class LicationLoadBalancerFrontendArgs:
    def __init__(__self__, *,
                 application_load_balancer_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a LicationLoadBalancerFrontend resource.
        :param pulumi.Input[builtins.str] application_load_balancer_id: The ID of the Application Gateway for Containers. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Application Gateway for Containers Frontend. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Application Gateway for Containers Frontend.
        """
        pulumi.set(__self__, "application_load_balancer_id", application_load_balancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="applicationLoadBalancerId")
    def application_load_balancer_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Application Gateway for Containers. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_load_balancer_id")

    @application_load_balancer_id.setter
    def application_load_balancer_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_load_balancer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Application Gateway for Containers Frontend. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Application Gateway for Containers Frontend.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LicationLoadBalancerFrontendState:
    def __init__(__self__, *,
                 application_load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 fully_qualified_domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LicationLoadBalancerFrontend resources.
        :param pulumi.Input[builtins.str] application_load_balancer_id: The ID of the Application Gateway for Containers. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] fully_qualified_domain_name: The Fully Qualified Domain Name of the DNS record associated to an Application Gateway for Containers Frontend.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Application Gateway for Containers Frontend. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Application Gateway for Containers Frontend.
        """
        if application_load_balancer_id is not None:
            pulumi.set(__self__, "application_load_balancer_id", application_load_balancer_id)
        if fully_qualified_domain_name is not None:
            pulumi.set(__self__, "fully_qualified_domain_name", fully_qualified_domain_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="applicationLoadBalancerId")
    def application_load_balancer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Application Gateway for Containers. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_load_balancer_id")

    @application_load_balancer_id.setter
    def application_load_balancer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_load_balancer_id", value)

    @property
    @pulumi.getter(name="fullyQualifiedDomainName")
    def fully_qualified_domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Fully Qualified Domain Name of the DNS record associated to an Application Gateway for Containers Frontend.
        """
        return pulumi.get(self, "fully_qualified_domain_name")

    @fully_qualified_domain_name.setter
    def fully_qualified_domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fully_qualified_domain_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Application Gateway for Containers Frontend. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Application Gateway for Containers Frontend.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:appconfiguration/licationLoadBalancerFrontend:LicationLoadBalancerFrontend")
class LicationLoadBalancerFrontend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Application Gateway for Containers Frontend.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.appconfiguration.LicationLoadBalancer("example",
            name="example",
            resource_group_name="example",
            location="West Europe")
        example_lication_load_balancer_frontend = azure.appconfiguration.LicationLoadBalancerFrontend("example",
            name="example",
            application_load_balancer_id=example.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceNetworking`: 2023-11-01

        ## Import

        Application Gateway for Containers Frontend can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appconfiguration/licationLoadBalancerFrontend:LicationLoadBalancerFrontend example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ServiceNetworking/trafficControllers/alb1/frontends/frontend1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_load_balancer_id: The ID of the Application Gateway for Containers. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Application Gateway for Containers Frontend. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Application Gateway for Containers Frontend.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LicationLoadBalancerFrontendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Application Gateway for Containers Frontend.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.appconfiguration.LicationLoadBalancer("example",
            name="example",
            resource_group_name="example",
            location="West Europe")
        example_lication_load_balancer_frontend = azure.appconfiguration.LicationLoadBalancerFrontend("example",
            name="example",
            application_load_balancer_id=example.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceNetworking`: 2023-11-01

        ## Import

        Application Gateway for Containers Frontend can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appconfiguration/licationLoadBalancerFrontend:LicationLoadBalancerFrontend example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ServiceNetworking/trafficControllers/alb1/frontends/frontend1
        ```

        :param str resource_name: The name of the resource.
        :param LicationLoadBalancerFrontendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LicationLoadBalancerFrontendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LicationLoadBalancerFrontendArgs.__new__(LicationLoadBalancerFrontendArgs)

            if application_load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_load_balancer_id'")
            __props__.__dict__["application_load_balancer_id"] = application_load_balancer_id
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["fully_qualified_domain_name"] = None
        super(LicationLoadBalancerFrontend, __self__).__init__(
            'azure:appconfiguration/licationLoadBalancerFrontend:LicationLoadBalancerFrontend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_load_balancer_id: Optional[pulumi.Input[builtins.str]] = None,
            fully_qualified_domain_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'LicationLoadBalancerFrontend':
        """
        Get an existing LicationLoadBalancerFrontend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_load_balancer_id: The ID of the Application Gateway for Containers. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] fully_qualified_domain_name: The Fully Qualified Domain Name of the DNS record associated to an Application Gateway for Containers Frontend.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Application Gateway for Containers Frontend. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Application Gateway for Containers Frontend.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LicationLoadBalancerFrontendState.__new__(_LicationLoadBalancerFrontendState)

        __props__.__dict__["application_load_balancer_id"] = application_load_balancer_id
        __props__.__dict__["fully_qualified_domain_name"] = fully_qualified_domain_name
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        return LicationLoadBalancerFrontend(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationLoadBalancerId")
    def application_load_balancer_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Application Gateway for Containers. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_load_balancer_id")

    @property
    @pulumi.getter(name="fullyQualifiedDomainName")
    def fully_qualified_domain_name(self) -> pulumi.Output[builtins.str]:
        """
        The Fully Qualified Domain Name of the DNS record associated to an Application Gateway for Containers Frontend.
        """
        return pulumi.get(self, "fully_qualified_domain_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Application Gateway for Containers Frontend. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Application Gateway for Containers Frontend.
        """
        return pulumi.get(self, "tags")

