# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConfigurationFeatureTargetingFilter',
    'ConfigurationFeatureTargetingFilterGroup',
    'ConfigurationFeatureTimewindowFilter',
    'ConfigurationStoreEncryption',
    'ConfigurationStoreIdentity',
    'ConfigurationStorePrimaryReadKey',
    'ConfigurationStorePrimaryWriteKey',
    'ConfigurationStoreReplica',
    'ConfigurationStoreSecondaryReadKey',
    'ConfigurationStoreSecondaryWriteKey',
    'GetConfigurationKeysItemResult',
    'GetConfigurationStoreEncryptionResult',
    'GetConfigurationStoreIdentityResult',
    'GetConfigurationStorePrimaryReadKeyResult',
    'GetConfigurationStorePrimaryWriteKeyResult',
    'GetConfigurationStoreReplicaResult',
    'GetConfigurationStoreSecondaryReadKeyResult',
    'GetConfigurationStoreSecondaryWriteKeyResult',
]

@pulumi.output_type
class ConfigurationFeatureTargetingFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRolloutPercentage":
            suggest = "default_rollout_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationFeatureTargetingFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationFeatureTargetingFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationFeatureTargetingFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_rollout_percentage: builtins.int,
                 groups: Optional[Sequence['outputs.ConfigurationFeatureTargetingFilterGroup']] = None,
                 users: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int default_rollout_percentage: A number representing the percentage of the entire user base.
        :param Sequence['ConfigurationFeatureTargetingFilterGroupArgs'] groups: One or more `groups` blocks as defined below.
        :param Sequence[builtins.str] users: A list of users to target for this feature.
        """
        pulumi.set(__self__, "default_rollout_percentage", default_rollout_percentage)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="defaultRolloutPercentage")
    def default_rollout_percentage(self) -> builtins.int:
        """
        A number representing the percentage of the entire user base.
        """
        return pulumi.get(self, "default_rollout_percentage")

    @property
    @pulumi.getter
    def groups(self) -> Optional[Sequence['outputs.ConfigurationFeatureTargetingFilterGroup']]:
        """
        One or more `groups` blocks as defined below.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def users(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of users to target for this feature.
        """
        return pulumi.get(self, "users")


@pulumi.output_type
class ConfigurationFeatureTargetingFilterGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rolloutPercentage":
            suggest = "rollout_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationFeatureTargetingFilterGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationFeatureTargetingFilterGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationFeatureTargetingFilterGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 rollout_percentage: builtins.int):
        """
        :param builtins.str name: The name of the group.
        :param builtins.int rollout_percentage: Rollout percentage of the group.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rollout_percentage", rollout_percentage)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rolloutPercentage")
    def rollout_percentage(self) -> builtins.int:
        """
        Rollout percentage of the group.
        """
        return pulumi.get(self, "rollout_percentage")


@pulumi.output_type
class ConfigurationFeatureTimewindowFilter(dict):
    def __init__(__self__, *,
                 end: Optional[builtins.str] = None,
                 start: Optional[builtins.str] = None):
        """
        :param builtins.str end: The latest timestamp the feature is enabled. The timestamp must be in RFC3339 format.
        :param builtins.str start: The earliest timestamp the feature is enabled. The timestamp must be in RFC3339 format.
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[builtins.str]:
        """
        The latest timestamp the feature is enabled. The timestamp must be in RFC3339 format.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def start(self) -> Optional[builtins.str]:
        """
        The earliest timestamp the feature is enabled. The timestamp must be in RFC3339 format.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class ConfigurationStoreEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityClientId":
            suggest = "identity_client_id"
        elif key == "keyVaultKeyIdentifier":
            suggest = "key_vault_key_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationStoreEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationStoreEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationStoreEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_client_id: Optional[builtins.str] = None,
                 key_vault_key_identifier: Optional[builtins.str] = None):
        """
        :param builtins.str identity_client_id: Specifies the client ID of the identity which will be used to access key vault.
        :param builtins.str key_vault_key_identifier: Specifies the URI of the key vault key used to encrypt data.
        """
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)
        if key_vault_key_identifier is not None:
            pulumi.set(__self__, "key_vault_key_identifier", key_vault_key_identifier)

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[builtins.str]:
        """
        Specifies the client ID of the identity which will be used to access key vault.
        """
        return pulumi.get(self, "identity_client_id")

    @property
    @pulumi.getter(name="keyVaultKeyIdentifier")
    def key_vault_key_identifier(self) -> Optional[builtins.str]:
        """
        Specifies the URI of the key vault key used to encrypt data.
        """
        return pulumi.get(self, "key_vault_key_identifier")


@pulumi.output_type
class ConfigurationStoreIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationStoreIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationStoreIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationStoreIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this App Configuration. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[builtins.str] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this App Configuration.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this App Configuration. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this App Configuration.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ConfigurationStorePrimaryReadKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationStorePrimaryReadKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationStorePrimaryReadKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationStorePrimaryReadKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 secret: Optional[builtins.str] = None):
        """
        :param builtins.str connection_string: The Connection String for this Access Key - consisting of the Endpoint, ID, and Secret.
        :param builtins.str id: The ID of the Access Key.
        :param builtins.str secret: The Secret of the Access Key.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[builtins.str]:
        """
        The Connection String for this Access Key - consisting of the Endpoint, ID, and Secret.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Access Key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def secret(self) -> Optional[builtins.str]:
        """
        The Secret of the Access Key.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class ConfigurationStorePrimaryWriteKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationStorePrimaryWriteKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationStorePrimaryWriteKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationStorePrimaryWriteKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 secret: Optional[builtins.str] = None):
        """
        :param builtins.str connection_string: The Connection String for this Access Key - consisting of the Endpoint, ID, and Secret.
        :param builtins.str id: The ID of the Access Key.
        :param builtins.str secret: The Secret of the Access Key.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[builtins.str]:
        """
        The Connection String for this Access Key - consisting of the Endpoint, ID, and Secret.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Access Key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def secret(self) -> Optional[builtins.str]:
        """
        The Secret of the Access Key.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class ConfigurationStoreReplica(dict):
    def __init__(__self__, *,
                 location: builtins.str,
                 name: builtins.str,
                 endpoint: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str location: Specifies the supported Azure location where the replica exists.
        :param builtins.str name: Specifies the name of the replica.
        :param builtins.str endpoint: The URL of the App Configuration Replica.
        :param builtins.str id: The ID of the Access Key.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Specifies the supported Azure location where the replica exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name of the replica.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[builtins.str]:
        """
        The URL of the App Configuration Replica.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Access Key.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ConfigurationStoreSecondaryReadKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationStoreSecondaryReadKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationStoreSecondaryReadKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationStoreSecondaryReadKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 secret: Optional[builtins.str] = None):
        """
        :param builtins.str connection_string: The Connection String for this Access Key - consisting of the Endpoint, ID, and Secret.
        :param builtins.str id: The ID of the Access Key.
        :param builtins.str secret: The Secret of the Access Key.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[builtins.str]:
        """
        The Connection String for this Access Key - consisting of the Endpoint, ID, and Secret.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Access Key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def secret(self) -> Optional[builtins.str]:
        """
        The Secret of the Access Key.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class ConfigurationStoreSecondaryWriteKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationStoreSecondaryWriteKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationStoreSecondaryWriteKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationStoreSecondaryWriteKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 secret: Optional[builtins.str] = None):
        """
        :param builtins.str connection_string: The Connection String for this Access Key - consisting of the Endpoint, ID, and Secret.
        :param builtins.str id: The ID of the Access Key.
        :param builtins.str secret: The Secret of the Access Key.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[builtins.str]:
        """
        The Connection String for this Access Key - consisting of the Endpoint, ID, and Secret.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Access Key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def secret(self) -> Optional[builtins.str]:
        """
        The Secret of the Access Key.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GetConfigurationKeysItemResult(dict):
    def __init__(__self__, *,
                 content_type: builtins.str,
                 etag: builtins.str,
                 key: builtins.str,
                 label: builtins.str,
                 locked: builtins.bool,
                 tags: Mapping[str, builtins.str],
                 type: builtins.str,
                 value: builtins.str,
                 vault_key_reference: builtins.str):
        """
        :param builtins.str content_type: The content type of the App Configuration Key.
        :param builtins.str etag: The ETag of the key.
        :param builtins.str key: The name of the App Configuration Keys to look up.
        :param builtins.str label: The label of the App Configuration Keys tp look up.
        :param builtins.bool locked: Is this App Configuration Key be Locked to prevent changes.
        :param Mapping[str, builtins.str] tags: A mapping of tags assigned to the resource.
        :param builtins.str type: The type of the App Configuration Key. It can either be `kv` (simple [key/value](https://docs.microsoft.com/azure/azure-app-configuration/concept-key-value)) or `vault` (where the value is a reference to a [Key Vault Secret](https://azure.microsoft.com/en-gb/services/key-vault/).
        :param builtins.str value: The value of the App Configuration Key.
        :param builtins.str vault_key_reference: The ID of the vault secret this App Configuration Key refers to, when `type` is `vault`.
        """
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "locked", locked)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "vault_key_reference", vault_key_reference)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> builtins.str:
        """
        The content type of the App Configuration Key.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        The ETag of the key.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The name of the App Configuration Keys to look up.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        The label of the App Configuration Keys tp look up.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def locked(self) -> builtins.bool:
        """
        Is this App Configuration Key be Locked to prevent changes.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the App Configuration Key. It can either be `kv` (simple [key/value](https://docs.microsoft.com/azure/azure-app-configuration/concept-key-value)) or `vault` (where the value is a reference to a [Key Vault Secret](https://azure.microsoft.com/en-gb/services/key-vault/).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the App Configuration Key.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vaultKeyReference")
    def vault_key_reference(self) -> builtins.str:
        """
        The ID of the vault secret this App Configuration Key refers to, when `type` is `vault`.
        """
        return pulumi.get(self, "vault_key_reference")


@pulumi.output_type
class GetConfigurationStoreEncryptionResult(dict):
    def __init__(__self__, *,
                 identity_client_id: builtins.str,
                 key_vault_key_identifier: builtins.str):
        pulumi.set(__self__, "identity_client_id", identity_client_id)
        pulumi.set(__self__, "key_vault_key_identifier", key_vault_key_identifier)

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> builtins.str:
        return pulumi.get(self, "identity_client_id")

    @property
    @pulumi.getter(name="keyVaultKeyIdentifier")
    def key_vault_key_identifier(self) -> builtins.str:
        return pulumi.get(self, "key_vault_key_identifier")


@pulumi.output_type
class GetConfigurationStoreIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetConfigurationStorePrimaryReadKeyResult(dict):
    def __init__(__self__, *,
                 connection_string: builtins.str,
                 id: builtins.str,
                 secret: builtins.str):
        """
        :param builtins.str connection_string: The Connection String for this Access Key - consisting of the Endpoint, ID and Secret.
        :param builtins.str id: The ID of the Access Key.
        :param builtins.str secret: The Secret of the Access Key.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> builtins.str:
        """
        The Connection String for this Access Key - consisting of the Endpoint, ID and Secret.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Access Key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def secret(self) -> builtins.str:
        """
        The Secret of the Access Key.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GetConfigurationStorePrimaryWriteKeyResult(dict):
    def __init__(__self__, *,
                 connection_string: builtins.str,
                 id: builtins.str,
                 secret: builtins.str):
        """
        :param builtins.str connection_string: The Connection String for this Access Key - consisting of the Endpoint, ID and Secret.
        :param builtins.str id: The ID of the Access Key.
        :param builtins.str secret: The Secret of the Access Key.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> builtins.str:
        """
        The Connection String for this Access Key - consisting of the Endpoint, ID and Secret.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Access Key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def secret(self) -> builtins.str:
        """
        The Secret of the Access Key.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GetConfigurationStoreReplicaResult(dict):
    def __init__(__self__, *,
                 endpoint: builtins.str,
                 id: builtins.str,
                 location: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str endpoint: The URL of the App Configuration Replica.
        :param builtins.str id: The ID of the Access Key.
        :param builtins.str location: The supported Azure location where the App Configuration Replica exists.
        :param builtins.str name: The Name of this App Configuration.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        The URL of the App Configuration Replica.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Access Key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The supported Azure location where the App Configuration Replica exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The Name of this App Configuration.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetConfigurationStoreSecondaryReadKeyResult(dict):
    def __init__(__self__, *,
                 connection_string: builtins.str,
                 id: builtins.str,
                 secret: builtins.str):
        """
        :param builtins.str connection_string: The Connection String for this Access Key - consisting of the Endpoint, ID and Secret.
        :param builtins.str id: The ID of the Access Key.
        :param builtins.str secret: The Secret of the Access Key.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> builtins.str:
        """
        The Connection String for this Access Key - consisting of the Endpoint, ID and Secret.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Access Key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def secret(self) -> builtins.str:
        """
        The Secret of the Access Key.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GetConfigurationStoreSecondaryWriteKeyResult(dict):
    def __init__(__self__, *,
                 connection_string: builtins.str,
                 id: builtins.str,
                 secret: builtins.str):
        """
        :param builtins.str connection_string: The Connection String for this Access Key - consisting of the Endpoint, ID and Secret.
        :param builtins.str id: The ID of the Access Key.
        :param builtins.str secret: The Secret of the Access Key.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> builtins.str:
        """
        The Connection String for this Access Key - consisting of the Endpoint, ID and Secret.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Access Key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def secret(self) -> builtins.str:
        """
        The Secret of the Access Key.
        """
        return pulumi.get(self, "secret")


