# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InsightsArgs', 'Insights']

@pulumi.input_type
class InsightsArgs:
    def __init__(__self__, *,
                 application_type: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 daily_data_cap_in_gb: Optional[pulumi.Input[builtins.float]] = None,
                 daily_data_cap_notifications_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_ip_masking: Optional[pulumi.Input[builtins.bool]] = None,
                 force_customer_storage_for_profiler: Optional[pulumi.Input[builtins.bool]] = None,
                 internet_ingestion_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 internet_query_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_authentication_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 sampling_percentage: Optional[pulumi.Input[builtins.float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Insights resource.
        :param pulumi.Input[builtins.str] application_type: Specifies the type of Application Insights to create. Valid values are `ios` for _iOS_, `java` for _Java web_, `MobileCenter` for _App Center_, `Node.JS` for _Node.js_, `other` for _General_, `phone` for _Windows Phone_, `store` for _Windows Store_ and `web` for _ASP.NET_. Please note these values are case sensitive; unmatched values are treated as _ASP.NET_ by Azure. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Application Insights component. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] daily_data_cap_in_gb: Specifies the Application Insights component daily data volume cap in GB. Defaults to `100`.
        :param pulumi.Input[builtins.bool] daily_data_cap_notifications_disabled: Specifies if a notification email will be sent when the daily data volume cap is met. Defaults to `false`.
        :param pulumi.Input[builtins.bool] disable_ip_masking: By default the real client IP is masked as `0.0.0.0` in the logs. Use this argument to disable masking and log the real client IP. Defaults to `false`.
        :param pulumi.Input[builtins.bool] force_customer_storage_for_profiler: Should the Application Insights component force users to create their own storage account for profiling? Defaults to `false`.
        :param pulumi.Input[builtins.bool] internet_ingestion_enabled: Should the Application Insights component support ingestion over the Public Internet? Defaults to `true`.
        :param pulumi.Input[builtins.bool] internet_query_enabled: Should the Application Insights component support querying over the Public Internet? Defaults to `true`.
        :param pulumi.Input[builtins.bool] local_authentication_disabled: Disable Non-Azure AD based Auth. Defaults to `false`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Application Insights component. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] retention_in_days: Specifies the retention period in days. Possible values are `30`, `60`, `90`, `120`, `180`, `270`, `365`, `550` or `730`. Defaults to `90`.
        :param pulumi.Input[builtins.float] sampling_percentage: Specifies the percentage of the data produced by the monitored application that is sampled for Application Insights telemetry. Defaults to `100`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] workspace_id: Specifies the id of a log analytics workspace resource.
               
               > **Note:** `workspace_id` cannot be removed after set. More details can be found at [Migrate to workspace-based Application Insights resources](https://docs.microsoft.com/azure/azure-monitor/app/convert-classic-resource#migration-process). If `workspace_id` is not specified but you encounter a diff, this might indicate a Microsoft initiated automatic migration from classic resources to workspace-based resources. If this is the case, please update `workspace_id` in the config file to the new value.
        """
        pulumi.set(__self__, "application_type", application_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if daily_data_cap_in_gb is not None:
            pulumi.set(__self__, "daily_data_cap_in_gb", daily_data_cap_in_gb)
        if daily_data_cap_notifications_disabled is not None:
            pulumi.set(__self__, "daily_data_cap_notifications_disabled", daily_data_cap_notifications_disabled)
        if disable_ip_masking is not None:
            pulumi.set(__self__, "disable_ip_masking", disable_ip_masking)
        if force_customer_storage_for_profiler is not None:
            pulumi.set(__self__, "force_customer_storage_for_profiler", force_customer_storage_for_profiler)
        if internet_ingestion_enabled is not None:
            pulumi.set(__self__, "internet_ingestion_enabled", internet_ingestion_enabled)
        if internet_query_enabled is not None:
            pulumi.set(__self__, "internet_query_enabled", internet_query_enabled)
        if local_authentication_disabled is not None:
            pulumi.set(__self__, "local_authentication_disabled", local_authentication_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if sampling_percentage is not None:
            pulumi.set(__self__, "sampling_percentage", sampling_percentage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of Application Insights to create. Valid values are `ios` for _iOS_, `java` for _Java web_, `MobileCenter` for _App Center_, `Node.JS` for _Node.js_, `other` for _General_, `phone` for _Windows Phone_, `store` for _Windows Store_ and `web` for _ASP.NET_. Please note these values are case sensitive; unmatched values are treated as _ASP.NET_ by Azure. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_type")

    @application_type.setter
    def application_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_type", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the Application Insights component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="dailyDataCapInGb")
    def daily_data_cap_in_gb(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Specifies the Application Insights component daily data volume cap in GB. Defaults to `100`.
        """
        return pulumi.get(self, "daily_data_cap_in_gb")

    @daily_data_cap_in_gb.setter
    def daily_data_cap_in_gb(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "daily_data_cap_in_gb", value)

    @property
    @pulumi.getter(name="dailyDataCapNotificationsDisabled")
    def daily_data_cap_notifications_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if a notification email will be sent when the daily data volume cap is met. Defaults to `false`.
        """
        return pulumi.get(self, "daily_data_cap_notifications_disabled")

    @daily_data_cap_notifications_disabled.setter
    def daily_data_cap_notifications_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "daily_data_cap_notifications_disabled", value)

    @property
    @pulumi.getter(name="disableIpMasking")
    def disable_ip_masking(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        By default the real client IP is masked as `0.0.0.0` in the logs. Use this argument to disable masking and log the real client IP. Defaults to `false`.
        """
        return pulumi.get(self, "disable_ip_masking")

    @disable_ip_masking.setter
    def disable_ip_masking(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_ip_masking", value)

    @property
    @pulumi.getter(name="forceCustomerStorageForProfiler")
    def force_customer_storage_for_profiler(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Application Insights component force users to create their own storage account for profiling? Defaults to `false`.
        """
        return pulumi.get(self, "force_customer_storage_for_profiler")

    @force_customer_storage_for_profiler.setter
    def force_customer_storage_for_profiler(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_customer_storage_for_profiler", value)

    @property
    @pulumi.getter(name="internetIngestionEnabled")
    def internet_ingestion_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Application Insights component support ingestion over the Public Internet? Defaults to `true`.
        """
        return pulumi.get(self, "internet_ingestion_enabled")

    @internet_ingestion_enabled.setter
    def internet_ingestion_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "internet_ingestion_enabled", value)

    @property
    @pulumi.getter(name="internetQueryEnabled")
    def internet_query_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Application Insights component support querying over the Public Internet? Defaults to `true`.
        """
        return pulumi.get(self, "internet_query_enabled")

    @internet_query_enabled.setter
    def internet_query_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "internet_query_enabled", value)

    @property
    @pulumi.getter(name="localAuthenticationDisabled")
    def local_authentication_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disable Non-Azure AD based Auth. Defaults to `false`.
        """
        return pulumi.get(self, "local_authentication_disabled")

    @local_authentication_disabled.setter
    def local_authentication_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_authentication_disabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Application Insights component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the retention period in days. Possible values are `30`, `60`, `90`, `120`, `180`, `270`, `365`, `550` or `730`. Defaults to `90`.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Specifies the percentage of the data produced by the monitored application that is sampled for Application Insights telemetry. Defaults to `100`.
        """
        return pulumi.get(self, "sampling_percentage")

    @sampling_percentage.setter
    def sampling_percentage(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "sampling_percentage", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the id of a log analytics workspace resource.

        > **Note:** `workspace_id` cannot be removed after set. More details can be found at [Migrate to workspace-based Application Insights resources](https://docs.microsoft.com/azure/azure-monitor/app/convert-classic-resource#migration-process). If `workspace_id` is not specified but you encounter a diff, this might indicate a Microsoft initiated automatic migration from classic resources to workspace-based resources. If this is the case, please update `workspace_id` in the config file to the new value.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _InsightsState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 application_type: Optional[pulumi.Input[builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 daily_data_cap_in_gb: Optional[pulumi.Input[builtins.float]] = None,
                 daily_data_cap_notifications_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_ip_masking: Optional[pulumi.Input[builtins.bool]] = None,
                 force_customer_storage_for_profiler: Optional[pulumi.Input[builtins.bool]] = None,
                 instrumentation_key: Optional[pulumi.Input[builtins.str]] = None,
                 internet_ingestion_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 internet_query_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_authentication_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 sampling_percentage: Optional[pulumi.Input[builtins.float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Insights resources.
        :param pulumi.Input[builtins.str] app_id: The App ID associated with this Application Insights component.
        :param pulumi.Input[builtins.str] application_type: Specifies the type of Application Insights to create. Valid values are `ios` for _iOS_, `java` for _Java web_, `MobileCenter` for _App Center_, `Node.JS` for _Node.js_, `other` for _General_, `phone` for _Windows Phone_, `store` for _Windows Store_ and `web` for _ASP.NET_. Please note these values are case sensitive; unmatched values are treated as _ASP.NET_ by Azure. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] connection_string: The Connection String for this Application Insights component. (Sensitive)
        :param pulumi.Input[builtins.float] daily_data_cap_in_gb: Specifies the Application Insights component daily data volume cap in GB. Defaults to `100`.
        :param pulumi.Input[builtins.bool] daily_data_cap_notifications_disabled: Specifies if a notification email will be sent when the daily data volume cap is met. Defaults to `false`.
        :param pulumi.Input[builtins.bool] disable_ip_masking: By default the real client IP is masked as `0.0.0.0` in the logs. Use this argument to disable masking and log the real client IP. Defaults to `false`.
        :param pulumi.Input[builtins.bool] force_customer_storage_for_profiler: Should the Application Insights component force users to create their own storage account for profiling? Defaults to `false`.
        :param pulumi.Input[builtins.str] instrumentation_key: The Instrumentation Key for this Application Insights component. (Sensitive)
        :param pulumi.Input[builtins.bool] internet_ingestion_enabled: Should the Application Insights component support ingestion over the Public Internet? Defaults to `true`.
        :param pulumi.Input[builtins.bool] internet_query_enabled: Should the Application Insights component support querying over the Public Internet? Defaults to `true`.
        :param pulumi.Input[builtins.bool] local_authentication_disabled: Disable Non-Azure AD based Auth. Defaults to `false`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Application Insights component. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Application Insights component. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] retention_in_days: Specifies the retention period in days. Possible values are `30`, `60`, `90`, `120`, `180`, `270`, `365`, `550` or `730`. Defaults to `90`.
        :param pulumi.Input[builtins.float] sampling_percentage: Specifies the percentage of the data produced by the monitored application that is sampled for Application Insights telemetry. Defaults to `100`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] workspace_id: Specifies the id of a log analytics workspace resource.
               
               > **Note:** `workspace_id` cannot be removed after set. More details can be found at [Migrate to workspace-based Application Insights resources](https://docs.microsoft.com/azure/azure-monitor/app/convert-classic-resource#migration-process). If `workspace_id` is not specified but you encounter a diff, this might indicate a Microsoft initiated automatic migration from classic resources to workspace-based resources. If this is the case, please update `workspace_id` in the config file to the new value.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if application_type is not None:
            pulumi.set(__self__, "application_type", application_type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if daily_data_cap_in_gb is not None:
            pulumi.set(__self__, "daily_data_cap_in_gb", daily_data_cap_in_gb)
        if daily_data_cap_notifications_disabled is not None:
            pulumi.set(__self__, "daily_data_cap_notifications_disabled", daily_data_cap_notifications_disabled)
        if disable_ip_masking is not None:
            pulumi.set(__self__, "disable_ip_masking", disable_ip_masking)
        if force_customer_storage_for_profiler is not None:
            pulumi.set(__self__, "force_customer_storage_for_profiler", force_customer_storage_for_profiler)
        if instrumentation_key is not None:
            pulumi.set(__self__, "instrumentation_key", instrumentation_key)
        if internet_ingestion_enabled is not None:
            pulumi.set(__self__, "internet_ingestion_enabled", internet_ingestion_enabled)
        if internet_query_enabled is not None:
            pulumi.set(__self__, "internet_query_enabled", internet_query_enabled)
        if local_authentication_disabled is not None:
            pulumi.set(__self__, "local_authentication_disabled", local_authentication_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if sampling_percentage is not None:
            pulumi.set(__self__, "sampling_percentage", sampling_percentage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The App ID associated with this Application Insights component.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of Application Insights to create. Valid values are `ios` for _iOS_, `java` for _Java web_, `MobileCenter` for _App Center_, `Node.JS` for _Node.js_, `other` for _General_, `phone` for _Windows Phone_, `store` for _Windows Store_ and `web` for _ASP.NET_. Please note these values are case sensitive; unmatched values are treated as _ASP.NET_ by Azure. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_type")

    @application_type.setter
    def application_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_type", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Connection String for this Application Insights component. (Sensitive)
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="dailyDataCapInGb")
    def daily_data_cap_in_gb(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Specifies the Application Insights component daily data volume cap in GB. Defaults to `100`.
        """
        return pulumi.get(self, "daily_data_cap_in_gb")

    @daily_data_cap_in_gb.setter
    def daily_data_cap_in_gb(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "daily_data_cap_in_gb", value)

    @property
    @pulumi.getter(name="dailyDataCapNotificationsDisabled")
    def daily_data_cap_notifications_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if a notification email will be sent when the daily data volume cap is met. Defaults to `false`.
        """
        return pulumi.get(self, "daily_data_cap_notifications_disabled")

    @daily_data_cap_notifications_disabled.setter
    def daily_data_cap_notifications_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "daily_data_cap_notifications_disabled", value)

    @property
    @pulumi.getter(name="disableIpMasking")
    def disable_ip_masking(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        By default the real client IP is masked as `0.0.0.0` in the logs. Use this argument to disable masking and log the real client IP. Defaults to `false`.
        """
        return pulumi.get(self, "disable_ip_masking")

    @disable_ip_masking.setter
    def disable_ip_masking(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_ip_masking", value)

    @property
    @pulumi.getter(name="forceCustomerStorageForProfiler")
    def force_customer_storage_for_profiler(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Application Insights component force users to create their own storage account for profiling? Defaults to `false`.
        """
        return pulumi.get(self, "force_customer_storage_for_profiler")

    @force_customer_storage_for_profiler.setter
    def force_customer_storage_for_profiler(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_customer_storage_for_profiler", value)

    @property
    @pulumi.getter(name="instrumentationKey")
    def instrumentation_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Instrumentation Key for this Application Insights component. (Sensitive)
        """
        return pulumi.get(self, "instrumentation_key")

    @instrumentation_key.setter
    def instrumentation_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instrumentation_key", value)

    @property
    @pulumi.getter(name="internetIngestionEnabled")
    def internet_ingestion_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Application Insights component support ingestion over the Public Internet? Defaults to `true`.
        """
        return pulumi.get(self, "internet_ingestion_enabled")

    @internet_ingestion_enabled.setter
    def internet_ingestion_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "internet_ingestion_enabled", value)

    @property
    @pulumi.getter(name="internetQueryEnabled")
    def internet_query_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Application Insights component support querying over the Public Internet? Defaults to `true`.
        """
        return pulumi.get(self, "internet_query_enabled")

    @internet_query_enabled.setter
    def internet_query_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "internet_query_enabled", value)

    @property
    @pulumi.getter(name="localAuthenticationDisabled")
    def local_authentication_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disable Non-Azure AD based Auth. Defaults to `false`.
        """
        return pulumi.get(self, "local_authentication_disabled")

    @local_authentication_disabled.setter
    def local_authentication_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_authentication_disabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Application Insights component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the Application Insights component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the retention period in days. Possible values are `30`, `60`, `90`, `120`, `180`, `270`, `365`, `550` or `730`. Defaults to `90`.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Specifies the percentage of the data produced by the monitored application that is sampled for Application Insights telemetry. Defaults to `100`.
        """
        return pulumi.get(self, "sampling_percentage")

    @sampling_percentage.setter
    def sampling_percentage(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "sampling_percentage", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the id of a log analytics workspace resource.

        > **Note:** `workspace_id` cannot be removed after set. More details can be found at [Migrate to workspace-based Application Insights resources](https://docs.microsoft.com/azure/azure-monitor/app/convert-classic-resource#migration-process). If `workspace_id` is not specified but you encounter a diff, this might indicate a Microsoft initiated automatic migration from classic resources to workspace-based resources. If this is the case, please update `workspace_id` in the config file to the new value.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:appinsights/insights:Insights")
class Insights(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_type: Optional[pulumi.Input[builtins.str]] = None,
                 daily_data_cap_in_gb: Optional[pulumi.Input[builtins.float]] = None,
                 daily_data_cap_notifications_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_ip_masking: Optional[pulumi.Input[builtins.bool]] = None,
                 force_customer_storage_for_profiler: Optional[pulumi.Input[builtins.bool]] = None,
                 internet_ingestion_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 internet_query_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_authentication_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 sampling_percentage: Optional[pulumi.Input[builtins.float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Application Insights component.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tf-test",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="tf-test-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        pulumi.export("instrumentationKey", example_insights.instrumentation_key)
        pulumi.export("appId", example_insights.app_id)
        ```

        ### Workspace Mode

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tf-test",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="workspace-test",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_insights = azure.appinsights.Insights("example",
            name="tf-test-appinsights",
            location=example.location,
            resource_group_name=example.name,
            workspace_id=example_analytics_workspace.id,
            application_type="web")
        pulumi.export("instrumentationKey", example_insights.instrumentation_key)
        pulumi.export("appId", example_insights.app_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AlertsManagement`: 2019-06-01

        * `Microsoft.Insights`: 2020-02-02, 2015-05-01

        ## Import

        Application Insights instances can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appinsights/insights:Insights instance1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Insights/components/instance1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_type: Specifies the type of Application Insights to create. Valid values are `ios` for _iOS_, `java` for _Java web_, `MobileCenter` for _App Center_, `Node.JS` for _Node.js_, `other` for _General_, `phone` for _Windows Phone_, `store` for _Windows Store_ and `web` for _ASP.NET_. Please note these values are case sensitive; unmatched values are treated as _ASP.NET_ by Azure. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.float] daily_data_cap_in_gb: Specifies the Application Insights component daily data volume cap in GB. Defaults to `100`.
        :param pulumi.Input[builtins.bool] daily_data_cap_notifications_disabled: Specifies if a notification email will be sent when the daily data volume cap is met. Defaults to `false`.
        :param pulumi.Input[builtins.bool] disable_ip_masking: By default the real client IP is masked as `0.0.0.0` in the logs. Use this argument to disable masking and log the real client IP. Defaults to `false`.
        :param pulumi.Input[builtins.bool] force_customer_storage_for_profiler: Should the Application Insights component force users to create their own storage account for profiling? Defaults to `false`.
        :param pulumi.Input[builtins.bool] internet_ingestion_enabled: Should the Application Insights component support ingestion over the Public Internet? Defaults to `true`.
        :param pulumi.Input[builtins.bool] internet_query_enabled: Should the Application Insights component support querying over the Public Internet? Defaults to `true`.
        :param pulumi.Input[builtins.bool] local_authentication_disabled: Disable Non-Azure AD based Auth. Defaults to `false`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Application Insights component. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Application Insights component. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] retention_in_days: Specifies the retention period in days. Possible values are `30`, `60`, `90`, `120`, `180`, `270`, `365`, `550` or `730`. Defaults to `90`.
        :param pulumi.Input[builtins.float] sampling_percentage: Specifies the percentage of the data produced by the monitored application that is sampled for Application Insights telemetry. Defaults to `100`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] workspace_id: Specifies the id of a log analytics workspace resource.
               
               > **Note:** `workspace_id` cannot be removed after set. More details can be found at [Migrate to workspace-based Application Insights resources](https://docs.microsoft.com/azure/azure-monitor/app/convert-classic-resource#migration-process). If `workspace_id` is not specified but you encounter a diff, this might indicate a Microsoft initiated automatic migration from classic resources to workspace-based resources. If this is the case, please update `workspace_id` in the config file to the new value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InsightsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Application Insights component.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tf-test",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="tf-test-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        pulumi.export("instrumentationKey", example_insights.instrumentation_key)
        pulumi.export("appId", example_insights.app_id)
        ```

        ### Workspace Mode

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tf-test",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="workspace-test",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_insights = azure.appinsights.Insights("example",
            name="tf-test-appinsights",
            location=example.location,
            resource_group_name=example.name,
            workspace_id=example_analytics_workspace.id,
            application_type="web")
        pulumi.export("instrumentationKey", example_insights.instrumentation_key)
        pulumi.export("appId", example_insights.app_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AlertsManagement`: 2019-06-01

        * `Microsoft.Insights`: 2020-02-02, 2015-05-01

        ## Import

        Application Insights instances can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appinsights/insights:Insights instance1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Insights/components/instance1
        ```

        :param str resource_name: The name of the resource.
        :param InsightsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InsightsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_type: Optional[pulumi.Input[builtins.str]] = None,
                 daily_data_cap_in_gb: Optional[pulumi.Input[builtins.float]] = None,
                 daily_data_cap_notifications_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_ip_masking: Optional[pulumi.Input[builtins.bool]] = None,
                 force_customer_storage_for_profiler: Optional[pulumi.Input[builtins.bool]] = None,
                 internet_ingestion_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 internet_query_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_authentication_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 sampling_percentage: Optional[pulumi.Input[builtins.float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InsightsArgs.__new__(InsightsArgs)

            if application_type is None and not opts.urn:
                raise TypeError("Missing required property 'application_type'")
            __props__.__dict__["application_type"] = application_type
            __props__.__dict__["daily_data_cap_in_gb"] = daily_data_cap_in_gb
            __props__.__dict__["daily_data_cap_notifications_disabled"] = daily_data_cap_notifications_disabled
            __props__.__dict__["disable_ip_masking"] = disable_ip_masking
            __props__.__dict__["force_customer_storage_for_profiler"] = force_customer_storage_for_profiler
            __props__.__dict__["internet_ingestion_enabled"] = internet_ingestion_enabled
            __props__.__dict__["internet_query_enabled"] = internet_query_enabled
            __props__.__dict__["local_authentication_disabled"] = local_authentication_disabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["retention_in_days"] = retention_in_days
            __props__.__dict__["sampling_percentage"] = sampling_percentage
            __props__.__dict__["tags"] = tags
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["app_id"] = None
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["instrumentation_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["connectionString", "instrumentationKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Insights, __self__).__init__(
            'azure:appinsights/insights:Insights',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[builtins.str]] = None,
            application_type: Optional[pulumi.Input[builtins.str]] = None,
            connection_string: Optional[pulumi.Input[builtins.str]] = None,
            daily_data_cap_in_gb: Optional[pulumi.Input[builtins.float]] = None,
            daily_data_cap_notifications_disabled: Optional[pulumi.Input[builtins.bool]] = None,
            disable_ip_masking: Optional[pulumi.Input[builtins.bool]] = None,
            force_customer_storage_for_profiler: Optional[pulumi.Input[builtins.bool]] = None,
            instrumentation_key: Optional[pulumi.Input[builtins.str]] = None,
            internet_ingestion_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            internet_query_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            local_authentication_disabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            retention_in_days: Optional[pulumi.Input[builtins.int]] = None,
            sampling_percentage: Optional[pulumi.Input[builtins.float]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            workspace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Insights':
        """
        Get an existing Insights resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_id: The App ID associated with this Application Insights component.
        :param pulumi.Input[builtins.str] application_type: Specifies the type of Application Insights to create. Valid values are `ios` for _iOS_, `java` for _Java web_, `MobileCenter` for _App Center_, `Node.JS` for _Node.js_, `other` for _General_, `phone` for _Windows Phone_, `store` for _Windows Store_ and `web` for _ASP.NET_. Please note these values are case sensitive; unmatched values are treated as _ASP.NET_ by Azure. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] connection_string: The Connection String for this Application Insights component. (Sensitive)
        :param pulumi.Input[builtins.float] daily_data_cap_in_gb: Specifies the Application Insights component daily data volume cap in GB. Defaults to `100`.
        :param pulumi.Input[builtins.bool] daily_data_cap_notifications_disabled: Specifies if a notification email will be sent when the daily data volume cap is met. Defaults to `false`.
        :param pulumi.Input[builtins.bool] disable_ip_masking: By default the real client IP is masked as `0.0.0.0` in the logs. Use this argument to disable masking and log the real client IP. Defaults to `false`.
        :param pulumi.Input[builtins.bool] force_customer_storage_for_profiler: Should the Application Insights component force users to create their own storage account for profiling? Defaults to `false`.
        :param pulumi.Input[builtins.str] instrumentation_key: The Instrumentation Key for this Application Insights component. (Sensitive)
        :param pulumi.Input[builtins.bool] internet_ingestion_enabled: Should the Application Insights component support ingestion over the Public Internet? Defaults to `true`.
        :param pulumi.Input[builtins.bool] internet_query_enabled: Should the Application Insights component support querying over the Public Internet? Defaults to `true`.
        :param pulumi.Input[builtins.bool] local_authentication_disabled: Disable Non-Azure AD based Auth. Defaults to `false`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Application Insights component. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Application Insights component. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] retention_in_days: Specifies the retention period in days. Possible values are `30`, `60`, `90`, `120`, `180`, `270`, `365`, `550` or `730`. Defaults to `90`.
        :param pulumi.Input[builtins.float] sampling_percentage: Specifies the percentage of the data produced by the monitored application that is sampled for Application Insights telemetry. Defaults to `100`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] workspace_id: Specifies the id of a log analytics workspace resource.
               
               > **Note:** `workspace_id` cannot be removed after set. More details can be found at [Migrate to workspace-based Application Insights resources](https://docs.microsoft.com/azure/azure-monitor/app/convert-classic-resource#migration-process). If `workspace_id` is not specified but you encounter a diff, this might indicate a Microsoft initiated automatic migration from classic resources to workspace-based resources. If this is the case, please update `workspace_id` in the config file to the new value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InsightsState.__new__(_InsightsState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["application_type"] = application_type
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["daily_data_cap_in_gb"] = daily_data_cap_in_gb
        __props__.__dict__["daily_data_cap_notifications_disabled"] = daily_data_cap_notifications_disabled
        __props__.__dict__["disable_ip_masking"] = disable_ip_masking
        __props__.__dict__["force_customer_storage_for_profiler"] = force_customer_storage_for_profiler
        __props__.__dict__["instrumentation_key"] = instrumentation_key
        __props__.__dict__["internet_ingestion_enabled"] = internet_ingestion_enabled
        __props__.__dict__["internet_query_enabled"] = internet_query_enabled
        __props__.__dict__["local_authentication_disabled"] = local_authentication_disabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["retention_in_days"] = retention_in_days
        __props__.__dict__["sampling_percentage"] = sampling_percentage
        __props__.__dict__["tags"] = tags
        __props__.__dict__["workspace_id"] = workspace_id
        return Insights(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[builtins.str]:
        """
        The App ID associated with this Application Insights component.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the type of Application Insights to create. Valid values are `ios` for _iOS_, `java` for _Java web_, `MobileCenter` for _App Center_, `Node.JS` for _Node.js_, `other` for _General_, `phone` for _Windows Phone_, `store` for _Windows Store_ and `web` for _ASP.NET_. Please note these values are case sensitive; unmatched values are treated as _ASP.NET_ by Azure. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_type")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The Connection String for this Application Insights component. (Sensitive)
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="dailyDataCapInGb")
    def daily_data_cap_in_gb(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        Specifies the Application Insights component daily data volume cap in GB. Defaults to `100`.
        """
        return pulumi.get(self, "daily_data_cap_in_gb")

    @property
    @pulumi.getter(name="dailyDataCapNotificationsDisabled")
    def daily_data_cap_notifications_disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies if a notification email will be sent when the daily data volume cap is met. Defaults to `false`.
        """
        return pulumi.get(self, "daily_data_cap_notifications_disabled")

    @property
    @pulumi.getter(name="disableIpMasking")
    def disable_ip_masking(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        By default the real client IP is masked as `0.0.0.0` in the logs. Use this argument to disable masking and log the real client IP. Defaults to `false`.
        """
        return pulumi.get(self, "disable_ip_masking")

    @property
    @pulumi.getter(name="forceCustomerStorageForProfiler")
    def force_customer_storage_for_profiler(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the Application Insights component force users to create their own storage account for profiling? Defaults to `false`.
        """
        return pulumi.get(self, "force_customer_storage_for_profiler")

    @property
    @pulumi.getter(name="instrumentationKey")
    def instrumentation_key(self) -> pulumi.Output[builtins.str]:
        """
        The Instrumentation Key for this Application Insights component. (Sensitive)
        """
        return pulumi.get(self, "instrumentation_key")

    @property
    @pulumi.getter(name="internetIngestionEnabled")
    def internet_ingestion_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the Application Insights component support ingestion over the Public Internet? Defaults to `true`.
        """
        return pulumi.get(self, "internet_ingestion_enabled")

    @property
    @pulumi.getter(name="internetQueryEnabled")
    def internet_query_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the Application Insights component support querying over the Public Internet? Defaults to `true`.
        """
        return pulumi.get(self, "internet_query_enabled")

    @property
    @pulumi.getter(name="localAuthenticationDisabled")
    def local_authentication_disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Disable Non-Azure AD based Auth. Defaults to `false`.
        """
        return pulumi.get(self, "local_authentication_disabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Application Insights component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the Application Insights component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the retention period in days. Possible values are `30`, `60`, `90`, `120`, `180`, `270`, `365`, `550` or `730`. Defaults to `90`.
        """
        return pulumi.get(self, "retention_in_days")

    @property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        Specifies the percentage of the data produced by the monitored application that is sampled for Application Insights telemetry. Defaults to `100`.
        """
        return pulumi.get(self, "sampling_percentage")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the id of a log analytics workspace resource.

        > **Note:** `workspace_id` cannot be removed after set. More details can be found at [Migrate to workspace-based Application Insights resources](https://docs.microsoft.com/azure/azure-monitor/app/convert-classic-resource#migration-process). If `workspace_id` is not specified but you encounter a diff, this might indicate a Microsoft initiated automatic migration from classic resources to workspace-based resources. If this is the case, please update `workspace_id` in the config file to the new value.
        """
        return pulumi.get(self, "workspace_id")

