# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'StandardWebTestRequest',
    'StandardWebTestRequestHeader',
    'StandardWebTestValidationRules',
    'StandardWebTestValidationRulesContent',
    'WorkbookIdentity',
    'WorkbookTemplateGallery',
]

@pulumi.output_type
class StandardWebTestRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "followRedirectsEnabled":
            suggest = "follow_redirects_enabled"
        elif key == "httpVerb":
            suggest = "http_verb"
        elif key == "parseDependentRequestsEnabled":
            suggest = "parse_dependent_requests_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardWebTestRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardWebTestRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardWebTestRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 body: Optional[builtins.str] = None,
                 follow_redirects_enabled: Optional[builtins.bool] = None,
                 headers: Optional[Sequence['outputs.StandardWebTestRequestHeader']] = None,
                 http_verb: Optional[builtins.str] = None,
                 parse_dependent_requests_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str url: The WebTest request URL.
        :param builtins.str body: The WebTest request body.
        :param builtins.bool follow_redirects_enabled: Should the following of redirects be enabled? Defaults to `true`.
        :param Sequence['StandardWebTestRequestHeaderArgs'] headers: One or more `header` blocks as defined above.
        :param builtins.str http_verb: Which HTTP verb to use for the call. Options are 'GET', 'POST', 'PUT', 'PATCH', 'DELETE', 'HEAD', and 'OPTIONS'. Defaults to `GET`.
        :param builtins.bool parse_dependent_requests_enabled: Should the parsing of dependend requests be enabled? Defaults to `true`.
        """
        pulumi.set(__self__, "url", url)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if follow_redirects_enabled is not None:
            pulumi.set(__self__, "follow_redirects_enabled", follow_redirects_enabled)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if http_verb is not None:
            pulumi.set(__self__, "http_verb", http_verb)
        if parse_dependent_requests_enabled is not None:
            pulumi.set(__self__, "parse_dependent_requests_enabled", parse_dependent_requests_enabled)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The WebTest request URL.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def body(self) -> Optional[builtins.str]:
        """
        The WebTest request body.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="followRedirectsEnabled")
    def follow_redirects_enabled(self) -> Optional[builtins.bool]:
        """
        Should the following of redirects be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "follow_redirects_enabled")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.StandardWebTestRequestHeader']]:
        """
        One or more `header` blocks as defined above.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="httpVerb")
    def http_verb(self) -> Optional[builtins.str]:
        """
        Which HTTP verb to use for the call. Options are 'GET', 'POST', 'PUT', 'PATCH', 'DELETE', 'HEAD', and 'OPTIONS'. Defaults to `GET`.
        """
        return pulumi.get(self, "http_verb")

    @property
    @pulumi.getter(name="parseDependentRequestsEnabled")
    def parse_dependent_requests_enabled(self) -> Optional[builtins.bool]:
        """
        Should the parsing of dependend requests be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "parse_dependent_requests_enabled")


@pulumi.output_type
class StandardWebTestRequestHeader(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name which should be used for a header in the request.
        :param builtins.str value: The value which should be used for a header in the request.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name which should be used for a header in the request.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value which should be used for a header in the request.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class StandardWebTestValidationRules(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectedStatusCode":
            suggest = "expected_status_code"
        elif key == "sslCertRemainingLifetime":
            suggest = "ssl_cert_remaining_lifetime"
        elif key == "sslCheckEnabled":
            suggest = "ssl_check_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardWebTestValidationRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardWebTestValidationRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardWebTestValidationRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: Optional['outputs.StandardWebTestValidationRulesContent'] = None,
                 expected_status_code: Optional[builtins.int] = None,
                 ssl_cert_remaining_lifetime: Optional[builtins.int] = None,
                 ssl_check_enabled: Optional[builtins.bool] = None):
        """
        :param 'StandardWebTestValidationRulesContentArgs' content: A `content` block as defined above.
        :param builtins.int expected_status_code: The expected status code of the response. Default is '200', '0' means 'response code < 400'
        :param builtins.int ssl_cert_remaining_lifetime: The number of days of SSL certificate validity remaining for the checked endpoint. If the certificate has a shorter remaining lifetime left, the test will fail. This number should be between 1 and 365.
        :param builtins.bool ssl_check_enabled: Should the SSL check be enabled?
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if expected_status_code is not None:
            pulumi.set(__self__, "expected_status_code", expected_status_code)
        if ssl_cert_remaining_lifetime is not None:
            pulumi.set(__self__, "ssl_cert_remaining_lifetime", ssl_cert_remaining_lifetime)
        if ssl_check_enabled is not None:
            pulumi.set(__self__, "ssl_check_enabled", ssl_check_enabled)

    @property
    @pulumi.getter
    def content(self) -> Optional['outputs.StandardWebTestValidationRulesContent']:
        """
        A `content` block as defined above.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="expectedStatusCode")
    def expected_status_code(self) -> Optional[builtins.int]:
        """
        The expected status code of the response. Default is '200', '0' means 'response code < 400'
        """
        return pulumi.get(self, "expected_status_code")

    @property
    @pulumi.getter(name="sslCertRemainingLifetime")
    def ssl_cert_remaining_lifetime(self) -> Optional[builtins.int]:
        """
        The number of days of SSL certificate validity remaining for the checked endpoint. If the certificate has a shorter remaining lifetime left, the test will fail. This number should be between 1 and 365.
        """
        return pulumi.get(self, "ssl_cert_remaining_lifetime")

    @property
    @pulumi.getter(name="sslCheckEnabled")
    def ssl_check_enabled(self) -> Optional[builtins.bool]:
        """
        Should the SSL check be enabled?
        """
        return pulumi.get(self, "ssl_check_enabled")


@pulumi.output_type
class StandardWebTestValidationRulesContent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentMatch":
            suggest = "content_match"
        elif key == "ignoreCase":
            suggest = "ignore_case"
        elif key == "passIfTextFound":
            suggest = "pass_if_text_found"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardWebTestValidationRulesContent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardWebTestValidationRulesContent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardWebTestValidationRulesContent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_match: builtins.str,
                 ignore_case: Optional[builtins.bool] = None,
                 pass_if_text_found: Optional[builtins.bool] = None):
        """
        :param builtins.str content_match: A string value containing the content to match on.
        :param builtins.bool ignore_case: Ignore the casing in the `content_match` value.
        :param builtins.bool pass_if_text_found: If the content of `content_match` is found, pass the test. If set to `false`, the WebTest is failing if the content of `content_match` is found.
        """
        pulumi.set(__self__, "content_match", content_match)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if pass_if_text_found is not None:
            pulumi.set(__self__, "pass_if_text_found", pass_if_text_found)

    @property
    @pulumi.getter(name="contentMatch")
    def content_match(self) -> builtins.str:
        """
        A string value containing the content to match on.
        """
        return pulumi.get(self, "content_match")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        Ignore the casing in the `content_match` value.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter(name="passIfTextFound")
    def pass_if_text_found(self) -> Optional[builtins.bool]:
        """
        If the content of `content_match` is found, pass the test. If set to `false`, the WebTest is failing if the content of `content_match` is found.
        """
        return pulumi.get(self, "pass_if_text_found")


@pulumi.output_type
class WorkbookIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkbookIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkbookIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkbookIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of Managed Service Identity that is configured on this Workbook. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`. Changing this forces a new resource to be created.
        :param Sequence[builtins.str] identity_ids: The list of User Assigned Managed Identity IDs assigned to this Workbook. Changing this forces a new resource to be created.
        :param builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Workbook.
        :param builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Workbook.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of Managed Service Identity that is configured on this Workbook. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of User Assigned Managed Identity IDs assigned to this Workbook. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Workbook.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Workbook.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class WorkbookTemplateGallery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkbookTemplateGallery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkbookTemplateGallery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkbookTemplateGallery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: builtins.str,
                 name: builtins.str,
                 order: Optional[builtins.int] = None,
                 resource_type: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str category: Category for the gallery.
        :param builtins.str name: Name of the workbook template in the gallery.
        :param builtins.int order: Order of the template within the gallery. Defaults to `0`.
        :param builtins.str resource_type: Azure resource type supported by the gallery. Defaults to `Azure Monitor`.
        :param builtins.str type: Type of workbook supported by the workbook template. Defaults to `workbook`.
               
               > **Note:** See [documentation](https://docs.microsoft.com/en-us/azure/azure-monitor/visualize/workbooks-automate#galleries) for more information of `resource_type` and `type`.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "name", name)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def category(self) -> builtins.str:
        """
        Category for the gallery.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the workbook template in the gallery.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def order(self) -> Optional[builtins.int]:
        """
        Order of the template within the gallery. Defaults to `0`.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[builtins.str]:
        """
        Azure resource type supported by the gallery. Defaults to `Azure Monitor`.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Type of workbook supported by the workbook template. Defaults to `workbook`.

        > **Note:** See [documentation](https://docs.microsoft.com/en-us/azure/azure-monitor/visualize/workbooks-automate#galleries) for more information of `resource_type` and `type`.
        """
        return pulumi.get(self, "type")


