# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkbookTemplateArgs', 'WorkbookTemplate']

@pulumi.input_type
class WorkbookTemplateArgs:
    def __init__(__self__, *,
                 galleries: pulumi.Input[Sequence[pulumi.Input['WorkbookTemplateGalleryArgs']]],
                 resource_group_name: pulumi.Input[builtins.str],
                 template_data: pulumi.Input[builtins.str],
                 author: Optional[pulumi.Input[builtins.str]] = None,
                 localized: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a WorkbookTemplate resource.
        :param pulumi.Input[Sequence[pulumi.Input['WorkbookTemplateGalleryArgs']]] galleries: A `galleries` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        :param pulumi.Input[builtins.str] template_data: Valid JSON object containing workbook template payload.
        :param pulumi.Input[builtins.str] author: Information about the author of the workbook template.
        :param pulumi.Input[builtins.str] localized: Key value pairs of localized gallery. Each key is the locale code of languages supported by the Azure portal.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Application Insights Workbook Template. Changing this forces a new Application Insights Workbook Template to be created.
        :param pulumi.Input[builtins.int] priority: Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode. Defaults to `0`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Application Insights Workbook Template.
        """
        pulumi.set(__self__, "galleries", galleries)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "template_data", template_data)
        if author is not None:
            pulumi.set(__self__, "author", author)
        if localized is not None:
            pulumi.set(__self__, "localized", localized)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def galleries(self) -> pulumi.Input[Sequence[pulumi.Input['WorkbookTemplateGalleryArgs']]]:
        """
        A `galleries` block as defined below.
        """
        return pulumi.get(self, "galleries")

    @galleries.setter
    def galleries(self, value: pulumi.Input[Sequence[pulumi.Input['WorkbookTemplateGalleryArgs']]]):
        pulumi.set(self, "galleries", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="templateData")
    def template_data(self) -> pulumi.Input[builtins.str]:
        """
        Valid JSON object containing workbook template payload.
        """
        return pulumi.get(self, "template_data")

    @template_data.setter
    def template_data(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "template_data", value)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Information about the author of the workbook template.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter
    def localized(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key value pairs of localized gallery. Each key is the locale code of languages supported by the Azure portal.
        """
        return pulumi.get(self, "localized")

    @localized.setter
    def localized(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "localized", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Application Insights Workbook Template. Changing this forces a new Application Insights Workbook Template to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode. Defaults to `0`.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Application Insights Workbook Template.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _WorkbookTemplateState:
    def __init__(__self__, *,
                 author: Optional[pulumi.Input[builtins.str]] = None,
                 galleries: Optional[pulumi.Input[Sequence[pulumi.Input['WorkbookTemplateGalleryArgs']]]] = None,
                 localized: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template_data: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkbookTemplate resources.
        :param pulumi.Input[builtins.str] author: Information about the author of the workbook template.
        :param pulumi.Input[Sequence[pulumi.Input['WorkbookTemplateGalleryArgs']]] galleries: A `galleries` block as defined below.
        :param pulumi.Input[builtins.str] localized: Key value pairs of localized gallery. Each key is the locale code of languages supported by the Azure portal.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Application Insights Workbook Template. Changing this forces a new Application Insights Workbook Template to be created.
        :param pulumi.Input[builtins.int] priority: Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode. Defaults to `0`.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Application Insights Workbook Template.
        :param pulumi.Input[builtins.str] template_data: Valid JSON object containing workbook template payload.
        """
        if author is not None:
            pulumi.set(__self__, "author", author)
        if galleries is not None:
            pulumi.set(__self__, "galleries", galleries)
        if localized is not None:
            pulumi.set(__self__, "localized", localized)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_data is not None:
            pulumi.set(__self__, "template_data", template_data)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Information about the author of the workbook template.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter
    def galleries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkbookTemplateGalleryArgs']]]]:
        """
        A `galleries` block as defined below.
        """
        return pulumi.get(self, "galleries")

    @galleries.setter
    def galleries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkbookTemplateGalleryArgs']]]]):
        pulumi.set(self, "galleries", value)

    @property
    @pulumi.getter
    def localized(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key value pairs of localized gallery. Each key is the locale code of languages supported by the Azure portal.
        """
        return pulumi.get(self, "localized")

    @localized.setter
    def localized(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "localized", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Application Insights Workbook Template. Changing this forces a new Application Insights Workbook Template to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode. Defaults to `0`.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Application Insights Workbook Template.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateData")
    def template_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Valid JSON object containing workbook template payload.
        """
        return pulumi.get(self, "template_data")

    @template_data.setter
    def template_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_data", value)


@pulumi.type_token("azure:appinsights/workbookTemplate:WorkbookTemplate")
class WorkbookTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 author: Optional[pulumi.Input[builtins.str]] = None,
                 galleries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkbookTemplateGalleryArgs', 'WorkbookTemplateGalleryArgsDict']]]]] = None,
                 localized: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template_data: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Application Insights Workbook Template.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_workbook_template = azure.appinsights.WorkbookTemplate("example",
            name="example-aiwt",
            resource_group_name=example.name,
            location="West Europe",
            author="test author",
            priority=1,
            galleries=[{
                "category": "workbook",
                "name": "test",
                "order": 100,
                "resource_type": "microsoft.insights/components",
                "type": "tsg",
            }],
            template_data=json.dumps({
                "version": "Notebook/1.0",
                "items": [{
                    "type": 1,
                    "content": {
                        "json": \"\"\"## New workbook
        ---

        Welcome to your new workbook.\"\"\",
                    },
                    "name": "text - 2",
                }],
                "styleSettings": {},
                "$schema": "https://github.com/Microsoft/Application-Insights-Workbooks/blob/master/schema/workbook.json",
            }),
            localized=json.dumps({
                "ar": [{
                    "galleries": [{
                        "name": "test",
                        "category": "Failures",
                        "type": "tsg",
                        "resourceType": "microsoft.insights/components",
                        "order": 100,
                    }],
                    "templateData": {
                        "version": "Notebook/1.0",
                        "items": [{
                            "type": 1,
                            "content": {
                                "json": \"\"\"## New workbook
        ---

        Welcome to your new workbook.\"\"\",
                            },
                            "name": "text - 2",
                        }],
                        "styleSettings": {},
                        "$schema": "https://github.com/Microsoft/Application-Insights-Workbooks/blob/master/schema/workbook.json",
                    },
                }],
            }),
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights`: 2020-11-20

        ## Import

        Application Insights Workbook Template can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appinsights/workbookTemplate:WorkbookTemplate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Insights/workbookTemplates/resource1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] author: Information about the author of the workbook template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkbookTemplateGalleryArgs', 'WorkbookTemplateGalleryArgsDict']]]] galleries: A `galleries` block as defined below.
        :param pulumi.Input[builtins.str] localized: Key value pairs of localized gallery. Each key is the locale code of languages supported by the Azure portal.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Application Insights Workbook Template. Changing this forces a new Application Insights Workbook Template to be created.
        :param pulumi.Input[builtins.int] priority: Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode. Defaults to `0`.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Application Insights Workbook Template.
        :param pulumi.Input[builtins.str] template_data: Valid JSON object containing workbook template payload.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkbookTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Application Insights Workbook Template.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_workbook_template = azure.appinsights.WorkbookTemplate("example",
            name="example-aiwt",
            resource_group_name=example.name,
            location="West Europe",
            author="test author",
            priority=1,
            galleries=[{
                "category": "workbook",
                "name": "test",
                "order": 100,
                "resource_type": "microsoft.insights/components",
                "type": "tsg",
            }],
            template_data=json.dumps({
                "version": "Notebook/1.0",
                "items": [{
                    "type": 1,
                    "content": {
                        "json": \"\"\"## New workbook
        ---

        Welcome to your new workbook.\"\"\",
                    },
                    "name": "text - 2",
                }],
                "styleSettings": {},
                "$schema": "https://github.com/Microsoft/Application-Insights-Workbooks/blob/master/schema/workbook.json",
            }),
            localized=json.dumps({
                "ar": [{
                    "galleries": [{
                        "name": "test",
                        "category": "Failures",
                        "type": "tsg",
                        "resourceType": "microsoft.insights/components",
                        "order": 100,
                    }],
                    "templateData": {
                        "version": "Notebook/1.0",
                        "items": [{
                            "type": 1,
                            "content": {
                                "json": \"\"\"## New workbook
        ---

        Welcome to your new workbook.\"\"\",
                            },
                            "name": "text - 2",
                        }],
                        "styleSettings": {},
                        "$schema": "https://github.com/Microsoft/Application-Insights-Workbooks/blob/master/schema/workbook.json",
                    },
                }],
            }),
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights`: 2020-11-20

        ## Import

        Application Insights Workbook Template can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appinsights/workbookTemplate:WorkbookTemplate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Insights/workbookTemplates/resource1
        ```

        :param str resource_name: The name of the resource.
        :param WorkbookTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkbookTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 author: Optional[pulumi.Input[builtins.str]] = None,
                 galleries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkbookTemplateGalleryArgs', 'WorkbookTemplateGalleryArgsDict']]]]] = None,
                 localized: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template_data: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkbookTemplateArgs.__new__(WorkbookTemplateArgs)

            __props__.__dict__["author"] = author
            if galleries is None and not opts.urn:
                raise TypeError("Missing required property 'galleries'")
            __props__.__dict__["galleries"] = galleries
            __props__.__dict__["localized"] = localized
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            if template_data is None and not opts.urn:
                raise TypeError("Missing required property 'template_data'")
            __props__.__dict__["template_data"] = template_data
        super(WorkbookTemplate, __self__).__init__(
            'azure:appinsights/workbookTemplate:WorkbookTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            author: Optional[pulumi.Input[builtins.str]] = None,
            galleries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkbookTemplateGalleryArgs', 'WorkbookTemplateGalleryArgsDict']]]]] = None,
            localized: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            template_data: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkbookTemplate':
        """
        Get an existing WorkbookTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] author: Information about the author of the workbook template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkbookTemplateGalleryArgs', 'WorkbookTemplateGalleryArgsDict']]]] galleries: A `galleries` block as defined below.
        :param pulumi.Input[builtins.str] localized: Key value pairs of localized gallery. Each key is the locale code of languages supported by the Azure portal.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Application Insights Workbook Template. Changing this forces a new Application Insights Workbook Template to be created.
        :param pulumi.Input[builtins.int] priority: Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode. Defaults to `0`.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Application Insights Workbook Template.
        :param pulumi.Input[builtins.str] template_data: Valid JSON object containing workbook template payload.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkbookTemplateState.__new__(_WorkbookTemplateState)

        __props__.__dict__["author"] = author
        __props__.__dict__["galleries"] = galleries
        __props__.__dict__["localized"] = localized
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_data"] = template_data
        return WorkbookTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Information about the author of the workbook template.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter
    def galleries(self) -> pulumi.Output[Sequence['outputs.WorkbookTemplateGallery']]:
        """
        A `galleries` block as defined below.
        """
        return pulumi.get(self, "galleries")

    @property
    @pulumi.getter
    def localized(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Key value pairs of localized gallery. Each key is the locale code of languages supported by the Azure portal.
        """
        return pulumi.get(self, "localized")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure Region where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name which should be used for this Application Insights Workbook Template. Changing this forces a new Application Insights Workbook Template to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode. Defaults to `0`.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group where the Application Insights Workbook Template should exist. Changing this forces a new Application Insights Workbook Template to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Application Insights Workbook Template.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateData")
    def template_data(self) -> pulumi.Output[builtins.str]:
        """
        Valid JSON object containing workbook template payload.
        """
        return pulumi.get(self, "template_data")

