# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSpringCloudServiceResult',
    'AwaitableGetSpringCloudServiceResult',
    'get_spring_cloud_service',
    'get_spring_cloud_service_output',
]

@pulumi.output_type
class GetSpringCloudServiceResult:
    """
    A collection of values returned by getSpringCloudService.
    """
    def __init__(__self__, config_server_git_settings=None, id=None, location=None, name=None, outbound_public_ip_addresses=None, required_network_traffic_rules=None, resource_group_name=None, tags=None):
        if config_server_git_settings and not isinstance(config_server_git_settings, list):
            raise TypeError("Expected argument 'config_server_git_settings' to be a list")
        pulumi.set(__self__, "config_server_git_settings", config_server_git_settings)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if outbound_public_ip_addresses and not isinstance(outbound_public_ip_addresses, list):
            raise TypeError("Expected argument 'outbound_public_ip_addresses' to be a list")
        pulumi.set(__self__, "outbound_public_ip_addresses", outbound_public_ip_addresses)
        if required_network_traffic_rules and not isinstance(required_network_traffic_rules, list):
            raise TypeError("Expected argument 'required_network_traffic_rules' to be a list")
        pulumi.set(__self__, "required_network_traffic_rules", required_network_traffic_rules)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="configServerGitSettings")
    def config_server_git_settings(self) -> Sequence['outputs.GetSpringCloudServiceConfigServerGitSettingResult']:
        """
        A `config_server_git_setting` block as defined below.
        """
        return pulumi.get(self, "config_server_git_settings")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location of Spring Cloud Service.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name to identify on the Git repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundPublicIpAddresses")
    def outbound_public_ip_addresses(self) -> Sequence[builtins.str]:
        """
        A list of the outbound Public IP Addresses used by this Spring Cloud Service.
        """
        return pulumi.get(self, "outbound_public_ip_addresses")

    @property
    @pulumi.getter(name="requiredNetworkTrafficRules")
    def required_network_traffic_rules(self) -> Sequence['outputs.GetSpringCloudServiceRequiredNetworkTrafficRuleResult']:
        """
        A list of `required_network_traffic_rules` blocks as defined below.
        """
        return pulumi.get(self, "required_network_traffic_rules")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to Spring Cloud Service.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSpringCloudServiceResult(GetSpringCloudServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSpringCloudServiceResult(
            config_server_git_settings=self.config_server_git_settings,
            id=self.id,
            location=self.location,
            name=self.name,
            outbound_public_ip_addresses=self.outbound_public_ip_addresses,
            required_network_traffic_rules=self.required_network_traffic_rules,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_spring_cloud_service(name: Optional[builtins.str] = None,
                             resource_group_name: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSpringCloudServiceResult:
    """
    Use this data source to access information about an existing Spring Cloud Service.

    !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudService` data source is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appplatform.get_spring_cloud_service(name=example_azurerm_spring_cloud_service["name"],
        resource_group_name=example_azurerm_spring_cloud_service["resourceGroupName"])
    pulumi.export("springCloudServiceId", example.id)
    ```


    :param builtins.str name: Specifies The name of the Spring Cloud Service resource.
    :param builtins.str resource_group_name: Specifies the name of the Resource Group where the Spring Cloud Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:appplatform/getSpringCloudService:getSpringCloudService', __args__, opts=opts, typ=GetSpringCloudServiceResult).value

    return AwaitableGetSpringCloudServiceResult(
        config_server_git_settings=pulumi.get(__ret__, 'config_server_git_settings'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        outbound_public_ip_addresses=pulumi.get(__ret__, 'outbound_public_ip_addresses'),
        required_network_traffic_rules=pulumi.get(__ret__, 'required_network_traffic_rules'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_spring_cloud_service_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                    resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSpringCloudServiceResult]:
    """
    Use this data source to access information about an existing Spring Cloud Service.

    !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudService` data source is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appplatform.get_spring_cloud_service(name=example_azurerm_spring_cloud_service["name"],
        resource_group_name=example_azurerm_spring_cloud_service["resourceGroupName"])
    pulumi.export("springCloudServiceId", example.id)
    ```


    :param builtins.str name: Specifies The name of the Spring Cloud Service resource.
    :param builtins.str resource_group_name: Specifies the name of the Resource Group where the Spring Cloud Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:appplatform/getSpringCloudService:getSpringCloudService', __args__, opts=opts, typ=GetSpringCloudServiceResult)
    return __ret__.apply(lambda __response__: GetSpringCloudServiceResult(
        config_server_git_settings=pulumi.get(__response__, 'config_server_git_settings'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        outbound_public_ip_addresses=pulumi.get(__response__, 'outbound_public_ip_addresses'),
        required_network_traffic_rules=pulumi.get(__response__, 'required_network_traffic_rules'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
