# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'SpringCloudApiPortalSso',
    'SpringCloudAppCustomPersistentDisk',
    'SpringCloudAppIdentity',
    'SpringCloudAppIngressSettings',
    'SpringCloudAppPersistentDisk',
    'SpringCloudBuildDeploymentQuota',
    'SpringCloudBuildPackBindingLaunch',
    'SpringCloudBuilderBuildPackGroup',
    'SpringCloudBuilderStack',
    'SpringCloudConfigurationServiceRepository',
    'SpringCloudConnectionAuthentication',
    'SpringCloudConnectionSecretStore',
    'SpringCloudContainerDeploymentQuota',
    'SpringCloudCustomizedAcceleratorGitRepository',
    'SpringCloudCustomizedAcceleratorGitRepositoryBasicAuth',
    'SpringCloudCustomizedAcceleratorGitRepositorySshAuth',
    'SpringCloudDevToolPortalSso',
    'SpringCloudGatewayApiMetadata',
    'SpringCloudGatewayClientAuthorization',
    'SpringCloudGatewayCors',
    'SpringCloudGatewayLocalResponseCachePerInstance',
    'SpringCloudGatewayLocalResponseCachePerRoute',
    'SpringCloudGatewayQuota',
    'SpringCloudGatewayRouteConfigOpenApi',
    'SpringCloudGatewayRouteConfigRoute',
    'SpringCloudGatewaySso',
    'SpringCloudJavaDeploymentQuota',
    'SpringCloudServiceConfigServerGitSetting',
    'SpringCloudServiceConfigServerGitSettingHttpBasicAuth',
    'SpringCloudServiceConfigServerGitSettingRepository',
    'SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth',
    'SpringCloudServiceConfigServerGitSettingRepositorySshAuth',
    'SpringCloudServiceConfigServerGitSettingSshAuth',
    'SpringCloudServiceContainerRegistry',
    'SpringCloudServiceDefaultBuildService',
    'SpringCloudServiceMarketplace',
    'SpringCloudServiceNetwork',
    'SpringCloudServiceRequiredNetworkTrafficRule',
    'SpringCloudServiceTrace',
    'GetSpringCloudAppIdentityResult',
    'GetSpringCloudAppPersistentDiskResult',
    'GetSpringCloudServiceConfigServerGitSettingResult',
    'GetSpringCloudServiceConfigServerGitSettingHttpBasicAuthResult',
    'GetSpringCloudServiceConfigServerGitSettingRepositoryResult',
    'GetSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthResult',
    'GetSpringCloudServiceConfigServerGitSettingRepositorySshAuthResult',
    'GetSpringCloudServiceConfigServerGitSettingSshAuthResult',
    'GetSpringCloudServiceRequiredNetworkTrafficRuleResult',
]

@pulumi.output_type
class SpringCloudApiPortalSso(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "issuerUri":
            suggest = "issuer_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudApiPortalSso. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudApiPortalSso.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudApiPortalSso.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[builtins.str] = None,
                 client_secret: Optional[builtins.str] = None,
                 issuer_uri: Optional[builtins.str] = None,
                 scopes: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str client_id: The public identifier for the application.
        :param builtins.str client_secret: The secret known only to the application and the authorization server.
        :param builtins.str issuer_uri: The URI of Issuer Identifier.
        :param Sequence[builtins.str] scopes: It defines the specific actions applications can be allowed to do on a user's behalf.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if issuer_uri is not None:
            pulumi.set(__self__, "issuer_uri", issuer_uri)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        """
        The public identifier for the application.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[builtins.str]:
        """
        The secret known only to the application and the authorization server.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="issuerUri")
    def issuer_uri(self) -> Optional[builtins.str]:
        """
        The URI of Issuer Identifier.
        """
        return pulumi.get(self, "issuer_uri")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[builtins.str]]:
        """
        It defines the specific actions applications can be allowed to do on a user's behalf.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class SpringCloudAppCustomPersistentDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "shareName":
            suggest = "share_name"
        elif key == "storageName":
            suggest = "storage_name"
        elif key == "mountOptions":
            suggest = "mount_options"
        elif key == "readOnlyEnabled":
            suggest = "read_only_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudAppCustomPersistentDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudAppCustomPersistentDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudAppCustomPersistentDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: builtins.str,
                 share_name: builtins.str,
                 storage_name: builtins.str,
                 mount_options: Optional[Sequence[builtins.str]] = None,
                 read_only_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str mount_path: The mount path of the persistent disk.
        :param builtins.str share_name: The share name of the Azure File share.
        :param builtins.str storage_name: The name of the Spring Cloud Storage.
        :param Sequence[builtins.str] mount_options: These are the mount options for a persistent disk.
        :param builtins.bool read_only_enabled: Indicates whether the persistent disk is a readOnly one.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "share_name", share_name)
        pulumi.set(__self__, "storage_name", storage_name)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if read_only_enabled is not None:
            pulumi.set(__self__, "read_only_enabled", read_only_enabled)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> builtins.str:
        """
        The mount path of the persistent disk.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> builtins.str:
        """
        The share name of the Azure File share.
        """
        return pulumi.get(self, "share_name")

    @property
    @pulumi.getter(name="storageName")
    def storage_name(self) -> builtins.str:
        """
        The name of the Spring Cloud Storage.
        """
        return pulumi.get(self, "storage_name")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[Sequence[builtins.str]]:
        """
        These are the mount options for a persistent disk.
        """
        return pulumi.get(self, "mount_options")

    @property
    @pulumi.getter(name="readOnlyEnabled")
    def read_only_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether the persistent disk is a readOnly one.
        """
        return pulumi.get(self, "read_only_enabled")


@pulumi.output_type
class SpringCloudAppIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudAppIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudAppIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudAppIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Spring Cloud Application. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[builtins.str] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this Spring Cloud Application.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Spring Cloud Application.
        :param builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Spring Cloud Application.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Spring Cloud Application. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this Spring Cloud Application.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Spring Cloud Application.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Spring Cloud Application.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class SpringCloudAppIngressSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendProtocol":
            suggest = "backend_protocol"
        elif key == "readTimeoutInSeconds":
            suggest = "read_timeout_in_seconds"
        elif key == "sendTimeoutInSeconds":
            suggest = "send_timeout_in_seconds"
        elif key == "sessionAffinity":
            suggest = "session_affinity"
        elif key == "sessionCookieMaxAge":
            suggest = "session_cookie_max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudAppIngressSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudAppIngressSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudAppIngressSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_protocol: Optional[builtins.str] = None,
                 read_timeout_in_seconds: Optional[builtins.int] = None,
                 send_timeout_in_seconds: Optional[builtins.int] = None,
                 session_affinity: Optional[builtins.str] = None,
                 session_cookie_max_age: Optional[builtins.int] = None):
        """
        :param builtins.str backend_protocol: Specifies how ingress should communicate with this app backend service. Allowed values are `GRPC` and `Default`. Defaults to `Default`.
        :param builtins.int read_timeout_in_seconds: Specifies the ingress read time out in seconds. Defaults to `300`.
        :param builtins.int send_timeout_in_seconds: Specifies the ingress send time out in seconds. Defaults to `60`.
        :param builtins.str session_affinity: Specifies the type of the affinity, set this to `Cookie` to enable session affinity. Allowed values are `Cookie` and `None`. Defaults to `None`.
        :param builtins.int session_cookie_max_age: Specifies the time in seconds until the cookie expires.
        """
        if backend_protocol is not None:
            pulumi.set(__self__, "backend_protocol", backend_protocol)
        if read_timeout_in_seconds is not None:
            pulumi.set(__self__, "read_timeout_in_seconds", read_timeout_in_seconds)
        if send_timeout_in_seconds is not None:
            pulumi.set(__self__, "send_timeout_in_seconds", send_timeout_in_seconds)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if session_cookie_max_age is not None:
            pulumi.set(__self__, "session_cookie_max_age", session_cookie_max_age)

    @property
    @pulumi.getter(name="backendProtocol")
    def backend_protocol(self) -> Optional[builtins.str]:
        """
        Specifies how ingress should communicate with this app backend service. Allowed values are `GRPC` and `Default`. Defaults to `Default`.
        """
        return pulumi.get(self, "backend_protocol")

    @property
    @pulumi.getter(name="readTimeoutInSeconds")
    def read_timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        Specifies the ingress read time out in seconds. Defaults to `300`.
        """
        return pulumi.get(self, "read_timeout_in_seconds")

    @property
    @pulumi.getter(name="sendTimeoutInSeconds")
    def send_timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        Specifies the ingress send time out in seconds. Defaults to `60`.
        """
        return pulumi.get(self, "send_timeout_in_seconds")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[builtins.str]:
        """
        Specifies the type of the affinity, set this to `Cookie` to enable session affinity. Allowed values are `Cookie` and `None`. Defaults to `None`.
        """
        return pulumi.get(self, "session_affinity")

    @property
    @pulumi.getter(name="sessionCookieMaxAge")
    def session_cookie_max_age(self) -> Optional[builtins.int]:
        """
        Specifies the time in seconds until the cookie expires.
        """
        return pulumi.get(self, "session_cookie_max_age")


@pulumi.output_type
class SpringCloudAppPersistentDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGb":
            suggest = "size_in_gb"
        elif key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudAppPersistentDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudAppPersistentDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudAppPersistentDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_gb: builtins.int,
                 mount_path: Optional[builtins.str] = None):
        """
        :param builtins.int size_in_gb: Specifies the size of the persistent disk in GB. Possible values are between `0` and `50`.
        :param builtins.str mount_path: Specifies the mount path of the persistent disk. Defaults to `/persistent`.
        """
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> builtins.int:
        """
        Specifies the size of the persistent disk in GB. Possible values are between `0` and `50`.
        """
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[builtins.str]:
        """
        Specifies the mount path of the persistent disk. Defaults to `/persistent`.
        """
        return pulumi.get(self, "mount_path")


@pulumi.output_type
class SpringCloudBuildDeploymentQuota(dict):
    def __init__(__self__, *,
                 cpu: Optional[builtins.str] = None,
                 memory: Optional[builtins.str] = None):
        """
        :param builtins.str cpu: Specifies the required cpu of the Spring Cloud Deployment. Possible Values are `500m`, `1`, `2`, `3` and `4`. Defaults to `1` if not specified.
               
               > **Note:** `cpu` supports `500m` and `1` for Basic tier, `500m`, `1`, `2`, `3` and `4` for Standard tier.
        :param builtins.str memory: Specifies the required memory size of the Spring Cloud Deployment. Possible Values are `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi`. Defaults to `1Gi` if not specified.
               
               > **Note:** `memory` supports `512Mi`, `1Gi` and `2Gi` for Basic tier, `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi` for Standard tier.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.str]:
        """
        Specifies the required cpu of the Spring Cloud Deployment. Possible Values are `500m`, `1`, `2`, `3` and `4`. Defaults to `1` if not specified.

        > **Note:** `cpu` supports `500m` and `1` for Basic tier, `500m`, `1`, `2`, `3` and `4` for Standard tier.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.str]:
        """
        Specifies the required memory size of the Spring Cloud Deployment. Possible Values are `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi`. Defaults to `1Gi` if not specified.

        > **Note:** `memory` supports `512Mi`, `1Gi` and `2Gi` for Basic tier, `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi` for Standard tier.
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class SpringCloudBuildPackBindingLaunch(dict):
    def __init__(__self__, *,
                 properties: Optional[Mapping[str, builtins.str]] = None,
                 secrets: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] properties: Specifies a map of non-sensitive properties for launchProperties.
        :param Mapping[str, builtins.str] secrets: Specifies a map of sensitive properties for launchProperties.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Specifies a map of non-sensitive properties for launchProperties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Specifies a map of sensitive properties for launchProperties.
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class SpringCloudBuilderBuildPackGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildPackIds":
            suggest = "build_pack_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudBuilderBuildPackGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudBuilderBuildPackGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudBuilderBuildPackGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 build_pack_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The name which should be used for this build pack group.
        :param Sequence[builtins.str] build_pack_ids: Specifies a list of the build pack's ID.
        """
        pulumi.set(__self__, "name", name)
        if build_pack_ids is not None:
            pulumi.set(__self__, "build_pack_ids", build_pack_ids)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name which should be used for this build pack group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="buildPackIds")
    def build_pack_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of the build pack's ID.
        """
        return pulumi.get(self, "build_pack_ids")


@pulumi.output_type
class SpringCloudBuilderStack(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str id: Specifies the ID of the ClusterStack.
        :param builtins.str version: Specifies the version of the ClusterStack
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Specifies the ID of the ClusterStack.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Specifies the version of the ClusterStack
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SpringCloudConfigurationServiceRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificateId":
            suggest = "ca_certificate_id"
        elif key == "hostKey":
            suggest = "host_key"
        elif key == "hostKeyAlgorithm":
            suggest = "host_key_algorithm"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "searchPaths":
            suggest = "search_paths"
        elif key == "strictHostKeyChecking":
            suggest = "strict_host_key_checking"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudConfigurationServiceRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudConfigurationServiceRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudConfigurationServiceRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: builtins.str,
                 name: builtins.str,
                 patterns: Sequence[builtins.str],
                 uri: builtins.str,
                 ca_certificate_id: Optional[builtins.str] = None,
                 host_key: Optional[builtins.str] = None,
                 host_key_algorithm: Optional[builtins.str] = None,
                 password: Optional[builtins.str] = None,
                 private_key: Optional[builtins.str] = None,
                 search_paths: Optional[Sequence[builtins.str]] = None,
                 strict_host_key_checking: Optional[builtins.bool] = None,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str label: Specifies the label of the repository.
        :param builtins.str name: Specifies the name which should be used for this repository.
        :param Sequence[builtins.str] patterns: Specifies the collection of patterns of the repository.
        :param builtins.str uri: Specifies the URI of the repository.
        :param builtins.str ca_certificate_id: Specifies the ID of the Certificate Authority used when retrieving the Git Repository via HTTPS.
        :param builtins.str host_key: Specifies the SSH public key of git repository.
        :param builtins.str host_key_algorithm: Specifies the SSH key algorithm of git repository.
        :param builtins.str password: Specifies the password of git repository basic auth.
        :param builtins.str private_key: Specifies the SSH private key of git repository.
        :param Sequence[builtins.str] search_paths: Specifies a list of searching path of the repository
        :param builtins.bool strict_host_key_checking: Specifies whether enable the strict host key checking.
        :param builtins.str username: Specifies the username of git repository basic auth.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "patterns", patterns)
        pulumi.set(__self__, "uri", uri)
        if ca_certificate_id is not None:
            pulumi.set(__self__, "ca_certificate_id", ca_certificate_id)
        if host_key is not None:
            pulumi.set(__self__, "host_key", host_key)
        if host_key_algorithm is not None:
            pulumi.set(__self__, "host_key_algorithm", host_key_algorithm)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if search_paths is not None:
            pulumi.set(__self__, "search_paths", search_paths)
        if strict_host_key_checking is not None:
            pulumi.set(__self__, "strict_host_key_checking", strict_host_key_checking)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        Specifies the label of the repository.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name which should be used for this repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def patterns(self) -> Sequence[builtins.str]:
        """
        Specifies the collection of patterns of the repository.
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        Specifies the URI of the repository.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="caCertificateId")
    def ca_certificate_id(self) -> Optional[builtins.str]:
        """
        Specifies the ID of the Certificate Authority used when retrieving the Git Repository via HTTPS.
        """
        return pulumi.get(self, "ca_certificate_id")

    @property
    @pulumi.getter(name="hostKey")
    def host_key(self) -> Optional[builtins.str]:
        """
        Specifies the SSH public key of git repository.
        """
        return pulumi.get(self, "host_key")

    @property
    @pulumi.getter(name="hostKeyAlgorithm")
    def host_key_algorithm(self) -> Optional[builtins.str]:
        """
        Specifies the SSH key algorithm of git repository.
        """
        return pulumi.get(self, "host_key_algorithm")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        Specifies the password of git repository basic auth.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[builtins.str]:
        """
        Specifies the SSH private key of git repository.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of searching path of the repository
        """
        return pulumi.get(self, "search_paths")

    @property
    @pulumi.getter(name="strictHostKeyChecking")
    def strict_host_key_checking(self) -> Optional[builtins.bool]:
        """
        Specifies whether enable the strict host key checking.
        """
        return pulumi.get(self, "strict_host_key_checking")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        Specifies the username of git repository basic auth.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SpringCloudConnectionAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudConnectionAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudConnectionAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudConnectionAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 certificate: Optional[builtins.str] = None,
                 client_id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 principal_id: Optional[builtins.str] = None,
                 secret: Optional[builtins.str] = None,
                 subscription_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: The authentication type. Possible values are `systemAssignedIdentity`, `userAssignedIdentity`, `servicePrincipalSecret`, `servicePrincipalCertificate`, `secret`. Changing this forces a new resource to be created.
        :param builtins.str certificate: Service principal certificate for `servicePrincipal` auth. Should be specified when `type` is set to `servicePrincipalCertificate`.
        :param builtins.str client_id: Client ID for `userAssignedIdentity` or `servicePrincipal` auth. Should be specified when `type` is set to `servicePrincipalSecret` or `servicePrincipalCertificate`. When `type` is set to `userAssignedIdentity`, `client_id` and `subscription_id` should be either both specified or both not specified.
        :param builtins.str name: Username or account name for secret auth. `name` and `secret` should be either both specified or both not specified when `type` is set to `secret`.
        :param builtins.str principal_id: Principal ID for `servicePrincipal` auth. Should be specified when `type` is set to `servicePrincipalSecret` or `servicePrincipalCertificate`.
        :param builtins.str secret: Password or account key for secret auth. `secret` and `name` should be either both specified or both not specified when `type` is set to `secret`.
        :param builtins.str subscription_id: Subscription ID for `userAssignedIdentity`. `subscription_id` and `client_id` should be either both specified or both not specified.
        """
        pulumi.set(__self__, "type", type)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The authentication type. Possible values are `systemAssignedIdentity`, `userAssignedIdentity`, `servicePrincipalSecret`, `servicePrincipalCertificate`, `secret`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        Service principal certificate for `servicePrincipal` auth. Should be specified when `type` is set to `servicePrincipalCertificate`.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        """
        Client ID for `userAssignedIdentity` or `servicePrincipal` auth. Should be specified when `type` is set to `servicePrincipalSecret` or `servicePrincipalCertificate`. When `type` is set to `userAssignedIdentity`, `client_id` and `subscription_id` should be either both specified or both not specified.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Username or account name for secret auth. `name` and `secret` should be either both specified or both not specified when `type` is set to `secret`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        Principal ID for `servicePrincipal` auth. Should be specified when `type` is set to `servicePrincipalSecret` or `servicePrincipalCertificate`.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter
    def secret(self) -> Optional[builtins.str]:
        """
        Password or account key for secret auth. `secret` and `name` should be either both specified or both not specified when `type` is set to `secret`.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[builtins.str]:
        """
        Subscription ID for `userAssignedIdentity`. `subscription_id` and `client_id` should be either both specified or both not specified.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class SpringCloudConnectionSecretStore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultId":
            suggest = "key_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudConnectionSecretStore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudConnectionSecretStore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudConnectionSecretStore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_id: builtins.str):
        """
        :param builtins.str key_vault_id: The key vault id to store secret.
        """
        pulumi.set(__self__, "key_vault_id", key_vault_id)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> builtins.str:
        """
        The key vault id to store secret.
        """
        return pulumi.get(self, "key_vault_id")


@pulumi.output_type
class SpringCloudContainerDeploymentQuota(dict):
    def __init__(__self__, *,
                 cpu: Optional[builtins.str] = None,
                 memory: Optional[builtins.str] = None):
        """
        :param builtins.str cpu: Specifies the required cpu of the Spring Cloud Deployment. Possible Values are `500m`, `1`, `2`, `3` and `4`. Defaults to `1` if not specified.
               
               > **Note:** `cpu` supports `500m` and `1` for Basic tier, `500m`, `1`, `2`, `3` and `4` for Standard tier.
        :param builtins.str memory: Specifies the required memory size of the Spring Cloud Deployment. Possible Values are `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi`. Defaults to `1Gi` if not specified.
               
               > **Note:** `memory` supports `512Mi`, `1Gi` and `2Gi` for Basic tier, `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi` for Standard tier.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.str]:
        """
        Specifies the required cpu of the Spring Cloud Deployment. Possible Values are `500m`, `1`, `2`, `3` and `4`. Defaults to `1` if not specified.

        > **Note:** `cpu` supports `500m` and `1` for Basic tier, `500m`, `1`, `2`, `3` and `4` for Standard tier.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.str]:
        """
        Specifies the required memory size of the Spring Cloud Deployment. Possible Values are `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi`. Defaults to `1Gi` if not specified.

        > **Note:** `memory` supports `512Mi`, `1Gi` and `2Gi` for Basic tier, `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi` for Standard tier.
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class SpringCloudCustomizedAcceleratorGitRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"
        elif key == "caCertificateId":
            suggest = "ca_certificate_id"
        elif key == "gitTag":
            suggest = "git_tag"
        elif key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "sshAuth":
            suggest = "ssh_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudCustomizedAcceleratorGitRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudCustomizedAcceleratorGitRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudCustomizedAcceleratorGitRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 basic_auth: Optional['outputs.SpringCloudCustomizedAcceleratorGitRepositoryBasicAuth'] = None,
                 branch: Optional[builtins.str] = None,
                 ca_certificate_id: Optional[builtins.str] = None,
                 commit: Optional[builtins.str] = None,
                 git_tag: Optional[builtins.str] = None,
                 interval_in_seconds: Optional[builtins.int] = None,
                 path: Optional[builtins.str] = None,
                 ssh_auth: Optional['outputs.SpringCloudCustomizedAcceleratorGitRepositorySshAuth'] = None):
        """
        :param builtins.str url: Specifies Git repository URL for the accelerator.
        :param 'SpringCloudCustomizedAcceleratorGitRepositoryBasicAuthArgs' basic_auth: A `basic_auth` block as defined below. Conflicts with `git_repository[0].ssh_auth`. Changing this forces a new Spring Cloud Customized Accelerator to be created.
        :param builtins.str branch: Specifies the Git repository branch to be used.
        :param builtins.str ca_certificate_id: Specifies the ID of the CA Spring Cloud Certificate for https URL of Git repository.
        :param builtins.str commit: Specifies the Git repository commit to be used.
        :param builtins.str git_tag: Specifies the Git repository tag to be used.
        :param builtins.int interval_in_seconds: Specifies the interval for checking for updates to Git or image repository. It should be greater than 10.
        :param builtins.str path: Specifies the path under the git repository to be treated as the root directory of the accelerator or the fragment (depending on `accelerator_type`).
        :param 'SpringCloudCustomizedAcceleratorGitRepositorySshAuthArgs' ssh_auth: A `ssh_auth` block as defined below. Conflicts with `git_repository[0].basic_auth`. Changing this forces a new Spring Cloud Customized Accelerator to be created.
        """
        pulumi.set(__self__, "url", url)
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if ca_certificate_id is not None:
            pulumi.set(__self__, "ca_certificate_id", ca_certificate_id)
        if commit is not None:
            pulumi.set(__self__, "commit", commit)
        if git_tag is not None:
            pulumi.set(__self__, "git_tag", git_tag)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if ssh_auth is not None:
            pulumi.set(__self__, "ssh_auth", ssh_auth)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        Specifies Git repository URL for the accelerator.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional['outputs.SpringCloudCustomizedAcceleratorGitRepositoryBasicAuth']:
        """
        A `basic_auth` block as defined below. Conflicts with `git_repository[0].ssh_auth`. Changing this forces a new Spring Cloud Customized Accelerator to be created.
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter
    def branch(self) -> Optional[builtins.str]:
        """
        Specifies the Git repository branch to be used.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="caCertificateId")
    def ca_certificate_id(self) -> Optional[builtins.str]:
        """
        Specifies the ID of the CA Spring Cloud Certificate for https URL of Git repository.
        """
        return pulumi.get(self, "ca_certificate_id")

    @property
    @pulumi.getter
    def commit(self) -> Optional[builtins.str]:
        """
        Specifies the Git repository commit to be used.
        """
        return pulumi.get(self, "commit")

    @property
    @pulumi.getter(name="gitTag")
    def git_tag(self) -> Optional[builtins.str]:
        """
        Specifies the Git repository tag to be used.
        """
        return pulumi.get(self, "git_tag")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[builtins.int]:
        """
        Specifies the interval for checking for updates to Git or image repository. It should be greater than 10.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        Specifies the path under the git repository to be treated as the root directory of the accelerator or the fragment (depending on `accelerator_type`).
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="sshAuth")
    def ssh_auth(self) -> Optional['outputs.SpringCloudCustomizedAcceleratorGitRepositorySshAuth']:
        """
        A `ssh_auth` block as defined below. Conflicts with `git_repository[0].basic_auth`. Changing this forces a new Spring Cloud Customized Accelerator to be created.
        """
        return pulumi.get(self, "ssh_auth")


@pulumi.output_type
class SpringCloudCustomizedAcceleratorGitRepositoryBasicAuth(dict):
    def __init__(__self__, *,
                 password: builtins.str,
                 username: builtins.str):
        """
        :param builtins.str password: Specifies the password of git repository basic auth.
        :param builtins.str username: Specifies the username of git repository basic auth.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        Specifies the password of git repository basic auth.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        Specifies the username of git repository basic auth.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SpringCloudCustomizedAcceleratorGitRepositorySshAuth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"
        elif key == "hostKey":
            suggest = "host_key"
        elif key == "hostKeyAlgorithm":
            suggest = "host_key_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudCustomizedAcceleratorGitRepositorySshAuth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudCustomizedAcceleratorGitRepositorySshAuth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudCustomizedAcceleratorGitRepositorySshAuth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_key: builtins.str,
                 host_key: Optional[builtins.str] = None,
                 host_key_algorithm: Optional[builtins.str] = None):
        """
        :param builtins.str private_key: Specifies the Private SSH Key of git repository basic auth.
        :param builtins.str host_key: Specifies the Public SSH Key of git repository basic auth.
        :param builtins.str host_key_algorithm: Specifies the SSH Key algorithm of git repository basic auth.
        """
        pulumi.set(__self__, "private_key", private_key)
        if host_key is not None:
            pulumi.set(__self__, "host_key", host_key)
        if host_key_algorithm is not None:
            pulumi.set(__self__, "host_key_algorithm", host_key_algorithm)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> builtins.str:
        """
        Specifies the Private SSH Key of git repository basic auth.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="hostKey")
    def host_key(self) -> Optional[builtins.str]:
        """
        Specifies the Public SSH Key of git repository basic auth.
        """
        return pulumi.get(self, "host_key")

    @property
    @pulumi.getter(name="hostKeyAlgorithm")
    def host_key_algorithm(self) -> Optional[builtins.str]:
        """
        Specifies the SSH Key algorithm of git repository basic auth.
        """
        return pulumi.get(self, "host_key_algorithm")


@pulumi.output_type
class SpringCloudDevToolPortalSso(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "metadataUrl":
            suggest = "metadata_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudDevToolPortalSso. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudDevToolPortalSso.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudDevToolPortalSso.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[builtins.str] = None,
                 client_secret: Optional[builtins.str] = None,
                 metadata_url: Optional[builtins.str] = None,
                 scopes: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str client_id: Specifies the public identifier for the application.
        :param builtins.str client_secret: Specifies the secret known only to the application and the authorization server.
        :param builtins.str metadata_url: Specifies the URI of a JSON file with generic OIDC provider configuration.
        :param Sequence[builtins.str] scopes: Specifies a list of specific actions applications can be allowed to do on a user's behalf.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if metadata_url is not None:
            pulumi.set(__self__, "metadata_url", metadata_url)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        """
        Specifies the public identifier for the application.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[builtins.str]:
        """
        Specifies the secret known only to the application and the authorization server.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="metadataUrl")
    def metadata_url(self) -> Optional[builtins.str]:
        """
        Specifies the URI of a JSON file with generic OIDC provider configuration.
        """
        return pulumi.get(self, "metadata_url")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of specific actions applications can be allowed to do on a user's behalf.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class SpringCloudGatewayApiMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "documentationUrl":
            suggest = "documentation_url"
        elif key == "serverUrl":
            suggest = "server_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudGatewayApiMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudGatewayApiMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudGatewayApiMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[builtins.str] = None,
                 documentation_url: Optional[builtins.str] = None,
                 server_url: Optional[builtins.str] = None,
                 title: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str description: Detailed description of the APIs available on the Gateway instance.
        :param builtins.str documentation_url: Location of additional documentation for the APIs available on the Gateway instance.
        :param builtins.str server_url: Base URL that API consumers will use to access APIs on the Gateway instance.
        :param builtins.str title: Specifies the title describing the context of the APIs available on the Gateway instance.
        :param builtins.str version: Specifies the version of APIs available on this Gateway instance.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if documentation_url is not None:
            pulumi.set(__self__, "documentation_url", documentation_url)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Detailed description of the APIs available on the Gateway instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="documentationUrl")
    def documentation_url(self) -> Optional[builtins.str]:
        """
        Location of additional documentation for the APIs available on the Gateway instance.
        """
        return pulumi.get(self, "documentation_url")

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[builtins.str]:
        """
        Base URL that API consumers will use to access APIs on the Gateway instance.
        """
        return pulumi.get(self, "server_url")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Specifies the title describing the context of the APIs available on the Gateway instance.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Specifies the version of APIs available on this Gateway instance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SpringCloudGatewayClientAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateIds":
            suggest = "certificate_ids"
        elif key == "verificationEnabled":
            suggest = "verification_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudGatewayClientAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudGatewayClientAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudGatewayClientAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_ids: Optional[Sequence[builtins.str]] = None,
                 verification_enabled: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] certificate_ids: Specifies the Spring Cloud Certificate IDs of the Spring Cloud Gateway.
        :param builtins.bool verification_enabled: Specifies whether the client certificate verification is enabled.
        """
        if certificate_ids is not None:
            pulumi.set(__self__, "certificate_ids", certificate_ids)
        if verification_enabled is not None:
            pulumi.set(__self__, "verification_enabled", verification_enabled)

    @property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the Spring Cloud Certificate IDs of the Spring Cloud Gateway.
        """
        return pulumi.get(self, "certificate_ids")

    @property
    @pulumi.getter(name="verificationEnabled")
    def verification_enabled(self) -> Optional[builtins.bool]:
        """
        Specifies whether the client certificate verification is enabled.
        """
        return pulumi.get(self, "verification_enabled")


@pulumi.output_type
class SpringCloudGatewayCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOriginPatterns":
            suggest = "allowed_origin_patterns"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "credentialsAllowed":
            suggest = "credentials_allowed"
        elif key == "exposedHeaders":
            suggest = "exposed_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudGatewayCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudGatewayCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudGatewayCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_headers: Optional[Sequence[builtins.str]] = None,
                 allowed_methods: Optional[Sequence[builtins.str]] = None,
                 allowed_origin_patterns: Optional[Sequence[builtins.str]] = None,
                 allowed_origins: Optional[Sequence[builtins.str]] = None,
                 credentials_allowed: Optional[builtins.bool] = None,
                 exposed_headers: Optional[Sequence[builtins.str]] = None,
                 max_age_seconds: Optional[builtins.int] = None):
        """
        :param Sequence[builtins.str] allowed_headers: Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header.
        :param Sequence[builtins.str] allowed_methods: Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS` and `PUT`.
        :param Sequence[builtins.str] allowed_origin_patterns: Allowed origin patterns to make cross-site requests.
        :param Sequence[builtins.str] allowed_origins: Allowed origins to make cross-site requests. The special value `*` allows all domains.
        :param builtins.bool credentials_allowed: is user credentials are supported on cross-site requests?
        :param Sequence[builtins.str] exposed_headers: HTTP response headers to expose for cross-site requests.
        :param builtins.int max_age_seconds: How long, in seconds, the response from a pre-flight request can be cached by clients.
        """
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if allowed_origin_patterns is not None:
            pulumi.set(__self__, "allowed_origin_patterns", allowed_origin_patterns)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if credentials_allowed is not None:
            pulumi.set(__self__, "credentials_allowed", credentials_allowed)
        if exposed_headers is not None:
            pulumi.set(__self__, "exposed_headers", exposed_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS` and `PUT`.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOriginPatterns")
    def allowed_origin_patterns(self) -> Optional[Sequence[builtins.str]]:
        """
        Allowed origin patterns to make cross-site requests.
        """
        return pulumi.get(self, "allowed_origin_patterns")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[Sequence[builtins.str]]:
        """
        Allowed origins to make cross-site requests. The special value `*` allows all domains.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="credentialsAllowed")
    def credentials_allowed(self) -> Optional[builtins.bool]:
        """
        is user credentials are supported on cross-site requests?
        """
        return pulumi.get(self, "credentials_allowed")

    @property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        HTTP response headers to expose for cross-site requests.
        """
        return pulumi.get(self, "exposed_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[builtins.int]:
        """
        How long, in seconds, the response from a pre-flight request can be cached by clients.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class SpringCloudGatewayLocalResponseCachePerInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeToLive":
            suggest = "time_to_live"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudGatewayLocalResponseCachePerInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudGatewayLocalResponseCachePerInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudGatewayLocalResponseCachePerInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: Optional[builtins.str] = None,
                 time_to_live: Optional[builtins.str] = None):
        """
        :param builtins.str size: Specifies the maximum size of cache (10MB, 900KB, 1GB...) to determine if the cache needs to evict some entries.
        :param builtins.str time_to_live: Specifies the time before a cached entry is expired (300s, 5m, 1h...).
        """
        if size is not None:
            pulumi.set(__self__, "size", size)
        if time_to_live is not None:
            pulumi.set(__self__, "time_to_live", time_to_live)

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        """
        Specifies the maximum size of cache (10MB, 900KB, 1GB...) to determine if the cache needs to evict some entries.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Optional[builtins.str]:
        """
        Specifies the time before a cached entry is expired (300s, 5m, 1h...).
        """
        return pulumi.get(self, "time_to_live")


@pulumi.output_type
class SpringCloudGatewayLocalResponseCachePerRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeToLive":
            suggest = "time_to_live"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudGatewayLocalResponseCachePerRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudGatewayLocalResponseCachePerRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudGatewayLocalResponseCachePerRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: Optional[builtins.str] = None,
                 time_to_live: Optional[builtins.str] = None):
        """
        :param builtins.str size: Specifies the maximum size of cache (10MB, 900KB, 1GB...) to determine if the cache needs to evict some entries.
        :param builtins.str time_to_live: Specifies the time before a cached entry is expired (300s, 5m, 1h...).
        """
        if size is not None:
            pulumi.set(__self__, "size", size)
        if time_to_live is not None:
            pulumi.set(__self__, "time_to_live", time_to_live)

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        """
        Specifies the maximum size of cache (10MB, 900KB, 1GB...) to determine if the cache needs to evict some entries.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Optional[builtins.str]:
        """
        Specifies the time before a cached entry is expired (300s, 5m, 1h...).
        """
        return pulumi.get(self, "time_to_live")


@pulumi.output_type
class SpringCloudGatewayQuota(dict):
    def __init__(__self__, *,
                 cpu: Optional[builtins.str] = None,
                 memory: Optional[builtins.str] = None):
        """
        :param builtins.str cpu: Specifies the required cpu of the Spring Cloud Deployment. Possible Values are `500m`, `1`, `2`, `3` and `4`. Defaults to `1` if not specified.
               
               > **Note:** `cpu` supports `500m` and `1` for Basic tier, `500m`, `1`, `2`, `3` and `4` for Standard tier.
        :param builtins.str memory: Specifies the required memory size of the Spring Cloud Deployment. Possible Values are `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi`. Defaults to `2Gi` if not specified.
               
               > **Note:** `memory` supports `512Mi`, `1Gi` and `2Gi` for Basic tier, `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi` for Standard tier.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.str]:
        """
        Specifies the required cpu of the Spring Cloud Deployment. Possible Values are `500m`, `1`, `2`, `3` and `4`. Defaults to `1` if not specified.

        > **Note:** `cpu` supports `500m` and `1` for Basic tier, `500m`, `1`, `2`, `3` and `4` for Standard tier.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.str]:
        """
        Specifies the required memory size of the Spring Cloud Deployment. Possible Values are `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi`. Defaults to `2Gi` if not specified.

        > **Note:** `memory` supports `512Mi`, `1Gi` and `2Gi` for Basic tier, `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi` for Standard tier.
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class SpringCloudGatewayRouteConfigOpenApi(dict):
    def __init__(__self__, *,
                 uri: Optional[builtins.str] = None):
        """
        :param builtins.str uri: The URI of OpenAPI specification.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        The URI of OpenAPI specification.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class SpringCloudGatewayRouteConfigRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classificationTags":
            suggest = "classification_tags"
        elif key == "ssoValidationEnabled":
            suggest = "sso_validation_enabled"
        elif key == "tokenRelay":
            suggest = "token_relay"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudGatewayRouteConfigRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudGatewayRouteConfigRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudGatewayRouteConfigRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 order: builtins.int,
                 classification_tags: Optional[Sequence[builtins.str]] = None,
                 description: Optional[builtins.str] = None,
                 filters: Optional[Sequence[builtins.str]] = None,
                 predicates: Optional[Sequence[builtins.str]] = None,
                 sso_validation_enabled: Optional[builtins.bool] = None,
                 title: Optional[builtins.str] = None,
                 token_relay: Optional[builtins.bool] = None,
                 uri: Optional[builtins.str] = None):
        """
        :param builtins.int order: Specifies the route processing order.
        :param Sequence[builtins.str] classification_tags: Specifies the classification tags which will be applied to methods in the generated OpenAPI documentation.
        :param builtins.str description: Specifies the description which will be applied to methods in the generated OpenAPI documentation.
        :param Sequence[builtins.str] filters: Specifies a list of filters which are used to modify the request before sending it to the target endpoint, or the received response.
        :param Sequence[builtins.str] predicates: Specifies a list of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
        :param builtins.bool sso_validation_enabled: Should the sso validation be enabled?
        :param builtins.str title: Specifies the title which will be applied to methods in the generated OpenAPI documentation.
        :param builtins.bool token_relay: Should pass currently-authenticated user's identity token to application service?
        :param builtins.str uri: Specifies the full uri which will override `appName`.
        """
        pulumi.set(__self__, "order", order)
        if classification_tags is not None:
            pulumi.set(__self__, "classification_tags", classification_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if predicates is not None:
            pulumi.set(__self__, "predicates", predicates)
        if sso_validation_enabled is not None:
            pulumi.set(__self__, "sso_validation_enabled", sso_validation_enabled)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if token_relay is not None:
            pulumi.set(__self__, "token_relay", token_relay)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def order(self) -> builtins.int:
        """
        Specifies the route processing order.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="classificationTags")
    def classification_tags(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the classification tags which will be applied to methods in the generated OpenAPI documentation.
        """
        return pulumi.get(self, "classification_tags")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Specifies the description which will be applied to methods in the generated OpenAPI documentation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of filters which are used to modify the request before sending it to the target endpoint, or the received response.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def predicates(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
        """
        return pulumi.get(self, "predicates")

    @property
    @pulumi.getter(name="ssoValidationEnabled")
    def sso_validation_enabled(self) -> Optional[builtins.bool]:
        """
        Should the sso validation be enabled?
        """
        return pulumi.get(self, "sso_validation_enabled")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Specifies the title which will be applied to methods in the generated OpenAPI documentation.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="tokenRelay")
    def token_relay(self) -> Optional[builtins.bool]:
        """
        Should pass currently-authenticated user's identity token to application service?
        """
        return pulumi.get(self, "token_relay")

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        Specifies the full uri which will override `appName`.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class SpringCloudGatewaySso(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "issuerUri":
            suggest = "issuer_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudGatewaySso. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudGatewaySso.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudGatewaySso.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[builtins.str] = None,
                 client_secret: Optional[builtins.str] = None,
                 issuer_uri: Optional[builtins.str] = None,
                 scopes: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str client_id: The public identifier for the application.
        :param builtins.str client_secret: The secret known only to the application and the authorization server.
        :param builtins.str issuer_uri: The URI of Issuer Identifier.
        :param Sequence[builtins.str] scopes: It defines the specific actions applications can be allowed to do on a user's behalf.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if issuer_uri is not None:
            pulumi.set(__self__, "issuer_uri", issuer_uri)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        """
        The public identifier for the application.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[builtins.str]:
        """
        The secret known only to the application and the authorization server.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="issuerUri")
    def issuer_uri(self) -> Optional[builtins.str]:
        """
        The URI of Issuer Identifier.
        """
        return pulumi.get(self, "issuer_uri")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[builtins.str]]:
        """
        It defines the specific actions applications can be allowed to do on a user's behalf.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class SpringCloudJavaDeploymentQuota(dict):
    def __init__(__self__, *,
                 cpu: Optional[builtins.str] = None,
                 memory: Optional[builtins.str] = None):
        """
        :param builtins.str cpu: Specifies the required cpu of the Spring Cloud Deployment. Possible Values are `500m`, `1`, `2`, `3` and `4`. Defaults to `1` if not specified.
               
               > **Note:** `cpu` supports `500m` and `1` for Basic tier, `500m`, `1`, `2`, `3` and `4` for Standard tier.
        :param builtins.str memory: Specifies the required memory size of the Spring Cloud Deployment. Possible Values are `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi`. Defaults to `1Gi` if not specified.
               
               > **Note:** `memory` supports `512Mi`, `1Gi` and `2Gi` for Basic tier, `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi` for Standard tier.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.str]:
        """
        Specifies the required cpu of the Spring Cloud Deployment. Possible Values are `500m`, `1`, `2`, `3` and `4`. Defaults to `1` if not specified.

        > **Note:** `cpu` supports `500m` and `1` for Basic tier, `500m`, `1`, `2`, `3` and `4` for Standard tier.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.str]:
        """
        Specifies the required memory size of the Spring Cloud Deployment. Possible Values are `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi`. Defaults to `1Gi` if not specified.

        > **Note:** `memory` supports `512Mi`, `1Gi` and `2Gi` for Basic tier, `512Mi`, `1Gi`, `2Gi`, `3Gi`, `4Gi`, `5Gi`, `6Gi`, `7Gi`, and `8Gi` for Standard tier.
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class SpringCloudServiceConfigServerGitSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpBasicAuth":
            suggest = "http_basic_auth"
        elif key == "searchPaths":
            suggest = "search_paths"
        elif key == "sshAuth":
            suggest = "ssh_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudServiceConfigServerGitSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudServiceConfigServerGitSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudServiceConfigServerGitSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: builtins.str,
                 http_basic_auth: Optional['outputs.SpringCloudServiceConfigServerGitSettingHttpBasicAuth'] = None,
                 label: Optional[builtins.str] = None,
                 repositories: Optional[Sequence['outputs.SpringCloudServiceConfigServerGitSettingRepository']] = None,
                 search_paths: Optional[Sequence[builtins.str]] = None,
                 ssh_auth: Optional['outputs.SpringCloudServiceConfigServerGitSettingSshAuth'] = None):
        """
        :param builtins.str uri: The URI of the default Git repository used as the Config Server back end, should be started with `http://`, `https://`, `git@`, or `ssh://`.
        :param 'SpringCloudServiceConfigServerGitSettingHttpBasicAuthArgs' http_basic_auth: A `http_basic_auth` block as defined below.
        :param builtins.str label: The default label of the Git repository, should be the branch name, tag name, or commit-id of the repository.
        :param Sequence['SpringCloudServiceConfigServerGitSettingRepositoryArgs'] repositories: One or more `repository` blocks as defined below.
        :param Sequence[builtins.str] search_paths: An array of strings used to search subdirectories of the Git repository.
        :param 'SpringCloudServiceConfigServerGitSettingSshAuthArgs' ssh_auth: A `ssh_auth` block as defined below.
        """
        pulumi.set(__self__, "uri", uri)
        if http_basic_auth is not None:
            pulumi.set(__self__, "http_basic_auth", http_basic_auth)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)
        if search_paths is not None:
            pulumi.set(__self__, "search_paths", search_paths)
        if ssh_auth is not None:
            pulumi.set(__self__, "ssh_auth", ssh_auth)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The URI of the default Git repository used as the Config Server back end, should be started with `http://`, `https://`, `git@`, or `ssh://`.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="httpBasicAuth")
    def http_basic_auth(self) -> Optional['outputs.SpringCloudServiceConfigServerGitSettingHttpBasicAuth']:
        """
        A `http_basic_auth` block as defined below.
        """
        return pulumi.get(self, "http_basic_auth")

    @property
    @pulumi.getter
    def label(self) -> Optional[builtins.str]:
        """
        The default label of the Git repository, should be the branch name, tag name, or commit-id of the repository.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def repositories(self) -> Optional[Sequence['outputs.SpringCloudServiceConfigServerGitSettingRepository']]:
        """
        One or more `repository` blocks as defined below.
        """
        return pulumi.get(self, "repositories")

    @property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> Optional[Sequence[builtins.str]]:
        """
        An array of strings used to search subdirectories of the Git repository.
        """
        return pulumi.get(self, "search_paths")

    @property
    @pulumi.getter(name="sshAuth")
    def ssh_auth(self) -> Optional['outputs.SpringCloudServiceConfigServerGitSettingSshAuth']:
        """
        A `ssh_auth` block as defined below.
        """
        return pulumi.get(self, "ssh_auth")


@pulumi.output_type
class SpringCloudServiceConfigServerGitSettingHttpBasicAuth(dict):
    def __init__(__self__, *,
                 password: builtins.str,
                 username: builtins.str):
        """
        :param builtins.str password: The password used to access the Git repository server, required when the Git repository server supports HTTP Basic Authentication.
        :param builtins.str username: The username that's used to access the Git repository server, required when the Git repository server supports HTTP Basic Authentication.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        The password used to access the Git repository server, required when the Git repository server supports HTTP Basic Authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The username that's used to access the Git repository server, required when the Git repository server supports HTTP Basic Authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SpringCloudServiceConfigServerGitSettingRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpBasicAuth":
            suggest = "http_basic_auth"
        elif key == "searchPaths":
            suggest = "search_paths"
        elif key == "sshAuth":
            suggest = "ssh_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudServiceConfigServerGitSettingRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudServiceConfigServerGitSettingRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudServiceConfigServerGitSettingRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 uri: builtins.str,
                 http_basic_auth: Optional['outputs.SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth'] = None,
                 label: Optional[builtins.str] = None,
                 patterns: Optional[Sequence[builtins.str]] = None,
                 search_paths: Optional[Sequence[builtins.str]] = None,
                 ssh_auth: Optional['outputs.SpringCloudServiceConfigServerGitSettingRepositorySshAuth'] = None):
        """
        :param builtins.str name: A name to identify on the Git repository, required only if repos exists.
        :param builtins.str uri: The URI of the Git repository that's used as the Config Server back end should be started with `http://`, `https://`, `git@`, or `ssh://`.
        :param 'SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthArgs' http_basic_auth: A `http_basic_auth` block as defined below.
        :param builtins.str label: The default label of the Git repository, should be the branch name, tag name, or commit-id of the repository.
        :param Sequence[builtins.str] patterns: An array of strings used to match an application name. For each pattern, use the `{application}/{profile}` format with wildcards.
        :param Sequence[builtins.str] search_paths: An array of strings used to search subdirectories of the Git repository.
        :param 'SpringCloudServiceConfigServerGitSettingRepositorySshAuthArgs' ssh_auth: A `ssh_auth` block as defined below.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uri", uri)
        if http_basic_auth is not None:
            pulumi.set(__self__, "http_basic_auth", http_basic_auth)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if patterns is not None:
            pulumi.set(__self__, "patterns", patterns)
        if search_paths is not None:
            pulumi.set(__self__, "search_paths", search_paths)
        if ssh_auth is not None:
            pulumi.set(__self__, "ssh_auth", ssh_auth)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A name to identify on the Git repository, required only if repos exists.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The URI of the Git repository that's used as the Config Server back end should be started with `http://`, `https://`, `git@`, or `ssh://`.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="httpBasicAuth")
    def http_basic_auth(self) -> Optional['outputs.SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth']:
        """
        A `http_basic_auth` block as defined below.
        """
        return pulumi.get(self, "http_basic_auth")

    @property
    @pulumi.getter
    def label(self) -> Optional[builtins.str]:
        """
        The default label of the Git repository, should be the branch name, tag name, or commit-id of the repository.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def patterns(self) -> Optional[Sequence[builtins.str]]:
        """
        An array of strings used to match an application name. For each pattern, use the `{application}/{profile}` format with wildcards.
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> Optional[Sequence[builtins.str]]:
        """
        An array of strings used to search subdirectories of the Git repository.
        """
        return pulumi.get(self, "search_paths")

    @property
    @pulumi.getter(name="sshAuth")
    def ssh_auth(self) -> Optional['outputs.SpringCloudServiceConfigServerGitSettingRepositorySshAuth']:
        """
        A `ssh_auth` block as defined below.
        """
        return pulumi.get(self, "ssh_auth")


@pulumi.output_type
class SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth(dict):
    def __init__(__self__, *,
                 password: builtins.str,
                 username: builtins.str):
        """
        :param builtins.str password: The password used to access the Git repository server, required when the Git repository server supports HTTP Basic Authentication.
        :param builtins.str username: The username that's used to access the Git repository server, required when the Git repository server supports HTTP Basic Authentication.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        The password used to access the Git repository server, required when the Git repository server supports HTTP Basic Authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The username that's used to access the Git repository server, required when the Git repository server supports HTTP Basic Authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SpringCloudServiceConfigServerGitSettingRepositorySshAuth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"
        elif key == "hostKey":
            suggest = "host_key"
        elif key == "hostKeyAlgorithm":
            suggest = "host_key_algorithm"
        elif key == "strictHostKeyCheckingEnabled":
            suggest = "strict_host_key_checking_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudServiceConfigServerGitSettingRepositorySshAuth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudServiceConfigServerGitSettingRepositorySshAuth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudServiceConfigServerGitSettingRepositorySshAuth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_key: builtins.str,
                 host_key: Optional[builtins.str] = None,
                 host_key_algorithm: Optional[builtins.str] = None,
                 strict_host_key_checking_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str private_key: The SSH private key to access the Git repository, required when the URI starts with `git@` or `ssh://`.
        :param builtins.str host_key: The host key of the Git repository server, should not include the algorithm prefix as covered by `host-key-algorithm`.
        :param builtins.str host_key_algorithm: The host key algorithm, should be `ssh-dss`, `ssh-rsa`, `ecdsa-sha2-nistp256`, `ecdsa-sha2-nistp384`, or `ecdsa-sha2-nistp521`. Required only if `host-key` exists.
        :param builtins.bool strict_host_key_checking_enabled: Indicates whether the Config Server instance will fail to start if the host_key does not match. Defaults to `true`.
        """
        pulumi.set(__self__, "private_key", private_key)
        if host_key is not None:
            pulumi.set(__self__, "host_key", host_key)
        if host_key_algorithm is not None:
            pulumi.set(__self__, "host_key_algorithm", host_key_algorithm)
        if strict_host_key_checking_enabled is not None:
            pulumi.set(__self__, "strict_host_key_checking_enabled", strict_host_key_checking_enabled)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> builtins.str:
        """
        The SSH private key to access the Git repository, required when the URI starts with `git@` or `ssh://`.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="hostKey")
    def host_key(self) -> Optional[builtins.str]:
        """
        The host key of the Git repository server, should not include the algorithm prefix as covered by `host-key-algorithm`.
        """
        return pulumi.get(self, "host_key")

    @property
    @pulumi.getter(name="hostKeyAlgorithm")
    def host_key_algorithm(self) -> Optional[builtins.str]:
        """
        The host key algorithm, should be `ssh-dss`, `ssh-rsa`, `ecdsa-sha2-nistp256`, `ecdsa-sha2-nistp384`, or `ecdsa-sha2-nistp521`. Required only if `host-key` exists.
        """
        return pulumi.get(self, "host_key_algorithm")

    @property
    @pulumi.getter(name="strictHostKeyCheckingEnabled")
    def strict_host_key_checking_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether the Config Server instance will fail to start if the host_key does not match. Defaults to `true`.
        """
        return pulumi.get(self, "strict_host_key_checking_enabled")


@pulumi.output_type
class SpringCloudServiceConfigServerGitSettingSshAuth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"
        elif key == "hostKey":
            suggest = "host_key"
        elif key == "hostKeyAlgorithm":
            suggest = "host_key_algorithm"
        elif key == "strictHostKeyCheckingEnabled":
            suggest = "strict_host_key_checking_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudServiceConfigServerGitSettingSshAuth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudServiceConfigServerGitSettingSshAuth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudServiceConfigServerGitSettingSshAuth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_key: builtins.str,
                 host_key: Optional[builtins.str] = None,
                 host_key_algorithm: Optional[builtins.str] = None,
                 strict_host_key_checking_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str private_key: The SSH private key to access the Git repository, required when the URI starts with `git@` or `ssh://`.
        :param builtins.str host_key: The host key of the Git repository server, should not include the algorithm prefix as covered by `host-key-algorithm`.
        :param builtins.str host_key_algorithm: The host key algorithm, should be `ssh-dss`, `ssh-rsa`, `ecdsa-sha2-nistp256`, `ecdsa-sha2-nistp384`, or `ecdsa-sha2-nistp521`. Required only if `host-key` exists.
        :param builtins.bool strict_host_key_checking_enabled: Indicates whether the Config Server instance will fail to start if the host_key does not match. Defaults to `true`.
        """
        pulumi.set(__self__, "private_key", private_key)
        if host_key is not None:
            pulumi.set(__self__, "host_key", host_key)
        if host_key_algorithm is not None:
            pulumi.set(__self__, "host_key_algorithm", host_key_algorithm)
        if strict_host_key_checking_enabled is not None:
            pulumi.set(__self__, "strict_host_key_checking_enabled", strict_host_key_checking_enabled)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> builtins.str:
        """
        The SSH private key to access the Git repository, required when the URI starts with `git@` or `ssh://`.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="hostKey")
    def host_key(self) -> Optional[builtins.str]:
        """
        The host key of the Git repository server, should not include the algorithm prefix as covered by `host-key-algorithm`.
        """
        return pulumi.get(self, "host_key")

    @property
    @pulumi.getter(name="hostKeyAlgorithm")
    def host_key_algorithm(self) -> Optional[builtins.str]:
        """
        The host key algorithm, should be `ssh-dss`, `ssh-rsa`, `ecdsa-sha2-nistp256`, `ecdsa-sha2-nistp384`, or `ecdsa-sha2-nistp521`. Required only if `host-key` exists.
        """
        return pulumi.get(self, "host_key_algorithm")

    @property
    @pulumi.getter(name="strictHostKeyCheckingEnabled")
    def strict_host_key_checking_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether the Config Server instance will fail to start if the host_key does not match. Defaults to `true`.
        """
        return pulumi.get(self, "strict_host_key_checking_enabled")


@pulumi.output_type
class SpringCloudServiceContainerRegistry(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 password: builtins.str,
                 server: builtins.str,
                 username: builtins.str):
        """
        :param builtins.str name: Specifies the name of the container registry.
        :param builtins.str password: Specifies the password of the container registry.
        :param builtins.str server: Specifies the login server of the container registry.
        :param builtins.str username: Specifies the username of the container registry.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name of the container registry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        Specifies the password of the container registry.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def server(self) -> builtins.str:
        """
        Specifies the login server of the container registry.
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        Specifies the username of the container registry.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SpringCloudServiceDefaultBuildService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerRegistryName":
            suggest = "container_registry_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudServiceDefaultBuildService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudServiceDefaultBuildService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudServiceDefaultBuildService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_registry_name: Optional[builtins.str] = None):
        """
        :param builtins.str container_registry_name: Specifies the name of the container registry used in the default build service.
        """
        if container_registry_name is not None:
            pulumi.set(__self__, "container_registry_name", container_registry_name)

    @property
    @pulumi.getter(name="containerRegistryName")
    def container_registry_name(self) -> Optional[builtins.str]:
        """
        Specifies the name of the container registry used in the default build service.
        """
        return pulumi.get(self, "container_registry_name")


@pulumi.output_type
class SpringCloudServiceMarketplace(dict):
    def __init__(__self__, *,
                 plan: builtins.str,
                 product: builtins.str,
                 publisher: builtins.str):
        """
        :param builtins.str plan: Specifies the plan ID of the 3rd Party Artifact that is being procured.
        :param builtins.str product: Specifies the 3rd Party artifact that is being procured.
        :param builtins.str publisher: Specifies the publisher ID of the 3rd Party Artifact that is being procured.
        """
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def plan(self) -> builtins.str:
        """
        Specifies the plan ID of the 3rd Party Artifact that is being procured.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def product(self) -> builtins.str:
        """
        Specifies the 3rd Party artifact that is being procured.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def publisher(self) -> builtins.str:
        """
        Specifies the publisher ID of the 3rd Party Artifact that is being procured.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class SpringCloudServiceNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appSubnetId":
            suggest = "app_subnet_id"
        elif key == "cidrRanges":
            suggest = "cidr_ranges"
        elif key == "serviceRuntimeSubnetId":
            suggest = "service_runtime_subnet_id"
        elif key == "appNetworkResourceGroup":
            suggest = "app_network_resource_group"
        elif key == "outboundType":
            suggest = "outbound_type"
        elif key == "readTimeoutSeconds":
            suggest = "read_timeout_seconds"
        elif key == "serviceRuntimeNetworkResourceGroup":
            suggest = "service_runtime_network_resource_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudServiceNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudServiceNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudServiceNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_subnet_id: builtins.str,
                 cidr_ranges: Sequence[builtins.str],
                 service_runtime_subnet_id: builtins.str,
                 app_network_resource_group: Optional[builtins.str] = None,
                 outbound_type: Optional[builtins.str] = None,
                 read_timeout_seconds: Optional[builtins.int] = None,
                 service_runtime_network_resource_group: Optional[builtins.str] = None):
        """
        :param builtins.str app_subnet_id: Specifies the ID of the Subnet which should host the Spring Boot Applications deployed in this Spring Cloud Service. Changing this forces a new resource to be created.
        :param Sequence[builtins.str] cidr_ranges: A list of (at least 3) CIDR ranges (at least /16) which are used to host the Spring Cloud infrastructure, which must not overlap with any existing CIDR ranges in the Subnet. Changing this forces a new resource to be created.
        :param builtins.str service_runtime_subnet_id: Specifies the ID of the Subnet where the Service Runtime components of the Spring Cloud Service will exist. Changing this forces a new resource to be created.
        :param builtins.str app_network_resource_group: Specifies the Name of the resource group containing network resources of Azure Spring Cloud Apps. Changing this forces a new resource to be created.
        :param builtins.str outbound_type: Specifies the egress traffic type of the Spring Cloud Service. Possible values are `loadBalancer` and `userDefinedRouting`. Defaults to `loadBalancer`. Changing this forces a new resource to be created.
        :param builtins.int read_timeout_seconds: Ingress read time out in seconds.
        :param builtins.str service_runtime_network_resource_group: Specifies the Name of the resource group containing network resources of Azure Spring Cloud Service Runtime. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "app_subnet_id", app_subnet_id)
        pulumi.set(__self__, "cidr_ranges", cidr_ranges)
        pulumi.set(__self__, "service_runtime_subnet_id", service_runtime_subnet_id)
        if app_network_resource_group is not None:
            pulumi.set(__self__, "app_network_resource_group", app_network_resource_group)
        if outbound_type is not None:
            pulumi.set(__self__, "outbound_type", outbound_type)
        if read_timeout_seconds is not None:
            pulumi.set(__self__, "read_timeout_seconds", read_timeout_seconds)
        if service_runtime_network_resource_group is not None:
            pulumi.set(__self__, "service_runtime_network_resource_group", service_runtime_network_resource_group)

    @property
    @pulumi.getter(name="appSubnetId")
    def app_subnet_id(self) -> builtins.str:
        """
        Specifies the ID of the Subnet which should host the Spring Boot Applications deployed in this Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "app_subnet_id")

    @property
    @pulumi.getter(name="cidrRanges")
    def cidr_ranges(self) -> Sequence[builtins.str]:
        """
        A list of (at least 3) CIDR ranges (at least /16) which are used to host the Spring Cloud infrastructure, which must not overlap with any existing CIDR ranges in the Subnet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cidr_ranges")

    @property
    @pulumi.getter(name="serviceRuntimeSubnetId")
    def service_runtime_subnet_id(self) -> builtins.str:
        """
        Specifies the ID of the Subnet where the Service Runtime components of the Spring Cloud Service will exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_runtime_subnet_id")

    @property
    @pulumi.getter(name="appNetworkResourceGroup")
    def app_network_resource_group(self) -> Optional[builtins.str]:
        """
        Specifies the Name of the resource group containing network resources of Azure Spring Cloud Apps. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "app_network_resource_group")

    @property
    @pulumi.getter(name="outboundType")
    def outbound_type(self) -> Optional[builtins.str]:
        """
        Specifies the egress traffic type of the Spring Cloud Service. Possible values are `loadBalancer` and `userDefinedRouting`. Defaults to `loadBalancer`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "outbound_type")

    @property
    @pulumi.getter(name="readTimeoutSeconds")
    def read_timeout_seconds(self) -> Optional[builtins.int]:
        """
        Ingress read time out in seconds.
        """
        return pulumi.get(self, "read_timeout_seconds")

    @property
    @pulumi.getter(name="serviceRuntimeNetworkResourceGroup")
    def service_runtime_network_resource_group(self) -> Optional[builtins.str]:
        """
        Specifies the Name of the resource group containing network resources of Azure Spring Cloud Service Runtime. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_runtime_network_resource_group")


@pulumi.output_type
class SpringCloudServiceRequiredNetworkTrafficRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudServiceRequiredNetworkTrafficRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudServiceRequiredNetworkTrafficRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudServiceRequiredNetworkTrafficRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 direction: Optional[builtins.str] = None,
                 fqdns: Optional[Sequence[builtins.str]] = None,
                 ip_addresses: Optional[Sequence[builtins.str]] = None,
                 port: Optional[builtins.int] = None,
                 protocol: Optional[builtins.str] = None):
        """
        :param builtins.str direction: The direction of required traffic. Possible values are `Inbound`, `Outbound`.
        :param Sequence[builtins.str] fqdns: The FQDN list of required traffic.
        :param Sequence[builtins.str] ip_addresses: The IP list of required traffic.
        :param builtins.int port: The port of required traffic.
        :param builtins.str protocol: The protocol of required traffic.
        """
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def direction(self) -> Optional[builtins.str]:
        """
        The direction of required traffic. Possible values are `Inbound`, `Outbound`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def fqdns(self) -> Optional[Sequence[builtins.str]]:
        """
        The FQDN list of required traffic.
        """
        return pulumi.get(self, "fqdns")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[builtins.str]]:
        """
        The IP list of required traffic.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port of required traffic.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        The protocol of required traffic.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class SpringCloudServiceTrace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "sampleRate":
            suggest = "sample_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpringCloudServiceTrace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpringCloudServiceTrace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpringCloudServiceTrace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Optional[builtins.str] = None,
                 sample_rate: Optional[builtins.float] = None):
        """
        :param builtins.str connection_string: The connection string used for Application Insights.
        :param builtins.float sample_rate: The sampling rate of Application Insights Agent. Must be between `0.0` and `100.0`. Defaults to `10.0`.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if sample_rate is not None:
            pulumi.set(__self__, "sample_rate", sample_rate)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[builtins.str]:
        """
        The connection string used for Application Insights.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> Optional[builtins.float]:
        """
        The sampling rate of Application Insights Agent. Must be between `0.0` and `100.0`. Defaults to `10.0`.
        """
        return pulumi.get(self, "sample_rate")


@pulumi.output_type
class GetSpringCloudAppIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Spring Cloud Application.
        :param builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Spring Cloud Application.
        :param builtins.str type: The Type of Managed Identity assigned to the Spring Cloud Application.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Spring Cloud Application.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Spring Cloud Application.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Type of Managed Identity assigned to the Spring Cloud Application.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetSpringCloudAppPersistentDiskResult(dict):
    def __init__(__self__, *,
                 mount_path: builtins.str,
                 size_in_gb: builtins.int):
        """
        :param builtins.str mount_path: The mount path of the persistent disk.
        :param builtins.int size_in_gb: The size of the persistent disk in GB.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "size_in_gb", size_in_gb)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> builtins.str:
        """
        The mount path of the persistent disk.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> builtins.int:
        """
        The size of the persistent disk in GB.
        """
        return pulumi.get(self, "size_in_gb")


@pulumi.output_type
class GetSpringCloudServiceConfigServerGitSettingResult(dict):
    def __init__(__self__, *,
                 http_basic_auths: Sequence['outputs.GetSpringCloudServiceConfigServerGitSettingHttpBasicAuthResult'],
                 label: builtins.str,
                 repositories: Sequence['outputs.GetSpringCloudServiceConfigServerGitSettingRepositoryResult'],
                 search_paths: Sequence[builtins.str],
                 ssh_auths: Sequence['outputs.GetSpringCloudServiceConfigServerGitSettingSshAuthResult'],
                 uri: builtins.str):
        """
        :param Sequence['GetSpringCloudServiceConfigServerGitSettingHttpBasicAuthArgs'] http_basic_auths: A `http_basic_auth` block as defined below.
        :param builtins.str label: The default label of the Git repository, which is a branch name, tag name, or commit-id of the repository
        :param Sequence['GetSpringCloudServiceConfigServerGitSettingRepositoryArgs'] repositories: One or more `repository` blocks as defined below.
        :param Sequence[builtins.str] search_paths: An array of strings used to search subdirectories of the Git repository.
        :param Sequence['GetSpringCloudServiceConfigServerGitSettingSshAuthArgs'] ssh_auths: A `ssh_auth` block as defined below.
        :param builtins.str uri: The URI of the Git repository
        """
        pulumi.set(__self__, "http_basic_auths", http_basic_auths)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "repositories", repositories)
        pulumi.set(__self__, "search_paths", search_paths)
        pulumi.set(__self__, "ssh_auths", ssh_auths)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="httpBasicAuths")
    def http_basic_auths(self) -> Sequence['outputs.GetSpringCloudServiceConfigServerGitSettingHttpBasicAuthResult']:
        """
        A `http_basic_auth` block as defined below.
        """
        return pulumi.get(self, "http_basic_auths")

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        The default label of the Git repository, which is a branch name, tag name, or commit-id of the repository
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def repositories(self) -> Sequence['outputs.GetSpringCloudServiceConfigServerGitSettingRepositoryResult']:
        """
        One or more `repository` blocks as defined below.
        """
        return pulumi.get(self, "repositories")

    @property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> Sequence[builtins.str]:
        """
        An array of strings used to search subdirectories of the Git repository.
        """
        return pulumi.get(self, "search_paths")

    @property
    @pulumi.getter(name="sshAuths")
    def ssh_auths(self) -> Sequence['outputs.GetSpringCloudServiceConfigServerGitSettingSshAuthResult']:
        """
        A `ssh_auth` block as defined below.
        """
        return pulumi.get(self, "ssh_auths")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The URI of the Git repository
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetSpringCloudServiceConfigServerGitSettingHttpBasicAuthResult(dict):
    def __init__(__self__, *,
                 password: builtins.str,
                 username: builtins.str):
        """
        :param builtins.str password: The password used to access the HTTP Basic Authentication Git repository server.
        :param builtins.str username: The username used to access the HTTP Basic Authentication Git repository server.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        The password used to access the HTTP Basic Authentication Git repository server.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The username used to access the HTTP Basic Authentication Git repository server.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetSpringCloudServiceConfigServerGitSettingRepositoryResult(dict):
    def __init__(__self__, *,
                 http_basic_auths: Sequence['outputs.GetSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthResult'],
                 label: builtins.str,
                 name: builtins.str,
                 patterns: Sequence[builtins.str],
                 search_paths: Sequence[builtins.str],
                 ssh_auths: Sequence['outputs.GetSpringCloudServiceConfigServerGitSettingRepositorySshAuthResult'],
                 uri: builtins.str):
        """
        :param Sequence['GetSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthArgs'] http_basic_auths: A `http_basic_auth` block as defined below.
        :param builtins.str label: The default label of the Git repository, which is a branch name, tag name, or commit-id of the repository
        :param builtins.str name: Specifies The name of the Spring Cloud Service resource.
        :param Sequence[builtins.str] patterns: An array of strings used to match an application name. For each pattern, use the `{application}/{profile}` format with wildcards.
        :param Sequence[builtins.str] search_paths: An array of strings used to search subdirectories of the Git repository.
        :param Sequence['GetSpringCloudServiceConfigServerGitSettingRepositorySshAuthArgs'] ssh_auths: A `ssh_auth` block as defined below.
        :param builtins.str uri: The URI of the Git repository
        """
        pulumi.set(__self__, "http_basic_auths", http_basic_auths)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "patterns", patterns)
        pulumi.set(__self__, "search_paths", search_paths)
        pulumi.set(__self__, "ssh_auths", ssh_auths)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="httpBasicAuths")
    def http_basic_auths(self) -> Sequence['outputs.GetSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthResult']:
        """
        A `http_basic_auth` block as defined below.
        """
        return pulumi.get(self, "http_basic_auths")

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        The default label of the Git repository, which is a branch name, tag name, or commit-id of the repository
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies The name of the Spring Cloud Service resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def patterns(self) -> Sequence[builtins.str]:
        """
        An array of strings used to match an application name. For each pattern, use the `{application}/{profile}` format with wildcards.
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> Sequence[builtins.str]:
        """
        An array of strings used to search subdirectories of the Git repository.
        """
        return pulumi.get(self, "search_paths")

    @property
    @pulumi.getter(name="sshAuths")
    def ssh_auths(self) -> Sequence['outputs.GetSpringCloudServiceConfigServerGitSettingRepositorySshAuthResult']:
        """
        A `ssh_auth` block as defined below.
        """
        return pulumi.get(self, "ssh_auths")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The URI of the Git repository
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthResult(dict):
    def __init__(__self__, *,
                 password: builtins.str,
                 username: builtins.str):
        """
        :param builtins.str password: The password used to access the HTTP Basic Authentication Git repository server.
        :param builtins.str username: The username used to access the HTTP Basic Authentication Git repository server.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        The password used to access the HTTP Basic Authentication Git repository server.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The username used to access the HTTP Basic Authentication Git repository server.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetSpringCloudServiceConfigServerGitSettingRepositorySshAuthResult(dict):
    def __init__(__self__, *,
                 host_key: builtins.str,
                 host_key_algorithm: builtins.str,
                 private_key: builtins.str,
                 strict_host_key_checking_enabled: builtins.bool):
        """
        :param builtins.str host_key: The host key of the Git repository server.
        :param builtins.str host_key_algorithm: The host key algorithm.
        :param builtins.str private_key: The SSH private key to access the Git repository, needed when the URI starts with `git@` or `ssh://`.
        :param builtins.bool strict_host_key_checking_enabled: Indicates whether the Config Server instance will fail to start if the host_key does not match.
        """
        pulumi.set(__self__, "host_key", host_key)
        pulumi.set(__self__, "host_key_algorithm", host_key_algorithm)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "strict_host_key_checking_enabled", strict_host_key_checking_enabled)

    @property
    @pulumi.getter(name="hostKey")
    def host_key(self) -> builtins.str:
        """
        The host key of the Git repository server.
        """
        return pulumi.get(self, "host_key")

    @property
    @pulumi.getter(name="hostKeyAlgorithm")
    def host_key_algorithm(self) -> builtins.str:
        """
        The host key algorithm.
        """
        return pulumi.get(self, "host_key_algorithm")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> builtins.str:
        """
        The SSH private key to access the Git repository, needed when the URI starts with `git@` or `ssh://`.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="strictHostKeyCheckingEnabled")
    def strict_host_key_checking_enabled(self) -> builtins.bool:
        """
        Indicates whether the Config Server instance will fail to start if the host_key does not match.
        """
        return pulumi.get(self, "strict_host_key_checking_enabled")


@pulumi.output_type
class GetSpringCloudServiceConfigServerGitSettingSshAuthResult(dict):
    def __init__(__self__, *,
                 host_key: builtins.str,
                 host_key_algorithm: builtins.str,
                 private_key: builtins.str,
                 strict_host_key_checking_enabled: builtins.bool):
        """
        :param builtins.str host_key: The host key of the Git repository server.
        :param builtins.str host_key_algorithm: The host key algorithm.
        :param builtins.str private_key: The SSH private key to access the Git repository, needed when the URI starts with `git@` or `ssh://`.
        :param builtins.bool strict_host_key_checking_enabled: Indicates whether the Config Server instance will fail to start if the host_key does not match.
        """
        pulumi.set(__self__, "host_key", host_key)
        pulumi.set(__self__, "host_key_algorithm", host_key_algorithm)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "strict_host_key_checking_enabled", strict_host_key_checking_enabled)

    @property
    @pulumi.getter(name="hostKey")
    def host_key(self) -> builtins.str:
        """
        The host key of the Git repository server.
        """
        return pulumi.get(self, "host_key")

    @property
    @pulumi.getter(name="hostKeyAlgorithm")
    def host_key_algorithm(self) -> builtins.str:
        """
        The host key algorithm.
        """
        return pulumi.get(self, "host_key_algorithm")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> builtins.str:
        """
        The SSH private key to access the Git repository, needed when the URI starts with `git@` or `ssh://`.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="strictHostKeyCheckingEnabled")
    def strict_host_key_checking_enabled(self) -> builtins.bool:
        """
        Indicates whether the Config Server instance will fail to start if the host_key does not match.
        """
        return pulumi.get(self, "strict_host_key_checking_enabled")


@pulumi.output_type
class GetSpringCloudServiceRequiredNetworkTrafficRuleResult(dict):
    def __init__(__self__, *,
                 direction: builtins.str,
                 fqdns: Sequence[builtins.str],
                 ip_addresses: Sequence[builtins.str],
                 port: builtins.int,
                 protocol: builtins.str):
        """
        :param builtins.str direction: The direction of required traffic. Possible values are `Inbound`, `Outbound`.
        :param Sequence[builtins.str] fqdns: The FQDN list of required traffic.
        :param Sequence[builtins.str] ip_addresses: The IP list of required traffic.
        :param builtins.int port: The port of required traffic.
        :param builtins.str protocol: The protocol of required traffic.
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "fqdns", fqdns)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def direction(self) -> builtins.str:
        """
        The direction of required traffic. Possible values are `Inbound`, `Outbound`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def fqdns(self) -> Sequence[builtins.str]:
        """
        The FQDN list of required traffic.
        """
        return pulumi.get(self, "fqdns")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[builtins.str]:
        """
        The IP list of required traffic.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port of required traffic.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The protocol of required traffic.
        """
        return pulumi.get(self, "protocol")


