# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpringCloudApiPortalArgs', 'SpringCloudApiPortal']

@pulumi.input_type
class SpringCloudApiPortalArgs:
    def __init__(__self__, *,
                 spring_cloud_service_id: pulumi.Input[builtins.str],
                 api_try_out_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 https_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sso: Optional[pulumi.Input['SpringCloudApiPortalSsoArgs']] = None):
        """
        The set of arguments for constructing a SpringCloudApiPortal resource.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud API Portal to be created.
        :param pulumi.Input[builtins.bool] api_try_out_enabled: Specifies whether the API try-out feature is enabled. When enabled, users can try out the API by sending requests and viewing responses in API portal.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gateway_ids: Specifies a list of Spring Cloud Gateway.
        :param pulumi.Input[builtins.bool] https_only_enabled: is only https is allowed?
        :param pulumi.Input[builtins.int] instance_count: Specifies the required instance count of the Spring Cloud API Portal. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal to be created. The only possible value is `default`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is the public network access enabled?
        :param pulumi.Input['SpringCloudApiPortalSsoArgs'] sso: A `sso` block as defined below.
        """
        pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if api_try_out_enabled is not None:
            pulumi.set(__self__, "api_try_out_enabled", api_try_out_enabled)
        if gateway_ids is not None:
            pulumi.set(__self__, "gateway_ids", gateway_ids)
        if https_only_enabled is not None:
            pulumi.set(__self__, "https_only_enabled", https_only_enabled)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud API Portal to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @property
    @pulumi.getter(name="apiTryOutEnabled")
    def api_try_out_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the API try-out feature is enabled. When enabled, users can try out the API by sending requests and viewing responses in API portal.
        """
        return pulumi.get(self, "api_try_out_enabled")

    @api_try_out_enabled.setter
    def api_try_out_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "api_try_out_enabled", value)

    @property
    @pulumi.getter(name="gatewayIds")
    def gateway_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of Spring Cloud Gateway.
        """
        return pulumi.get(self, "gateway_ids")

    @gateway_ids.setter
    def gateway_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "gateway_ids", value)

    @property
    @pulumi.getter(name="httpsOnlyEnabled")
    def https_only_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        is only https is allowed?
        """
        return pulumi.get(self, "https_only_enabled")

    @https_only_enabled.setter
    def https_only_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "https_only_enabled", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the required instance count of the Spring Cloud API Portal. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal to be created. The only possible value is `default`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the public network access enabled?
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter
    def sso(self) -> Optional[pulumi.Input['SpringCloudApiPortalSsoArgs']]:
        """
        A `sso` block as defined below.
        """
        return pulumi.get(self, "sso")

    @sso.setter
    def sso(self, value: Optional[pulumi.Input['SpringCloudApiPortalSsoArgs']]):
        pulumi.set(self, "sso", value)


@pulumi.input_type
class _SpringCloudApiPortalState:
    def __init__(__self__, *,
                 api_try_out_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 https_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 sso: Optional[pulumi.Input['SpringCloudApiPortalSsoArgs']] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudApiPortal resources.
        :param pulumi.Input[builtins.bool] api_try_out_enabled: Specifies whether the API try-out feature is enabled. When enabled, users can try out the API by sending requests and viewing responses in API portal.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gateway_ids: Specifies a list of Spring Cloud Gateway.
        :param pulumi.Input[builtins.bool] https_only_enabled: is only https is allowed?
        :param pulumi.Input[builtins.int] instance_count: Specifies the required instance count of the Spring Cloud API Portal. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal to be created. The only possible value is `default`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is the public network access enabled?
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud API Portal to be created.
        :param pulumi.Input['SpringCloudApiPortalSsoArgs'] sso: A `sso` block as defined below.
        :param pulumi.Input[builtins.str] url: TODO.
        """
        if api_try_out_enabled is not None:
            pulumi.set(__self__, "api_try_out_enabled", api_try_out_enabled)
        if gateway_ids is not None:
            pulumi.set(__self__, "gateway_ids", gateway_ids)
        if https_only_enabled is not None:
            pulumi.set(__self__, "https_only_enabled", https_only_enabled)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if spring_cloud_service_id is not None:
            pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="apiTryOutEnabled")
    def api_try_out_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the API try-out feature is enabled. When enabled, users can try out the API by sending requests and viewing responses in API portal.
        """
        return pulumi.get(self, "api_try_out_enabled")

    @api_try_out_enabled.setter
    def api_try_out_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "api_try_out_enabled", value)

    @property
    @pulumi.getter(name="gatewayIds")
    def gateway_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of Spring Cloud Gateway.
        """
        return pulumi.get(self, "gateway_ids")

    @gateway_ids.setter
    def gateway_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "gateway_ids", value)

    @property
    @pulumi.getter(name="httpsOnlyEnabled")
    def https_only_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        is only https is allowed?
        """
        return pulumi.get(self, "https_only_enabled")

    @https_only_enabled.setter
    def https_only_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "https_only_enabled", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the required instance count of the Spring Cloud API Portal. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal to be created. The only possible value is `default`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the public network access enabled?
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud API Portal to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @property
    @pulumi.getter
    def sso(self) -> Optional[pulumi.Input['SpringCloudApiPortalSsoArgs']]:
        """
        A `sso` block as defined below.
        """
        return pulumi.get(self, "sso")

    @sso.setter
    def sso(self, value: Optional[pulumi.Input['SpringCloudApiPortalSsoArgs']]):
        pulumi.set(self, "sso", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TODO.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("azure:appplatform/springCloudApiPortal:SpringCloudApiPortal")
class SpringCloudApiPortal(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_try_out_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 https_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 sso: Optional[pulumi.Input[Union['SpringCloudApiPortalSsoArgs', 'SpringCloudApiPortalSsoArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Spring Cloud API Portal.

        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudApiPortal` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_gateway = azure.appplatform.SpringCloudGateway("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id)
        example_spring_cloud_api_portal = azure.appplatform.SpringCloudApiPortal("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id,
            gateway_ids=[example_spring_cloud_gateway.id],
            https_only_enabled=False,
            public_network_access_enabled=True,
            instance_count=1,
            api_try_out_enabled=True,
            sso={
                "client_id": "test",
                "client_secret": "secret",
                "issuer_uri": "https://www.example.com/issueToken",
                "scopes": ["read"],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud API Portals can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudApiPortal:SpringCloudApiPortal example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/spring/service1/apiPortals/apiPortal1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] api_try_out_enabled: Specifies whether the API try-out feature is enabled. When enabled, users can try out the API by sending requests and viewing responses in API portal.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gateway_ids: Specifies a list of Spring Cloud Gateway.
        :param pulumi.Input[builtins.bool] https_only_enabled: is only https is allowed?
        :param pulumi.Input[builtins.int] instance_count: Specifies the required instance count of the Spring Cloud API Portal. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal to be created. The only possible value is `default`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is the public network access enabled?
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud API Portal to be created.
        :param pulumi.Input[Union['SpringCloudApiPortalSsoArgs', 'SpringCloudApiPortalSsoArgsDict']] sso: A `sso` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudApiPortalArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spring Cloud API Portal.

        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudApiPortal` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_gateway = azure.appplatform.SpringCloudGateway("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id)
        example_spring_cloud_api_portal = azure.appplatform.SpringCloudApiPortal("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id,
            gateway_ids=[example_spring_cloud_gateway.id],
            https_only_enabled=False,
            public_network_access_enabled=True,
            instance_count=1,
            api_try_out_enabled=True,
            sso={
                "client_id": "test",
                "client_secret": "secret",
                "issuer_uri": "https://www.example.com/issueToken",
                "scopes": ["read"],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud API Portals can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudApiPortal:SpringCloudApiPortal example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/spring/service1/apiPortals/apiPortal1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudApiPortalArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudApiPortalArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_try_out_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 https_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 sso: Optional[pulumi.Input[Union['SpringCloudApiPortalSsoArgs', 'SpringCloudApiPortalSsoArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudApiPortalArgs.__new__(SpringCloudApiPortalArgs)

            __props__.__dict__["api_try_out_enabled"] = api_try_out_enabled
            __props__.__dict__["gateway_ids"] = gateway_ids
            __props__.__dict__["https_only_enabled"] = https_only_enabled
            __props__.__dict__["instance_count"] = instance_count
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if spring_cloud_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_service_id'")
            __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
            __props__.__dict__["sso"] = sso
            __props__.__dict__["url"] = None
        super(SpringCloudApiPortal, __self__).__init__(
            'azure:appplatform/springCloudApiPortal:SpringCloudApiPortal',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_try_out_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            gateway_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            https_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            instance_count: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
            sso: Optional[pulumi.Input[Union['SpringCloudApiPortalSsoArgs', 'SpringCloudApiPortalSsoArgsDict']]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None) -> 'SpringCloudApiPortal':
        """
        Get an existing SpringCloudApiPortal resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] api_try_out_enabled: Specifies whether the API try-out feature is enabled. When enabled, users can try out the API by sending requests and viewing responses in API portal.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gateway_ids: Specifies a list of Spring Cloud Gateway.
        :param pulumi.Input[builtins.bool] https_only_enabled: is only https is allowed?
        :param pulumi.Input[builtins.int] instance_count: Specifies the required instance count of the Spring Cloud API Portal. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal to be created. The only possible value is `default`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is the public network access enabled?
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud API Portal to be created.
        :param pulumi.Input[Union['SpringCloudApiPortalSsoArgs', 'SpringCloudApiPortalSsoArgsDict']] sso: A `sso` block as defined below.
        :param pulumi.Input[builtins.str] url: TODO.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudApiPortalState.__new__(_SpringCloudApiPortalState)

        __props__.__dict__["api_try_out_enabled"] = api_try_out_enabled
        __props__.__dict__["gateway_ids"] = gateway_ids
        __props__.__dict__["https_only_enabled"] = https_only_enabled
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        __props__.__dict__["sso"] = sso
        __props__.__dict__["url"] = url
        return SpringCloudApiPortal(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiTryOutEnabled")
    def api_try_out_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the API try-out feature is enabled. When enabled, users can try out the API by sending requests and viewing responses in API portal.
        """
        return pulumi.get(self, "api_try_out_enabled")

    @property
    @pulumi.getter(name="gatewayIds")
    def gateway_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of Spring Cloud Gateway.
        """
        return pulumi.get(self, "gateway_ids")

    @property
    @pulumi.getter(name="httpsOnlyEnabled")
    def https_only_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        is only https is allowed?
        """
        return pulumi.get(self, "https_only_enabled")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the required instance count of the Spring Cloud API Portal. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal to be created. The only possible value is `default`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is the public network access enabled?
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud API Portal to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @property
    @pulumi.getter
    def sso(self) -> pulumi.Output[Optional['outputs.SpringCloudApiPortalSso']]:
        """
        A `sso` block as defined below.
        """
        return pulumi.get(self, "sso")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        TODO.
        """
        return pulumi.get(self, "url")

