# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SpringCloudApiPortalCustomDomainArgs', 'SpringCloudApiPortalCustomDomain']

@pulumi.input_type
class SpringCloudApiPortalCustomDomainArgs:
    def __init__(__self__, *,
                 spring_cloud_api_portal_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 thumbprint: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SpringCloudApiPortalCustomDomain resource.
        :param pulumi.Input[builtins.str] spring_cloud_api_portal_id: The ID of the Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal Domain to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud API Portal Domain. Changing this forces a new Spring Cloud API Portal Domain to be created.
        :param pulumi.Input[builtins.str] thumbprint: Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud API Portal Domain.
        """
        pulumi.set(__self__, "spring_cloud_api_portal_id", spring_cloud_api_portal_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="springCloudApiPortalId")
    def spring_cloud_api_portal_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal Domain to be created.
        """
        return pulumi.get(self, "spring_cloud_api_portal_id")

    @spring_cloud_api_portal_id.setter
    def spring_cloud_api_portal_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "spring_cloud_api_portal_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud API Portal Domain. Changing this forces a new Spring Cloud API Portal Domain to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud API Portal Domain.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class _SpringCloudApiPortalCustomDomainState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_api_portal_id: Optional[pulumi.Input[builtins.str]] = None,
                 thumbprint: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudApiPortalCustomDomain resources.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud API Portal Domain. Changing this forces a new Spring Cloud API Portal Domain to be created.
        :param pulumi.Input[builtins.str] spring_cloud_api_portal_id: The ID of the Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal Domain to be created.
        :param pulumi.Input[builtins.str] thumbprint: Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud API Portal Domain.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spring_cloud_api_portal_id is not None:
            pulumi.set(__self__, "spring_cloud_api_portal_id", spring_cloud_api_portal_id)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud API Portal Domain. Changing this forces a new Spring Cloud API Portal Domain to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="springCloudApiPortalId")
    def spring_cloud_api_portal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal Domain to be created.
        """
        return pulumi.get(self, "spring_cloud_api_portal_id")

    @spring_cloud_api_portal_id.setter
    def spring_cloud_api_portal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spring_cloud_api_portal_id", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud API Portal Domain.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.type_token("azure:appplatform/springCloudApiPortalCustomDomain:SpringCloudApiPortalCustomDomain")
class SpringCloudApiPortalCustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_api_portal_id: Optional[pulumi.Input[builtins.str]] = None,
                 thumbprint: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Spring Cloud API Portal Domain.

        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudApiPortalCustomDomain` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_gateway = azure.appplatform.SpringCloudGateway("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id)
        example_spring_cloud_api_portal = azure.appplatform.SpringCloudApiPortal("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id,
            gateway_ids=[example_spring_cloud_gateway.id])
        example_spring_cloud_api_portal_custom_domain = azure.appplatform.SpringCloudApiPortalCustomDomain("example",
            name="example.com",
            spring_cloud_api_portal_id=example_spring_cloud_api_portal.id)
        ```

        ## Import

        Spring Cloud API Portal Domains can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudApiPortalCustomDomain:SpringCloudApiPortalCustomDomain example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/spring/service1/apiPortals/apiPortal1/domains/domain1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud API Portal Domain. Changing this forces a new Spring Cloud API Portal Domain to be created.
        :param pulumi.Input[builtins.str] spring_cloud_api_portal_id: The ID of the Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal Domain to be created.
        :param pulumi.Input[builtins.str] thumbprint: Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud API Portal Domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudApiPortalCustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spring Cloud API Portal Domain.

        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudApiPortalCustomDomain` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_gateway = azure.appplatform.SpringCloudGateway("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id)
        example_spring_cloud_api_portal = azure.appplatform.SpringCloudApiPortal("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id,
            gateway_ids=[example_spring_cloud_gateway.id])
        example_spring_cloud_api_portal_custom_domain = azure.appplatform.SpringCloudApiPortalCustomDomain("example",
            name="example.com",
            spring_cloud_api_portal_id=example_spring_cloud_api_portal.id)
        ```

        ## Import

        Spring Cloud API Portal Domains can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudApiPortalCustomDomain:SpringCloudApiPortalCustomDomain example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/spring/service1/apiPortals/apiPortal1/domains/domain1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudApiPortalCustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudApiPortalCustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_api_portal_id: Optional[pulumi.Input[builtins.str]] = None,
                 thumbprint: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudApiPortalCustomDomainArgs.__new__(SpringCloudApiPortalCustomDomainArgs)

            __props__.__dict__["name"] = name
            if spring_cloud_api_portal_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_api_portal_id'")
            __props__.__dict__["spring_cloud_api_portal_id"] = spring_cloud_api_portal_id
            __props__.__dict__["thumbprint"] = thumbprint
        super(SpringCloudApiPortalCustomDomain, __self__).__init__(
            'azure:appplatform/springCloudApiPortalCustomDomain:SpringCloudApiPortalCustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            spring_cloud_api_portal_id: Optional[pulumi.Input[builtins.str]] = None,
            thumbprint: Optional[pulumi.Input[builtins.str]] = None) -> 'SpringCloudApiPortalCustomDomain':
        """
        Get an existing SpringCloudApiPortalCustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud API Portal Domain. Changing this forces a new Spring Cloud API Portal Domain to be created.
        :param pulumi.Input[builtins.str] spring_cloud_api_portal_id: The ID of the Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal Domain to be created.
        :param pulumi.Input[builtins.str] thumbprint: Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud API Portal Domain.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudApiPortalCustomDomainState.__new__(_SpringCloudApiPortalCustomDomainState)

        __props__.__dict__["name"] = name
        __props__.__dict__["spring_cloud_api_portal_id"] = spring_cloud_api_portal_id
        __props__.__dict__["thumbprint"] = thumbprint
        return SpringCloudApiPortalCustomDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Spring Cloud API Portal Domain. Changing this forces a new Spring Cloud API Portal Domain to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="springCloudApiPortalId")
    def spring_cloud_api_portal_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Spring Cloud API Portal. Changing this forces a new Spring Cloud API Portal Domain to be created.
        """
        return pulumi.get(self, "spring_cloud_api_portal_id")

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud API Portal Domain.
        """
        return pulumi.get(self, "thumbprint")

