# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SpringCloudAppCosmosDBAssociationArgs', 'SpringCloudAppCosmosDBAssociation']

@pulumi.input_type
class SpringCloudAppCosmosDBAssociationArgs:
    def __init__(__self__, *,
                 api_type: pulumi.Input[builtins.str],
                 cosmosdb_access_key: pulumi.Input[builtins.str],
                 cosmosdb_account_id: pulumi.Input[builtins.str],
                 spring_cloud_app_id: pulumi.Input[builtins.str],
                 cosmosdb_cassandra_keyspace_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_gremlin_database_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_gremlin_graph_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_mongo_database_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_sql_database_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SpringCloudAppCosmosDBAssociation resource.
        :param pulumi.Input[builtins.str] api_type: Specifies the API type which should be used when connecting to the CosmosDB Account. Possible values are `cassandra`, `gremlin`, `mongo`, `sql` or `table`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] cosmosdb_access_key: Specifies the CosmosDB Account access key.
        :param pulumi.Input[builtins.str] cosmosdb_account_id: Specifies the ID of the CosmosDB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] spring_cloud_app_id: Specifies the ID of the Spring Cloud Application where this Association is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] cosmosdb_cassandra_keyspace_name: Specifies the name of the Cassandra Keyspace which the Spring Cloud App should be associated with. Should only be set when `api_type` is `cassandra`.
        :param pulumi.Input[builtins.str] cosmosdb_gremlin_database_name: Specifies the name of the Gremlin Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        :param pulumi.Input[builtins.str] cosmosdb_gremlin_graph_name: Specifies the name of the Gremlin Graph which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        :param pulumi.Input[builtins.str] cosmosdb_mongo_database_name: Specifies the name of the Mongo Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `mongo`.
        :param pulumi.Input[builtins.str] cosmosdb_sql_database_name: Specifies the name of the SQL Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `sql`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "api_type", api_type)
        pulumi.set(__self__, "cosmosdb_access_key", cosmosdb_access_key)
        pulumi.set(__self__, "cosmosdb_account_id", cosmosdb_account_id)
        pulumi.set(__self__, "spring_cloud_app_id", spring_cloud_app_id)
        if cosmosdb_cassandra_keyspace_name is not None:
            pulumi.set(__self__, "cosmosdb_cassandra_keyspace_name", cosmosdb_cassandra_keyspace_name)
        if cosmosdb_gremlin_database_name is not None:
            pulumi.set(__self__, "cosmosdb_gremlin_database_name", cosmosdb_gremlin_database_name)
        if cosmosdb_gremlin_graph_name is not None:
            pulumi.set(__self__, "cosmosdb_gremlin_graph_name", cosmosdb_gremlin_graph_name)
        if cosmosdb_mongo_database_name is not None:
            pulumi.set(__self__, "cosmosdb_mongo_database_name", cosmosdb_mongo_database_name)
        if cosmosdb_sql_database_name is not None:
            pulumi.set(__self__, "cosmosdb_sql_database_name", cosmosdb_sql_database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="apiType")
    def api_type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the API type which should be used when connecting to the CosmosDB Account. Possible values are `cassandra`, `gremlin`, `mongo`, `sql` or `table`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_type")

    @api_type.setter
    def api_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_type", value)

    @property
    @pulumi.getter(name="cosmosdbAccessKey")
    def cosmosdb_access_key(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the CosmosDB Account access key.
        """
        return pulumi.get(self, "cosmosdb_access_key")

    @cosmosdb_access_key.setter
    def cosmosdb_access_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cosmosdb_access_key", value)

    @property
    @pulumi.getter(name="cosmosdbAccountId")
    def cosmosdb_account_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cosmosdb_account_id")

    @cosmosdb_account_id.setter
    def cosmosdb_account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cosmosdb_account_id", value)

    @property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the Spring Cloud Application where this Association is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

    @spring_cloud_app_id.setter
    def spring_cloud_app_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "spring_cloud_app_id", value)

    @property
    @pulumi.getter(name="cosmosdbCassandraKeyspaceName")
    def cosmosdb_cassandra_keyspace_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Cassandra Keyspace which the Spring Cloud App should be associated with. Should only be set when `api_type` is `cassandra`.
        """
        return pulumi.get(self, "cosmosdb_cassandra_keyspace_name")

    @cosmosdb_cassandra_keyspace_name.setter
    def cosmosdb_cassandra_keyspace_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cosmosdb_cassandra_keyspace_name", value)

    @property
    @pulumi.getter(name="cosmosdbGremlinDatabaseName")
    def cosmosdb_gremlin_database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Gremlin Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        """
        return pulumi.get(self, "cosmosdb_gremlin_database_name")

    @cosmosdb_gremlin_database_name.setter
    def cosmosdb_gremlin_database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cosmosdb_gremlin_database_name", value)

    @property
    @pulumi.getter(name="cosmosdbGremlinGraphName")
    def cosmosdb_gremlin_graph_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Gremlin Graph which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        """
        return pulumi.get(self, "cosmosdb_gremlin_graph_name")

    @cosmosdb_gremlin_graph_name.setter
    def cosmosdb_gremlin_graph_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cosmosdb_gremlin_graph_name", value)

    @property
    @pulumi.getter(name="cosmosdbMongoDatabaseName")
    def cosmosdb_mongo_database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Mongo Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `mongo`.
        """
        return pulumi.get(self, "cosmosdb_mongo_database_name")

    @cosmosdb_mongo_database_name.setter
    def cosmosdb_mongo_database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cosmosdb_mongo_database_name", value)

    @property
    @pulumi.getter(name="cosmosdbSqlDatabaseName")
    def cosmosdb_sql_database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the SQL Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `sql`.
        """
        return pulumi.get(self, "cosmosdb_sql_database_name")

    @cosmosdb_sql_database_name.setter
    def cosmosdb_sql_database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cosmosdb_sql_database_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SpringCloudAppCosmosDBAssociationState:
    def __init__(__self__, *,
                 api_type: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_cassandra_keyspace_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_gremlin_database_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_gremlin_graph_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_mongo_database_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_sql_database_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudAppCosmosDBAssociation resources.
        :param pulumi.Input[builtins.str] api_type: Specifies the API type which should be used when connecting to the CosmosDB Account. Possible values are `cassandra`, `gremlin`, `mongo`, `sql` or `table`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] cosmosdb_access_key: Specifies the CosmosDB Account access key.
        :param pulumi.Input[builtins.str] cosmosdb_account_id: Specifies the ID of the CosmosDB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] cosmosdb_cassandra_keyspace_name: Specifies the name of the Cassandra Keyspace which the Spring Cloud App should be associated with. Should only be set when `api_type` is `cassandra`.
        :param pulumi.Input[builtins.str] cosmosdb_gremlin_database_name: Specifies the name of the Gremlin Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        :param pulumi.Input[builtins.str] cosmosdb_gremlin_graph_name: Specifies the name of the Gremlin Graph which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        :param pulumi.Input[builtins.str] cosmosdb_mongo_database_name: Specifies the name of the Mongo Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `mongo`.
        :param pulumi.Input[builtins.str] cosmosdb_sql_database_name: Specifies the name of the SQL Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `sql`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] spring_cloud_app_id: Specifies the ID of the Spring Cloud Application where this Association is created. Changing this forces a new resource to be created.
        """
        if api_type is not None:
            pulumi.set(__self__, "api_type", api_type)
        if cosmosdb_access_key is not None:
            pulumi.set(__self__, "cosmosdb_access_key", cosmosdb_access_key)
        if cosmosdb_account_id is not None:
            pulumi.set(__self__, "cosmosdb_account_id", cosmosdb_account_id)
        if cosmosdb_cassandra_keyspace_name is not None:
            pulumi.set(__self__, "cosmosdb_cassandra_keyspace_name", cosmosdb_cassandra_keyspace_name)
        if cosmosdb_gremlin_database_name is not None:
            pulumi.set(__self__, "cosmosdb_gremlin_database_name", cosmosdb_gremlin_database_name)
        if cosmosdb_gremlin_graph_name is not None:
            pulumi.set(__self__, "cosmosdb_gremlin_graph_name", cosmosdb_gremlin_graph_name)
        if cosmosdb_mongo_database_name is not None:
            pulumi.set(__self__, "cosmosdb_mongo_database_name", cosmosdb_mongo_database_name)
        if cosmosdb_sql_database_name is not None:
            pulumi.set(__self__, "cosmosdb_sql_database_name", cosmosdb_sql_database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spring_cloud_app_id is not None:
            pulumi.set(__self__, "spring_cloud_app_id", spring_cloud_app_id)

    @property
    @pulumi.getter(name="apiType")
    def api_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the API type which should be used when connecting to the CosmosDB Account. Possible values are `cassandra`, `gremlin`, `mongo`, `sql` or `table`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_type")

    @api_type.setter
    def api_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_type", value)

    @property
    @pulumi.getter(name="cosmosdbAccessKey")
    def cosmosdb_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the CosmosDB Account access key.
        """
        return pulumi.get(self, "cosmosdb_access_key")

    @cosmosdb_access_key.setter
    def cosmosdb_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cosmosdb_access_key", value)

    @property
    @pulumi.getter(name="cosmosdbAccountId")
    def cosmosdb_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cosmosdb_account_id")

    @cosmosdb_account_id.setter
    def cosmosdb_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cosmosdb_account_id", value)

    @property
    @pulumi.getter(name="cosmosdbCassandraKeyspaceName")
    def cosmosdb_cassandra_keyspace_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Cassandra Keyspace which the Spring Cloud App should be associated with. Should only be set when `api_type` is `cassandra`.
        """
        return pulumi.get(self, "cosmosdb_cassandra_keyspace_name")

    @cosmosdb_cassandra_keyspace_name.setter
    def cosmosdb_cassandra_keyspace_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cosmosdb_cassandra_keyspace_name", value)

    @property
    @pulumi.getter(name="cosmosdbGremlinDatabaseName")
    def cosmosdb_gremlin_database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Gremlin Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        """
        return pulumi.get(self, "cosmosdb_gremlin_database_name")

    @cosmosdb_gremlin_database_name.setter
    def cosmosdb_gremlin_database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cosmosdb_gremlin_database_name", value)

    @property
    @pulumi.getter(name="cosmosdbGremlinGraphName")
    def cosmosdb_gremlin_graph_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Gremlin Graph which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        """
        return pulumi.get(self, "cosmosdb_gremlin_graph_name")

    @cosmosdb_gremlin_graph_name.setter
    def cosmosdb_gremlin_graph_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cosmosdb_gremlin_graph_name", value)

    @property
    @pulumi.getter(name="cosmosdbMongoDatabaseName")
    def cosmosdb_mongo_database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Mongo Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `mongo`.
        """
        return pulumi.get(self, "cosmosdb_mongo_database_name")

    @cosmosdb_mongo_database_name.setter
    def cosmosdb_mongo_database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cosmosdb_mongo_database_name", value)

    @property
    @pulumi.getter(name="cosmosdbSqlDatabaseName")
    def cosmosdb_sql_database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the SQL Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `sql`.
        """
        return pulumi.get(self, "cosmosdb_sql_database_name")

    @cosmosdb_sql_database_name.setter
    def cosmosdb_sql_database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cosmosdb_sql_database_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the Spring Cloud Application where this Association is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

    @spring_cloud_app_id.setter
    def spring_cloud_app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spring_cloud_app_id", value)


@pulumi.type_token("azure:appplatform/springCloudAppCosmosDBAssociation:SpringCloudAppCosmosDBAssociation")
class SpringCloudAppCosmosDBAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_type: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_cassandra_keyspace_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_gremlin_database_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_gremlin_graph_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_mongo_database_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_sql_database_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Associates a Spring Cloud Application with a CosmosDB Account.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudAppCosmosDBAssociation` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example-springcloud",
            resource_group_name=example.name,
            location=example.location)
        example_spring_cloud_app = azure.appplatform.SpringCloudApp("example",
            name="example-springcloudapp",
            resource_group_name=example.name,
            service_name=example_spring_cloud_service.name)
        example_account = azure.cosmosdb.Account("example",
            name="example-cosmosdb-account",
            location=example.location,
            resource_group_name=example.name,
            offer_type="Standard",
            kind="GlobalDocumentDB",
            consistency_policy={
                "consistency_level": "Strong",
            },
            geo_locations=[{
                "location": example.location,
                "failover_priority": 0,
            }])
        example_spring_cloud_app_cosmos_dbassociation = azure.appplatform.SpringCloudAppCosmosDBAssociation("example",
            name="example-bind",
            spring_cloud_app_id=example_spring_cloud_app.id,
            cosmosdb_account_id=example_account.id,
            api_type="table",
            cosmosdb_access_key=example_account.primary_key)
        ```

        ## Import

        Spring Cloud Application CosmosDB Association can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudAppCosmosDBAssociation:SpringCloudAppCosmosDBAssociation example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourcegroup1/providers/Microsoft.AppPlatform/spring/service1/apps/app1/bindings/bind1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_type: Specifies the API type which should be used when connecting to the CosmosDB Account. Possible values are `cassandra`, `gremlin`, `mongo`, `sql` or `table`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] cosmosdb_access_key: Specifies the CosmosDB Account access key.
        :param pulumi.Input[builtins.str] cosmosdb_account_id: Specifies the ID of the CosmosDB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] cosmosdb_cassandra_keyspace_name: Specifies the name of the Cassandra Keyspace which the Spring Cloud App should be associated with. Should only be set when `api_type` is `cassandra`.
        :param pulumi.Input[builtins.str] cosmosdb_gremlin_database_name: Specifies the name of the Gremlin Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        :param pulumi.Input[builtins.str] cosmosdb_gremlin_graph_name: Specifies the name of the Gremlin Graph which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        :param pulumi.Input[builtins.str] cosmosdb_mongo_database_name: Specifies the name of the Mongo Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `mongo`.
        :param pulumi.Input[builtins.str] cosmosdb_sql_database_name: Specifies the name of the SQL Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `sql`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] spring_cloud_app_id: Specifies the ID of the Spring Cloud Application where this Association is created. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudAppCosmosDBAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates a Spring Cloud Application with a CosmosDB Account.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudAppCosmosDBAssociation` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example-springcloud",
            resource_group_name=example.name,
            location=example.location)
        example_spring_cloud_app = azure.appplatform.SpringCloudApp("example",
            name="example-springcloudapp",
            resource_group_name=example.name,
            service_name=example_spring_cloud_service.name)
        example_account = azure.cosmosdb.Account("example",
            name="example-cosmosdb-account",
            location=example.location,
            resource_group_name=example.name,
            offer_type="Standard",
            kind="GlobalDocumentDB",
            consistency_policy={
                "consistency_level": "Strong",
            },
            geo_locations=[{
                "location": example.location,
                "failover_priority": 0,
            }])
        example_spring_cloud_app_cosmos_dbassociation = azure.appplatform.SpringCloudAppCosmosDBAssociation("example",
            name="example-bind",
            spring_cloud_app_id=example_spring_cloud_app.id,
            cosmosdb_account_id=example_account.id,
            api_type="table",
            cosmosdb_access_key=example_account.primary_key)
        ```

        ## Import

        Spring Cloud Application CosmosDB Association can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudAppCosmosDBAssociation:SpringCloudAppCosmosDBAssociation example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourcegroup1/providers/Microsoft.AppPlatform/spring/service1/apps/app1/bindings/bind1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudAppCosmosDBAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudAppCosmosDBAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_type: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_cassandra_keyspace_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_gremlin_database_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_gremlin_graph_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_mongo_database_name: Optional[pulumi.Input[builtins.str]] = None,
                 cosmosdb_sql_database_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudAppCosmosDBAssociationArgs.__new__(SpringCloudAppCosmosDBAssociationArgs)

            if api_type is None and not opts.urn:
                raise TypeError("Missing required property 'api_type'")
            __props__.__dict__["api_type"] = api_type
            if cosmosdb_access_key is None and not opts.urn:
                raise TypeError("Missing required property 'cosmosdb_access_key'")
            __props__.__dict__["cosmosdb_access_key"] = cosmosdb_access_key
            if cosmosdb_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'cosmosdb_account_id'")
            __props__.__dict__["cosmosdb_account_id"] = cosmosdb_account_id
            __props__.__dict__["cosmosdb_cassandra_keyspace_name"] = cosmosdb_cassandra_keyspace_name
            __props__.__dict__["cosmosdb_gremlin_database_name"] = cosmosdb_gremlin_database_name
            __props__.__dict__["cosmosdb_gremlin_graph_name"] = cosmosdb_gremlin_graph_name
            __props__.__dict__["cosmosdb_mongo_database_name"] = cosmosdb_mongo_database_name
            __props__.__dict__["cosmosdb_sql_database_name"] = cosmosdb_sql_database_name
            __props__.__dict__["name"] = name
            if spring_cloud_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_app_id'")
            __props__.__dict__["spring_cloud_app_id"] = spring_cloud_app_id
        super(SpringCloudAppCosmosDBAssociation, __self__).__init__(
            'azure:appplatform/springCloudAppCosmosDBAssociation:SpringCloudAppCosmosDBAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_type: Optional[pulumi.Input[builtins.str]] = None,
            cosmosdb_access_key: Optional[pulumi.Input[builtins.str]] = None,
            cosmosdb_account_id: Optional[pulumi.Input[builtins.str]] = None,
            cosmosdb_cassandra_keyspace_name: Optional[pulumi.Input[builtins.str]] = None,
            cosmosdb_gremlin_database_name: Optional[pulumi.Input[builtins.str]] = None,
            cosmosdb_gremlin_graph_name: Optional[pulumi.Input[builtins.str]] = None,
            cosmosdb_mongo_database_name: Optional[pulumi.Input[builtins.str]] = None,
            cosmosdb_sql_database_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            spring_cloud_app_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SpringCloudAppCosmosDBAssociation':
        """
        Get an existing SpringCloudAppCosmosDBAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_type: Specifies the API type which should be used when connecting to the CosmosDB Account. Possible values are `cassandra`, `gremlin`, `mongo`, `sql` or `table`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] cosmosdb_access_key: Specifies the CosmosDB Account access key.
        :param pulumi.Input[builtins.str] cosmosdb_account_id: Specifies the ID of the CosmosDB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] cosmosdb_cassandra_keyspace_name: Specifies the name of the Cassandra Keyspace which the Spring Cloud App should be associated with. Should only be set when `api_type` is `cassandra`.
        :param pulumi.Input[builtins.str] cosmosdb_gremlin_database_name: Specifies the name of the Gremlin Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        :param pulumi.Input[builtins.str] cosmosdb_gremlin_graph_name: Specifies the name of the Gremlin Graph which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        :param pulumi.Input[builtins.str] cosmosdb_mongo_database_name: Specifies the name of the Mongo Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `mongo`.
        :param pulumi.Input[builtins.str] cosmosdb_sql_database_name: Specifies the name of the SQL Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `sql`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] spring_cloud_app_id: Specifies the ID of the Spring Cloud Application where this Association is created. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudAppCosmosDBAssociationState.__new__(_SpringCloudAppCosmosDBAssociationState)

        __props__.__dict__["api_type"] = api_type
        __props__.__dict__["cosmosdb_access_key"] = cosmosdb_access_key
        __props__.__dict__["cosmosdb_account_id"] = cosmosdb_account_id
        __props__.__dict__["cosmosdb_cassandra_keyspace_name"] = cosmosdb_cassandra_keyspace_name
        __props__.__dict__["cosmosdb_gremlin_database_name"] = cosmosdb_gremlin_database_name
        __props__.__dict__["cosmosdb_gremlin_graph_name"] = cosmosdb_gremlin_graph_name
        __props__.__dict__["cosmosdb_mongo_database_name"] = cosmosdb_mongo_database_name
        __props__.__dict__["cosmosdb_sql_database_name"] = cosmosdb_sql_database_name
        __props__.__dict__["name"] = name
        __props__.__dict__["spring_cloud_app_id"] = spring_cloud_app_id
        return SpringCloudAppCosmosDBAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiType")
    def api_type(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the API type which should be used when connecting to the CosmosDB Account. Possible values are `cassandra`, `gremlin`, `mongo`, `sql` or `table`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_type")

    @property
    @pulumi.getter(name="cosmosdbAccessKey")
    def cosmosdb_access_key(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the CosmosDB Account access key.
        """
        return pulumi.get(self, "cosmosdb_access_key")

    @property
    @pulumi.getter(name="cosmosdbAccountId")
    def cosmosdb_account_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cosmosdb_account_id")

    @property
    @pulumi.getter(name="cosmosdbCassandraKeyspaceName")
    def cosmosdb_cassandra_keyspace_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the name of the Cassandra Keyspace which the Spring Cloud App should be associated with. Should only be set when `api_type` is `cassandra`.
        """
        return pulumi.get(self, "cosmosdb_cassandra_keyspace_name")

    @property
    @pulumi.getter(name="cosmosdbGremlinDatabaseName")
    def cosmosdb_gremlin_database_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the name of the Gremlin Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        """
        return pulumi.get(self, "cosmosdb_gremlin_database_name")

    @property
    @pulumi.getter(name="cosmosdbGremlinGraphName")
    def cosmosdb_gremlin_graph_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the name of the Gremlin Graph which the Spring Cloud App should be associated with. Should only be set when `api_type` is `gremlin`.
        """
        return pulumi.get(self, "cosmosdb_gremlin_graph_name")

    @property
    @pulumi.getter(name="cosmosdbMongoDatabaseName")
    def cosmosdb_mongo_database_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the name of the Mongo Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `mongo`.
        """
        return pulumi.get(self, "cosmosdb_mongo_database_name")

    @property
    @pulumi.getter(name="cosmosdbSqlDatabaseName")
    def cosmosdb_sql_database_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the name of the SQL Database which the Spring Cloud App should be associated with. Should only be set when `api_type` is `sql`.
        """
        return pulumi.get(self, "cosmosdb_sql_database_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the Spring Cloud Application where this Association is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

