# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SpringCloudAppRedisAssociationArgs', 'SpringCloudAppRedisAssociation']

@pulumi.input_type
class SpringCloudAppRedisAssociationArgs:
    def __init__(__self__, *,
                 redis_access_key: pulumi.Input[builtins.str],
                 redis_cache_id: pulumi.Input[builtins.str],
                 spring_cloud_app_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a SpringCloudAppRedisAssociation resource.
        :param pulumi.Input[builtins.str] redis_access_key: Specifies the Redis Cache access key.
        :param pulumi.Input[builtins.str] redis_cache_id: Specifies the Redis Cache resource ID. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] spring_cloud_app_id: Specifies the Spring Cloud Application resource ID in which the Association is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] ssl_enabled: Should SSL be used when connecting to Redis? Defaults to `true`.
        """
        pulumi.set(__self__, "redis_access_key", redis_access_key)
        pulumi.set(__self__, "redis_cache_id", redis_cache_id)
        pulumi.set(__self__, "spring_cloud_app_id", spring_cloud_app_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)

    @property
    @pulumi.getter(name="redisAccessKey")
    def redis_access_key(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Redis Cache access key.
        """
        return pulumi.get(self, "redis_access_key")

    @redis_access_key.setter
    def redis_access_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "redis_access_key", value)

    @property
    @pulumi.getter(name="redisCacheId")
    def redis_cache_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Redis Cache resource ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "redis_cache_id")

    @redis_cache_id.setter
    def redis_cache_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "redis_cache_id", value)

    @property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Spring Cloud Application resource ID in which the Association is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

    @spring_cloud_app_id.setter
    def spring_cloud_app_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "spring_cloud_app_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should SSL be used when connecting to Redis? Defaults to `true`.
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ssl_enabled", value)


@pulumi.input_type
class _SpringCloudAppRedisAssociationState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redis_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 redis_cache_id: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SpringCloudAppRedisAssociation resources.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] redis_access_key: Specifies the Redis Cache access key.
        :param pulumi.Input[builtins.str] redis_cache_id: Specifies the Redis Cache resource ID. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] spring_cloud_app_id: Specifies the Spring Cloud Application resource ID in which the Association is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] ssl_enabled: Should SSL be used when connecting to Redis? Defaults to `true`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redis_access_key is not None:
            pulumi.set(__self__, "redis_access_key", redis_access_key)
        if redis_cache_id is not None:
            pulumi.set(__self__, "redis_cache_id", redis_cache_id)
        if spring_cloud_app_id is not None:
            pulumi.set(__self__, "spring_cloud_app_id", spring_cloud_app_id)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redisAccessKey")
    def redis_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Redis Cache access key.
        """
        return pulumi.get(self, "redis_access_key")

    @redis_access_key.setter
    def redis_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redis_access_key", value)

    @property
    @pulumi.getter(name="redisCacheId")
    def redis_cache_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Redis Cache resource ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "redis_cache_id")

    @redis_cache_id.setter
    def redis_cache_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redis_cache_id", value)

    @property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Spring Cloud Application resource ID in which the Association is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

    @spring_cloud_app_id.setter
    def spring_cloud_app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spring_cloud_app_id", value)

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should SSL be used when connecting to Redis? Defaults to `true`.
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ssl_enabled", value)


@pulumi.type_token("azure:appplatform/springCloudAppRedisAssociation:SpringCloudAppRedisAssociation")
class SpringCloudAppRedisAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redis_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 redis_cache_id: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Associates a Spring Cloud Application with a Redis Cache.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudAppRedisAssociation` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Import

        Spring Cloud Application Redis Association can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudAppRedisAssociation:SpringCloudAppRedisAssociation example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.AppPlatform/spring/myservice/apps/myapp/bindings/bind1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] redis_access_key: Specifies the Redis Cache access key.
        :param pulumi.Input[builtins.str] redis_cache_id: Specifies the Redis Cache resource ID. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] spring_cloud_app_id: Specifies the Spring Cloud Application resource ID in which the Association is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] ssl_enabled: Should SSL be used when connecting to Redis? Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudAppRedisAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates a Spring Cloud Application with a Redis Cache.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudAppRedisAssociation` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Import

        Spring Cloud Application Redis Association can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudAppRedisAssociation:SpringCloudAppRedisAssociation example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.AppPlatform/spring/myservice/apps/myapp/bindings/bind1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudAppRedisAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudAppRedisAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redis_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 redis_cache_id: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudAppRedisAssociationArgs.__new__(SpringCloudAppRedisAssociationArgs)

            __props__.__dict__["name"] = name
            if redis_access_key is None and not opts.urn:
                raise TypeError("Missing required property 'redis_access_key'")
            __props__.__dict__["redis_access_key"] = redis_access_key
            if redis_cache_id is None and not opts.urn:
                raise TypeError("Missing required property 'redis_cache_id'")
            __props__.__dict__["redis_cache_id"] = redis_cache_id
            if spring_cloud_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_app_id'")
            __props__.__dict__["spring_cloud_app_id"] = spring_cloud_app_id
            __props__.__dict__["ssl_enabled"] = ssl_enabled
        super(SpringCloudAppRedisAssociation, __self__).__init__(
            'azure:appplatform/springCloudAppRedisAssociation:SpringCloudAppRedisAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            redis_access_key: Optional[pulumi.Input[builtins.str]] = None,
            redis_cache_id: Optional[pulumi.Input[builtins.str]] = None,
            spring_cloud_app_id: Optional[pulumi.Input[builtins.str]] = None,
            ssl_enabled: Optional[pulumi.Input[builtins.bool]] = None) -> 'SpringCloudAppRedisAssociation':
        """
        Get an existing SpringCloudAppRedisAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] redis_access_key: Specifies the Redis Cache access key.
        :param pulumi.Input[builtins.str] redis_cache_id: Specifies the Redis Cache resource ID. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] spring_cloud_app_id: Specifies the Spring Cloud Application resource ID in which the Association is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] ssl_enabled: Should SSL be used when connecting to Redis? Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudAppRedisAssociationState.__new__(_SpringCloudAppRedisAssociationState)

        __props__.__dict__["name"] = name
        __props__.__dict__["redis_access_key"] = redis_access_key
        __props__.__dict__["redis_cache_id"] = redis_cache_id
        __props__.__dict__["spring_cloud_app_id"] = spring_cloud_app_id
        __props__.__dict__["ssl_enabled"] = ssl_enabled
        return SpringCloudAppRedisAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Spring Cloud Application Association. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="redisAccessKey")
    def redis_access_key(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Redis Cache access key.
        """
        return pulumi.get(self, "redis_access_key")

    @property
    @pulumi.getter(name="redisCacheId")
    def redis_cache_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Redis Cache resource ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "redis_cache_id")

    @property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Spring Cloud Application resource ID in which the Association is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should SSL be used when connecting to Redis? Defaults to `true`.
        """
        return pulumi.get(self, "ssl_enabled")

