# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SpringCloudApplicationInsightsApplicationPerformanceMonitoringArgs', 'SpringCloudApplicationInsightsApplicationPerformanceMonitoring']

@pulumi.input_type
class SpringCloudApplicationInsightsApplicationPerformanceMonitoringArgs:
    def __init__(__self__, *,
                 spring_cloud_service_id: pulumi.Input[builtins.str],
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 globally_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role_instance: Optional[pulumi.Input[builtins.str]] = None,
                 role_name: Optional[pulumi.Input[builtins.str]] = None,
                 sampling_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 sampling_requests_per_second: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a SpringCloudApplicationInsightsApplicationPerformanceMonitoring resource.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] connection_string: The instrumentation key used to push data to Application Insights.
        :param pulumi.Input[builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for Application Insights. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] role_instance: Specifies the cloud role instance.
        :param pulumi.Input[builtins.str] role_name: Specifies the cloud role name used to label the component on the application map.
        :param pulumi.Input[builtins.int] sampling_percentage: Specifies the percentage for fixed-percentage sampling.
        :param pulumi.Input[builtins.int] sampling_requests_per_second: Specifies the number of requests per second for the rate-limited sampling.
        """
        pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if globally_enabled is not None:
            pulumi.set(__self__, "globally_enabled", globally_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_instance is not None:
            pulumi.set(__self__, "role_instance", role_instance)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if sampling_percentage is not None:
            pulumi.set(__self__, "sampling_percentage", sampling_percentage)
        if sampling_requests_per_second is not None:
            pulumi.set(__self__, "sampling_requests_per_second", sampling_requests_per_second)

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instrumentation key used to push data to Application Insights.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @globally_enabled.setter
    def globally_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "globally_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for Application Insights. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleInstance")
    def role_instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the cloud role instance.
        """
        return pulumi.get(self, "role_instance")

    @role_instance.setter
    def role_instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_instance", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the cloud role name used to label the component on the application map.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the percentage for fixed-percentage sampling.
        """
        return pulumi.get(self, "sampling_percentage")

    @sampling_percentage.setter
    def sampling_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sampling_percentage", value)

    @property
    @pulumi.getter(name="samplingRequestsPerSecond")
    def sampling_requests_per_second(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of requests per second for the rate-limited sampling.
        """
        return pulumi.get(self, "sampling_requests_per_second")

    @sampling_requests_per_second.setter
    def sampling_requests_per_second(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sampling_requests_per_second", value)


@pulumi.input_type
class _SpringCloudApplicationInsightsApplicationPerformanceMonitoringState:
    def __init__(__self__, *,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 globally_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role_instance: Optional[pulumi.Input[builtins.str]] = None,
                 role_name: Optional[pulumi.Input[builtins.str]] = None,
                 sampling_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 sampling_requests_per_second: Optional[pulumi.Input[builtins.int]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudApplicationInsightsApplicationPerformanceMonitoring resources.
        :param pulumi.Input[builtins.str] connection_string: The instrumentation key used to push data to Application Insights.
        :param pulumi.Input[builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for Application Insights. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] role_instance: Specifies the cloud role instance.
        :param pulumi.Input[builtins.str] role_name: Specifies the cloud role name used to label the component on the application map.
        :param pulumi.Input[builtins.int] sampling_percentage: Specifies the percentage for fixed-percentage sampling.
        :param pulumi.Input[builtins.int] sampling_requests_per_second: Specifies the number of requests per second for the rate-limited sampling.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if globally_enabled is not None:
            pulumi.set(__self__, "globally_enabled", globally_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_instance is not None:
            pulumi.set(__self__, "role_instance", role_instance)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if sampling_percentage is not None:
            pulumi.set(__self__, "sampling_percentage", sampling_percentage)
        if sampling_requests_per_second is not None:
            pulumi.set(__self__, "sampling_requests_per_second", sampling_requests_per_second)
        if spring_cloud_service_id is not None:
            pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instrumentation key used to push data to Application Insights.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @globally_enabled.setter
    def globally_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "globally_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for Application Insights. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleInstance")
    def role_instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the cloud role instance.
        """
        return pulumi.get(self, "role_instance")

    @role_instance.setter
    def role_instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_instance", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the cloud role name used to label the component on the application map.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the percentage for fixed-percentage sampling.
        """
        return pulumi.get(self, "sampling_percentage")

    @sampling_percentage.setter
    def sampling_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sampling_percentage", value)

    @property
    @pulumi.getter(name="samplingRequestsPerSecond")
    def sampling_requests_per_second(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of requests per second for the rate-limited sampling.
        """
        return pulumi.get(self, "sampling_requests_per_second")

    @sampling_requests_per_second.setter
    def sampling_requests_per_second(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sampling_requests_per_second", value)

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spring_cloud_service_id", value)


@pulumi.type_token("azure:appplatform/springCloudApplicationInsightsApplicationPerformanceMonitoring:SpringCloudApplicationInsightsApplicationPerformanceMonitoring")
class SpringCloudApplicationInsightsApplicationPerformanceMonitoring(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 globally_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role_instance: Optional[pulumi.Input[builtins.str]] = None,
                 role_name: Optional[pulumi.Input[builtins.str]] = None,
                 sampling_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 sampling_requests_per_second: Optional[pulumi.Input[builtins.int]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > **Note:** This resource is only applicable for Spring Cloud Service enterprise tier

        Manages a Spring Cloud Application Performance Monitoring resource for Application Insights.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudApplicationInsightsApplicationPerformanceMonitoring` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_application_insights_application_performance_monitoring = azure.appplatform.SpringCloudApplicationInsightsApplicationPerformanceMonitoring("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            connection_string=example_insights.instrumentation_key,
            globally_enabled=True,
            role_name="test-role",
            role_instance="test-instance",
            sampling_percentage=50,
            sampling_requests_per_second=10)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud Application Performance Monitoring resource for Application Insights can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudApplicationInsightsApplicationPerformanceMonitoring:SpringCloudApplicationInsightsApplicationPerformanceMonitoring example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AppPlatform/spring/service1/apms/apm1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] connection_string: The instrumentation key used to push data to Application Insights.
        :param pulumi.Input[builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for Application Insights. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] role_instance: Specifies the cloud role instance.
        :param pulumi.Input[builtins.str] role_name: Specifies the cloud role name used to label the component on the application map.
        :param pulumi.Input[builtins.int] sampling_percentage: Specifies the percentage for fixed-percentage sampling.
        :param pulumi.Input[builtins.int] sampling_requests_per_second: Specifies the number of requests per second for the rate-limited sampling.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudApplicationInsightsApplicationPerformanceMonitoringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Note:** This resource is only applicable for Spring Cloud Service enterprise tier

        Manages a Spring Cloud Application Performance Monitoring resource for Application Insights.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudApplicationInsightsApplicationPerformanceMonitoring` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_application_insights_application_performance_monitoring = azure.appplatform.SpringCloudApplicationInsightsApplicationPerformanceMonitoring("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            connection_string=example_insights.instrumentation_key,
            globally_enabled=True,
            role_name="test-role",
            role_instance="test-instance",
            sampling_percentage=50,
            sampling_requests_per_second=10)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud Application Performance Monitoring resource for Application Insights can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudApplicationInsightsApplicationPerformanceMonitoring:SpringCloudApplicationInsightsApplicationPerformanceMonitoring example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AppPlatform/spring/service1/apms/apm1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudApplicationInsightsApplicationPerformanceMonitoringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudApplicationInsightsApplicationPerformanceMonitoringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 globally_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role_instance: Optional[pulumi.Input[builtins.str]] = None,
                 role_name: Optional[pulumi.Input[builtins.str]] = None,
                 sampling_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 sampling_requests_per_second: Optional[pulumi.Input[builtins.int]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudApplicationInsightsApplicationPerformanceMonitoringArgs.__new__(SpringCloudApplicationInsightsApplicationPerformanceMonitoringArgs)

            __props__.__dict__["connection_string"] = connection_string
            __props__.__dict__["globally_enabled"] = globally_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["role_instance"] = role_instance
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["sampling_percentage"] = sampling_percentage
            __props__.__dict__["sampling_requests_per_second"] = sampling_requests_per_second
            if spring_cloud_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_service_id'")
            __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        super(SpringCloudApplicationInsightsApplicationPerformanceMonitoring, __self__).__init__(
            'azure:appplatform/springCloudApplicationInsightsApplicationPerformanceMonitoring:SpringCloudApplicationInsightsApplicationPerformanceMonitoring',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_string: Optional[pulumi.Input[builtins.str]] = None,
            globally_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            role_instance: Optional[pulumi.Input[builtins.str]] = None,
            role_name: Optional[pulumi.Input[builtins.str]] = None,
            sampling_percentage: Optional[pulumi.Input[builtins.int]] = None,
            sampling_requests_per_second: Optional[pulumi.Input[builtins.int]] = None,
            spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SpringCloudApplicationInsightsApplicationPerformanceMonitoring':
        """
        Get an existing SpringCloudApplicationInsightsApplicationPerformanceMonitoring resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] connection_string: The instrumentation key used to push data to Application Insights.
        :param pulumi.Input[builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for Application Insights. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] role_instance: Specifies the cloud role instance.
        :param pulumi.Input[builtins.str] role_name: Specifies the cloud role name used to label the component on the application map.
        :param pulumi.Input[builtins.int] sampling_percentage: Specifies the percentage for fixed-percentage sampling.
        :param pulumi.Input[builtins.int] sampling_requests_per_second: Specifies the number of requests per second for the rate-limited sampling.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudApplicationInsightsApplicationPerformanceMonitoringState.__new__(_SpringCloudApplicationInsightsApplicationPerformanceMonitoringState)

        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["globally_enabled"] = globally_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["role_instance"] = role_instance
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["sampling_percentage"] = sampling_percentage
        __props__.__dict__["sampling_requests_per_second"] = sampling_requests_per_second
        __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        return SpringCloudApplicationInsightsApplicationPerformanceMonitoring(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The instrumentation key used to push data to Application Insights.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for Application Insights. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleInstance")
    def role_instance(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the cloud role instance.
        """
        return pulumi.get(self, "role_instance")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the cloud role name used to label the component on the application map.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the percentage for fixed-percentage sampling.
        """
        return pulumi.get(self, "sampling_percentage")

    @property
    @pulumi.getter(name="samplingRequestsPerSecond")
    def sampling_requests_per_second(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the number of requests per second for the rate-limited sampling.
        """
        return pulumi.get(self, "sampling_requests_per_second")

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

