# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpringCloudBuildDeploymentArgs', 'SpringCloudBuildDeployment']

@pulumi.input_type
class SpringCloudBuildDeploymentArgs:
    def __init__(__self__, *,
                 build_result_id: pulumi.Input[builtins.str],
                 spring_cloud_app_id: pulumi.Input[builtins.str],
                 addon_json: Optional[pulumi.Input[builtins.str]] = None,
                 application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 quota: Optional[pulumi.Input['SpringCloudBuildDeploymentQuotaArgs']] = None):
        """
        The set of arguments for constructing a SpringCloudBuildDeployment resource.
        :param pulumi.Input[builtins.str] build_result_id: The ID of the Spring Cloud Build Result.
        :param pulumi.Input[builtins.str] spring_cloud_app_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Build Deployment to be created.
        :param pulumi.Input[builtins.str] addon_json: A JSON object that contains the addon configurations of the Spring Cloud Build Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] application_performance_monitoring_ids: Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        :param pulumi.Input[builtins.int] instance_count: Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Build Deployment. Changing this forces a new Spring Cloud Build Deployment to be created.
        :param pulumi.Input['SpringCloudBuildDeploymentQuotaArgs'] quota: A `quota` block as defined below.
        """
        pulumi.set(__self__, "build_result_id", build_result_id)
        pulumi.set(__self__, "spring_cloud_app_id", spring_cloud_app_id)
        if addon_json is not None:
            pulumi.set(__self__, "addon_json", addon_json)
        if application_performance_monitoring_ids is not None:
            pulumi.set(__self__, "application_performance_monitoring_ids", application_performance_monitoring_ids)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)

    @property
    @pulumi.getter(name="buildResultId")
    def build_result_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Spring Cloud Build Result.
        """
        return pulumi.get(self, "build_result_id")

    @build_result_id.setter
    def build_result_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "build_result_id", value)

    @property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Build Deployment to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

    @spring_cloud_app_id.setter
    def spring_cloud_app_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "spring_cloud_app_id", value)

    @property
    @pulumi.getter(name="addonJson")
    def addon_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A JSON object that contains the addon configurations of the Spring Cloud Build Deployment.
        """
        return pulumi.get(self, "addon_json")

    @addon_json.setter
    def addon_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "addon_json", value)

    @property
    @pulumi.getter(name="applicationPerformanceMonitoringIds")
    def application_performance_monitoring_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        """
        return pulumi.get(self, "application_performance_monitoring_ids")

    @application_performance_monitoring_ids.setter
    def application_performance_monitoring_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "application_performance_monitoring_ids", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud Build Deployment. Changing this forces a new Spring Cloud Build Deployment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['SpringCloudBuildDeploymentQuotaArgs']]:
        """
        A `quota` block as defined below.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['SpringCloudBuildDeploymentQuotaArgs']]):
        pulumi.set(self, "quota", value)


@pulumi.input_type
class _SpringCloudBuildDeploymentState:
    def __init__(__self__, *,
                 addon_json: Optional[pulumi.Input[builtins.str]] = None,
                 application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 build_result_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 quota: Optional[pulumi.Input['SpringCloudBuildDeploymentQuotaArgs']] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudBuildDeployment resources.
        :param pulumi.Input[builtins.str] addon_json: A JSON object that contains the addon configurations of the Spring Cloud Build Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] application_performance_monitoring_ids: Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        :param pulumi.Input[builtins.str] build_result_id: The ID of the Spring Cloud Build Result.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        :param pulumi.Input[builtins.int] instance_count: Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Build Deployment. Changing this forces a new Spring Cloud Build Deployment to be created.
        :param pulumi.Input['SpringCloudBuildDeploymentQuotaArgs'] quota: A `quota` block as defined below.
        :param pulumi.Input[builtins.str] spring_cloud_app_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Build Deployment to be created.
        """
        if addon_json is not None:
            pulumi.set(__self__, "addon_json", addon_json)
        if application_performance_monitoring_ids is not None:
            pulumi.set(__self__, "application_performance_monitoring_ids", application_performance_monitoring_ids)
        if build_result_id is not None:
            pulumi.set(__self__, "build_result_id", build_result_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if spring_cloud_app_id is not None:
            pulumi.set(__self__, "spring_cloud_app_id", spring_cloud_app_id)

    @property
    @pulumi.getter(name="addonJson")
    def addon_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A JSON object that contains the addon configurations of the Spring Cloud Build Deployment.
        """
        return pulumi.get(self, "addon_json")

    @addon_json.setter
    def addon_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "addon_json", value)

    @property
    @pulumi.getter(name="applicationPerformanceMonitoringIds")
    def application_performance_monitoring_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        """
        return pulumi.get(self, "application_performance_monitoring_ids")

    @application_performance_monitoring_ids.setter
    def application_performance_monitoring_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "application_performance_monitoring_ids", value)

    @property
    @pulumi.getter(name="buildResultId")
    def build_result_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Spring Cloud Build Result.
        """
        return pulumi.get(self, "build_result_id")

    @build_result_id.setter
    def build_result_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "build_result_id", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud Build Deployment. Changing this forces a new Spring Cloud Build Deployment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['SpringCloudBuildDeploymentQuotaArgs']]:
        """
        A `quota` block as defined below.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['SpringCloudBuildDeploymentQuotaArgs']]):
        pulumi.set(self, "quota", value)

    @property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Build Deployment to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

    @spring_cloud_app_id.setter
    def spring_cloud_app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spring_cloud_app_id", value)


@pulumi.type_token("azure:appplatform/springCloudBuildDeployment:SpringCloudBuildDeployment")
class SpringCloudBuildDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_json: Optional[pulumi.Input[builtins.str]] = None,
                 application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 build_result_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 quota: Optional[pulumi.Input[Union['SpringCloudBuildDeploymentQuotaArgs', 'SpringCloudBuildDeploymentQuotaArgsDict']]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Spring Cloud Build Deployment.

        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudBuildDeployment` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_app = azure.appplatform.SpringCloudApp("example",
            name="example",
            resource_group_name=example_spring_cloud_service.resource_group_name,
            service_name=example_spring_cloud_service.name)
        example_spring_cloud_build_deployment = azure.appplatform.SpringCloudBuildDeployment("example",
            name="example",
            spring_cloud_app_id=example_spring_cloud_app.id,
            build_result_id="<default>",
            instance_count=2,
            environment_variables={
                "Foo": "Bar",
                "Env": "Staging",
            },
            quota={
                "cpu": "2",
                "memory": "4Gi",
            })
        ```

        ## Import

        Spring Cloud Build Deployments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudBuildDeployment:SpringCloudBuildDeployment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.AppPlatform/spring/spring1/apps/app1/deployments/deploy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] addon_json: A JSON object that contains the addon configurations of the Spring Cloud Build Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] application_performance_monitoring_ids: Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        :param pulumi.Input[builtins.str] build_result_id: The ID of the Spring Cloud Build Result.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        :param pulumi.Input[builtins.int] instance_count: Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Build Deployment. Changing this forces a new Spring Cloud Build Deployment to be created.
        :param pulumi.Input[Union['SpringCloudBuildDeploymentQuotaArgs', 'SpringCloudBuildDeploymentQuotaArgsDict']] quota: A `quota` block as defined below.
        :param pulumi.Input[builtins.str] spring_cloud_app_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Build Deployment to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudBuildDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spring Cloud Build Deployment.

        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudBuildDeployment` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_app = azure.appplatform.SpringCloudApp("example",
            name="example",
            resource_group_name=example_spring_cloud_service.resource_group_name,
            service_name=example_spring_cloud_service.name)
        example_spring_cloud_build_deployment = azure.appplatform.SpringCloudBuildDeployment("example",
            name="example",
            spring_cloud_app_id=example_spring_cloud_app.id,
            build_result_id="<default>",
            instance_count=2,
            environment_variables={
                "Foo": "Bar",
                "Env": "Staging",
            },
            quota={
                "cpu": "2",
                "memory": "4Gi",
            })
        ```

        ## Import

        Spring Cloud Build Deployments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudBuildDeployment:SpringCloudBuildDeployment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.AppPlatform/spring/spring1/apps/app1/deployments/deploy1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudBuildDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudBuildDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_json: Optional[pulumi.Input[builtins.str]] = None,
                 application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 build_result_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 quota: Optional[pulumi.Input[Union['SpringCloudBuildDeploymentQuotaArgs', 'SpringCloudBuildDeploymentQuotaArgsDict']]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudBuildDeploymentArgs.__new__(SpringCloudBuildDeploymentArgs)

            __props__.__dict__["addon_json"] = addon_json
            __props__.__dict__["application_performance_monitoring_ids"] = application_performance_monitoring_ids
            if build_result_id is None and not opts.urn:
                raise TypeError("Missing required property 'build_result_id'")
            __props__.__dict__["build_result_id"] = build_result_id
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["instance_count"] = instance_count
            __props__.__dict__["name"] = name
            __props__.__dict__["quota"] = quota
            if spring_cloud_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_app_id'")
            __props__.__dict__["spring_cloud_app_id"] = spring_cloud_app_id
        super(SpringCloudBuildDeployment, __self__).__init__(
            'azure:appplatform/springCloudBuildDeployment:SpringCloudBuildDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addon_json: Optional[pulumi.Input[builtins.str]] = None,
            application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            build_result_id: Optional[pulumi.Input[builtins.str]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            instance_count: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            quota: Optional[pulumi.Input[Union['SpringCloudBuildDeploymentQuotaArgs', 'SpringCloudBuildDeploymentQuotaArgsDict']]] = None,
            spring_cloud_app_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SpringCloudBuildDeployment':
        """
        Get an existing SpringCloudBuildDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] addon_json: A JSON object that contains the addon configurations of the Spring Cloud Build Deployment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] application_performance_monitoring_ids: Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        :param pulumi.Input[builtins.str] build_result_id: The ID of the Spring Cloud Build Result.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        :param pulumi.Input[builtins.int] instance_count: Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Build Deployment. Changing this forces a new Spring Cloud Build Deployment to be created.
        :param pulumi.Input[Union['SpringCloudBuildDeploymentQuotaArgs', 'SpringCloudBuildDeploymentQuotaArgsDict']] quota: A `quota` block as defined below.
        :param pulumi.Input[builtins.str] spring_cloud_app_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Build Deployment to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudBuildDeploymentState.__new__(_SpringCloudBuildDeploymentState)

        __props__.__dict__["addon_json"] = addon_json
        __props__.__dict__["application_performance_monitoring_ids"] = application_performance_monitoring_ids
        __props__.__dict__["build_result_id"] = build_result_id
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["name"] = name
        __props__.__dict__["quota"] = quota
        __props__.__dict__["spring_cloud_app_id"] = spring_cloud_app_id
        return SpringCloudBuildDeployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addonJson")
    def addon_json(self) -> pulumi.Output[builtins.str]:
        """
        A JSON object that contains the addon configurations of the Spring Cloud Build Deployment.
        """
        return pulumi.get(self, "addon_json")

    @property
    @pulumi.getter(name="applicationPerformanceMonitoringIds")
    def application_performance_monitoring_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        """
        return pulumi.get(self, "application_performance_monitoring_ids")

    @property
    @pulumi.getter(name="buildResultId")
    def build_result_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Spring Cloud Build Result.
        """
        return pulumi.get(self, "build_result_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Specifies the environment variables of the Spring Cloud Deployment as a map of key-value pairs.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the required instance count of the Spring Cloud Deployment. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Spring Cloud Build Deployment. Changing this forces a new Spring Cloud Build Deployment to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def quota(self) -> pulumi.Output['outputs.SpringCloudBuildDeploymentQuota']:
        """
        A `quota` block as defined below.
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Build Deployment to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

