# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpringCloudBuilderArgs', 'SpringCloudBuilder']

@pulumi.input_type
class SpringCloudBuilderArgs:
    def __init__(__self__, *,
                 build_pack_groups: pulumi.Input[Sequence[pulumi.Input['SpringCloudBuilderBuildPackGroupArgs']]],
                 spring_cloud_service_id: pulumi.Input[builtins.str],
                 stack: pulumi.Input['SpringCloudBuilderStackArgs'],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SpringCloudBuilder resource.
        :param pulumi.Input[Sequence[pulumi.Input['SpringCloudBuilderBuildPackGroupArgs']]] build_pack_groups: One or more `build_pack_group` blocks as defined below.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Builder to be created.
        :param pulumi.Input['SpringCloudBuilderStackArgs'] stack: A `stack` block as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Builder. Changing this forces a new Spring Cloud Builder to be created.
        """
        pulumi.set(__self__, "build_pack_groups", build_pack_groups)
        pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        pulumi.set(__self__, "stack", stack)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="buildPackGroups")
    def build_pack_groups(self) -> pulumi.Input[Sequence[pulumi.Input['SpringCloudBuilderBuildPackGroupArgs']]]:
        """
        One or more `build_pack_group` blocks as defined below.
        """
        return pulumi.get(self, "build_pack_groups")

    @build_pack_groups.setter
    def build_pack_groups(self, value: pulumi.Input[Sequence[pulumi.Input['SpringCloudBuilderBuildPackGroupArgs']]]):
        pulumi.set(self, "build_pack_groups", value)

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Builder to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @property
    @pulumi.getter
    def stack(self) -> pulumi.Input['SpringCloudBuilderStackArgs']:
        """
        A `stack` block as defined below.
        """
        return pulumi.get(self, "stack")

    @stack.setter
    def stack(self, value: pulumi.Input['SpringCloudBuilderStackArgs']):
        pulumi.set(self, "stack", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud Builder. Changing this forces a new Spring Cloud Builder to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SpringCloudBuilderState:
    def __init__(__self__, *,
                 build_pack_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudBuilderBuildPackGroupArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 stack: Optional[pulumi.Input['SpringCloudBuilderStackArgs']] = None):
        """
        Input properties used for looking up and filtering SpringCloudBuilder resources.
        :param pulumi.Input[Sequence[pulumi.Input['SpringCloudBuilderBuildPackGroupArgs']]] build_pack_groups: One or more `build_pack_group` blocks as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Builder. Changing this forces a new Spring Cloud Builder to be created.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Builder to be created.
        :param pulumi.Input['SpringCloudBuilderStackArgs'] stack: A `stack` block as defined below.
        """
        if build_pack_groups is not None:
            pulumi.set(__self__, "build_pack_groups", build_pack_groups)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spring_cloud_service_id is not None:
            pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if stack is not None:
            pulumi.set(__self__, "stack", stack)

    @property
    @pulumi.getter(name="buildPackGroups")
    def build_pack_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudBuilderBuildPackGroupArgs']]]]:
        """
        One or more `build_pack_group` blocks as defined below.
        """
        return pulumi.get(self, "build_pack_groups")

    @build_pack_groups.setter
    def build_pack_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudBuilderBuildPackGroupArgs']]]]):
        pulumi.set(self, "build_pack_groups", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud Builder. Changing this forces a new Spring Cloud Builder to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Builder to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @property
    @pulumi.getter
    def stack(self) -> Optional[pulumi.Input['SpringCloudBuilderStackArgs']]:
        """
        A `stack` block as defined below.
        """
        return pulumi.get(self, "stack")

    @stack.setter
    def stack(self, value: Optional[pulumi.Input['SpringCloudBuilderStackArgs']]):
        pulumi.set(self, "stack", value)


@pulumi.type_token("azure:appplatform/springCloudBuilder:SpringCloudBuilder")
class SpringCloudBuilder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_pack_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudBuilderBuildPackGroupArgs', 'SpringCloudBuilderBuildPackGroupArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 stack: Optional[pulumi.Input[Union['SpringCloudBuilderStackArgs', 'SpringCloudBuilderStackArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Spring Cloud Builder.

        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudBuilder` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example-springcloud",
            resource_group_name=example.name,
            location=example.location,
            sku_name="E0")
        example_spring_cloud_builder = azure.appplatform.SpringCloudBuilder("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            build_pack_groups=[{
                "name": "mix",
                "build_pack_ids": ["tanzu-buildpacks/java-azure"],
            }],
            stack={
                "id": "io.buildpacks.stacks.bionic",
                "version": "base",
            })
        ```

        ## Import

        Spring Cloud Builders can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudBuilder:SpringCloudBuilder example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/spring/service1/buildServices/buildService1/builders/builder1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudBuilderBuildPackGroupArgs', 'SpringCloudBuilderBuildPackGroupArgsDict']]]] build_pack_groups: One or more `build_pack_group` blocks as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Builder. Changing this forces a new Spring Cloud Builder to be created.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Builder to be created.
        :param pulumi.Input[Union['SpringCloudBuilderStackArgs', 'SpringCloudBuilderStackArgsDict']] stack: A `stack` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudBuilderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spring Cloud Builder.

        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudBuilder` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example-springcloud",
            resource_group_name=example.name,
            location=example.location,
            sku_name="E0")
        example_spring_cloud_builder = azure.appplatform.SpringCloudBuilder("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            build_pack_groups=[{
                "name": "mix",
                "build_pack_ids": ["tanzu-buildpacks/java-azure"],
            }],
            stack={
                "id": "io.buildpacks.stacks.bionic",
                "version": "base",
            })
        ```

        ## Import

        Spring Cloud Builders can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudBuilder:SpringCloudBuilder example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/spring/service1/buildServices/buildService1/builders/builder1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudBuilderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudBuilderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_pack_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudBuilderBuildPackGroupArgs', 'SpringCloudBuilderBuildPackGroupArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 stack: Optional[pulumi.Input[Union['SpringCloudBuilderStackArgs', 'SpringCloudBuilderStackArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudBuilderArgs.__new__(SpringCloudBuilderArgs)

            if build_pack_groups is None and not opts.urn:
                raise TypeError("Missing required property 'build_pack_groups'")
            __props__.__dict__["build_pack_groups"] = build_pack_groups
            __props__.__dict__["name"] = name
            if spring_cloud_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_service_id'")
            __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
            if stack is None and not opts.urn:
                raise TypeError("Missing required property 'stack'")
            __props__.__dict__["stack"] = stack
        super(SpringCloudBuilder, __self__).__init__(
            'azure:appplatform/springCloudBuilder:SpringCloudBuilder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            build_pack_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudBuilderBuildPackGroupArgs', 'SpringCloudBuilderBuildPackGroupArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
            stack: Optional[pulumi.Input[Union['SpringCloudBuilderStackArgs', 'SpringCloudBuilderStackArgsDict']]] = None) -> 'SpringCloudBuilder':
        """
        Get an existing SpringCloudBuilder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudBuilderBuildPackGroupArgs', 'SpringCloudBuilderBuildPackGroupArgsDict']]]] build_pack_groups: One or more `build_pack_group` blocks as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Builder. Changing this forces a new Spring Cloud Builder to be created.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Builder to be created.
        :param pulumi.Input[Union['SpringCloudBuilderStackArgs', 'SpringCloudBuilderStackArgsDict']] stack: A `stack` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudBuilderState.__new__(_SpringCloudBuilderState)

        __props__.__dict__["build_pack_groups"] = build_pack_groups
        __props__.__dict__["name"] = name
        __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        __props__.__dict__["stack"] = stack
        return SpringCloudBuilder(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="buildPackGroups")
    def build_pack_groups(self) -> pulumi.Output[Sequence['outputs.SpringCloudBuilderBuildPackGroup']]:
        """
        One or more `build_pack_group` blocks as defined below.
        """
        return pulumi.get(self, "build_pack_groups")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Spring Cloud Builder. Changing this forces a new Spring Cloud Builder to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Builder to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @property
    @pulumi.getter
    def stack(self) -> pulumi.Output['outputs.SpringCloudBuilderStack']:
        """
        A `stack` block as defined below.
        """
        return pulumi.get(self, "stack")

