# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpringCloudConfigurationServiceArgs', 'SpringCloudConfigurationService']

@pulumi.input_type
class SpringCloudConfigurationServiceArgs:
    def __init__(__self__, *,
                 spring_cloud_service_id: pulumi.Input[builtins.str],
                 generation: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_interval_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudConfigurationServiceRepositoryArgs']]]] = None):
        """
        The set of arguments for constructing a SpringCloudConfigurationService resource.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Configuration Service to be created.
        :param pulumi.Input[builtins.str] generation: The generation of the Spring Cloud Configuration Service. Possible values are `Gen1` and `Gen2`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Configuration Service. The only possible value is `default`. Changing this forces a new Spring Cloud Configuration Service to be created.
        :param pulumi.Input[builtins.int] refresh_interval_in_seconds: Specifies how often to check repository updates. Minimum value is 0.
        :param pulumi.Input[Sequence[pulumi.Input['SpringCloudConfigurationServiceRepositoryArgs']]] repositories: One or more `repository` blocks as defined below.
        """
        pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if refresh_interval_in_seconds is not None:
            pulumi.set(__self__, "refresh_interval_in_seconds", refresh_interval_in_seconds)
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Configuration Service to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The generation of the Spring Cloud Configuration Service. Possible values are `Gen1` and `Gen2`.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud Configuration Service. The only possible value is `default`. Changing this forces a new Spring Cloud Configuration Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="refreshIntervalInSeconds")
    def refresh_interval_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies how often to check repository updates. Minimum value is 0.
        """
        return pulumi.get(self, "refresh_interval_in_seconds")

    @refresh_interval_in_seconds.setter
    def refresh_interval_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "refresh_interval_in_seconds", value)

    @property
    @pulumi.getter
    def repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudConfigurationServiceRepositoryArgs']]]]:
        """
        One or more `repository` blocks as defined below.
        """
        return pulumi.get(self, "repositories")

    @repositories.setter
    def repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudConfigurationServiceRepositoryArgs']]]]):
        pulumi.set(self, "repositories", value)


@pulumi.input_type
class _SpringCloudConfigurationServiceState:
    def __init__(__self__, *,
                 generation: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_interval_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudConfigurationServiceRepositoryArgs']]]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudConfigurationService resources.
        :param pulumi.Input[builtins.str] generation: The generation of the Spring Cloud Configuration Service. Possible values are `Gen1` and `Gen2`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Configuration Service. The only possible value is `default`. Changing this forces a new Spring Cloud Configuration Service to be created.
        :param pulumi.Input[builtins.int] refresh_interval_in_seconds: Specifies how often to check repository updates. Minimum value is 0.
        :param pulumi.Input[Sequence[pulumi.Input['SpringCloudConfigurationServiceRepositoryArgs']]] repositories: One or more `repository` blocks as defined below.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Configuration Service to be created.
        """
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if refresh_interval_in_seconds is not None:
            pulumi.set(__self__, "refresh_interval_in_seconds", refresh_interval_in_seconds)
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)
        if spring_cloud_service_id is not None:
            pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The generation of the Spring Cloud Configuration Service. Possible values are `Gen1` and `Gen2`.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud Configuration Service. The only possible value is `default`. Changing this forces a new Spring Cloud Configuration Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="refreshIntervalInSeconds")
    def refresh_interval_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies how often to check repository updates. Minimum value is 0.
        """
        return pulumi.get(self, "refresh_interval_in_seconds")

    @refresh_interval_in_seconds.setter
    def refresh_interval_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "refresh_interval_in_seconds", value)

    @property
    @pulumi.getter
    def repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudConfigurationServiceRepositoryArgs']]]]:
        """
        One or more `repository` blocks as defined below.
        """
        return pulumi.get(self, "repositories")

    @repositories.setter
    def repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudConfigurationServiceRepositoryArgs']]]]):
        pulumi.set(self, "repositories", value)

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Configuration Service to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spring_cloud_service_id", value)


@pulumi.type_token("azure:appplatform/springCloudConfigurationService:SpringCloudConfigurationService")
class SpringCloudConfigurationService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 generation: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_interval_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudConfigurationServiceRepositoryArgs', 'SpringCloudConfigurationServiceRepositoryArgsDict']]]]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Spring Cloud Configuration Service.

        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudConfigurationService` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_configuration_service = azure.appplatform.SpringCloudConfigurationService("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id,
            repositories=[{
                "name": "fake",
                "label": "master",
                "patterns": ["app/dev"],
                "uri": "https://github.com/Azure-Samples/piggymetrics",
                "search_paths": [
                    "dir1",
                    "dir2",
                ],
                "strict_host_key_checking": False,
                "username": "adminuser",
                "password": "H@Sh1CoR3!",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud Configuration Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudConfigurationService:SpringCloudConfigurationService example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/spring/service1/configurationServices/configurationService1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] generation: The generation of the Spring Cloud Configuration Service. Possible values are `Gen1` and `Gen2`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Configuration Service. The only possible value is `default`. Changing this forces a new Spring Cloud Configuration Service to be created.
        :param pulumi.Input[builtins.int] refresh_interval_in_seconds: Specifies how often to check repository updates. Minimum value is 0.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudConfigurationServiceRepositoryArgs', 'SpringCloudConfigurationServiceRepositoryArgsDict']]]] repositories: One or more `repository` blocks as defined below.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Configuration Service to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudConfigurationServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spring Cloud Configuration Service.

        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudConfigurationService` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_configuration_service = azure.appplatform.SpringCloudConfigurationService("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id,
            repositories=[{
                "name": "fake",
                "label": "master",
                "patterns": ["app/dev"],
                "uri": "https://github.com/Azure-Samples/piggymetrics",
                "search_paths": [
                    "dir1",
                    "dir2",
                ],
                "strict_host_key_checking": False,
                "username": "adminuser",
                "password": "H@Sh1CoR3!",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud Configuration Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudConfigurationService:SpringCloudConfigurationService example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/spring/service1/configurationServices/configurationService1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudConfigurationServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudConfigurationServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 generation: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_interval_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudConfigurationServiceRepositoryArgs', 'SpringCloudConfigurationServiceRepositoryArgsDict']]]]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudConfigurationServiceArgs.__new__(SpringCloudConfigurationServiceArgs)

            __props__.__dict__["generation"] = generation
            __props__.__dict__["name"] = name
            __props__.__dict__["refresh_interval_in_seconds"] = refresh_interval_in_seconds
            __props__.__dict__["repositories"] = repositories
            if spring_cloud_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_service_id'")
            __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        super(SpringCloudConfigurationService, __self__).__init__(
            'azure:appplatform/springCloudConfigurationService:SpringCloudConfigurationService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            generation: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            refresh_interval_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudConfigurationServiceRepositoryArgs', 'SpringCloudConfigurationServiceRepositoryArgsDict']]]]] = None,
            spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SpringCloudConfigurationService':
        """
        Get an existing SpringCloudConfigurationService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] generation: The generation of the Spring Cloud Configuration Service. Possible values are `Gen1` and `Gen2`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Configuration Service. The only possible value is `default`. Changing this forces a new Spring Cloud Configuration Service to be created.
        :param pulumi.Input[builtins.int] refresh_interval_in_seconds: Specifies how often to check repository updates. Minimum value is 0.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudConfigurationServiceRepositoryArgs', 'SpringCloudConfigurationServiceRepositoryArgsDict']]]] repositories: One or more `repository` blocks as defined below.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Configuration Service to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudConfigurationServiceState.__new__(_SpringCloudConfigurationServiceState)

        __props__.__dict__["generation"] = generation
        __props__.__dict__["name"] = name
        __props__.__dict__["refresh_interval_in_seconds"] = refresh_interval_in_seconds
        __props__.__dict__["repositories"] = repositories
        __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        return SpringCloudConfigurationService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def generation(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The generation of the Spring Cloud Configuration Service. Possible values are `Gen1` and `Gen2`.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Spring Cloud Configuration Service. The only possible value is `default`. Changing this forces a new Spring Cloud Configuration Service to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="refreshIntervalInSeconds")
    def refresh_interval_in_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies how often to check repository updates. Minimum value is 0.
        """
        return pulumi.get(self, "refresh_interval_in_seconds")

    @property
    @pulumi.getter
    def repositories(self) -> pulumi.Output[Optional[Sequence['outputs.SpringCloudConfigurationServiceRepository']]]:
        """
        One or more `repository` blocks as defined below.
        """
        return pulumi.get(self, "repositories")

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Configuration Service to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

