# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpringCloudDevToolPortalArgs', 'SpringCloudDevToolPortal']

@pulumi.input_type
class SpringCloudDevToolPortalArgs:
    def __init__(__self__, *,
                 spring_cloud_service_id: pulumi.Input[builtins.str],
                 application_accelerator_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 application_live_view_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sso: Optional[pulumi.Input['SpringCloudDevToolPortalSsoArgs']] = None):
        """
        The set of arguments for constructing a SpringCloudDevToolPortal resource.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        :param pulumi.Input[builtins.bool] application_accelerator_enabled: Should the Accelerator plugin be enabled?
        :param pulumi.Input[builtins.bool] application_live_view_enabled: Should the Application Live View be enabled?
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Dev Tool Portal. The only possible value is `default`. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is public network access enabled?
        :param pulumi.Input['SpringCloudDevToolPortalSsoArgs'] sso: A `sso` block as defined below.
        """
        pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if application_accelerator_enabled is not None:
            pulumi.set(__self__, "application_accelerator_enabled", application_accelerator_enabled)
        if application_live_view_enabled is not None:
            pulumi.set(__self__, "application_live_view_enabled", application_live_view_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @property
    @pulumi.getter(name="applicationAcceleratorEnabled")
    def application_accelerator_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Accelerator plugin be enabled?
        """
        return pulumi.get(self, "application_accelerator_enabled")

    @application_accelerator_enabled.setter
    def application_accelerator_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "application_accelerator_enabled", value)

    @property
    @pulumi.getter(name="applicationLiveViewEnabled")
    def application_live_view_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Application Live View be enabled?
        """
        return pulumi.get(self, "application_live_view_enabled")

    @application_live_view_enabled.setter
    def application_live_view_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "application_live_view_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud Dev Tool Portal. The only possible value is `default`. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is public network access enabled?
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter
    def sso(self) -> Optional[pulumi.Input['SpringCloudDevToolPortalSsoArgs']]:
        """
        A `sso` block as defined below.
        """
        return pulumi.get(self, "sso")

    @sso.setter
    def sso(self, value: Optional[pulumi.Input['SpringCloudDevToolPortalSsoArgs']]):
        pulumi.set(self, "sso", value)


@pulumi.input_type
class _SpringCloudDevToolPortalState:
    def __init__(__self__, *,
                 application_accelerator_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 application_live_view_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 sso: Optional[pulumi.Input['SpringCloudDevToolPortalSsoArgs']] = None):
        """
        Input properties used for looking up and filtering SpringCloudDevToolPortal resources.
        :param pulumi.Input[builtins.bool] application_accelerator_enabled: Should the Accelerator plugin be enabled?
        :param pulumi.Input[builtins.bool] application_live_view_enabled: Should the Application Live View be enabled?
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Dev Tool Portal. The only possible value is `default`. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is public network access enabled?
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        :param pulumi.Input['SpringCloudDevToolPortalSsoArgs'] sso: A `sso` block as defined below.
        """
        if application_accelerator_enabled is not None:
            pulumi.set(__self__, "application_accelerator_enabled", application_accelerator_enabled)
        if application_live_view_enabled is not None:
            pulumi.set(__self__, "application_live_view_enabled", application_live_view_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if spring_cloud_service_id is not None:
            pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)

    @property
    @pulumi.getter(name="applicationAcceleratorEnabled")
    def application_accelerator_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Accelerator plugin be enabled?
        """
        return pulumi.get(self, "application_accelerator_enabled")

    @application_accelerator_enabled.setter
    def application_accelerator_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "application_accelerator_enabled", value)

    @property
    @pulumi.getter(name="applicationLiveViewEnabled")
    def application_live_view_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Application Live View be enabled?
        """
        return pulumi.get(self, "application_live_view_enabled")

    @application_live_view_enabled.setter
    def application_live_view_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "application_live_view_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud Dev Tool Portal. The only possible value is `default`. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is public network access enabled?
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @property
    @pulumi.getter
    def sso(self) -> Optional[pulumi.Input['SpringCloudDevToolPortalSsoArgs']]:
        """
        A `sso` block as defined below.
        """
        return pulumi.get(self, "sso")

    @sso.setter
    def sso(self, value: Optional[pulumi.Input['SpringCloudDevToolPortalSsoArgs']]):
        pulumi.set(self, "sso", value)


@pulumi.type_token("azure:appplatform/springCloudDevToolPortal:SpringCloudDevToolPortal")
class SpringCloudDevToolPortal(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_accelerator_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 application_live_view_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 sso: Optional[pulumi.Input[Union['SpringCloudDevToolPortalSsoArgs', 'SpringCloudDevToolPortalSsoArgsDict']]] = None,
                 __props__=None):
        """
        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        Manages a Spring Cloud Dev Tool Portal.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudDevToolPortal` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_dev_tool_portal = azure.appplatform.SpringCloudDevToolPortal("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id,
            public_network_access_enabled=True,
            sso={
                "client_id": "example id",
                "client_secret": "example secret",
                "metadata_url": f"https://login.microsoftonline.com/{current.tenant_id}/v2.0/.well-known/openid-configuration",
                "scopes": [
                    "openid",
                    "profile",
                    "email",
                ],
            },
            application_accelerator_enabled=True,
            application_live_view_enabled=True)
        ```

        ## Import

        Spring Cloud Dev Tool Portals can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudDevToolPortal:SpringCloudDevToolPortal example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/Spring/service1/DevToolPortals/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] application_accelerator_enabled: Should the Accelerator plugin be enabled?
        :param pulumi.Input[builtins.bool] application_live_view_enabled: Should the Application Live View be enabled?
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Dev Tool Portal. The only possible value is `default`. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is public network access enabled?
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        :param pulumi.Input[Union['SpringCloudDevToolPortalSsoArgs', 'SpringCloudDevToolPortalSsoArgsDict']] sso: A `sso` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudDevToolPortalArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        Manages a Spring Cloud Dev Tool Portal.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudDevToolPortal` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_dev_tool_portal = azure.appplatform.SpringCloudDevToolPortal("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id,
            public_network_access_enabled=True,
            sso={
                "client_id": "example id",
                "client_secret": "example secret",
                "metadata_url": f"https://login.microsoftonline.com/{current.tenant_id}/v2.0/.well-known/openid-configuration",
                "scopes": [
                    "openid",
                    "profile",
                    "email",
                ],
            },
            application_accelerator_enabled=True,
            application_live_view_enabled=True)
        ```

        ## Import

        Spring Cloud Dev Tool Portals can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudDevToolPortal:SpringCloudDevToolPortal example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/Spring/service1/DevToolPortals/default
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudDevToolPortalArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudDevToolPortalArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_accelerator_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 application_live_view_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 sso: Optional[pulumi.Input[Union['SpringCloudDevToolPortalSsoArgs', 'SpringCloudDevToolPortalSsoArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudDevToolPortalArgs.__new__(SpringCloudDevToolPortalArgs)

            __props__.__dict__["application_accelerator_enabled"] = application_accelerator_enabled
            __props__.__dict__["application_live_view_enabled"] = application_live_view_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if spring_cloud_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_service_id'")
            __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
            __props__.__dict__["sso"] = sso
        super(SpringCloudDevToolPortal, __self__).__init__(
            'azure:appplatform/springCloudDevToolPortal:SpringCloudDevToolPortal',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_accelerator_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            application_live_view_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
            sso: Optional[pulumi.Input[Union['SpringCloudDevToolPortalSsoArgs', 'SpringCloudDevToolPortalSsoArgsDict']]] = None) -> 'SpringCloudDevToolPortal':
        """
        Get an existing SpringCloudDevToolPortal resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] application_accelerator_enabled: Should the Accelerator plugin be enabled?
        :param pulumi.Input[builtins.bool] application_live_view_enabled: Should the Application Live View be enabled?
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Dev Tool Portal. The only possible value is `default`. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is public network access enabled?
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        :param pulumi.Input[Union['SpringCloudDevToolPortalSsoArgs', 'SpringCloudDevToolPortalSsoArgsDict']] sso: A `sso` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudDevToolPortalState.__new__(_SpringCloudDevToolPortalState)

        __props__.__dict__["application_accelerator_enabled"] = application_accelerator_enabled
        __props__.__dict__["application_live_view_enabled"] = application_live_view_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        __props__.__dict__["sso"] = sso
        return SpringCloudDevToolPortal(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationAcceleratorEnabled")
    def application_accelerator_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Should the Accelerator plugin be enabled?
        """
        return pulumi.get(self, "application_accelerator_enabled")

    @property
    @pulumi.getter(name="applicationLiveViewEnabled")
    def application_live_view_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Should the Application Live View be enabled?
        """
        return pulumi.get(self, "application_live_view_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Spring Cloud Dev Tool Portal. The only possible value is `default`. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is public network access enabled?
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Dev Tool Portal to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @property
    @pulumi.getter
    def sso(self) -> pulumi.Output[Optional['outputs.SpringCloudDevToolPortalSso']]:
        """
        A `sso` block as defined below.
        """
        return pulumi.get(self, "sso")

