# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SpringCloudElasticApplicationPerformanceMonitoringArgs', 'SpringCloudElasticApplicationPerformanceMonitoring']

@pulumi.input_type
class SpringCloudElasticApplicationPerformanceMonitoringArgs:
    def __init__(__self__, *,
                 application_packages: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 server_url: pulumi.Input[builtins.str],
                 service_name: pulumi.Input[builtins.str],
                 spring_cloud_service_id: pulumi.Input[builtins.str],
                 globally_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SpringCloudElasticApplicationPerformanceMonitoring resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] application_packages: Specifies a list of the packages which should be used to determine whether a stack trace frame is an in-app frame or a library frame. This is a comma separated list of package names.
        :param pulumi.Input[builtins.str] server_url: Specifies the server URL. The URL must be fully qualified, including protocol (http or https) and port.
        :param pulumi.Input[builtins.str] service_name: Specifies the service name which is used to keep all the errors and transactions of your service together and is the primary filter in the Elastic APM user interface.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for Elastic. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "application_packages", application_packages)
        pulumi.set(__self__, "server_url", server_url)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if globally_enabled is not None:
            pulumi.set(__self__, "globally_enabled", globally_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="applicationPackages")
    def application_packages(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Specifies a list of the packages which should be used to determine whether a stack trace frame is an in-app frame or a library frame. This is a comma separated list of package names.
        """
        return pulumi.get(self, "application_packages")

    @application_packages.setter
    def application_packages(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "application_packages", value)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the server URL. The URL must be fully qualified, including protocol (http or https) and port.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the service name which is used to keep all the errors and transactions of your service together and is the primary filter in the Elastic APM user interface.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @globally_enabled.setter
    def globally_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "globally_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for Elastic. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SpringCloudElasticApplicationPerformanceMonitoringState:
    def __init__(__self__, *,
                 application_packages: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 globally_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 server_url: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudElasticApplicationPerformanceMonitoring resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] application_packages: Specifies a list of the packages which should be used to determine whether a stack trace frame is an in-app frame or a library frame. This is a comma separated list of package names.
        :param pulumi.Input[builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for Elastic. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server_url: Specifies the server URL. The URL must be fully qualified, including protocol (http or https) and port.
        :param pulumi.Input[builtins.str] service_name: Specifies the service name which is used to keep all the errors and transactions of your service together and is the primary filter in the Elastic APM user interface.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        if application_packages is not None:
            pulumi.set(__self__, "application_packages", application_packages)
        if globally_enabled is not None:
            pulumi.set(__self__, "globally_enabled", globally_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if spring_cloud_service_id is not None:
            pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)

    @property
    @pulumi.getter(name="applicationPackages")
    def application_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of the packages which should be used to determine whether a stack trace frame is an in-app frame or a library frame. This is a comma separated list of package names.
        """
        return pulumi.get(self, "application_packages")

    @application_packages.setter
    def application_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "application_packages", value)

    @property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @globally_enabled.setter
    def globally_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "globally_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for Elastic. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the server URL. The URL must be fully qualified, including protocol (http or https) and port.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the service name which is used to keep all the errors and transactions of your service together and is the primary filter in the Elastic APM user interface.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spring_cloud_service_id", value)


@pulumi.type_token("azure:appplatform/springCloudElasticApplicationPerformanceMonitoring:SpringCloudElasticApplicationPerformanceMonitoring")
class SpringCloudElasticApplicationPerformanceMonitoring(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_packages: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 globally_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 server_url: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > **Note:** This resource is only applicable for Spring Cloud Service enterprise tier

        Manages a Spring Cloud Application Performance Monitoring resource for Elastic.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudElasticApplicationPerformanceMonitoring` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_elastic_application_performance_monitoring = azure.appplatform.SpringCloudElasticApplicationPerformanceMonitoring("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            globally_enabled=True,
            application_packages=[
                "org.example",
                "org.another.example",
            ],
            service_name="example-service-name",
            server_url="http://127.0.0.1:8200")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud Application Performance Monitoring resource for Elastic can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudElasticApplicationPerformanceMonitoring:SpringCloudElasticApplicationPerformanceMonitoring example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AppPlatform/spring/service1/apms/apm1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] application_packages: Specifies a list of the packages which should be used to determine whether a stack trace frame is an in-app frame or a library frame. This is a comma separated list of package names.
        :param pulumi.Input[builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for Elastic. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server_url: Specifies the server URL. The URL must be fully qualified, including protocol (http or https) and port.
        :param pulumi.Input[builtins.str] service_name: Specifies the service name which is used to keep all the errors and transactions of your service together and is the primary filter in the Elastic APM user interface.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudElasticApplicationPerformanceMonitoringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Note:** This resource is only applicable for Spring Cloud Service enterprise tier

        Manages a Spring Cloud Application Performance Monitoring resource for Elastic.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudElasticApplicationPerformanceMonitoring` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_elastic_application_performance_monitoring = azure.appplatform.SpringCloudElasticApplicationPerformanceMonitoring("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            globally_enabled=True,
            application_packages=[
                "org.example",
                "org.another.example",
            ],
            service_name="example-service-name",
            server_url="http://127.0.0.1:8200")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud Application Performance Monitoring resource for Elastic can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudElasticApplicationPerformanceMonitoring:SpringCloudElasticApplicationPerformanceMonitoring example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AppPlatform/spring/service1/apms/apm1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudElasticApplicationPerformanceMonitoringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudElasticApplicationPerformanceMonitoringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_packages: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 globally_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 server_url: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudElasticApplicationPerformanceMonitoringArgs.__new__(SpringCloudElasticApplicationPerformanceMonitoringArgs)

            if application_packages is None and not opts.urn:
                raise TypeError("Missing required property 'application_packages'")
            __props__.__dict__["application_packages"] = application_packages
            __props__.__dict__["globally_enabled"] = globally_enabled
            __props__.__dict__["name"] = name
            if server_url is None and not opts.urn:
                raise TypeError("Missing required property 'server_url'")
            __props__.__dict__["server_url"] = server_url
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if spring_cloud_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_service_id'")
            __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        super(SpringCloudElasticApplicationPerformanceMonitoring, __self__).__init__(
            'azure:appplatform/springCloudElasticApplicationPerformanceMonitoring:SpringCloudElasticApplicationPerformanceMonitoring',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_packages: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            globally_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            server_url: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            spring_cloud_service_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SpringCloudElasticApplicationPerformanceMonitoring':
        """
        Get an existing SpringCloudElasticApplicationPerformanceMonitoring resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] application_packages: Specifies a list of the packages which should be used to determine whether a stack trace frame is an in-app frame or a library frame. This is a comma separated list of package names.
        :param pulumi.Input[builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for Elastic. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server_url: Specifies the server URL. The URL must be fully qualified, including protocol (http or https) and port.
        :param pulumi.Input[builtins.str] service_name: Specifies the service name which is used to keep all the errors and transactions of your service together and is the primary filter in the Elastic APM user interface.
        :param pulumi.Input[builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudElasticApplicationPerformanceMonitoringState.__new__(_SpringCloudElasticApplicationPerformanceMonitoringState)

        __props__.__dict__["application_packages"] = application_packages
        __props__.__dict__["globally_enabled"] = globally_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["server_url"] = server_url
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        return SpringCloudElasticApplicationPerformanceMonitoring(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationPackages")
    def application_packages(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Specifies a list of the packages which should be used to determine whether a stack trace frame is an in-app frame or a library frame. This is a comma separated list of package names.
        """
        return pulumi.get(self, "application_packages")

    @property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for Elastic. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the server URL. The URL must be fully qualified, including protocol (http or https) and port.
        """
        return pulumi.get(self, "server_url")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the service name which is used to keep all the errors and transactions of your service together and is the primary filter in the Elastic APM user interface.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

