# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppFlexConsumptionArgs', 'AppFlexConsumption']

@pulumi.input_type
class AppFlexConsumptionArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 runtime_name: pulumi.Input[builtins.str],
                 runtime_version: pulumi.Input[builtins.str],
                 service_plan_id: pulumi.Input[builtins.str],
                 site_config: pulumi.Input['AppFlexConsumptionSiteConfigArgs'],
                 storage_authentication_type: pulumi.Input[builtins.str],
                 storage_container_endpoint: pulumi.Input[builtins.str],
                 storage_container_type: pulumi.Input[builtins.str],
                 always_readies: Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionAlwaysReadyArgs']]]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input['AppFlexConsumptionAuthSettingsArgs']] = None,
                 auth_settings_v2: Optional[pulumi.Input['AppFlexConsumptionAuthSettingsV2Args']] = None,
                 client_certificate_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionConnectionStringArgs']]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['AppFlexConsumptionIdentityArgs']] = None,
                 instance_memory_in_mb: Optional[pulumi.Input[builtins.int]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maximum_instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sticky_settings: Optional[pulumi.Input['AppFlexConsumptionStickySettingsArgs']] = None,
                 storage_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 zip_deploy_file: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AppFlexConsumption resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Function App should exist. Changing this forces a new Linux Function App to be created.
        :param pulumi.Input[builtins.str] runtime_name: The Runtime of the Linux Function App. Possible values are `node`, `dotnet-isolated`, `powershell`, `python`, `java` and `custom`.
        :param pulumi.Input[builtins.str] runtime_version: The Runtime version of the Linux Function App. The values are diff from different runtime version. The supported values are `8.0`, `9.0` for `dotnet-isolated`, `20` for `node`, `3.10`, `3.11` for `python`, `11`, `17` for `java`, `7.4` for `powershell`.
        :param pulumi.Input[builtins.str] service_plan_id: The ID of the App Service Plan within which to create this Function App. Changing this forces a new Linux Function App to be created.
        :param pulumi.Input['AppFlexConsumptionSiteConfigArgs'] site_config: A `site_config` block as defined below.
        :param pulumi.Input[builtins.str] storage_authentication_type: The authentication type which will be used to access the backend storage account for the Function App. Possible values are `StorageAccountConnectionString`, `SystemAssignedIdentity`, and `UserAssignedIdentity`.
        :param pulumi.Input[builtins.str] storage_container_endpoint: The backend storage container endpoint which will be used by this Function App.
        :param pulumi.Input[builtins.str] storage_container_type: The storage container type used for the Function App. The current supported type is `blobContainer`.
        :param pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionAlwaysReadyArgs']]] always_readies: One or more `always_ready` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_settings: A map of key-value pairs for [App
               Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        :param pulumi.Input['AppFlexConsumptionAuthSettingsArgs'] auth_settings: A `auth_settings` block as defined below.
        :param pulumi.Input['AppFlexConsumptionAuthSettingsV2Args'] auth_settings_v2: An `auth_settings_v2` block as defined below.
        :param pulumi.Input[builtins.bool] client_certificate_enabled: Should the function app use Client Certificates.
        :param pulumi.Input[builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[builtins.str] client_certificate_mode: The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionConnectionStringArgs']]] connection_strings: One or more `connection_string` blocks as defined below.
        :param pulumi.Input[builtins.bool] enabled: Is the Function App enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] https_only: Is Https Connection enforced to the function app. Defaults to `false`
        :param pulumi.Input['AppFlexConsumptionIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.int] instance_memory_in_mb: The memory size of the instances on which your app runs. The [currently supported values](https://learn.microsoft.com/en-us/azure/azure-functions/flex-consumption-plan#instance-memory) are `2048` or `4096`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Function App should exist. Changing this forces a new Function App to be created.
        :param pulumi.Input[builtins.int] maximum_instance_count: The number of workers this function app can scale out to.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Function App. Changing this forces a new Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Should public network access be enabled for the Function App. Defaults to `true`.
        :param pulumi.Input['AppFlexConsumptionStickySettingsArgs'] sticky_settings: A `sticky_settings` block as defined below.
        :param pulumi.Input[builtins.str] storage_access_key: The access key which will be used to access the backend storage account for the Function App.
               
               > **Note:** The `storage_access_key` must be specified when `storage_authentication_type` is set to `StorageAccountConnectionString`.
        :param pulumi.Input[builtins.str] storage_user_assigned_identity_id: The user assigned Managed Identity to access the storage account. Conflicts with `storage_access_key`.
               
               > **Note:** The `storage_user_assigned_identity_id` must be specified when `storage_authentication_type` is set to `UserAssignedIdentity`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Linux Function App.
        :param pulumi.Input[builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
               
               > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        :param pulumi.Input[builtins.str] zip_deploy_file: The local path and filename of the Zip packaged application to deploy to this Linux Function App.
               
               > **Note:** Using this value requires either `WEBSITE_RUN_FROM_PACKAGE=1` or `SCM_DO_BUILD_DURING_DEPLOYMENT=true` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "runtime_name", runtime_name)
        pulumi.set(__self__, "runtime_version", runtime_version)
        pulumi.set(__self__, "service_plan_id", service_plan_id)
        pulumi.set(__self__, "site_config", site_config)
        pulumi.set(__self__, "storage_authentication_type", storage_authentication_type)
        pulumi.set(__self__, "storage_container_endpoint", storage_container_endpoint)
        pulumi.set(__self__, "storage_container_type", storage_container_type)
        if always_readies is not None:
            pulumi.set(__self__, "always_readies", always_readies)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auth_settings is not None:
            pulumi.set(__self__, "auth_settings", auth_settings)
        if auth_settings_v2 is not None:
            pulumi.set(__self__, "auth_settings_v2", auth_settings_v2)
        if client_certificate_enabled is not None:
            pulumi.set(__self__, "client_certificate_enabled", client_certificate_enabled)
        if client_certificate_exclusion_paths is not None:
            pulumi.set(__self__, "client_certificate_exclusion_paths", client_certificate_exclusion_paths)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if instance_memory_in_mb is not None:
            pulumi.set(__self__, "instance_memory_in_mb", instance_memory_in_mb)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_instance_count is not None:
            pulumi.set(__self__, "maximum_instance_count", maximum_instance_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if sticky_settings is not None:
            pulumi.set(__self__, "sticky_settings", sticky_settings)
        if storage_access_key is not None:
            pulumi.set(__self__, "storage_access_key", storage_access_key)
        if storage_user_assigned_identity_id is not None:
            pulumi.set(__self__, "storage_user_assigned_identity_id", storage_user_assigned_identity_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)
        if webdeploy_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "webdeploy_publish_basic_authentication_enabled", webdeploy_publish_basic_authentication_enabled)
        if zip_deploy_file is not None:
            pulumi.set(__self__, "zip_deploy_file", zip_deploy_file)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Function App should exist. Changing this forces a new Linux Function App to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="runtimeName")
    def runtime_name(self) -> pulumi.Input[builtins.str]:
        """
        The Runtime of the Linux Function App. Possible values are `node`, `dotnet-isolated`, `powershell`, `python`, `java` and `custom`.
        """
        return pulumi.get(self, "runtime_name")

    @runtime_name.setter
    def runtime_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runtime_name", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[builtins.str]:
        """
        The Runtime version of the Linux Function App. The values are diff from different runtime version. The supported values are `8.0`, `9.0` for `dotnet-isolated`, `20` for `node`, `3.10`, `3.11` for `python`, `11`, `17` for `java`, `7.4` for `powershell`.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter(name="servicePlanId")
    def service_plan_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the App Service Plan within which to create this Function App. Changing this forces a new Linux Function App to be created.
        """
        return pulumi.get(self, "service_plan_id")

    @service_plan_id.setter
    def service_plan_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_plan_id", value)

    @property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> pulumi.Input['AppFlexConsumptionSiteConfigArgs']:
        """
        A `site_config` block as defined below.
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: pulumi.Input['AppFlexConsumptionSiteConfigArgs']):
        pulumi.set(self, "site_config", value)

    @property
    @pulumi.getter(name="storageAuthenticationType")
    def storage_authentication_type(self) -> pulumi.Input[builtins.str]:
        """
        The authentication type which will be used to access the backend storage account for the Function App. Possible values are `StorageAccountConnectionString`, `SystemAssignedIdentity`, and `UserAssignedIdentity`.
        """
        return pulumi.get(self, "storage_authentication_type")

    @storage_authentication_type.setter
    def storage_authentication_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_authentication_type", value)

    @property
    @pulumi.getter(name="storageContainerEndpoint")
    def storage_container_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The backend storage container endpoint which will be used by this Function App.
        """
        return pulumi.get(self, "storage_container_endpoint")

    @storage_container_endpoint.setter
    def storage_container_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_container_endpoint", value)

    @property
    @pulumi.getter(name="storageContainerType")
    def storage_container_type(self) -> pulumi.Input[builtins.str]:
        """
        The storage container type used for the Function App. The current supported type is `blobContainer`.
        """
        return pulumi.get(self, "storage_container_type")

    @storage_container_type.setter
    def storage_container_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_container_type", value)

    @property
    @pulumi.getter(name="alwaysReadies")
    def always_readies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionAlwaysReadyArgs']]]]:
        """
        One or more `always_ready` blocks as defined below.
        """
        return pulumi.get(self, "always_readies")

    @always_readies.setter
    def always_readies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionAlwaysReadyArgs']]]]):
        pulumi.set(self, "always_readies", value)

    @property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key-value pairs for [App
        Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "app_settings", value)

    @property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> Optional[pulumi.Input['AppFlexConsumptionAuthSettingsArgs']]:
        """
        A `auth_settings` block as defined below.
        """
        return pulumi.get(self, "auth_settings")

    @auth_settings.setter
    def auth_settings(self, value: Optional[pulumi.Input['AppFlexConsumptionAuthSettingsArgs']]):
        pulumi.set(self, "auth_settings", value)

    @property
    @pulumi.getter(name="authSettingsV2")
    def auth_settings_v2(self) -> Optional[pulumi.Input['AppFlexConsumptionAuthSettingsV2Args']]:
        """
        An `auth_settings_v2` block as defined below.
        """
        return pulumi.get(self, "auth_settings_v2")

    @auth_settings_v2.setter
    def auth_settings_v2(self, value: Optional[pulumi.Input['AppFlexConsumptionAuthSettingsV2Args']]):
        pulumi.set(self, "auth_settings_v2", value)

    @property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the function app use Client Certificates.
        """
        return pulumi.get(self, "client_certificate_enabled")

    @client_certificate_enabled.setter
    def client_certificate_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "client_certificate_enabled", value)

    @property
    @pulumi.getter(name="clientCertificateExclusionPaths")
    def client_certificate_exclusion_paths(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Paths to exclude when using client certificates, separated by ;
        """
        return pulumi.get(self, "client_certificate_exclusion_paths")

    @client_certificate_exclusion_paths.setter
    def client_certificate_exclusion_paths(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_exclusion_paths", value)

    @property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @client_certificate_mode.setter
    def client_certificate_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_mode", value)

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionConnectionStringArgs']]]]:
        """
        One or more `connection_string` blocks as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the Function App enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Https Connection enforced to the function app. Defaults to `false`
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AppFlexConsumptionIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AppFlexConsumptionIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="instanceMemoryInMb")
    def instance_memory_in_mb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The memory size of the instances on which your app runs. The [currently supported values](https://learn.microsoft.com/en-us/azure/azure-functions/flex-consumption-plan#instance-memory) are `2048` or `4096`.
        """
        return pulumi.get(self, "instance_memory_in_mb")

    @instance_memory_in_mb.setter
    def instance_memory_in_mb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "instance_memory_in_mb", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Function App should exist. Changing this forces a new Function App to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maximumInstanceCount")
    def maximum_instance_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of workers this function app can scale out to.
        """
        return pulumi.get(self, "maximum_instance_count")

    @maximum_instance_count.setter
    def maximum_instance_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum_instance_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Function App. Changing this forces a new Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should public network access be enabled for the Function App. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="stickySettings")
    def sticky_settings(self) -> Optional[pulumi.Input['AppFlexConsumptionStickySettingsArgs']]:
        """
        A `sticky_settings` block as defined below.
        """
        return pulumi.get(self, "sticky_settings")

    @sticky_settings.setter
    def sticky_settings(self, value: Optional[pulumi.Input['AppFlexConsumptionStickySettingsArgs']]):
        pulumi.set(self, "sticky_settings", value)

    @property
    @pulumi.getter(name="storageAccessKey")
    def storage_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access key which will be used to access the backend storage account for the Function App.

        > **Note:** The `storage_access_key` must be specified when `storage_authentication_type` is set to `StorageAccountConnectionString`.
        """
        return pulumi.get(self, "storage_access_key")

    @storage_access_key.setter
    def storage_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_access_key", value)

    @property
    @pulumi.getter(name="storageUserAssignedIdentityId")
    def storage_user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user assigned Managed Identity to access the storage account. Conflicts with `storage_access_key`.

        > **Note:** The `storage_user_assigned_identity_id` must be specified when `storage_authentication_type` is set to `UserAssignedIdentity`.
        """
        return pulumi.get(self, "storage_user_assigned_identity_id")

    @storage_user_assigned_identity_id.setter
    def storage_user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_user_assigned_identity_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Linux Function App.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @virtual_network_subnet_id.setter
    def virtual_network_subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_network_subnet_id", value)

    @property
    @pulumi.getter(name="webdeployPublishBasicAuthenticationEnabled")
    def webdeploy_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.

        > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        """
        return pulumi.get(self, "webdeploy_publish_basic_authentication_enabled")

    @webdeploy_publish_basic_authentication_enabled.setter
    def webdeploy_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "webdeploy_publish_basic_authentication_enabled", value)

    @property
    @pulumi.getter(name="zipDeployFile")
    def zip_deploy_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The local path and filename of the Zip packaged application to deploy to this Linux Function App.

        > **Note:** Using this value requires either `WEBSITE_RUN_FROM_PACKAGE=1` or `SCM_DO_BUILD_DURING_DEPLOYMENT=true` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        return pulumi.get(self, "zip_deploy_file")

    @zip_deploy_file.setter
    def zip_deploy_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zip_deploy_file", value)


@pulumi.input_type
class _AppFlexConsumptionState:
    def __init__(__self__, *,
                 always_readies: Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionAlwaysReadyArgs']]]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input['AppFlexConsumptionAuthSettingsArgs']] = None,
                 auth_settings_v2: Optional[pulumi.Input['AppFlexConsumptionAuthSettingsV2Args']] = None,
                 client_certificate_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionConnectionStringArgs']]]] = None,
                 custom_domain_verification_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 hosting_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 https_only: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['AppFlexConsumptionIdentityArgs']] = None,
                 instance_memory_in_mb: Optional[pulumi.Input[builtins.int]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maximum_instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 outbound_ip_addresses: Optional[pulumi.Input[builtins.str]] = None,
                 possible_outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 possible_outbound_ip_addresses: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_name: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[builtins.str]] = None,
                 service_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 site_config: Optional[pulumi.Input['AppFlexConsumptionSiteConfigArgs']] = None,
                 site_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionSiteCredentialArgs']]]] = None,
                 sticky_settings: Optional[pulumi.Input['AppFlexConsumptionStickySettingsArgs']] = None,
                 storage_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_type: Optional[pulumi.Input[builtins.str]] = None,
                 storage_user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 zip_deploy_file: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppFlexConsumption resources.
        :param pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionAlwaysReadyArgs']]] always_readies: One or more `always_ready` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_settings: A map of key-value pairs for [App
               Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        :param pulumi.Input['AppFlexConsumptionAuthSettingsArgs'] auth_settings: A `auth_settings` block as defined below.
        :param pulumi.Input['AppFlexConsumptionAuthSettingsV2Args'] auth_settings_v2: An `auth_settings_v2` block as defined below.
        :param pulumi.Input[builtins.bool] client_certificate_enabled: Should the function app use Client Certificates.
        :param pulumi.Input[builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[builtins.str] client_certificate_mode: The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionConnectionStringArgs']]] connection_strings: One or more `connection_string` blocks as defined below.
        :param pulumi.Input[builtins.str] custom_domain_verification_id: The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        :param pulumi.Input[builtins.str] default_hostname: The default hostname of the Linux Function App.
        :param pulumi.Input[builtins.bool] enabled: Is the Function App enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] hosting_environment_id: The ID of the App Service Environment used by Function App.
        :param pulumi.Input[builtins.bool] https_only: Is Https Connection enforced to the function app. Defaults to `false`
        :param pulumi.Input['AppFlexConsumptionIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.int] instance_memory_in_mb: The memory size of the instances on which your app runs. The [currently supported values](https://learn.microsoft.com/en-us/azure/azure-functions/flex-consumption-plan#instance-memory) are `2048` or `4096`.
        :param pulumi.Input[builtins.str] kind: The Kind value for this Linux Function App.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Function App should exist. Changing this forces a new Function App to be created.
        :param pulumi.Input[builtins.int] maximum_instance_count: The number of workers this function app can scale out to.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Function App. Changing this forces a new Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] outbound_ip_address_lists: A list of outbound IP addresses. For example `["52.23.25.3", "52.143.43.12"]`
        :param pulumi.Input[builtins.str] outbound_ip_addresses: A comma separated list of outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] possible_outbound_ip_address_lists: A list of possible outbound IP addresses, not all of which are necessarily in use. This is a superset of `outbound_ip_address_list`. For example `["52.23.25.3", "52.143.43.12"]`.
        :param pulumi.Input[builtins.str] possible_outbound_ip_addresses: A comma separated list of possible outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12,52.143.43.17`. This is a superset of `outbound_ip_addresses`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Should public network access be enabled for the Function App. Defaults to `true`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Function App should exist. Changing this forces a new Linux Function App to be created.
        :param pulumi.Input[builtins.str] runtime_name: The Runtime of the Linux Function App. Possible values are `node`, `dotnet-isolated`, `powershell`, `python`, `java` and `custom`.
        :param pulumi.Input[builtins.str] runtime_version: The Runtime version of the Linux Function App. The values are diff from different runtime version. The supported values are `8.0`, `9.0` for `dotnet-isolated`, `20` for `node`, `3.10`, `3.11` for `python`, `11`, `17` for `java`, `7.4` for `powershell`.
        :param pulumi.Input[builtins.str] service_plan_id: The ID of the App Service Plan within which to create this Function App. Changing this forces a new Linux Function App to be created.
        :param pulumi.Input['AppFlexConsumptionSiteConfigArgs'] site_config: A `site_config` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionSiteCredentialArgs']]] site_credentials: A `site_credential` block as defined below.
        :param pulumi.Input['AppFlexConsumptionStickySettingsArgs'] sticky_settings: A `sticky_settings` block as defined below.
        :param pulumi.Input[builtins.str] storage_access_key: The access key which will be used to access the backend storage account for the Function App.
               
               > **Note:** The `storage_access_key` must be specified when `storage_authentication_type` is set to `StorageAccountConnectionString`.
        :param pulumi.Input[builtins.str] storage_authentication_type: The authentication type which will be used to access the backend storage account for the Function App. Possible values are `StorageAccountConnectionString`, `SystemAssignedIdentity`, and `UserAssignedIdentity`.
        :param pulumi.Input[builtins.str] storage_container_endpoint: The backend storage container endpoint which will be used by this Function App.
        :param pulumi.Input[builtins.str] storage_container_type: The storage container type used for the Function App. The current supported type is `blobContainer`.
        :param pulumi.Input[builtins.str] storage_user_assigned_identity_id: The user assigned Managed Identity to access the storage account. Conflicts with `storage_access_key`.
               
               > **Note:** The `storage_user_assigned_identity_id` must be specified when `storage_authentication_type` is set to `UserAssignedIdentity`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Linux Function App.
        :param pulumi.Input[builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
               
               > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        :param pulumi.Input[builtins.str] zip_deploy_file: The local path and filename of the Zip packaged application to deploy to this Linux Function App.
               
               > **Note:** Using this value requires either `WEBSITE_RUN_FROM_PACKAGE=1` or `SCM_DO_BUILD_DURING_DEPLOYMENT=true` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        if always_readies is not None:
            pulumi.set(__self__, "always_readies", always_readies)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auth_settings is not None:
            pulumi.set(__self__, "auth_settings", auth_settings)
        if auth_settings_v2 is not None:
            pulumi.set(__self__, "auth_settings_v2", auth_settings_v2)
        if client_certificate_enabled is not None:
            pulumi.set(__self__, "client_certificate_enabled", client_certificate_enabled)
        if client_certificate_exclusion_paths is not None:
            pulumi.set(__self__, "client_certificate_exclusion_paths", client_certificate_exclusion_paths)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if custom_domain_verification_id is not None:
            pulumi.set(__self__, "custom_domain_verification_id", custom_domain_verification_id)
        if default_hostname is not None:
            pulumi.set(__self__, "default_hostname", default_hostname)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if hosting_environment_id is not None:
            pulumi.set(__self__, "hosting_environment_id", hosting_environment_id)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if instance_memory_in_mb is not None:
            pulumi.set(__self__, "instance_memory_in_mb", instance_memory_in_mb)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_instance_count is not None:
            pulumi.set(__self__, "maximum_instance_count", maximum_instance_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_ip_address_lists is not None:
            pulumi.set(__self__, "outbound_ip_address_lists", outbound_ip_address_lists)
        if outbound_ip_addresses is not None:
            pulumi.set(__self__, "outbound_ip_addresses", outbound_ip_addresses)
        if possible_outbound_ip_address_lists is not None:
            pulumi.set(__self__, "possible_outbound_ip_address_lists", possible_outbound_ip_address_lists)
        if possible_outbound_ip_addresses is not None:
            pulumi.set(__self__, "possible_outbound_ip_addresses", possible_outbound_ip_addresses)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if runtime_name is not None:
            pulumi.set(__self__, "runtime_name", runtime_name)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if service_plan_id is not None:
            pulumi.set(__self__, "service_plan_id", service_plan_id)
        if site_config is not None:
            pulumi.set(__self__, "site_config", site_config)
        if site_credentials is not None:
            pulumi.set(__self__, "site_credentials", site_credentials)
        if sticky_settings is not None:
            pulumi.set(__self__, "sticky_settings", sticky_settings)
        if storage_access_key is not None:
            pulumi.set(__self__, "storage_access_key", storage_access_key)
        if storage_authentication_type is not None:
            pulumi.set(__self__, "storage_authentication_type", storage_authentication_type)
        if storage_container_endpoint is not None:
            pulumi.set(__self__, "storage_container_endpoint", storage_container_endpoint)
        if storage_container_type is not None:
            pulumi.set(__self__, "storage_container_type", storage_container_type)
        if storage_user_assigned_identity_id is not None:
            pulumi.set(__self__, "storage_user_assigned_identity_id", storage_user_assigned_identity_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)
        if webdeploy_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "webdeploy_publish_basic_authentication_enabled", webdeploy_publish_basic_authentication_enabled)
        if zip_deploy_file is not None:
            pulumi.set(__self__, "zip_deploy_file", zip_deploy_file)

    @property
    @pulumi.getter(name="alwaysReadies")
    def always_readies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionAlwaysReadyArgs']]]]:
        """
        One or more `always_ready` blocks as defined below.
        """
        return pulumi.get(self, "always_readies")

    @always_readies.setter
    def always_readies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionAlwaysReadyArgs']]]]):
        pulumi.set(self, "always_readies", value)

    @property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key-value pairs for [App
        Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "app_settings", value)

    @property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> Optional[pulumi.Input['AppFlexConsumptionAuthSettingsArgs']]:
        """
        A `auth_settings` block as defined below.
        """
        return pulumi.get(self, "auth_settings")

    @auth_settings.setter
    def auth_settings(self, value: Optional[pulumi.Input['AppFlexConsumptionAuthSettingsArgs']]):
        pulumi.set(self, "auth_settings", value)

    @property
    @pulumi.getter(name="authSettingsV2")
    def auth_settings_v2(self) -> Optional[pulumi.Input['AppFlexConsumptionAuthSettingsV2Args']]:
        """
        An `auth_settings_v2` block as defined below.
        """
        return pulumi.get(self, "auth_settings_v2")

    @auth_settings_v2.setter
    def auth_settings_v2(self, value: Optional[pulumi.Input['AppFlexConsumptionAuthSettingsV2Args']]):
        pulumi.set(self, "auth_settings_v2", value)

    @property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the function app use Client Certificates.
        """
        return pulumi.get(self, "client_certificate_enabled")

    @client_certificate_enabled.setter
    def client_certificate_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "client_certificate_enabled", value)

    @property
    @pulumi.getter(name="clientCertificateExclusionPaths")
    def client_certificate_exclusion_paths(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Paths to exclude when using client certificates, separated by ;
        """
        return pulumi.get(self, "client_certificate_exclusion_paths")

    @client_certificate_exclusion_paths.setter
    def client_certificate_exclusion_paths(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_exclusion_paths", value)

    @property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @client_certificate_mode.setter
    def client_certificate_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_mode", value)

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionConnectionStringArgs']]]]:
        """
        One or more `connection_string` blocks as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @custom_domain_verification_id.setter
    def custom_domain_verification_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_domain_verification_id", value)

    @property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default hostname of the Linux Function App.
        """
        return pulumi.get(self, "default_hostname")

    @default_hostname.setter
    def default_hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_hostname", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the Function App enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="hostingEnvironmentId")
    def hosting_environment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the App Service Environment used by Function App.
        """
        return pulumi.get(self, "hosting_environment_id")

    @hosting_environment_id.setter
    def hosting_environment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hosting_environment_id", value)

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Https Connection enforced to the function app. Defaults to `false`
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AppFlexConsumptionIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AppFlexConsumptionIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="instanceMemoryInMb")
    def instance_memory_in_mb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The memory size of the instances on which your app runs. The [currently supported values](https://learn.microsoft.com/en-us/azure/azure-functions/flex-consumption-plan#instance-memory) are `2048` or `4096`.
        """
        return pulumi.get(self, "instance_memory_in_mb")

    @instance_memory_in_mb.setter
    def instance_memory_in_mb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "instance_memory_in_mb", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kind value for this Linux Function App.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Function App should exist. Changing this forces a new Function App to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maximumInstanceCount")
    def maximum_instance_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of workers this function app can scale out to.
        """
        return pulumi.get(self, "maximum_instance_count")

    @maximum_instance_count.setter
    def maximum_instance_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum_instance_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Function App. Changing this forces a new Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outboundIpAddressLists")
    def outbound_ip_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of outbound IP addresses. For example `["52.23.25.3", "52.143.43.12"]`
        """
        return pulumi.get(self, "outbound_ip_address_lists")

    @outbound_ip_address_lists.setter
    def outbound_ip_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "outbound_ip_address_lists", value)

    @property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comma separated list of outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12`.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @outbound_ip_addresses.setter
    def outbound_ip_addresses(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outbound_ip_addresses", value)

    @property
    @pulumi.getter(name="possibleOutboundIpAddressLists")
    def possible_outbound_ip_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of possible outbound IP addresses, not all of which are necessarily in use. This is a superset of `outbound_ip_address_list`. For example `["52.23.25.3", "52.143.43.12"]`.
        """
        return pulumi.get(self, "possible_outbound_ip_address_lists")

    @possible_outbound_ip_address_lists.setter
    def possible_outbound_ip_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "possible_outbound_ip_address_lists", value)

    @property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comma separated list of possible outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12,52.143.43.17`. This is a superset of `outbound_ip_addresses`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @possible_outbound_ip_addresses.setter
    def possible_outbound_ip_addresses(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "possible_outbound_ip_addresses", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should public network access be enabled for the Function App. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Function App should exist. Changing this forces a new Linux Function App to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="runtimeName")
    def runtime_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Runtime of the Linux Function App. Possible values are `node`, `dotnet-isolated`, `powershell`, `python`, `java` and `custom`.
        """
        return pulumi.get(self, "runtime_name")

    @runtime_name.setter
    def runtime_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runtime_name", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Runtime version of the Linux Function App. The values are diff from different runtime version. The supported values are `8.0`, `9.0` for `dotnet-isolated`, `20` for `node`, `3.10`, `3.11` for `python`, `11`, `17` for `java`, `7.4` for `powershell`.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runtime_version", value)

    @property
    @pulumi.getter(name="servicePlanId")
    def service_plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the App Service Plan within which to create this Function App. Changing this forces a new Linux Function App to be created.
        """
        return pulumi.get(self, "service_plan_id")

    @service_plan_id.setter
    def service_plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_plan_id", value)

    @property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> Optional[pulumi.Input['AppFlexConsumptionSiteConfigArgs']]:
        """
        A `site_config` block as defined below.
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: Optional[pulumi.Input['AppFlexConsumptionSiteConfigArgs']]):
        pulumi.set(self, "site_config", value)

    @property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionSiteCredentialArgs']]]]:
        """
        A `site_credential` block as defined below.
        """
        return pulumi.get(self, "site_credentials")

    @site_credentials.setter
    def site_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppFlexConsumptionSiteCredentialArgs']]]]):
        pulumi.set(self, "site_credentials", value)

    @property
    @pulumi.getter(name="stickySettings")
    def sticky_settings(self) -> Optional[pulumi.Input['AppFlexConsumptionStickySettingsArgs']]:
        """
        A `sticky_settings` block as defined below.
        """
        return pulumi.get(self, "sticky_settings")

    @sticky_settings.setter
    def sticky_settings(self, value: Optional[pulumi.Input['AppFlexConsumptionStickySettingsArgs']]):
        pulumi.set(self, "sticky_settings", value)

    @property
    @pulumi.getter(name="storageAccessKey")
    def storage_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access key which will be used to access the backend storage account for the Function App.

        > **Note:** The `storage_access_key` must be specified when `storage_authentication_type` is set to `StorageAccountConnectionString`.
        """
        return pulumi.get(self, "storage_access_key")

    @storage_access_key.setter
    def storage_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_access_key", value)

    @property
    @pulumi.getter(name="storageAuthenticationType")
    def storage_authentication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The authentication type which will be used to access the backend storage account for the Function App. Possible values are `StorageAccountConnectionString`, `SystemAssignedIdentity`, and `UserAssignedIdentity`.
        """
        return pulumi.get(self, "storage_authentication_type")

    @storage_authentication_type.setter
    def storage_authentication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_authentication_type", value)

    @property
    @pulumi.getter(name="storageContainerEndpoint")
    def storage_container_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The backend storage container endpoint which will be used by this Function App.
        """
        return pulumi.get(self, "storage_container_endpoint")

    @storage_container_endpoint.setter
    def storage_container_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_container_endpoint", value)

    @property
    @pulumi.getter(name="storageContainerType")
    def storage_container_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The storage container type used for the Function App. The current supported type is `blobContainer`.
        """
        return pulumi.get(self, "storage_container_type")

    @storage_container_type.setter
    def storage_container_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_container_type", value)

    @property
    @pulumi.getter(name="storageUserAssignedIdentityId")
    def storage_user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user assigned Managed Identity to access the storage account. Conflicts with `storage_access_key`.

        > **Note:** The `storage_user_assigned_identity_id` must be specified when `storage_authentication_type` is set to `UserAssignedIdentity`.
        """
        return pulumi.get(self, "storage_user_assigned_identity_id")

    @storage_user_assigned_identity_id.setter
    def storage_user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_user_assigned_identity_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Linux Function App.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @virtual_network_subnet_id.setter
    def virtual_network_subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_network_subnet_id", value)

    @property
    @pulumi.getter(name="webdeployPublishBasicAuthenticationEnabled")
    def webdeploy_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.

        > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        """
        return pulumi.get(self, "webdeploy_publish_basic_authentication_enabled")

    @webdeploy_publish_basic_authentication_enabled.setter
    def webdeploy_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "webdeploy_publish_basic_authentication_enabled", value)

    @property
    @pulumi.getter(name="zipDeployFile")
    def zip_deploy_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The local path and filename of the Zip packaged application to deploy to this Linux Function App.

        > **Note:** Using this value requires either `WEBSITE_RUN_FROM_PACKAGE=1` or `SCM_DO_BUILD_DURING_DEPLOYMENT=true` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        return pulumi.get(self, "zip_deploy_file")

    @zip_deploy_file.setter
    def zip_deploy_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zip_deploy_file", value)


@pulumi.type_token("azure:appservice/appFlexConsumption:AppFlexConsumption")
class AppFlexConsumption(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_readies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppFlexConsumptionAlwaysReadyArgs', 'AppFlexConsumptionAlwaysReadyArgsDict']]]]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input[Union['AppFlexConsumptionAuthSettingsArgs', 'AppFlexConsumptionAuthSettingsArgsDict']]] = None,
                 auth_settings_v2: Optional[pulumi.Input[Union['AppFlexConsumptionAuthSettingsV2Args', 'AppFlexConsumptionAuthSettingsV2ArgsDict']]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppFlexConsumptionConnectionStringArgs', 'AppFlexConsumptionConnectionStringArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['AppFlexConsumptionIdentityArgs', 'AppFlexConsumptionIdentityArgsDict']]] = None,
                 instance_memory_in_mb: Optional[pulumi.Input[builtins.int]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maximum_instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_name: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[builtins.str]] = None,
                 service_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 site_config: Optional[pulumi.Input[Union['AppFlexConsumptionSiteConfigArgs', 'AppFlexConsumptionSiteConfigArgsDict']]] = None,
                 sticky_settings: Optional[pulumi.Input[Union['AppFlexConsumptionStickySettingsArgs', 'AppFlexConsumptionStickySettingsArgsDict']]] = None,
                 storage_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_type: Optional[pulumi.Input[builtins.str]] = None,
                 storage_user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 zip_deploy_file: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Function App Running on a Flex Consumption Plan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplelinuxfunctionappsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="example-flexcontainer",
            storage_account_id=example_account.id,
            container_access_type="private")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-app-service-plan",
            resource_group_name=example.name,
            location=example.location,
            sku_name="FC1",
            os_type="Linux")
        example_app_flex_consumption = azure.appservice.AppFlexConsumption("example",
            name="example-linux-function-app",
            resource_group_name=example.name,
            location=example.location,
            service_plan_id=example_service_plan.id,
            storage_container_type="blobContainer",
            storage_container_endpoint=pulumi.Output.all(
                primary_blob_endpoint=example_account.primary_blob_endpoint,
                name=example_container.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['primary_blob_endpoint']}{resolved_outputs['name']}")
        ,
            storage_authentication_type="StorageAccountConnectionString",
            storage_access_key=example_account.primary_access_key,
            runtime_name="node",
            runtime_version="20",
            maximum_instance_count=50,
            instance_memory_in_mb=2048,
            site_config={})
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01, 2023-01-01

        ## Import

        The Function Apps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/appFlexConsumption:AppFlexConsumption example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Web/sites/site1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppFlexConsumptionAlwaysReadyArgs', 'AppFlexConsumptionAlwaysReadyArgsDict']]]] always_readies: One or more `always_ready` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_settings: A map of key-value pairs for [App
               Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        :param pulumi.Input[Union['AppFlexConsumptionAuthSettingsArgs', 'AppFlexConsumptionAuthSettingsArgsDict']] auth_settings: A `auth_settings` block as defined below.
        :param pulumi.Input[Union['AppFlexConsumptionAuthSettingsV2Args', 'AppFlexConsumptionAuthSettingsV2ArgsDict']] auth_settings_v2: An `auth_settings_v2` block as defined below.
        :param pulumi.Input[builtins.bool] client_certificate_enabled: Should the function app use Client Certificates.
        :param pulumi.Input[builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[builtins.str] client_certificate_mode: The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppFlexConsumptionConnectionStringArgs', 'AppFlexConsumptionConnectionStringArgsDict']]]] connection_strings: One or more `connection_string` blocks as defined below.
        :param pulumi.Input[builtins.bool] enabled: Is the Function App enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] https_only: Is Https Connection enforced to the function app. Defaults to `false`
        :param pulumi.Input[Union['AppFlexConsumptionIdentityArgs', 'AppFlexConsumptionIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.int] instance_memory_in_mb: The memory size of the instances on which your app runs. The [currently supported values](https://learn.microsoft.com/en-us/azure/azure-functions/flex-consumption-plan#instance-memory) are `2048` or `4096`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Function App should exist. Changing this forces a new Function App to be created.
        :param pulumi.Input[builtins.int] maximum_instance_count: The number of workers this function app can scale out to.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Function App. Changing this forces a new Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Should public network access be enabled for the Function App. Defaults to `true`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Function App should exist. Changing this forces a new Linux Function App to be created.
        :param pulumi.Input[builtins.str] runtime_name: The Runtime of the Linux Function App. Possible values are `node`, `dotnet-isolated`, `powershell`, `python`, `java` and `custom`.
        :param pulumi.Input[builtins.str] runtime_version: The Runtime version of the Linux Function App. The values are diff from different runtime version. The supported values are `8.0`, `9.0` for `dotnet-isolated`, `20` for `node`, `3.10`, `3.11` for `python`, `11`, `17` for `java`, `7.4` for `powershell`.
        :param pulumi.Input[builtins.str] service_plan_id: The ID of the App Service Plan within which to create this Function App. Changing this forces a new Linux Function App to be created.
        :param pulumi.Input[Union['AppFlexConsumptionSiteConfigArgs', 'AppFlexConsumptionSiteConfigArgsDict']] site_config: A `site_config` block as defined below.
        :param pulumi.Input[Union['AppFlexConsumptionStickySettingsArgs', 'AppFlexConsumptionStickySettingsArgsDict']] sticky_settings: A `sticky_settings` block as defined below.
        :param pulumi.Input[builtins.str] storage_access_key: The access key which will be used to access the backend storage account for the Function App.
               
               > **Note:** The `storage_access_key` must be specified when `storage_authentication_type` is set to `StorageAccountConnectionString`.
        :param pulumi.Input[builtins.str] storage_authentication_type: The authentication type which will be used to access the backend storage account for the Function App. Possible values are `StorageAccountConnectionString`, `SystemAssignedIdentity`, and `UserAssignedIdentity`.
        :param pulumi.Input[builtins.str] storage_container_endpoint: The backend storage container endpoint which will be used by this Function App.
        :param pulumi.Input[builtins.str] storage_container_type: The storage container type used for the Function App. The current supported type is `blobContainer`.
        :param pulumi.Input[builtins.str] storage_user_assigned_identity_id: The user assigned Managed Identity to access the storage account. Conflicts with `storage_access_key`.
               
               > **Note:** The `storage_user_assigned_identity_id` must be specified when `storage_authentication_type` is set to `UserAssignedIdentity`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Linux Function App.
        :param pulumi.Input[builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
               
               > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        :param pulumi.Input[builtins.str] zip_deploy_file: The local path and filename of the Zip packaged application to deploy to this Linux Function App.
               
               > **Note:** Using this value requires either `WEBSITE_RUN_FROM_PACKAGE=1` or `SCM_DO_BUILD_DURING_DEPLOYMENT=true` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppFlexConsumptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Function App Running on a Flex Consumption Plan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplelinuxfunctionappsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="example-flexcontainer",
            storage_account_id=example_account.id,
            container_access_type="private")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-app-service-plan",
            resource_group_name=example.name,
            location=example.location,
            sku_name="FC1",
            os_type="Linux")
        example_app_flex_consumption = azure.appservice.AppFlexConsumption("example",
            name="example-linux-function-app",
            resource_group_name=example.name,
            location=example.location,
            service_plan_id=example_service_plan.id,
            storage_container_type="blobContainer",
            storage_container_endpoint=pulumi.Output.all(
                primary_blob_endpoint=example_account.primary_blob_endpoint,
                name=example_container.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['primary_blob_endpoint']}{resolved_outputs['name']}")
        ,
            storage_authentication_type="StorageAccountConnectionString",
            storage_access_key=example_account.primary_access_key,
            runtime_name="node",
            runtime_version="20",
            maximum_instance_count=50,
            instance_memory_in_mb=2048,
            site_config={})
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01, 2023-01-01

        ## Import

        The Function Apps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/appFlexConsumption:AppFlexConsumption example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Web/sites/site1
        ```

        :param str resource_name: The name of the resource.
        :param AppFlexConsumptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppFlexConsumptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_readies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppFlexConsumptionAlwaysReadyArgs', 'AppFlexConsumptionAlwaysReadyArgsDict']]]]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input[Union['AppFlexConsumptionAuthSettingsArgs', 'AppFlexConsumptionAuthSettingsArgsDict']]] = None,
                 auth_settings_v2: Optional[pulumi.Input[Union['AppFlexConsumptionAuthSettingsV2Args', 'AppFlexConsumptionAuthSettingsV2ArgsDict']]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppFlexConsumptionConnectionStringArgs', 'AppFlexConsumptionConnectionStringArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['AppFlexConsumptionIdentityArgs', 'AppFlexConsumptionIdentityArgsDict']]] = None,
                 instance_memory_in_mb: Optional[pulumi.Input[builtins.int]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maximum_instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_name: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[builtins.str]] = None,
                 service_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 site_config: Optional[pulumi.Input[Union['AppFlexConsumptionSiteConfigArgs', 'AppFlexConsumptionSiteConfigArgsDict']]] = None,
                 sticky_settings: Optional[pulumi.Input[Union['AppFlexConsumptionStickySettingsArgs', 'AppFlexConsumptionStickySettingsArgsDict']]] = None,
                 storage_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_type: Optional[pulumi.Input[builtins.str]] = None,
                 storage_user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 zip_deploy_file: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppFlexConsumptionArgs.__new__(AppFlexConsumptionArgs)

            __props__.__dict__["always_readies"] = always_readies
            __props__.__dict__["app_settings"] = app_settings
            __props__.__dict__["auth_settings"] = auth_settings
            __props__.__dict__["auth_settings_v2"] = auth_settings_v2
            __props__.__dict__["client_certificate_enabled"] = client_certificate_enabled
            __props__.__dict__["client_certificate_exclusion_paths"] = client_certificate_exclusion_paths
            __props__.__dict__["client_certificate_mode"] = client_certificate_mode
            __props__.__dict__["connection_strings"] = connection_strings
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["https_only"] = https_only
            __props__.__dict__["identity"] = identity
            __props__.__dict__["instance_memory_in_mb"] = instance_memory_in_mb
            __props__.__dict__["location"] = location
            __props__.__dict__["maximum_instance_count"] = maximum_instance_count
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if runtime_name is None and not opts.urn:
                raise TypeError("Missing required property 'runtime_name'")
            __props__.__dict__["runtime_name"] = runtime_name
            if runtime_version is None and not opts.urn:
                raise TypeError("Missing required property 'runtime_version'")
            __props__.__dict__["runtime_version"] = runtime_version
            if service_plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_plan_id'")
            __props__.__dict__["service_plan_id"] = service_plan_id
            if site_config is None and not opts.urn:
                raise TypeError("Missing required property 'site_config'")
            __props__.__dict__["site_config"] = site_config
            __props__.__dict__["sticky_settings"] = sticky_settings
            __props__.__dict__["storage_access_key"] = storage_access_key
            if storage_authentication_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_authentication_type'")
            __props__.__dict__["storage_authentication_type"] = storage_authentication_type
            if storage_container_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container_endpoint'")
            __props__.__dict__["storage_container_endpoint"] = storage_container_endpoint
            if storage_container_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container_type'")
            __props__.__dict__["storage_container_type"] = storage_container_type
            __props__.__dict__["storage_user_assigned_identity_id"] = storage_user_assigned_identity_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["virtual_network_subnet_id"] = virtual_network_subnet_id
            __props__.__dict__["webdeploy_publish_basic_authentication_enabled"] = webdeploy_publish_basic_authentication_enabled
            __props__.__dict__["zip_deploy_file"] = zip_deploy_file
            __props__.__dict__["custom_domain_verification_id"] = None
            __props__.__dict__["default_hostname"] = None
            __props__.__dict__["hosting_environment_id"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["outbound_ip_address_lists"] = None
            __props__.__dict__["outbound_ip_addresses"] = None
            __props__.__dict__["possible_outbound_ip_address_lists"] = None
            __props__.__dict__["possible_outbound_ip_addresses"] = None
            __props__.__dict__["site_credentials"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["customDomainVerificationId", "siteCredentials"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AppFlexConsumption, __self__).__init__(
            'azure:appservice/appFlexConsumption:AppFlexConsumption',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            always_readies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppFlexConsumptionAlwaysReadyArgs', 'AppFlexConsumptionAlwaysReadyArgsDict']]]]] = None,
            app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            auth_settings: Optional[pulumi.Input[Union['AppFlexConsumptionAuthSettingsArgs', 'AppFlexConsumptionAuthSettingsArgsDict']]] = None,
            auth_settings_v2: Optional[pulumi.Input[Union['AppFlexConsumptionAuthSettingsV2Args', 'AppFlexConsumptionAuthSettingsV2ArgsDict']]] = None,
            client_certificate_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            client_certificate_exclusion_paths: Optional[pulumi.Input[builtins.str]] = None,
            client_certificate_mode: Optional[pulumi.Input[builtins.str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppFlexConsumptionConnectionStringArgs', 'AppFlexConsumptionConnectionStringArgsDict']]]]] = None,
            custom_domain_verification_id: Optional[pulumi.Input[builtins.str]] = None,
            default_hostname: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            hosting_environment_id: Optional[pulumi.Input[builtins.str]] = None,
            https_only: Optional[pulumi.Input[builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['AppFlexConsumptionIdentityArgs', 'AppFlexConsumptionIdentityArgsDict']]] = None,
            instance_memory_in_mb: Optional[pulumi.Input[builtins.int]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            maximum_instance_count: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            outbound_ip_addresses: Optional[pulumi.Input[builtins.str]] = None,
            possible_outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            possible_outbound_ip_addresses: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            runtime_name: Optional[pulumi.Input[builtins.str]] = None,
            runtime_version: Optional[pulumi.Input[builtins.str]] = None,
            service_plan_id: Optional[pulumi.Input[builtins.str]] = None,
            site_config: Optional[pulumi.Input[Union['AppFlexConsumptionSiteConfigArgs', 'AppFlexConsumptionSiteConfigArgsDict']]] = None,
            site_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppFlexConsumptionSiteCredentialArgs', 'AppFlexConsumptionSiteCredentialArgsDict']]]]] = None,
            sticky_settings: Optional[pulumi.Input[Union['AppFlexConsumptionStickySettingsArgs', 'AppFlexConsumptionStickySettingsArgsDict']]] = None,
            storage_access_key: Optional[pulumi.Input[builtins.str]] = None,
            storage_authentication_type: Optional[pulumi.Input[builtins.str]] = None,
            storage_container_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            storage_container_type: Optional[pulumi.Input[builtins.str]] = None,
            storage_user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            virtual_network_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            zip_deploy_file: Optional[pulumi.Input[builtins.str]] = None) -> 'AppFlexConsumption':
        """
        Get an existing AppFlexConsumption resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppFlexConsumptionAlwaysReadyArgs', 'AppFlexConsumptionAlwaysReadyArgsDict']]]] always_readies: One or more `always_ready` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_settings: A map of key-value pairs for [App
               Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        :param pulumi.Input[Union['AppFlexConsumptionAuthSettingsArgs', 'AppFlexConsumptionAuthSettingsArgsDict']] auth_settings: A `auth_settings` block as defined below.
        :param pulumi.Input[Union['AppFlexConsumptionAuthSettingsV2Args', 'AppFlexConsumptionAuthSettingsV2ArgsDict']] auth_settings_v2: An `auth_settings_v2` block as defined below.
        :param pulumi.Input[builtins.bool] client_certificate_enabled: Should the function app use Client Certificates.
        :param pulumi.Input[builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[builtins.str] client_certificate_mode: The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppFlexConsumptionConnectionStringArgs', 'AppFlexConsumptionConnectionStringArgsDict']]]] connection_strings: One or more `connection_string` blocks as defined below.
        :param pulumi.Input[builtins.str] custom_domain_verification_id: The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        :param pulumi.Input[builtins.str] default_hostname: The default hostname of the Linux Function App.
        :param pulumi.Input[builtins.bool] enabled: Is the Function App enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] hosting_environment_id: The ID of the App Service Environment used by Function App.
        :param pulumi.Input[builtins.bool] https_only: Is Https Connection enforced to the function app. Defaults to `false`
        :param pulumi.Input[Union['AppFlexConsumptionIdentityArgs', 'AppFlexConsumptionIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.int] instance_memory_in_mb: The memory size of the instances on which your app runs. The [currently supported values](https://learn.microsoft.com/en-us/azure/azure-functions/flex-consumption-plan#instance-memory) are `2048` or `4096`.
        :param pulumi.Input[builtins.str] kind: The Kind value for this Linux Function App.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Function App should exist. Changing this forces a new Function App to be created.
        :param pulumi.Input[builtins.int] maximum_instance_count: The number of workers this function app can scale out to.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Function App. Changing this forces a new Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] outbound_ip_address_lists: A list of outbound IP addresses. For example `["52.23.25.3", "52.143.43.12"]`
        :param pulumi.Input[builtins.str] outbound_ip_addresses: A comma separated list of outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] possible_outbound_ip_address_lists: A list of possible outbound IP addresses, not all of which are necessarily in use. This is a superset of `outbound_ip_address_list`. For example `["52.23.25.3", "52.143.43.12"]`.
        :param pulumi.Input[builtins.str] possible_outbound_ip_addresses: A comma separated list of possible outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12,52.143.43.17`. This is a superset of `outbound_ip_addresses`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Should public network access be enabled for the Function App. Defaults to `true`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Function App should exist. Changing this forces a new Linux Function App to be created.
        :param pulumi.Input[builtins.str] runtime_name: The Runtime of the Linux Function App. Possible values are `node`, `dotnet-isolated`, `powershell`, `python`, `java` and `custom`.
        :param pulumi.Input[builtins.str] runtime_version: The Runtime version of the Linux Function App. The values are diff from different runtime version. The supported values are `8.0`, `9.0` for `dotnet-isolated`, `20` for `node`, `3.10`, `3.11` for `python`, `11`, `17` for `java`, `7.4` for `powershell`.
        :param pulumi.Input[builtins.str] service_plan_id: The ID of the App Service Plan within which to create this Function App. Changing this forces a new Linux Function App to be created.
        :param pulumi.Input[Union['AppFlexConsumptionSiteConfigArgs', 'AppFlexConsumptionSiteConfigArgsDict']] site_config: A `site_config` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppFlexConsumptionSiteCredentialArgs', 'AppFlexConsumptionSiteCredentialArgsDict']]]] site_credentials: A `site_credential` block as defined below.
        :param pulumi.Input[Union['AppFlexConsumptionStickySettingsArgs', 'AppFlexConsumptionStickySettingsArgsDict']] sticky_settings: A `sticky_settings` block as defined below.
        :param pulumi.Input[builtins.str] storage_access_key: The access key which will be used to access the backend storage account for the Function App.
               
               > **Note:** The `storage_access_key` must be specified when `storage_authentication_type` is set to `StorageAccountConnectionString`.
        :param pulumi.Input[builtins.str] storage_authentication_type: The authentication type which will be used to access the backend storage account for the Function App. Possible values are `StorageAccountConnectionString`, `SystemAssignedIdentity`, and `UserAssignedIdentity`.
        :param pulumi.Input[builtins.str] storage_container_endpoint: The backend storage container endpoint which will be used by this Function App.
        :param pulumi.Input[builtins.str] storage_container_type: The storage container type used for the Function App. The current supported type is `blobContainer`.
        :param pulumi.Input[builtins.str] storage_user_assigned_identity_id: The user assigned Managed Identity to access the storage account. Conflicts with `storage_access_key`.
               
               > **Note:** The `storage_user_assigned_identity_id` must be specified when `storage_authentication_type` is set to `UserAssignedIdentity`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Linux Function App.
        :param pulumi.Input[builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
               
               > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        :param pulumi.Input[builtins.str] zip_deploy_file: The local path and filename of the Zip packaged application to deploy to this Linux Function App.
               
               > **Note:** Using this value requires either `WEBSITE_RUN_FROM_PACKAGE=1` or `SCM_DO_BUILD_DURING_DEPLOYMENT=true` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppFlexConsumptionState.__new__(_AppFlexConsumptionState)

        __props__.__dict__["always_readies"] = always_readies
        __props__.__dict__["app_settings"] = app_settings
        __props__.__dict__["auth_settings"] = auth_settings
        __props__.__dict__["auth_settings_v2"] = auth_settings_v2
        __props__.__dict__["client_certificate_enabled"] = client_certificate_enabled
        __props__.__dict__["client_certificate_exclusion_paths"] = client_certificate_exclusion_paths
        __props__.__dict__["client_certificate_mode"] = client_certificate_mode
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["custom_domain_verification_id"] = custom_domain_verification_id
        __props__.__dict__["default_hostname"] = default_hostname
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["hosting_environment_id"] = hosting_environment_id
        __props__.__dict__["https_only"] = https_only
        __props__.__dict__["identity"] = identity
        __props__.__dict__["instance_memory_in_mb"] = instance_memory_in_mb
        __props__.__dict__["kind"] = kind
        __props__.__dict__["location"] = location
        __props__.__dict__["maximum_instance_count"] = maximum_instance_count
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_ip_address_lists"] = outbound_ip_address_lists
        __props__.__dict__["outbound_ip_addresses"] = outbound_ip_addresses
        __props__.__dict__["possible_outbound_ip_address_lists"] = possible_outbound_ip_address_lists
        __props__.__dict__["possible_outbound_ip_addresses"] = possible_outbound_ip_addresses
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["runtime_name"] = runtime_name
        __props__.__dict__["runtime_version"] = runtime_version
        __props__.__dict__["service_plan_id"] = service_plan_id
        __props__.__dict__["site_config"] = site_config
        __props__.__dict__["site_credentials"] = site_credentials
        __props__.__dict__["sticky_settings"] = sticky_settings
        __props__.__dict__["storage_access_key"] = storage_access_key
        __props__.__dict__["storage_authentication_type"] = storage_authentication_type
        __props__.__dict__["storage_container_endpoint"] = storage_container_endpoint
        __props__.__dict__["storage_container_type"] = storage_container_type
        __props__.__dict__["storage_user_assigned_identity_id"] = storage_user_assigned_identity_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_network_subnet_id"] = virtual_network_subnet_id
        __props__.__dict__["webdeploy_publish_basic_authentication_enabled"] = webdeploy_publish_basic_authentication_enabled
        __props__.__dict__["zip_deploy_file"] = zip_deploy_file
        return AppFlexConsumption(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alwaysReadies")
    def always_readies(self) -> pulumi.Output[Optional[Sequence['outputs.AppFlexConsumptionAlwaysReady']]]:
        """
        One or more `always_ready` blocks as defined below.
        """
        return pulumi.get(self, "always_readies")

    @property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of key-value pairs for [App
        Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        """
        return pulumi.get(self, "app_settings")

    @property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> pulumi.Output[Optional['outputs.AppFlexConsumptionAuthSettings']]:
        """
        A `auth_settings` block as defined below.
        """
        return pulumi.get(self, "auth_settings")

    @property
    @pulumi.getter(name="authSettingsV2")
    def auth_settings_v2(self) -> pulumi.Output[Optional['outputs.AppFlexConsumptionAuthSettingsV2']]:
        """
        An `auth_settings_v2` block as defined below.
        """
        return pulumi.get(self, "auth_settings_v2")

    @property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the function app use Client Certificates.
        """
        return pulumi.get(self, "client_certificate_enabled")

    @property
    @pulumi.getter(name="clientCertificateExclusionPaths")
    def client_certificate_exclusion_paths(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Paths to exclude when using client certificates, separated by ;
        """
        return pulumi.get(self, "client_certificate_exclusion_paths")

    @property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Optional[Sequence['outputs.AppFlexConsumptionConnectionString']]]:
        """
        One or more `connection_string` blocks as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> pulumi.Output[builtins.str]:
        """
        The default hostname of the Linux Function App.
        """
        return pulumi.get(self, "default_hostname")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is the Function App enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="hostingEnvironmentId")
    def hosting_environment_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the App Service Environment used by Function App.
        """
        return pulumi.get(self, "hosting_environment_id")

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is Https Connection enforced to the function app. Defaults to `false`
        """
        return pulumi.get(self, "https_only")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.AppFlexConsumptionIdentity']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="instanceMemoryInMb")
    def instance_memory_in_mb(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The memory size of the instances on which your app runs. The [currently supported values](https://learn.microsoft.com/en-us/azure/azure-functions/flex-consumption-plan#instance-memory) are `2048` or `4096`.
        """
        return pulumi.get(self, "instance_memory_in_mb")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[builtins.str]:
        """
        The Kind value for this Linux Function App.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Function App should exist. Changing this forces a new Function App to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maximumInstanceCount")
    def maximum_instance_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of workers this function app can scale out to.
        """
        return pulumi.get(self, "maximum_instance_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Function App. Changing this forces a new Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundIpAddressLists")
    def outbound_ip_address_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of outbound IP addresses. For example `["52.23.25.3", "52.143.43.12"]`
        """
        return pulumi.get(self, "outbound_ip_address_lists")

    @property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> pulumi.Output[builtins.str]:
        """
        A comma separated list of outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12`.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @property
    @pulumi.getter(name="possibleOutboundIpAddressLists")
    def possible_outbound_ip_address_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of possible outbound IP addresses, not all of which are necessarily in use. This is a superset of `outbound_ip_address_list`. For example `["52.23.25.3", "52.143.43.12"]`.
        """
        return pulumi.get(self, "possible_outbound_ip_address_lists")

    @property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> pulumi.Output[builtins.str]:
        """
        A comma separated list of possible outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12,52.143.43.17`. This is a superset of `outbound_ip_addresses`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should public network access be enabled for the Function App. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Function App should exist. Changing this forces a new Linux Function App to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="runtimeName")
    def runtime_name(self) -> pulumi.Output[builtins.str]:
        """
        The Runtime of the Linux Function App. Possible values are `node`, `dotnet-isolated`, `powershell`, `python`, `java` and `custom`.
        """
        return pulumi.get(self, "runtime_name")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Output[builtins.str]:
        """
        The Runtime version of the Linux Function App. The values are diff from different runtime version. The supported values are `8.0`, `9.0` for `dotnet-isolated`, `20` for `node`, `3.10`, `3.11` for `python`, `11`, `17` for `java`, `7.4` for `powershell`.
        """
        return pulumi.get(self, "runtime_version")

    @property
    @pulumi.getter(name="servicePlanId")
    def service_plan_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the App Service Plan within which to create this Function App. Changing this forces a new Linux Function App to be created.
        """
        return pulumi.get(self, "service_plan_id")

    @property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> pulumi.Output['outputs.AppFlexConsumptionSiteConfig']:
        """
        A `site_config` block as defined below.
        """
        return pulumi.get(self, "site_config")

    @property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> pulumi.Output[Sequence['outputs.AppFlexConsumptionSiteCredential']]:
        """
        A `site_credential` block as defined below.
        """
        return pulumi.get(self, "site_credentials")

    @property
    @pulumi.getter(name="stickySettings")
    def sticky_settings(self) -> pulumi.Output[Optional['outputs.AppFlexConsumptionStickySettings']]:
        """
        A `sticky_settings` block as defined below.
        """
        return pulumi.get(self, "sticky_settings")

    @property
    @pulumi.getter(name="storageAccessKey")
    def storage_access_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The access key which will be used to access the backend storage account for the Function App.

        > **Note:** The `storage_access_key` must be specified when `storage_authentication_type` is set to `StorageAccountConnectionString`.
        """
        return pulumi.get(self, "storage_access_key")

    @property
    @pulumi.getter(name="storageAuthenticationType")
    def storage_authentication_type(self) -> pulumi.Output[builtins.str]:
        """
        The authentication type which will be used to access the backend storage account for the Function App. Possible values are `StorageAccountConnectionString`, `SystemAssignedIdentity`, and `UserAssignedIdentity`.
        """
        return pulumi.get(self, "storage_authentication_type")

    @property
    @pulumi.getter(name="storageContainerEndpoint")
    def storage_container_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The backend storage container endpoint which will be used by this Function App.
        """
        return pulumi.get(self, "storage_container_endpoint")

    @property
    @pulumi.getter(name="storageContainerType")
    def storage_container_type(self) -> pulumi.Output[builtins.str]:
        """
        The storage container type used for the Function App. The current supported type is `blobContainer`.
        """
        return pulumi.get(self, "storage_container_type")

    @property
    @pulumi.getter(name="storageUserAssignedIdentityId")
    def storage_user_assigned_identity_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user assigned Managed Identity to access the storage account. Conflicts with `storage_access_key`.

        > **Note:** The `storage_user_assigned_identity_id` must be specified when `storage_authentication_type` is set to `UserAssignedIdentity`.
        """
        return pulumi.get(self, "storage_user_assigned_identity_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Linux Function App.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @property
    @pulumi.getter(name="webdeployPublishBasicAuthenticationEnabled")
    def webdeploy_publish_basic_authentication_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.

        > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        """
        return pulumi.get(self, "webdeploy_publish_basic_authentication_enabled")

    @property
    @pulumi.getter(name="zipDeployFile")
    def zip_deploy_file(self) -> pulumi.Output[builtins.str]:
        """
        The local path and filename of the Zip packaged application to deploy to this Linux Function App.

        > **Note:** Using this value requires either `WEBSITE_RUN_FROM_PACKAGE=1` or `SCM_DO_BUILD_DURING_DEPLOYMENT=true` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        return pulumi.get(self, "zip_deploy_file")

