# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionAppArgs', 'FunctionApp']

@pulumi.input_type
class FunctionAppArgs:
    def __init__(__self__, *,
                 app_service_plan_id: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 storage_account_access_key: pulumi.Input[builtins.str],
                 storage_account_name: pulumi.Input[builtins.str],
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input['FunctionAppAuthSettingsArgs']] = None,
                 client_cert_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppConnectionStringArgs']]]] = None,
                 daily_memory_time_quota: Optional[pulumi.Input[builtins.int]] = None,
                 enable_builtin_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['FunctionAppIdentityArgs']] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 os_type: Optional[pulumi.Input[builtins.str]] = None,
                 site_config: Optional[pulumi.Input['FunctionAppSiteConfigArgs']] = None,
                 source_control: Optional[pulumi.Input['FunctionAppSourceControlArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a FunctionApp resource.
        :param pulumi.Input[builtins.str] app_service_plan_id: The ID of the App Service Plan within which to create this Function App.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Function App. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_account_access_key: The access key which will be used to access the backend storage account for the Function App.
               
               > **Note:** When integrating a `CI/CD pipeline` and expecting to run from a deployed package in `Azure` you must seed your `app settings` as part of the application code for function app to be successfully deployed. `Important Default key pairs`: (`"WEBSITE_RUN_FROM_PACKAGE" = ""`, `"FUNCTIONS_WORKER_RUNTIME" = "node"` (or python, etc), `"WEBSITE_NODE_DEFAULT_VERSION" = "10.14.1"`, `"APPINSIGHTS_INSTRUMENTATIONKEY" = ""`).
               
               > **Note:**  When using an App Service Plan in the `Free` or `Shared` Tiers `use_32_bit_worker_process` must be set to `true`.
        :param pulumi.Input[builtins.str] storage_account_name: The backend storage account name which will be used by this Function App (such as the dashboard, logs). Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_settings: A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
               
               > **NOTE:** The values for `AzureWebJobsStorage` and `FUNCTIONS_EXTENSION_VERSION` will be filled by other input arguments and shouldn't be configured separately. `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`.
        :param pulumi.Input['FunctionAppAuthSettingsArgs'] auth_settings: A `auth_settings` block as defined below.
        :param pulumi.Input[builtins.str] client_cert_mode: The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionAppConnectionStringArgs']]] connection_strings: An `connection_string` block as defined below.
        :param pulumi.Input[builtins.int] daily_memory_time_quota: The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan.
        :param pulumi.Input[builtins.bool] enable_builtin_logging: Should the built-in logging of this Function App be enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] enabled: Is the Function App enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] https_only: Can the Function App only be accessed via HTTPS? Defaults to `false`.
        :param pulumi.Input['FunctionAppIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] key_vault_reference_identity_id: The User Assigned Identity Id used for looking up KeyVault secrets. The identity must be assigned to the application. See [Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity) for more information.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Function App. Changing this forces a new resource to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftweb).
        :param pulumi.Input[builtins.str] os_type: A string indicating the Operating System type for this function app. Possible values are `linux` and ``(empty string). Changing this forces a new resource to be created. Defaults to `""`.
               
               > **NOTE:** This value will be `linux` for Linux derivatives, or an empty string for Windows (default). When set to `linux` you must also set `appservice.Plan` arguments as `kind = "Linux"` and `reserved = true`
        :param pulumi.Input['FunctionAppSiteConfigArgs'] site_config: A `site_config` object as defined below.
        :param pulumi.Input['FunctionAppSourceControlArgs'] source_control: A `source_control` block, as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] version: The runtime version associated with the Function App. Defaults to `~1`.
        """
        pulumi.set(__self__, "app_service_plan_id", app_service_plan_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auth_settings is not None:
            pulumi.set(__self__, "auth_settings", auth_settings)
        if client_cert_mode is not None:
            pulumi.set(__self__, "client_cert_mode", client_cert_mode)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if daily_memory_time_quota is not None:
            pulumi.set(__self__, "daily_memory_time_quota", daily_memory_time_quota)
        if enable_builtin_logging is not None:
            pulumi.set(__self__, "enable_builtin_logging", enable_builtin_logging)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_reference_identity_id is not None:
            pulumi.set(__self__, "key_vault_reference_identity_id", key_vault_reference_identity_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if site_config is not None:
            pulumi.set(__self__, "site_config", site_config)
        if source_control is not None:
            pulumi.set(__self__, "source_control", source_control)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="appServicePlanId")
    def app_service_plan_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the App Service Plan within which to create this Function App.
        """
        return pulumi.get(self, "app_service_plan_id")

    @app_service_plan_id.setter
    def app_service_plan_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "app_service_plan_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the Function App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> pulumi.Input[builtins.str]:
        """
        The access key which will be used to access the backend storage account for the Function App.

        > **Note:** When integrating a `CI/CD pipeline` and expecting to run from a deployed package in `Azure` you must seed your `app settings` as part of the application code for function app to be successfully deployed. `Important Default key pairs`: (`"WEBSITE_RUN_FROM_PACKAGE" = ""`, `"FUNCTIONS_WORKER_RUNTIME" = "node"` (or python, etc), `"WEBSITE_NODE_DEFAULT_VERSION" = "10.14.1"`, `"APPINSIGHTS_INSTRUMENTATIONKEY" = ""`).

        > **Note:**  When using an App Service Plan in the `Free` or `Shared` Tiers `use_32_bit_worker_process` must be set to `true`.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_account_access_key", value)

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Input[builtins.str]:
        """
        The backend storage account name which will be used by this Function App (such as the dashboard, logs). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_account_name", value)

    @property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.

        > **NOTE:** The values for `AzureWebJobsStorage` and `FUNCTIONS_EXTENSION_VERSION` will be filled by other input arguments and shouldn't be configured separately. `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "app_settings", value)

    @property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> Optional[pulumi.Input['FunctionAppAuthSettingsArgs']]:
        """
        A `auth_settings` block as defined below.
        """
        return pulumi.get(self, "auth_settings")

    @auth_settings.setter
    def auth_settings(self, value: Optional[pulumi.Input['FunctionAppAuthSettingsArgs']]):
        pulumi.set(self, "auth_settings", value)

    @property
    @pulumi.getter(name="clientCertMode")
    def client_cert_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        """
        return pulumi.get(self, "client_cert_mode")

    @client_cert_mode.setter
    def client_cert_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_cert_mode", value)

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppConnectionStringArgs']]]]:
        """
        An `connection_string` block as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @property
    @pulumi.getter(name="dailyMemoryTimeQuota")
    def daily_memory_time_quota(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan.
        """
        return pulumi.get(self, "daily_memory_time_quota")

    @daily_memory_time_quota.setter
    def daily_memory_time_quota(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "daily_memory_time_quota", value)

    @property
    @pulumi.getter(name="enableBuiltinLogging")
    def enable_builtin_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the built-in logging of this Function App be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enable_builtin_logging")

    @enable_builtin_logging.setter
    def enable_builtin_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_builtin_logging", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the Function App enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Can the Function App only be accessed via HTTPS? Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['FunctionAppIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['FunctionAppIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyVaultReferenceIdentityId")
    def key_vault_reference_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The User Assigned Identity Id used for looking up KeyVault secrets. The identity must be assigned to the application. See [Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity) for more information.
        """
        return pulumi.get(self, "key_vault_reference_identity_id")

    @key_vault_reference_identity_id.setter
    def key_vault_reference_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_reference_identity_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Function App. Changing this forces a new resource to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftweb).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string indicating the Operating System type for this function app. Possible values are `linux` and ``(empty string). Changing this forces a new resource to be created. Defaults to `""`.

        > **NOTE:** This value will be `linux` for Linux derivatives, or an empty string for Windows (default). When set to `linux` you must also set `appservice.Plan` arguments as `kind = "Linux"` and `reserved = true`
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> Optional[pulumi.Input['FunctionAppSiteConfigArgs']]:
        """
        A `site_config` object as defined below.
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: Optional[pulumi.Input['FunctionAppSiteConfigArgs']]):
        pulumi.set(self, "site_config", value)

    @property
    @pulumi.getter(name="sourceControl")
    def source_control(self) -> Optional[pulumi.Input['FunctionAppSourceControlArgs']]:
        """
        A `source_control` block, as defined below.
        """
        return pulumi.get(self, "source_control")

    @source_control.setter
    def source_control(self, value: Optional[pulumi.Input['FunctionAppSourceControlArgs']]):
        pulumi.set(self, "source_control", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The runtime version associated with the Function App. Defaults to `~1`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _FunctionAppState:
    def __init__(__self__, *,
                 app_service_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input['FunctionAppAuthSettingsArgs']] = None,
                 client_cert_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppConnectionStringArgs']]]] = None,
                 custom_domain_verification_id: Optional[pulumi.Input[builtins.str]] = None,
                 daily_memory_time_quota: Optional[pulumi.Input[builtins.int]] = None,
                 default_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 enable_builtin_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['FunctionAppIdentityArgs']] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 os_type: Optional[pulumi.Input[builtins.str]] = None,
                 outbound_ip_addresses: Optional[pulumi.Input[builtins.str]] = None,
                 possible_outbound_ip_addresses: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 site_config: Optional[pulumi.Input['FunctionAppSiteConfigArgs']] = None,
                 site_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppSiteCredentialArgs']]]] = None,
                 source_control: Optional[pulumi.Input['FunctionAppSourceControlArgs']] = None,
                 storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FunctionApp resources.
        :param pulumi.Input[builtins.str] app_service_plan_id: The ID of the App Service Plan within which to create this Function App.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_settings: A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
               
               > **NOTE:** The values for `AzureWebJobsStorage` and `FUNCTIONS_EXTENSION_VERSION` will be filled by other input arguments and shouldn't be configured separately. `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`.
        :param pulumi.Input['FunctionAppAuthSettingsArgs'] auth_settings: A `auth_settings` block as defined below.
        :param pulumi.Input[builtins.str] client_cert_mode: The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionAppConnectionStringArgs']]] connection_strings: An `connection_string` block as defined below.
        :param pulumi.Input[builtins.str] custom_domain_verification_id: An identifier used by App Service to perform domain ownership verification via DNS TXT record.
        :param pulumi.Input[builtins.int] daily_memory_time_quota: The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan.
        :param pulumi.Input[builtins.str] default_hostname: The default hostname associated with the Function App - such as `mysite.azurewebsites.net`
        :param pulumi.Input[builtins.bool] enable_builtin_logging: Should the built-in logging of this Function App be enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] enabled: Is the Function App enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] https_only: Can the Function App only be accessed via HTTPS? Defaults to `false`.
        :param pulumi.Input['FunctionAppIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] key_vault_reference_identity_id: The User Assigned Identity Id used for looking up KeyVault secrets. The identity must be assigned to the application. See [Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity) for more information.
        :param pulumi.Input[builtins.str] kind: The Function App kind - such as `functionapp,linux,container`
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Function App. Changing this forces a new resource to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftweb).
        :param pulumi.Input[builtins.str] os_type: A string indicating the Operating System type for this function app. Possible values are `linux` and ``(empty string). Changing this forces a new resource to be created. Defaults to `""`.
               
               > **NOTE:** This value will be `linux` for Linux derivatives, or an empty string for Windows (default). When set to `linux` you must also set `appservice.Plan` arguments as `kind = "Linux"` and `reserved = true`
        :param pulumi.Input[builtins.str] outbound_ip_addresses: A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12`
        :param pulumi.Input[builtins.str] possible_outbound_ip_addresses: A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12,52.143.43.17` - not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Function App. Changing this forces a new resource to be created.
        :param pulumi.Input['FunctionAppSiteConfigArgs'] site_config: A `site_config` object as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionAppSiteCredentialArgs']]] site_credentials: A `site_credential` block as defined below, which contains the site-level credentials used to publish to this App Service.
        :param pulumi.Input['FunctionAppSourceControlArgs'] source_control: A `source_control` block, as defined below.
        :param pulumi.Input[builtins.str] storage_account_access_key: The access key which will be used to access the backend storage account for the Function App.
               
               > **Note:** When integrating a `CI/CD pipeline` and expecting to run from a deployed package in `Azure` you must seed your `app settings` as part of the application code for function app to be successfully deployed. `Important Default key pairs`: (`"WEBSITE_RUN_FROM_PACKAGE" = ""`, `"FUNCTIONS_WORKER_RUNTIME" = "node"` (or python, etc), `"WEBSITE_NODE_DEFAULT_VERSION" = "10.14.1"`, `"APPINSIGHTS_INSTRUMENTATIONKEY" = ""`).
               
               > **Note:**  When using an App Service Plan in the `Free` or `Shared` Tiers `use_32_bit_worker_process` must be set to `true`.
        :param pulumi.Input[builtins.str] storage_account_name: The backend storage account name which will be used by this Function App (such as the dashboard, logs). Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] version: The runtime version associated with the Function App. Defaults to `~1`.
        """
        if app_service_plan_id is not None:
            pulumi.set(__self__, "app_service_plan_id", app_service_plan_id)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auth_settings is not None:
            pulumi.set(__self__, "auth_settings", auth_settings)
        if client_cert_mode is not None:
            pulumi.set(__self__, "client_cert_mode", client_cert_mode)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if custom_domain_verification_id is not None:
            pulumi.set(__self__, "custom_domain_verification_id", custom_domain_verification_id)
        if daily_memory_time_quota is not None:
            pulumi.set(__self__, "daily_memory_time_quota", daily_memory_time_quota)
        if default_hostname is not None:
            pulumi.set(__self__, "default_hostname", default_hostname)
        if enable_builtin_logging is not None:
            pulumi.set(__self__, "enable_builtin_logging", enable_builtin_logging)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_reference_identity_id is not None:
            pulumi.set(__self__, "key_vault_reference_identity_id", key_vault_reference_identity_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if outbound_ip_addresses is not None:
            pulumi.set(__self__, "outbound_ip_addresses", outbound_ip_addresses)
        if possible_outbound_ip_addresses is not None:
            pulumi.set(__self__, "possible_outbound_ip_addresses", possible_outbound_ip_addresses)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if site_config is not None:
            pulumi.set(__self__, "site_config", site_config)
        if site_credentials is not None:
            pulumi.set(__self__, "site_credentials", site_credentials)
        if source_control is not None:
            pulumi.set(__self__, "source_control", source_control)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="appServicePlanId")
    def app_service_plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the App Service Plan within which to create this Function App.
        """
        return pulumi.get(self, "app_service_plan_id")

    @app_service_plan_id.setter
    def app_service_plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_service_plan_id", value)

    @property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.

        > **NOTE:** The values for `AzureWebJobsStorage` and `FUNCTIONS_EXTENSION_VERSION` will be filled by other input arguments and shouldn't be configured separately. `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "app_settings", value)

    @property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> Optional[pulumi.Input['FunctionAppAuthSettingsArgs']]:
        """
        A `auth_settings` block as defined below.
        """
        return pulumi.get(self, "auth_settings")

    @auth_settings.setter
    def auth_settings(self, value: Optional[pulumi.Input['FunctionAppAuthSettingsArgs']]):
        pulumi.set(self, "auth_settings", value)

    @property
    @pulumi.getter(name="clientCertMode")
    def client_cert_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        """
        return pulumi.get(self, "client_cert_mode")

    @client_cert_mode.setter
    def client_cert_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_cert_mode", value)

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppConnectionStringArgs']]]]:
        """
        An `connection_string` block as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @custom_domain_verification_id.setter
    def custom_domain_verification_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_domain_verification_id", value)

    @property
    @pulumi.getter(name="dailyMemoryTimeQuota")
    def daily_memory_time_quota(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan.
        """
        return pulumi.get(self, "daily_memory_time_quota")

    @daily_memory_time_quota.setter
    def daily_memory_time_quota(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "daily_memory_time_quota", value)

    @property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default hostname associated with the Function App - such as `mysite.azurewebsites.net`
        """
        return pulumi.get(self, "default_hostname")

    @default_hostname.setter
    def default_hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_hostname", value)

    @property
    @pulumi.getter(name="enableBuiltinLogging")
    def enable_builtin_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the built-in logging of this Function App be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enable_builtin_logging")

    @enable_builtin_logging.setter
    def enable_builtin_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_builtin_logging", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the Function App enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Can the Function App only be accessed via HTTPS? Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['FunctionAppIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['FunctionAppIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyVaultReferenceIdentityId")
    def key_vault_reference_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The User Assigned Identity Id used for looking up KeyVault secrets. The identity must be assigned to the application. See [Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity) for more information.
        """
        return pulumi.get(self, "key_vault_reference_identity_id")

    @key_vault_reference_identity_id.setter
    def key_vault_reference_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_reference_identity_id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Function App kind - such as `functionapp,linux,container`
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Function App. Changing this forces a new resource to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftweb).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string indicating the Operating System type for this function app. Possible values are `linux` and ``(empty string). Changing this forces a new resource to be created. Defaults to `""`.

        > **NOTE:** This value will be `linux` for Linux derivatives, or an empty string for Windows (default). When set to `linux` you must also set `appservice.Plan` arguments as `kind = "Linux"` and `reserved = true`
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12`
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @outbound_ip_addresses.setter
    def outbound_ip_addresses(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outbound_ip_addresses", value)

    @property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12,52.143.43.17` - not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @possible_outbound_ip_addresses.setter
    def possible_outbound_ip_addresses(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "possible_outbound_ip_addresses", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the Function App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> Optional[pulumi.Input['FunctionAppSiteConfigArgs']]:
        """
        A `site_config` object as defined below.
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: Optional[pulumi.Input['FunctionAppSiteConfigArgs']]):
        pulumi.set(self, "site_config", value)

    @property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppSiteCredentialArgs']]]]:
        """
        A `site_credential` block as defined below, which contains the site-level credentials used to publish to this App Service.
        """
        return pulumi.get(self, "site_credentials")

    @site_credentials.setter
    def site_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppSiteCredentialArgs']]]]):
        pulumi.set(self, "site_credentials", value)

    @property
    @pulumi.getter(name="sourceControl")
    def source_control(self) -> Optional[pulumi.Input['FunctionAppSourceControlArgs']]:
        """
        A `source_control` block, as defined below.
        """
        return pulumi.get(self, "source_control")

    @source_control.setter
    def source_control(self, value: Optional[pulumi.Input['FunctionAppSourceControlArgs']]):
        pulumi.set(self, "source_control", value)

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access key which will be used to access the backend storage account for the Function App.

        > **Note:** When integrating a `CI/CD pipeline` and expecting to run from a deployed package in `Azure` you must seed your `app settings` as part of the application code for function app to be successfully deployed. `Important Default key pairs`: (`"WEBSITE_RUN_FROM_PACKAGE" = ""`, `"FUNCTIONS_WORKER_RUNTIME" = "node"` (or python, etc), `"WEBSITE_NODE_DEFAULT_VERSION" = "10.14.1"`, `"APPINSIGHTS_INSTRUMENTATIONKEY" = ""`).

        > **Note:**  When using an App Service Plan in the `Free` or `Shared` Tiers `use_32_bit_worker_process` must be set to `true`.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The backend storage account name which will be used by this Function App (such as the dashboard, logs). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The runtime version associated with the Function App. Defaults to `~1`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:appservice/functionApp:FunctionApp")
class FunctionApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input[Union['FunctionAppAuthSettingsArgs', 'FunctionAppAuthSettingsArgsDict']]] = None,
                 client_cert_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionAppConnectionStringArgs', 'FunctionAppConnectionStringArgsDict']]]]] = None,
                 daily_memory_time_quota: Optional[pulumi.Input[builtins.int]] = None,
                 enable_builtin_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['FunctionAppIdentityArgs', 'FunctionAppIdentityArgsDict']]] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 os_type: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 site_config: Optional[pulumi.Input[Union['FunctionAppSiteConfigArgs', 'FunctionAppSiteConfigArgsDict']]] = None,
                 source_control: Optional[pulumi.Input[Union['FunctionAppSourceControlArgs', 'FunctionAppSourceControlArgsDict']]] = None,
                 storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Function App.

        !> **NOTE:** This resource has been deprecated in version 5.0 of the provider and will be removed in version 6.0. Please use `appservice.LinuxFunctionApp` and `appservice.WindowsFunctionApp` resources instead.

        > **Note:** To connect an Azure Function App and a subnet within the same region `appservice.VirtualNetworkSwiftConnection` can be used.
        For an example, check the `appservice.VirtualNetworkSwiftConnection` documentation.

        ## Example Usage

        ### With App Service Plan)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="azure-functions-test-rg",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="functionsapptestsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_plan = azure.appservice.Plan("example",
            name="azure-functions-test-service-plan",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "tier": "Standard",
                "size": "S1",
            })
        example_function_app = azure.appservice.FunctionApp("example",
            name="test-azure-functions",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key)
        ```

        ### In A Consumption Plan)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="azure-functions-cptest-rg",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="functionsapptestsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_plan = azure.appservice.Plan("example",
            name="azure-functions-test-service-plan",
            location=example.location,
            resource_group_name=example.name,
            kind="FunctionApp",
            sku={
                "tier": "Dynamic",
                "size": "Y1",
            })
        example_function_app = azure.appservice.FunctionApp("example",
            name="test-azure-functions",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key)
        ```

        ### Linux)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="azure-functions-cptest-rg",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="functionsapptestsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_plan = azure.appservice.Plan("example",
            name="azure-functions-test-service-plan",
            location=example.location,
            resource_group_name=example.name,
            kind="Linux",
            reserved=True,
            sku={
                "tier": "Dynamic",
                "size": "Y1",
            })
        example_function_app = azure.appservice.FunctionApp("example",
            name="test-azure-functions",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            os_type="linux",
            version="~3")
        ```

        > **Note:** Version `~3` or `~4` is required for Linux Function Apps.

        ## Import

        Function Apps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/functionApp:FunctionApp functionapp1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Web/sites/functionapp1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_service_plan_id: The ID of the App Service Plan within which to create this Function App.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_settings: A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
               
               > **NOTE:** The values for `AzureWebJobsStorage` and `FUNCTIONS_EXTENSION_VERSION` will be filled by other input arguments and shouldn't be configured separately. `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`.
        :param pulumi.Input[Union['FunctionAppAuthSettingsArgs', 'FunctionAppAuthSettingsArgsDict']] auth_settings: A `auth_settings` block as defined below.
        :param pulumi.Input[builtins.str] client_cert_mode: The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionAppConnectionStringArgs', 'FunctionAppConnectionStringArgsDict']]]] connection_strings: An `connection_string` block as defined below.
        :param pulumi.Input[builtins.int] daily_memory_time_quota: The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan.
        :param pulumi.Input[builtins.bool] enable_builtin_logging: Should the built-in logging of this Function App be enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] enabled: Is the Function App enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] https_only: Can the Function App only be accessed via HTTPS? Defaults to `false`.
        :param pulumi.Input[Union['FunctionAppIdentityArgs', 'FunctionAppIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] key_vault_reference_identity_id: The User Assigned Identity Id used for looking up KeyVault secrets. The identity must be assigned to the application. See [Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity) for more information.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Function App. Changing this forces a new resource to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftweb).
        :param pulumi.Input[builtins.str] os_type: A string indicating the Operating System type for this function app. Possible values are `linux` and ``(empty string). Changing this forces a new resource to be created. Defaults to `""`.
               
               > **NOTE:** This value will be `linux` for Linux derivatives, or an empty string for Windows (default). When set to `linux` you must also set `appservice.Plan` arguments as `kind = "Linux"` and `reserved = true`
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Function App. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['FunctionAppSiteConfigArgs', 'FunctionAppSiteConfigArgsDict']] site_config: A `site_config` object as defined below.
        :param pulumi.Input[Union['FunctionAppSourceControlArgs', 'FunctionAppSourceControlArgsDict']] source_control: A `source_control` block, as defined below.
        :param pulumi.Input[builtins.str] storage_account_access_key: The access key which will be used to access the backend storage account for the Function App.
               
               > **Note:** When integrating a `CI/CD pipeline` and expecting to run from a deployed package in `Azure` you must seed your `app settings` as part of the application code for function app to be successfully deployed. `Important Default key pairs`: (`"WEBSITE_RUN_FROM_PACKAGE" = ""`, `"FUNCTIONS_WORKER_RUNTIME" = "node"` (or python, etc), `"WEBSITE_NODE_DEFAULT_VERSION" = "10.14.1"`, `"APPINSIGHTS_INSTRUMENTATIONKEY" = ""`).
               
               > **Note:**  When using an App Service Plan in the `Free` or `Shared` Tiers `use_32_bit_worker_process` must be set to `true`.
        :param pulumi.Input[builtins.str] storage_account_name: The backend storage account name which will be used by this Function App (such as the dashboard, logs). Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] version: The runtime version associated with the Function App. Defaults to `~1`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Function App.

        !> **NOTE:** This resource has been deprecated in version 5.0 of the provider and will be removed in version 6.0. Please use `appservice.LinuxFunctionApp` and `appservice.WindowsFunctionApp` resources instead.

        > **Note:** To connect an Azure Function App and a subnet within the same region `appservice.VirtualNetworkSwiftConnection` can be used.
        For an example, check the `appservice.VirtualNetworkSwiftConnection` documentation.

        ## Example Usage

        ### With App Service Plan)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="azure-functions-test-rg",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="functionsapptestsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_plan = azure.appservice.Plan("example",
            name="azure-functions-test-service-plan",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "tier": "Standard",
                "size": "S1",
            })
        example_function_app = azure.appservice.FunctionApp("example",
            name="test-azure-functions",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key)
        ```

        ### In A Consumption Plan)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="azure-functions-cptest-rg",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="functionsapptestsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_plan = azure.appservice.Plan("example",
            name="azure-functions-test-service-plan",
            location=example.location,
            resource_group_name=example.name,
            kind="FunctionApp",
            sku={
                "tier": "Dynamic",
                "size": "Y1",
            })
        example_function_app = azure.appservice.FunctionApp("example",
            name="test-azure-functions",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key)
        ```

        ### Linux)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="azure-functions-cptest-rg",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="functionsapptestsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_plan = azure.appservice.Plan("example",
            name="azure-functions-test-service-plan",
            location=example.location,
            resource_group_name=example.name,
            kind="Linux",
            reserved=True,
            sku={
                "tier": "Dynamic",
                "size": "Y1",
            })
        example_function_app = azure.appservice.FunctionApp("example",
            name="test-azure-functions",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            os_type="linux",
            version="~3")
        ```

        > **Note:** Version `~3` or `~4` is required for Linux Function Apps.

        ## Import

        Function Apps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/functionApp:FunctionApp functionapp1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Web/sites/functionapp1
        ```

        :param str resource_name: The name of the resource.
        :param FunctionAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input[Union['FunctionAppAuthSettingsArgs', 'FunctionAppAuthSettingsArgsDict']]] = None,
                 client_cert_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionAppConnectionStringArgs', 'FunctionAppConnectionStringArgsDict']]]]] = None,
                 daily_memory_time_quota: Optional[pulumi.Input[builtins.int]] = None,
                 enable_builtin_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['FunctionAppIdentityArgs', 'FunctionAppIdentityArgsDict']]] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 os_type: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 site_config: Optional[pulumi.Input[Union['FunctionAppSiteConfigArgs', 'FunctionAppSiteConfigArgsDict']]] = None,
                 source_control: Optional[pulumi.Input[Union['FunctionAppSourceControlArgs', 'FunctionAppSourceControlArgsDict']]] = None,
                 storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionAppArgs.__new__(FunctionAppArgs)

            if app_service_plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_service_plan_id'")
            __props__.__dict__["app_service_plan_id"] = app_service_plan_id
            __props__.__dict__["app_settings"] = app_settings
            __props__.__dict__["auth_settings"] = auth_settings
            __props__.__dict__["client_cert_mode"] = client_cert_mode
            __props__.__dict__["connection_strings"] = connection_strings
            __props__.__dict__["daily_memory_time_quota"] = daily_memory_time_quota
            __props__.__dict__["enable_builtin_logging"] = enable_builtin_logging
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["https_only"] = https_only
            __props__.__dict__["identity"] = identity
            __props__.__dict__["key_vault_reference_identity_id"] = key_vault_reference_identity_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["os_type"] = os_type
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["site_config"] = site_config
            __props__.__dict__["source_control"] = source_control
            if storage_account_access_key is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_access_key'")
            __props__.__dict__["storage_account_access_key"] = None if storage_account_access_key is None else pulumi.Output.secret(storage_account_access_key)
            if storage_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_name'")
            __props__.__dict__["storage_account_name"] = storage_account_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version"] = version
            __props__.__dict__["custom_domain_verification_id"] = None
            __props__.__dict__["default_hostname"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["outbound_ip_addresses"] = None
            __props__.__dict__["possible_outbound_ip_addresses"] = None
            __props__.__dict__["site_credentials"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["storageAccountAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FunctionApp, __self__).__init__(
            'azure:appservice/functionApp:FunctionApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_service_plan_id: Optional[pulumi.Input[builtins.str]] = None,
            app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            auth_settings: Optional[pulumi.Input[Union['FunctionAppAuthSettingsArgs', 'FunctionAppAuthSettingsArgsDict']]] = None,
            client_cert_mode: Optional[pulumi.Input[builtins.str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionAppConnectionStringArgs', 'FunctionAppConnectionStringArgsDict']]]]] = None,
            custom_domain_verification_id: Optional[pulumi.Input[builtins.str]] = None,
            daily_memory_time_quota: Optional[pulumi.Input[builtins.int]] = None,
            default_hostname: Optional[pulumi.Input[builtins.str]] = None,
            enable_builtin_logging: Optional[pulumi.Input[builtins.bool]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            https_only: Optional[pulumi.Input[builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['FunctionAppIdentityArgs', 'FunctionAppIdentityArgsDict']]] = None,
            key_vault_reference_identity_id: Optional[pulumi.Input[builtins.str]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            os_type: Optional[pulumi.Input[builtins.str]] = None,
            outbound_ip_addresses: Optional[pulumi.Input[builtins.str]] = None,
            possible_outbound_ip_addresses: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            site_config: Optional[pulumi.Input[Union['FunctionAppSiteConfigArgs', 'FunctionAppSiteConfigArgsDict']]] = None,
            site_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionAppSiteCredentialArgs', 'FunctionAppSiteCredentialArgsDict']]]]] = None,
            source_control: Optional[pulumi.Input[Union['FunctionAppSourceControlArgs', 'FunctionAppSourceControlArgsDict']]] = None,
            storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'FunctionApp':
        """
        Get an existing FunctionApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_service_plan_id: The ID of the App Service Plan within which to create this Function App.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_settings: A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
               
               > **NOTE:** The values for `AzureWebJobsStorage` and `FUNCTIONS_EXTENSION_VERSION` will be filled by other input arguments and shouldn't be configured separately. `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`.
        :param pulumi.Input[Union['FunctionAppAuthSettingsArgs', 'FunctionAppAuthSettingsArgsDict']] auth_settings: A `auth_settings` block as defined below.
        :param pulumi.Input[builtins.str] client_cert_mode: The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionAppConnectionStringArgs', 'FunctionAppConnectionStringArgsDict']]]] connection_strings: An `connection_string` block as defined below.
        :param pulumi.Input[builtins.str] custom_domain_verification_id: An identifier used by App Service to perform domain ownership verification via DNS TXT record.
        :param pulumi.Input[builtins.int] daily_memory_time_quota: The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan.
        :param pulumi.Input[builtins.str] default_hostname: The default hostname associated with the Function App - such as `mysite.azurewebsites.net`
        :param pulumi.Input[builtins.bool] enable_builtin_logging: Should the built-in logging of this Function App be enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] enabled: Is the Function App enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] https_only: Can the Function App only be accessed via HTTPS? Defaults to `false`.
        :param pulumi.Input[Union['FunctionAppIdentityArgs', 'FunctionAppIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] key_vault_reference_identity_id: The User Assigned Identity Id used for looking up KeyVault secrets. The identity must be assigned to the application. See [Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity) for more information.
        :param pulumi.Input[builtins.str] kind: The Function App kind - such as `functionapp,linux,container`
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Function App. Changing this forces a new resource to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftweb).
        :param pulumi.Input[builtins.str] os_type: A string indicating the Operating System type for this function app. Possible values are `linux` and ``(empty string). Changing this forces a new resource to be created. Defaults to `""`.
               
               > **NOTE:** This value will be `linux` for Linux derivatives, or an empty string for Windows (default). When set to `linux` you must also set `appservice.Plan` arguments as `kind = "Linux"` and `reserved = true`
        :param pulumi.Input[builtins.str] outbound_ip_addresses: A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12`
        :param pulumi.Input[builtins.str] possible_outbound_ip_addresses: A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12,52.143.43.17` - not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Function App. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['FunctionAppSiteConfigArgs', 'FunctionAppSiteConfigArgsDict']] site_config: A `site_config` object as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionAppSiteCredentialArgs', 'FunctionAppSiteCredentialArgsDict']]]] site_credentials: A `site_credential` block as defined below, which contains the site-level credentials used to publish to this App Service.
        :param pulumi.Input[Union['FunctionAppSourceControlArgs', 'FunctionAppSourceControlArgsDict']] source_control: A `source_control` block, as defined below.
        :param pulumi.Input[builtins.str] storage_account_access_key: The access key which will be used to access the backend storage account for the Function App.
               
               > **Note:** When integrating a `CI/CD pipeline` and expecting to run from a deployed package in `Azure` you must seed your `app settings` as part of the application code for function app to be successfully deployed. `Important Default key pairs`: (`"WEBSITE_RUN_FROM_PACKAGE" = ""`, `"FUNCTIONS_WORKER_RUNTIME" = "node"` (or python, etc), `"WEBSITE_NODE_DEFAULT_VERSION" = "10.14.1"`, `"APPINSIGHTS_INSTRUMENTATIONKEY" = ""`).
               
               > **Note:**  When using an App Service Plan in the `Free` or `Shared` Tiers `use_32_bit_worker_process` must be set to `true`.
        :param pulumi.Input[builtins.str] storage_account_name: The backend storage account name which will be used by this Function App (such as the dashboard, logs). Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] version: The runtime version associated with the Function App. Defaults to `~1`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionAppState.__new__(_FunctionAppState)

        __props__.__dict__["app_service_plan_id"] = app_service_plan_id
        __props__.__dict__["app_settings"] = app_settings
        __props__.__dict__["auth_settings"] = auth_settings
        __props__.__dict__["client_cert_mode"] = client_cert_mode
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["custom_domain_verification_id"] = custom_domain_verification_id
        __props__.__dict__["daily_memory_time_quota"] = daily_memory_time_quota
        __props__.__dict__["default_hostname"] = default_hostname
        __props__.__dict__["enable_builtin_logging"] = enable_builtin_logging
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["https_only"] = https_only
        __props__.__dict__["identity"] = identity
        __props__.__dict__["key_vault_reference_identity_id"] = key_vault_reference_identity_id
        __props__.__dict__["kind"] = kind
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["outbound_ip_addresses"] = outbound_ip_addresses
        __props__.__dict__["possible_outbound_ip_addresses"] = possible_outbound_ip_addresses
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["site_config"] = site_config
        __props__.__dict__["site_credentials"] = site_credentials
        __props__.__dict__["source_control"] = source_control
        __props__.__dict__["storage_account_access_key"] = storage_account_access_key
        __props__.__dict__["storage_account_name"] = storage_account_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        return FunctionApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appServicePlanId")
    def app_service_plan_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the App Service Plan within which to create this Function App.
        """
        return pulumi.get(self, "app_service_plan_id")

    @property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.

        > **NOTE:** The values for `AzureWebJobsStorage` and `FUNCTIONS_EXTENSION_VERSION` will be filled by other input arguments and shouldn't be configured separately. `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`.
        """
        return pulumi.get(self, "app_settings")

    @property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> pulumi.Output['outputs.FunctionAppAuthSettings']:
        """
        A `auth_settings` block as defined below.
        """
        return pulumi.get(self, "auth_settings")

    @property
    @pulumi.getter(name="clientCertMode")
    def client_cert_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        """
        return pulumi.get(self, "client_cert_mode")

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Sequence['outputs.FunctionAppConnectionString']]:
        """
        An `connection_string` block as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> pulumi.Output[builtins.str]:
        """
        An identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @property
    @pulumi.getter(name="dailyMemoryTimeQuota")
    def daily_memory_time_quota(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan.
        """
        return pulumi.get(self, "daily_memory_time_quota")

    @property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> pulumi.Output[builtins.str]:
        """
        The default hostname associated with the Function App - such as `mysite.azurewebsites.net`
        """
        return pulumi.get(self, "default_hostname")

    @property
    @pulumi.getter(name="enableBuiltinLogging")
    def enable_builtin_logging(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the built-in logging of this Function App be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enable_builtin_logging")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is the Function App enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Can the Function App only be accessed via HTTPS? Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.FunctionAppIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="keyVaultReferenceIdentityId")
    def key_vault_reference_identity_id(self) -> pulumi.Output[builtins.str]:
        """
        The User Assigned Identity Id used for looking up KeyVault secrets. The identity must be assigned to the application. See [Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity) for more information.
        """
        return pulumi.get(self, "key_vault_reference_identity_id")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[builtins.str]:
        """
        The Function App kind - such as `functionapp,linux,container`
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Function App. Changing this forces a new resource to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftweb).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A string indicating the Operating System type for this function app. Possible values are `linux` and ``(empty string). Changing this forces a new resource to be created. Defaults to `""`.

        > **NOTE:** This value will be `linux` for Linux derivatives, or an empty string for Windows (default). When set to `linux` you must also set `appservice.Plan` arguments as `kind = "Linux"` and `reserved = true`
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> pulumi.Output[builtins.str]:
        """
        A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12`
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> pulumi.Output[builtins.str]:
        """
        A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12,52.143.43.17` - not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the Function App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> pulumi.Output['outputs.FunctionAppSiteConfig']:
        """
        A `site_config` object as defined below.
        """
        return pulumi.get(self, "site_config")

    @property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> pulumi.Output[Sequence['outputs.FunctionAppSiteCredential']]:
        """
        A `site_credential` block as defined below, which contains the site-level credentials used to publish to this App Service.
        """
        return pulumi.get(self, "site_credentials")

    @property
    @pulumi.getter(name="sourceControl")
    def source_control(self) -> pulumi.Output['outputs.FunctionAppSourceControl']:
        """
        A `source_control` block, as defined below.
        """
        return pulumi.get(self, "source_control")

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> pulumi.Output[builtins.str]:
        """
        The access key which will be used to access the backend storage account for the Function App.

        > **Note:** When integrating a `CI/CD pipeline` and expecting to run from a deployed package in `Azure` you must seed your `app settings` as part of the application code for function app to be successfully deployed. `Important Default key pairs`: (`"WEBSITE_RUN_FROM_PACKAGE" = ""`, `"FUNCTIONS_WORKER_RUNTIME" = "node"` (or python, etc), `"WEBSITE_NODE_DEFAULT_VERSION" = "10.14.1"`, `"APPINSIGHTS_INSTRUMENTATIONKEY" = ""`).

        > **Note:**  When using an App Service Plan in the `Free` or `Shared` Tiers `use_32_bit_worker_process` must be set to `true`.
        """
        return pulumi.get(self, "storage_account_access_key")

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Output[builtins.str]:
        """
        The backend storage account name which will be used by this Function App (such as the dashboard, logs). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The runtime version associated with the Function App. Defaults to `~1`.
        """
        return pulumi.get(self, "version")

