# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionAppFunctionArgs', 'FunctionAppFunction']

@pulumi.input_type
class FunctionAppFunctionArgs:
    def __init__(__self__, *,
                 config_json: pulumi.Input[builtins.str],
                 function_app_id: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppFunctionFileArgs']]]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 test_data: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a FunctionAppFunction resource.
        :param pulumi.Input[builtins.str] config_json: The config for this Function in JSON format.
        :param pulumi.Input[builtins.str] function_app_id: The ID of the Function App in which this function should reside. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] enabled: Should this function be enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionAppFunctionFileArgs']]] files: A `file` block as detailed below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] language: The language the Function is written in. Possible values are `CSharp`, `Custom`, `Java`, `Javascript`, `Python`, `PowerShell`, and `TypeScript`.
               
               > **Note:** when using `Custom` language, you must specify the code handler in the `host.json` file for your function. See the [official docs](https://docs.microsoft.com/azure/azure-functions/functions-custom-handlers#hostjson) for more information.
        :param pulumi.Input[builtins.str] name: The name of the function. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] test_data: The test data for the function.
        """
        pulumi.set(__self__, "config_json", config_json)
        pulumi.set(__self__, "function_app_id", function_app_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if test_data is not None:
            pulumi.set(__self__, "test_data", test_data)

    @property
    @pulumi.getter(name="configJson")
    def config_json(self) -> pulumi.Input[builtins.str]:
        """
        The config for this Function in JSON format.
        """
        return pulumi.get(self, "config_json")

    @config_json.setter
    def config_json(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "config_json", value)

    @property
    @pulumi.getter(name="functionAppId")
    def function_app_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Function App in which this function should reside. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "function_app_id")

    @function_app_id.setter
    def function_app_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "function_app_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should this function be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppFunctionFileArgs']]]]:
        """
        A `file` block as detailed below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppFunctionFileArgs']]]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The language the Function is written in. Possible values are `CSharp`, `Custom`, `Java`, `Javascript`, `Python`, `PowerShell`, and `TypeScript`.

        > **Note:** when using `Custom` language, you must specify the code handler in the `host.json` file for your function. See the [official docs](https://docs.microsoft.com/azure/azure-functions/functions-custom-handlers#hostjson) for more information.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the function. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="testData")
    def test_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The test data for the function.
        """
        return pulumi.get(self, "test_data")

    @test_data.setter
    def test_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "test_data", value)


@pulumi.input_type
class _FunctionAppFunctionState:
    def __init__(__self__, *,
                 config_json: Optional[pulumi.Input[builtins.str]] = None,
                 config_url: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppFunctionFileArgs']]]] = None,
                 function_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 invocation_url: Optional[pulumi.Input[builtins.str]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 script_root_path_url: Optional[pulumi.Input[builtins.str]] = None,
                 script_url: Optional[pulumi.Input[builtins.str]] = None,
                 secrets_file_url: Optional[pulumi.Input[builtins.str]] = None,
                 test_data: Optional[pulumi.Input[builtins.str]] = None,
                 test_data_url: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FunctionAppFunction resources.
        :param pulumi.Input[builtins.str] config_json: The config for this Function in JSON format.
        :param pulumi.Input[builtins.str] config_url: The URL of the configuration JSON.
        :param pulumi.Input[builtins.bool] enabled: Should this function be enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionAppFunctionFileArgs']]] files: A `file` block as detailed below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] function_app_id: The ID of the Function App in which this function should reside. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] invocation_url: The invocation URL.
        :param pulumi.Input[builtins.str] language: The language the Function is written in. Possible values are `CSharp`, `Custom`, `Java`, `Javascript`, `Python`, `PowerShell`, and `TypeScript`.
               
               > **Note:** when using `Custom` language, you must specify the code handler in the `host.json` file for your function. See the [official docs](https://docs.microsoft.com/azure/azure-functions/functions-custom-handlers#hostjson) for more information.
        :param pulumi.Input[builtins.str] name: The name of the function. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] script_root_path_url: The Script root path URL.
        :param pulumi.Input[builtins.str] script_url: The script URL.
        :param pulumi.Input[builtins.str] secrets_file_url: The URL for the Secrets File.
        :param pulumi.Input[builtins.str] test_data: The test data for the function.
        :param pulumi.Input[builtins.str] test_data_url: The Test data URL.
        :param pulumi.Input[builtins.str] url: The function URL.
        """
        if config_json is not None:
            pulumi.set(__self__, "config_json", config_json)
        if config_url is not None:
            pulumi.set(__self__, "config_url", config_url)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if function_app_id is not None:
            pulumi.set(__self__, "function_app_id", function_app_id)
        if invocation_url is not None:
            pulumi.set(__self__, "invocation_url", invocation_url)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if script_root_path_url is not None:
            pulumi.set(__self__, "script_root_path_url", script_root_path_url)
        if script_url is not None:
            pulumi.set(__self__, "script_url", script_url)
        if secrets_file_url is not None:
            pulumi.set(__self__, "secrets_file_url", secrets_file_url)
        if test_data is not None:
            pulumi.set(__self__, "test_data", test_data)
        if test_data_url is not None:
            pulumi.set(__self__, "test_data_url", test_data_url)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="configJson")
    def config_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The config for this Function in JSON format.
        """
        return pulumi.get(self, "config_json")

    @config_json.setter
    def config_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config_json", value)

    @property
    @pulumi.getter(name="configUrl")
    def config_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the configuration JSON.
        """
        return pulumi.get(self, "config_url")

    @config_url.setter
    def config_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config_url", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should this function be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppFunctionFileArgs']]]]:
        """
        A `file` block as detailed below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionAppFunctionFileArgs']]]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="functionAppId")
    def function_app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Function App in which this function should reside. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "function_app_id")

    @function_app_id.setter
    def function_app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "function_app_id", value)

    @property
    @pulumi.getter(name="invocationUrl")
    def invocation_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The invocation URL.
        """
        return pulumi.get(self, "invocation_url")

    @invocation_url.setter
    def invocation_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "invocation_url", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The language the Function is written in. Possible values are `CSharp`, `Custom`, `Java`, `Javascript`, `Python`, `PowerShell`, and `TypeScript`.

        > **Note:** when using `Custom` language, you must specify the code handler in the `host.json` file for your function. See the [official docs](https://docs.microsoft.com/azure/azure-functions/functions-custom-handlers#hostjson) for more information.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the function. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="scriptRootPathUrl")
    def script_root_path_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Script root path URL.
        """
        return pulumi.get(self, "script_root_path_url")

    @script_root_path_url.setter
    def script_root_path_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "script_root_path_url", value)

    @property
    @pulumi.getter(name="scriptUrl")
    def script_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The script URL.
        """
        return pulumi.get(self, "script_url")

    @script_url.setter
    def script_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "script_url", value)

    @property
    @pulumi.getter(name="secretsFileUrl")
    def secrets_file_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL for the Secrets File.
        """
        return pulumi.get(self, "secrets_file_url")

    @secrets_file_url.setter
    def secrets_file_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secrets_file_url", value)

    @property
    @pulumi.getter(name="testData")
    def test_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The test data for the function.
        """
        return pulumi.get(self, "test_data")

    @test_data.setter
    def test_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "test_data", value)

    @property
    @pulumi.getter(name="testDataUrl")
    def test_data_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Test data URL.
        """
        return pulumi.get(self, "test_data_url")

    @test_data_url.setter
    def test_data_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "test_data_url", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The function URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("azure:appservice/functionAppFunction:FunctionAppFunction")
class FunctionAppFunction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_json: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionAppFunctionFileArgs', 'FunctionAppFunctionFileArgsDict']]]]] = None,
                 function_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 test_data: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Function App Function.

        ## Example Usage

        ### Basic HTTP Trigger

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-group",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplesa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-service-plan",
            location=example.location,
            resource_group_name=example.name,
            os_type="Linux",
            sku_name="S1")
        example_linux_function_app = azure.appservice.LinuxFunctionApp("example",
            name="example-function-app",
            location=example.location,
            resource_group_name=example.name,
            service_plan_id=example_service_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            site_config={
                "application_stack": {
                    "python_version": "3.9",
                },
            })
        example_function_app_function = azure.appservice.FunctionAppFunction("example",
            name="example-function-app-function",
            function_app_id=example_linux_function_app.id,
            language="Python",
            test_data=json.dumps({
                "name": "Azure",
            }),
            config_json=json.dumps({
                "bindings": [
                    {
                        "authLevel": "function",
                        "direction": "in",
                        "methods": [
                            "get",
                            "post",
                        ],
                        "name": "req",
                        "type": "httpTrigger",
                    },
                    {
                        "direction": "out",
                        "name": "$return",
                        "type": "http",
                    },
                ],
            }))
        ```

        ### HTTP Trigger With Code Upload

        ```python
        import pulumi
        import json
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-group",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplesa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-service-plan",
            location=example.location,
            resource_group_name=example.name,
            os_type="Windows",
            sku_name="S1")
        example_windows_function_app = azure.appservice.WindowsFunctionApp("example",
            name="example-function-app",
            location=example.location,
            resource_group_name=example.name,
            service_plan_id=example_service_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            site_config={
                "application_stack": {
                    "dotnet_version": "6",
                },
            })
        example_function_app_function = azure.appservice.FunctionAppFunction("example",
            name="example-function-app-function",
            function_app_id=example_windows_function_app.id,
            language="CSharp",
            files=[{
                "name": "run.csx",
                "content": std.file(input="exampledata/run.csx").result,
            }],
            test_data=json.dumps({
                "name": "Azure",
            }),
            config_json=json.dumps({
                "bindings": [
                    {
                        "authLevel": "function",
                        "direction": "in",
                        "methods": [
                            "get",
                            "post",
                        ],
                        "name": "req",
                        "type": "httpTrigger",
                    },
                    {
                        "direction": "out",
                        "name": "$return",
                        "type": "http",
                    },
                ],
            }))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01

        ## Import

        a Function App Function can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/functionAppFunction:FunctionAppFunction example "/subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Web/sites/site1/functions/function1"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] config_json: The config for this Function in JSON format.
        :param pulumi.Input[builtins.bool] enabled: Should this function be enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionAppFunctionFileArgs', 'FunctionAppFunctionFileArgsDict']]]] files: A `file` block as detailed below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] function_app_id: The ID of the Function App in which this function should reside. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] language: The language the Function is written in. Possible values are `CSharp`, `Custom`, `Java`, `Javascript`, `Python`, `PowerShell`, and `TypeScript`.
               
               > **Note:** when using `Custom` language, you must specify the code handler in the `host.json` file for your function. See the [official docs](https://docs.microsoft.com/azure/azure-functions/functions-custom-handlers#hostjson) for more information.
        :param pulumi.Input[builtins.str] name: The name of the function. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] test_data: The test data for the function.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionAppFunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Function App Function.

        ## Example Usage

        ### Basic HTTP Trigger

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-group",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplesa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-service-plan",
            location=example.location,
            resource_group_name=example.name,
            os_type="Linux",
            sku_name="S1")
        example_linux_function_app = azure.appservice.LinuxFunctionApp("example",
            name="example-function-app",
            location=example.location,
            resource_group_name=example.name,
            service_plan_id=example_service_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            site_config={
                "application_stack": {
                    "python_version": "3.9",
                },
            })
        example_function_app_function = azure.appservice.FunctionAppFunction("example",
            name="example-function-app-function",
            function_app_id=example_linux_function_app.id,
            language="Python",
            test_data=json.dumps({
                "name": "Azure",
            }),
            config_json=json.dumps({
                "bindings": [
                    {
                        "authLevel": "function",
                        "direction": "in",
                        "methods": [
                            "get",
                            "post",
                        ],
                        "name": "req",
                        "type": "httpTrigger",
                    },
                    {
                        "direction": "out",
                        "name": "$return",
                        "type": "http",
                    },
                ],
            }))
        ```

        ### HTTP Trigger With Code Upload

        ```python
        import pulumi
        import json
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-group",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplesa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-service-plan",
            location=example.location,
            resource_group_name=example.name,
            os_type="Windows",
            sku_name="S1")
        example_windows_function_app = azure.appservice.WindowsFunctionApp("example",
            name="example-function-app",
            location=example.location,
            resource_group_name=example.name,
            service_plan_id=example_service_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            site_config={
                "application_stack": {
                    "dotnet_version": "6",
                },
            })
        example_function_app_function = azure.appservice.FunctionAppFunction("example",
            name="example-function-app-function",
            function_app_id=example_windows_function_app.id,
            language="CSharp",
            files=[{
                "name": "run.csx",
                "content": std.file(input="exampledata/run.csx").result,
            }],
            test_data=json.dumps({
                "name": "Azure",
            }),
            config_json=json.dumps({
                "bindings": [
                    {
                        "authLevel": "function",
                        "direction": "in",
                        "methods": [
                            "get",
                            "post",
                        ],
                        "name": "req",
                        "type": "httpTrigger",
                    },
                    {
                        "direction": "out",
                        "name": "$return",
                        "type": "http",
                    },
                ],
            }))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01

        ## Import

        a Function App Function can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/functionAppFunction:FunctionAppFunction example "/subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Web/sites/site1/functions/function1"
        ```

        :param str resource_name: The name of the resource.
        :param FunctionAppFunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionAppFunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_json: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionAppFunctionFileArgs', 'FunctionAppFunctionFileArgsDict']]]]] = None,
                 function_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 test_data: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionAppFunctionArgs.__new__(FunctionAppFunctionArgs)

            if config_json is None and not opts.urn:
                raise TypeError("Missing required property 'config_json'")
            __props__.__dict__["config_json"] = config_json
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["files"] = files
            if function_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'function_app_id'")
            __props__.__dict__["function_app_id"] = function_app_id
            __props__.__dict__["language"] = language
            __props__.__dict__["name"] = name
            __props__.__dict__["test_data"] = test_data
            __props__.__dict__["config_url"] = None
            __props__.__dict__["invocation_url"] = None
            __props__.__dict__["script_root_path_url"] = None
            __props__.__dict__["script_url"] = None
            __props__.__dict__["secrets_file_url"] = None
            __props__.__dict__["test_data_url"] = None
            __props__.__dict__["url"] = None
        super(FunctionAppFunction, __self__).__init__(
            'azure:appservice/functionAppFunction:FunctionAppFunction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_json: Optional[pulumi.Input[builtins.str]] = None,
            config_url: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionAppFunctionFileArgs', 'FunctionAppFunctionFileArgsDict']]]]] = None,
            function_app_id: Optional[pulumi.Input[builtins.str]] = None,
            invocation_url: Optional[pulumi.Input[builtins.str]] = None,
            language: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            script_root_path_url: Optional[pulumi.Input[builtins.str]] = None,
            script_url: Optional[pulumi.Input[builtins.str]] = None,
            secrets_file_url: Optional[pulumi.Input[builtins.str]] = None,
            test_data: Optional[pulumi.Input[builtins.str]] = None,
            test_data_url: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None) -> 'FunctionAppFunction':
        """
        Get an existing FunctionAppFunction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] config_json: The config for this Function in JSON format.
        :param pulumi.Input[builtins.str] config_url: The URL of the configuration JSON.
        :param pulumi.Input[builtins.bool] enabled: Should this function be enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionAppFunctionFileArgs', 'FunctionAppFunctionFileArgsDict']]]] files: A `file` block as detailed below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] function_app_id: The ID of the Function App in which this function should reside. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] invocation_url: The invocation URL.
        :param pulumi.Input[builtins.str] language: The language the Function is written in. Possible values are `CSharp`, `Custom`, `Java`, `Javascript`, `Python`, `PowerShell`, and `TypeScript`.
               
               > **Note:** when using `Custom` language, you must specify the code handler in the `host.json` file for your function. See the [official docs](https://docs.microsoft.com/azure/azure-functions/functions-custom-handlers#hostjson) for more information.
        :param pulumi.Input[builtins.str] name: The name of the function. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] script_root_path_url: The Script root path URL.
        :param pulumi.Input[builtins.str] script_url: The script URL.
        :param pulumi.Input[builtins.str] secrets_file_url: The URL for the Secrets File.
        :param pulumi.Input[builtins.str] test_data: The test data for the function.
        :param pulumi.Input[builtins.str] test_data_url: The Test data URL.
        :param pulumi.Input[builtins.str] url: The function URL.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionAppFunctionState.__new__(_FunctionAppFunctionState)

        __props__.__dict__["config_json"] = config_json
        __props__.__dict__["config_url"] = config_url
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["files"] = files
        __props__.__dict__["function_app_id"] = function_app_id
        __props__.__dict__["invocation_url"] = invocation_url
        __props__.__dict__["language"] = language
        __props__.__dict__["name"] = name
        __props__.__dict__["script_root_path_url"] = script_root_path_url
        __props__.__dict__["script_url"] = script_url
        __props__.__dict__["secrets_file_url"] = secrets_file_url
        __props__.__dict__["test_data"] = test_data
        __props__.__dict__["test_data_url"] = test_data_url
        __props__.__dict__["url"] = url
        return FunctionAppFunction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configJson")
    def config_json(self) -> pulumi.Output[builtins.str]:
        """
        The config for this Function in JSON format.
        """
        return pulumi.get(self, "config_json")

    @property
    @pulumi.getter(name="configUrl")
    def config_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the configuration JSON.
        """
        return pulumi.get(self, "config_url")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should this function be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def files(self) -> pulumi.Output[Optional[Sequence['outputs.FunctionAppFunctionFile']]]:
        """
        A `file` block as detailed below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter(name="functionAppId")
    def function_app_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Function App in which this function should reside. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "function_app_id")

    @property
    @pulumi.getter(name="invocationUrl")
    def invocation_url(self) -> pulumi.Output[builtins.str]:
        """
        The invocation URL.
        """
        return pulumi.get(self, "invocation_url")

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The language the Function is written in. Possible values are `CSharp`, `Custom`, `Java`, `Javascript`, `Python`, `PowerShell`, and `TypeScript`.

        > **Note:** when using `Custom` language, you must specify the code handler in the `host.json` file for your function. See the [official docs](https://docs.microsoft.com/azure/azure-functions/functions-custom-handlers#hostjson) for more information.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the function. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scriptRootPathUrl")
    def script_root_path_url(self) -> pulumi.Output[builtins.str]:
        """
        The Script root path URL.
        """
        return pulumi.get(self, "script_root_path_url")

    @property
    @pulumi.getter(name="scriptUrl")
    def script_url(self) -> pulumi.Output[builtins.str]:
        """
        The script URL.
        """
        return pulumi.get(self, "script_url")

    @property
    @pulumi.getter(name="secretsFileUrl")
    def secrets_file_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL for the Secrets File.
        """
        return pulumi.get(self, "secrets_file_url")

    @property
    @pulumi.getter(name="testData")
    def test_data(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The test data for the function.
        """
        return pulumi.get(self, "test_data")

    @property
    @pulumi.getter(name="testDataUrl")
    def test_data_url(self) -> pulumi.Output[builtins.str]:
        """
        The Test data URL.
        """
        return pulumi.get(self, "test_data_url")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        The function URL.
        """
        return pulumi.get(self, "url")

