# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCertificateOrderResult',
    'AwaitableGetCertificateOrderResult',
    'get_certificate_order',
    'get_certificate_order_output',
]

@pulumi.output_type
class GetCertificateOrderResult:
    """
    A collection of values returned by getCertificateOrder.
    """
    def __init__(__self__, app_service_certificate_not_renewable_reasons=None, auto_renew=None, certificates=None, csr=None, distinguished_name=None, domain_verification_token=None, expiration_time=None, id=None, intermediate_thumbprint=None, is_private_key_external=None, key_size=None, location=None, name=None, product_type=None, resource_group_name=None, root_thumbprint=None, signed_certificate_thumbprint=None, status=None, tags=None, validity_in_years=None):
        if app_service_certificate_not_renewable_reasons and not isinstance(app_service_certificate_not_renewable_reasons, list):
            raise TypeError("Expected argument 'app_service_certificate_not_renewable_reasons' to be a list")
        pulumi.set(__self__, "app_service_certificate_not_renewable_reasons", app_service_certificate_not_renewable_reasons)
        if auto_renew and not isinstance(auto_renew, bool):
            raise TypeError("Expected argument 'auto_renew' to be a bool")
        pulumi.set(__self__, "auto_renew", auto_renew)
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        pulumi.set(__self__, "certificates", certificates)
        if csr and not isinstance(csr, str):
            raise TypeError("Expected argument 'csr' to be a str")
        pulumi.set(__self__, "csr", csr)
        if distinguished_name and not isinstance(distinguished_name, str):
            raise TypeError("Expected argument 'distinguished_name' to be a str")
        pulumi.set(__self__, "distinguished_name", distinguished_name)
        if domain_verification_token and not isinstance(domain_verification_token, str):
            raise TypeError("Expected argument 'domain_verification_token' to be a str")
        pulumi.set(__self__, "domain_verification_token", domain_verification_token)
        if expiration_time and not isinstance(expiration_time, str):
            raise TypeError("Expected argument 'expiration_time' to be a str")
        pulumi.set(__self__, "expiration_time", expiration_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if intermediate_thumbprint and not isinstance(intermediate_thumbprint, str):
            raise TypeError("Expected argument 'intermediate_thumbprint' to be a str")
        pulumi.set(__self__, "intermediate_thumbprint", intermediate_thumbprint)
        if is_private_key_external and not isinstance(is_private_key_external, bool):
            raise TypeError("Expected argument 'is_private_key_external' to be a bool")
        pulumi.set(__self__, "is_private_key_external", is_private_key_external)
        if key_size and not isinstance(key_size, int):
            raise TypeError("Expected argument 'key_size' to be a int")
        pulumi.set(__self__, "key_size", key_size)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if product_type and not isinstance(product_type, str):
            raise TypeError("Expected argument 'product_type' to be a str")
        pulumi.set(__self__, "product_type", product_type)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if root_thumbprint and not isinstance(root_thumbprint, str):
            raise TypeError("Expected argument 'root_thumbprint' to be a str")
        pulumi.set(__self__, "root_thumbprint", root_thumbprint)
        if signed_certificate_thumbprint and not isinstance(signed_certificate_thumbprint, str):
            raise TypeError("Expected argument 'signed_certificate_thumbprint' to be a str")
        pulumi.set(__self__, "signed_certificate_thumbprint", signed_certificate_thumbprint)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if validity_in_years and not isinstance(validity_in_years, int):
            raise TypeError("Expected argument 'validity_in_years' to be a int")
        pulumi.set(__self__, "validity_in_years", validity_in_years)

    @property
    @pulumi.getter(name="appServiceCertificateNotRenewableReasons")
    def app_service_certificate_not_renewable_reasons(self) -> Sequence[builtins.str]:
        """
        Reasons why App Service Certificate is not renewable at the current moment.
        """
        return pulumi.get(self, "app_service_certificate_not_renewable_reasons")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> builtins.bool:
        """
        true if the certificate should be automatically renewed when it expires; otherwise, false.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.GetCertificateOrderCertificateResult']:
        """
        State of the Key Vault secret. A `certificates` block as defined below.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter
    def csr(self) -> builtins.str:
        """
        Last CSR that was created for this order.
        """
        return pulumi.get(self, "csr")

    @property
    @pulumi.getter(name="distinguishedName")
    def distinguished_name(self) -> builtins.str:
        """
        The Distinguished Name for the App Service Certificate Order.
        """
        return pulumi.get(self, "distinguished_name")

    @property
    @pulumi.getter(name="domainVerificationToken")
    def domain_verification_token(self) -> builtins.str:
        """
        Domain verification token.
        """
        return pulumi.get(self, "domain_verification_token")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> builtins.str:
        """
        Certificate expiration time.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intermediateThumbprint")
    def intermediate_thumbprint(self) -> builtins.str:
        """
        Certificate thumbprint intermediate certificate.
        """
        return pulumi.get(self, "intermediate_thumbprint")

    @property
    @pulumi.getter(name="isPrivateKeyExternal")
    def is_private_key_external(self) -> builtins.bool:
        """
        Whether the private key is external or not.
        """
        return pulumi.get(self, "is_private_key_external")

    @property
    @pulumi.getter(name="keySize")
    def key_size(self) -> builtins.int:
        """
        Certificate key size.
        """
        return pulumi.get(self, "key_size")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure location where the App Service exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productType")
    def product_type(self) -> builtins.str:
        """
        Certificate product type, such as `Standard` or `WildCard`.
        """
        return pulumi.get(self, "product_type")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="rootThumbprint")
    def root_thumbprint(self) -> builtins.str:
        """
        Certificate thumbprint for root certificate.
        """
        return pulumi.get(self, "root_thumbprint")

    @property
    @pulumi.getter(name="signedCertificateThumbprint")
    def signed_certificate_thumbprint(self) -> builtins.str:
        """
        Certificate thumbprint for signed certificate.
        """
        return pulumi.get(self, "signed_certificate_thumbprint")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Current order status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="validityInYears")
    def validity_in_years(self) -> builtins.int:
        """
        Duration in years (must be between 1 and 3).
        """
        return pulumi.get(self, "validity_in_years")


class AwaitableGetCertificateOrderResult(GetCertificateOrderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateOrderResult(
            app_service_certificate_not_renewable_reasons=self.app_service_certificate_not_renewable_reasons,
            auto_renew=self.auto_renew,
            certificates=self.certificates,
            csr=self.csr,
            distinguished_name=self.distinguished_name,
            domain_verification_token=self.domain_verification_token,
            expiration_time=self.expiration_time,
            id=self.id,
            intermediate_thumbprint=self.intermediate_thumbprint,
            is_private_key_external=self.is_private_key_external,
            key_size=self.key_size,
            location=self.location,
            name=self.name,
            product_type=self.product_type,
            resource_group_name=self.resource_group_name,
            root_thumbprint=self.root_thumbprint,
            signed_certificate_thumbprint=self.signed_certificate_thumbprint,
            status=self.status,
            tags=self.tags,
            validity_in_years=self.validity_in_years)


def get_certificate_order(name: Optional[builtins.str] = None,
                          resource_group_name: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateOrderResult:
    """
    Use this data source to access information about an existing App Service Certificate Order.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appservice.get_certificate_order(name="example-cert-order",
        resource_group_name="example-resources")
    pulumi.export("certificateOrderId", example.id)
    ```


    :param builtins.str name: The name of the App Service.
    :param builtins.str resource_group_name: The Name of the Resource Group where the App Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:appservice/getCertificateOrder:getCertificateOrder', __args__, opts=opts, typ=GetCertificateOrderResult).value

    return AwaitableGetCertificateOrderResult(
        app_service_certificate_not_renewable_reasons=pulumi.get(__ret__, 'app_service_certificate_not_renewable_reasons'),
        auto_renew=pulumi.get(__ret__, 'auto_renew'),
        certificates=pulumi.get(__ret__, 'certificates'),
        csr=pulumi.get(__ret__, 'csr'),
        distinguished_name=pulumi.get(__ret__, 'distinguished_name'),
        domain_verification_token=pulumi.get(__ret__, 'domain_verification_token'),
        expiration_time=pulumi.get(__ret__, 'expiration_time'),
        id=pulumi.get(__ret__, 'id'),
        intermediate_thumbprint=pulumi.get(__ret__, 'intermediate_thumbprint'),
        is_private_key_external=pulumi.get(__ret__, 'is_private_key_external'),
        key_size=pulumi.get(__ret__, 'key_size'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        product_type=pulumi.get(__ret__, 'product_type'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        root_thumbprint=pulumi.get(__ret__, 'root_thumbprint'),
        signed_certificate_thumbprint=pulumi.get(__ret__, 'signed_certificate_thumbprint'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        validity_in_years=pulumi.get(__ret__, 'validity_in_years'))
def get_certificate_order_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateOrderResult]:
    """
    Use this data source to access information about an existing App Service Certificate Order.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appservice.get_certificate_order(name="example-cert-order",
        resource_group_name="example-resources")
    pulumi.export("certificateOrderId", example.id)
    ```


    :param builtins.str name: The name of the App Service.
    :param builtins.str resource_group_name: The Name of the Resource Group where the App Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:appservice/getCertificateOrder:getCertificateOrder', __args__, opts=opts, typ=GetCertificateOrderResult)
    return __ret__.apply(lambda __response__: GetCertificateOrderResult(
        app_service_certificate_not_renewable_reasons=pulumi.get(__response__, 'app_service_certificate_not_renewable_reasons'),
        auto_renew=pulumi.get(__response__, 'auto_renew'),
        certificates=pulumi.get(__response__, 'certificates'),
        csr=pulumi.get(__response__, 'csr'),
        distinguished_name=pulumi.get(__response__, 'distinguished_name'),
        domain_verification_token=pulumi.get(__response__, 'domain_verification_token'),
        expiration_time=pulumi.get(__response__, 'expiration_time'),
        id=pulumi.get(__response__, 'id'),
        intermediate_thumbprint=pulumi.get(__response__, 'intermediate_thumbprint'),
        is_private_key_external=pulumi.get(__response__, 'is_private_key_external'),
        key_size=pulumi.get(__response__, 'key_size'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        product_type=pulumi.get(__response__, 'product_type'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        root_thumbprint=pulumi.get(__response__, 'root_thumbprint'),
        signed_certificate_thumbprint=pulumi.get(__response__, 'signed_certificate_thumbprint'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        validity_in_years=pulumi.get(__response__, 'validity_in_years')))
