# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SourceControlTokenArgs', 'SourceControlToken']

@pulumi.input_type
class SourceControlTokenArgs:
    def __init__(__self__, *,
                 token: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 token_secret: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SourceControlToken resource.
        :param pulumi.Input[builtins.str] token: The Access Token.
        :param pulumi.Input[builtins.str] type: The Token type. Possible values include `Bitbucket`, `Dropbox`, `Github`, and `OneDrive`.
        :param pulumi.Input[builtins.str] token_secret: The Access Token Secret.
               
               > **Note:** The token used for deploying App Service needs the following permissions: `repo` and `workflow`.
        """
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "type", type)
        if token_secret is not None:
            pulumi.set(__self__, "token_secret", token_secret)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[builtins.str]:
        """
        The Access Token.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The Token type. Possible values include `Bitbucket`, `Dropbox`, `Github`, and `OneDrive`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="tokenSecret")
    def token_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Access Token Secret.

        > **Note:** The token used for deploying App Service needs the following permissions: `repo` and `workflow`.
        """
        return pulumi.get(self, "token_secret")

    @token_secret.setter
    def token_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token_secret", value)


@pulumi.input_type
class _SourceControlTokenState:
    def __init__(__self__, *,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 token_secret: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SourceControlToken resources.
        :param pulumi.Input[builtins.str] token: The Access Token.
        :param pulumi.Input[builtins.str] token_secret: The Access Token Secret.
               
               > **Note:** The token used for deploying App Service needs the following permissions: `repo` and `workflow`.
        :param pulumi.Input[builtins.str] type: The Token type. Possible values include `Bitbucket`, `Dropbox`, `Github`, and `OneDrive`.
        """
        if token is not None:
            pulumi.set(__self__, "token", token)
        if token_secret is not None:
            pulumi.set(__self__, "token_secret", token_secret)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Access Token.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="tokenSecret")
    def token_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Access Token Secret.

        > **Note:** The token used for deploying App Service needs the following permissions: `repo` and `workflow`.
        """
        return pulumi.get(self, "token_secret")

    @token_secret.setter
    def token_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token_secret", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Token type. Possible values include `Bitbucket`, `Dropbox`, `Github`, and `OneDrive`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("azure:appservice/sourceControlToken:SourceControlToken")
class SourceControlToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 token_secret: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.appservice.SourceControlToken("example",
            type="GitHub",
            token="ghp_sometokenvaluesecretsauce")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-01-01

        ## Import

        App Service Source GitHub Tokens can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/sourceControlToken:SourceControlToken example /providers/Microsoft.Web/sourceControls/GitHub
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] token: The Access Token.
        :param pulumi.Input[builtins.str] token_secret: The Access Token Secret.
               
               > **Note:** The token used for deploying App Service needs the following permissions: `repo` and `workflow`.
        :param pulumi.Input[builtins.str] type: The Token type. Possible values include `Bitbucket`, `Dropbox`, `Github`, and `OneDrive`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SourceControlTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.appservice.SourceControlToken("example",
            type="GitHub",
            token="ghp_sometokenvaluesecretsauce")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-01-01

        ## Import

        App Service Source GitHub Tokens can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/sourceControlToken:SourceControlToken example /providers/Microsoft.Web/sourceControls/GitHub
        ```

        :param str resource_name: The name of the resource.
        :param SourceControlTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SourceControlTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 token_secret: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SourceControlTokenArgs.__new__(SourceControlTokenArgs)

            if token is None and not opts.urn:
                raise TypeError("Missing required property 'token'")
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            __props__.__dict__["token_secret"] = None if token_secret is None else pulumi.Output.secret(token_secret)
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token", "tokenSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SourceControlToken, __self__).__init__(
            'azure:appservice/sourceControlToken:SourceControlToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            token: Optional[pulumi.Input[builtins.str]] = None,
            token_secret: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'SourceControlToken':
        """
        Get an existing SourceControlToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] token: The Access Token.
        :param pulumi.Input[builtins.str] token_secret: The Access Token Secret.
               
               > **Note:** The token used for deploying App Service needs the following permissions: `repo` and `workflow`.
        :param pulumi.Input[builtins.str] type: The Token type. Possible values include `Bitbucket`, `Dropbox`, `Github`, and `OneDrive`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SourceControlTokenState.__new__(_SourceControlTokenState)

        __props__.__dict__["token"] = token
        __props__.__dict__["token_secret"] = token_secret
        __props__.__dict__["type"] = type
        return SourceControlToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[builtins.str]:
        """
        The Access Token.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="tokenSecret")
    def token_secret(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Access Token Secret.

        > **Note:** The token used for deploying App Service needs the following permissions: `repo` and `workflow`.
        """
        return pulumi.get(self, "token_secret")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The Token type. Possible values include `Bitbucket`, `Dropbox`, `Github`, and `OneDrive`.
        """
        return pulumi.get(self, "type")

