# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WindowsFunctionAppArgs', 'WindowsFunctionApp']

@pulumi.input_type
class WindowsFunctionAppArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 service_plan_id: pulumi.Input[builtins.str],
                 site_config: pulumi.Input['WindowsFunctionAppSiteConfigArgs'],
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input['WindowsFunctionAppAuthSettingsArgs']] = None,
                 auth_settings_v2: Optional[pulumi.Input['WindowsFunctionAppAuthSettingsV2Args']] = None,
                 backup: Optional[pulumi.Input['WindowsFunctionAppBackupArgs']] = None,
                 builtin_logging_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppConnectionStringArgs']]]] = None,
                 content_share_force_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 daily_memory_time_quota: Optional[pulumi.Input[builtins.int]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 functions_extension_version: Optional[pulumi.Input[builtins.str]] = None,
                 https_only: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['WindowsFunctionAppIdentityArgs']] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sticky_settings: Optional[pulumi.Input['WindowsFunctionAppStickySettingsArgs']] = None,
                 storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppStorageAccountArgs']]]] = None,
                 storage_key_vault_secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_uses_managed_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_network_backup_restore_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 vnet_image_pull_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 zip_deploy_file: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a WindowsFunctionApp resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        :param pulumi.Input[builtins.str] service_plan_id: The ID of the App Service Plan within which to create this Function App.
        :param pulumi.Input['WindowsFunctionAppSiteConfigArgs'] site_config: A `site_config` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_settings: A map of key-value pairs for [App
               Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        :param pulumi.Input['WindowsFunctionAppAuthSettingsArgs'] auth_settings: A `auth_settings` block as defined below.
        :param pulumi.Input['WindowsFunctionAppAuthSettingsV2Args'] auth_settings_v2: A `auth_settings_v2` block as defined below.
        :param pulumi.Input['WindowsFunctionAppBackupArgs'] backup: A `backup` block as defined below.
        :param pulumi.Input[builtins.bool] builtin_logging_enabled: Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        :param pulumi.Input[builtins.bool] client_certificate_enabled: Should the function app use Client Certificates.
        :param pulumi.Input[builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[builtins.str] client_certificate_mode: The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppConnectionStringArgs']]] connection_strings: One or more `connection_string` blocks as defined below.
        :param pulumi.Input[builtins.bool] content_share_force_disabled: Should Content Share Settings be disabled. Defaults to `false`.
        :param pulumi.Input[builtins.int] daily_memory_time_quota: The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan. Defaults to `0`.
        :param pulumi.Input[builtins.bool] enabled: Is the Function App enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] ftp_publish_basic_authentication_enabled: Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] functions_extension_version: The runtime version associated with the Function App. Defaults to `~4`.
        :param pulumi.Input[builtins.bool] https_only: Can the Function App only be accessed via HTTPS?. Defaults to `false`.
        :param pulumi.Input['WindowsFunctionAppIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.str] key_vault_reference_identity_id: The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        :param pulumi.Input[builtins.str] location: The Azure Region where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Windows Function App. Changing this forces a new Windows Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Should public network access be enabled for the Function App. Defaults to `true`.
        :param pulumi.Input['WindowsFunctionAppStickySettingsArgs'] sticky_settings: A `sticky_settings` block as defined below.
        :param pulumi.Input[builtins.str] storage_account_access_key: The access key which will be used to access the backend storage account for the Function App. Conflicts with `storage_uses_managed_identity`.
        :param pulumi.Input[builtins.str] storage_account_name: The backend storage account name which will be used by this Function App.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppStorageAccountArgs']]] storage_accounts: One or more `storage_account` blocks as defined below.
        :param pulumi.Input[builtins.str] storage_key_vault_secret_id: The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.
               
               > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.
               
               > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        :param pulumi.Input[builtins.bool] storage_uses_managed_identity: Should the Function App use Managed Identity to access the storage account. Conflicts with `storage_account_access_key`.
               
               > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Windows Function App.
        :param pulumi.Input[builtins.bool] virtual_network_backup_restore_enabled: Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] vnet_image_pull_enabled: Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.
               
               > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for app running in the App Service Environment.
        :param pulumi.Input[builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
               
               > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        :param pulumi.Input[builtins.str] zip_deploy_file: The local path and filename of the Zip packaged application to deploy to this Windows Function App.
               
               > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "service_plan_id", service_plan_id)
        pulumi.set(__self__, "site_config", site_config)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auth_settings is not None:
            pulumi.set(__self__, "auth_settings", auth_settings)
        if auth_settings_v2 is not None:
            pulumi.set(__self__, "auth_settings_v2", auth_settings_v2)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if builtin_logging_enabled is not None:
            pulumi.set(__self__, "builtin_logging_enabled", builtin_logging_enabled)
        if client_certificate_enabled is not None:
            pulumi.set(__self__, "client_certificate_enabled", client_certificate_enabled)
        if client_certificate_exclusion_paths is not None:
            pulumi.set(__self__, "client_certificate_exclusion_paths", client_certificate_exclusion_paths)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if content_share_force_disabled is not None:
            pulumi.set(__self__, "content_share_force_disabled", content_share_force_disabled)
        if daily_memory_time_quota is not None:
            pulumi.set(__self__, "daily_memory_time_quota", daily_memory_time_quota)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ftp_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "ftp_publish_basic_authentication_enabled", ftp_publish_basic_authentication_enabled)
        if functions_extension_version is not None:
            pulumi.set(__self__, "functions_extension_version", functions_extension_version)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_reference_identity_id is not None:
            pulumi.set(__self__, "key_vault_reference_identity_id", key_vault_reference_identity_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if sticky_settings is not None:
            pulumi.set(__self__, "sticky_settings", sticky_settings)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if storage_key_vault_secret_id is not None:
            pulumi.set(__self__, "storage_key_vault_secret_id", storage_key_vault_secret_id)
        if storage_uses_managed_identity is not None:
            pulumi.set(__self__, "storage_uses_managed_identity", storage_uses_managed_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_backup_restore_enabled is not None:
            pulumi.set(__self__, "virtual_network_backup_restore_enabled", virtual_network_backup_restore_enabled)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)
        if vnet_image_pull_enabled is not None:
            pulumi.set(__self__, "vnet_image_pull_enabled", vnet_image_pull_enabled)
        if webdeploy_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "webdeploy_publish_basic_authentication_enabled", webdeploy_publish_basic_authentication_enabled)
        if zip_deploy_file is not None:
            pulumi.set(__self__, "zip_deploy_file", zip_deploy_file)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="servicePlanId")
    def service_plan_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the App Service Plan within which to create this Function App.
        """
        return pulumi.get(self, "service_plan_id")

    @service_plan_id.setter
    def service_plan_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_plan_id", value)

    @property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> pulumi.Input['WindowsFunctionAppSiteConfigArgs']:
        """
        A `site_config` block as defined below.
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: pulumi.Input['WindowsFunctionAppSiteConfigArgs']):
        pulumi.set(self, "site_config", value)

    @property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key-value pairs for [App
        Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "app_settings", value)

    @property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> Optional[pulumi.Input['WindowsFunctionAppAuthSettingsArgs']]:
        """
        A `auth_settings` block as defined below.
        """
        return pulumi.get(self, "auth_settings")

    @auth_settings.setter
    def auth_settings(self, value: Optional[pulumi.Input['WindowsFunctionAppAuthSettingsArgs']]):
        pulumi.set(self, "auth_settings", value)

    @property
    @pulumi.getter(name="authSettingsV2")
    def auth_settings_v2(self) -> Optional[pulumi.Input['WindowsFunctionAppAuthSettingsV2Args']]:
        """
        A `auth_settings_v2` block as defined below.
        """
        return pulumi.get(self, "auth_settings_v2")

    @auth_settings_v2.setter
    def auth_settings_v2(self, value: Optional[pulumi.Input['WindowsFunctionAppAuthSettingsV2Args']]):
        pulumi.set(self, "auth_settings_v2", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['WindowsFunctionAppBackupArgs']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['WindowsFunctionAppBackupArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="builtinLoggingEnabled")
    def builtin_logging_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        """
        return pulumi.get(self, "builtin_logging_enabled")

    @builtin_logging_enabled.setter
    def builtin_logging_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "builtin_logging_enabled", value)

    @property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the function app use Client Certificates.
        """
        return pulumi.get(self, "client_certificate_enabled")

    @client_certificate_enabled.setter
    def client_certificate_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "client_certificate_enabled", value)

    @property
    @pulumi.getter(name="clientCertificateExclusionPaths")
    def client_certificate_exclusion_paths(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Paths to exclude when using client certificates, separated by ;
        """
        return pulumi.get(self, "client_certificate_exclusion_paths")

    @client_certificate_exclusion_paths.setter
    def client_certificate_exclusion_paths(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_exclusion_paths", value)

    @property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @client_certificate_mode.setter
    def client_certificate_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_mode", value)

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppConnectionStringArgs']]]]:
        """
        One or more `connection_string` blocks as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @property
    @pulumi.getter(name="contentShareForceDisabled")
    def content_share_force_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should Content Share Settings be disabled. Defaults to `false`.
        """
        return pulumi.get(self, "content_share_force_disabled")

    @content_share_force_disabled.setter
    def content_share_force_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "content_share_force_disabled", value)

    @property
    @pulumi.getter(name="dailyMemoryTimeQuota")
    def daily_memory_time_quota(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan. Defaults to `0`.
        """
        return pulumi.get(self, "daily_memory_time_quota")

    @daily_memory_time_quota.setter
    def daily_memory_time_quota(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "daily_memory_time_quota", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the Function App enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="ftpPublishBasicAuthenticationEnabled")
    def ftp_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ftp_publish_basic_authentication_enabled")

    @ftp_publish_basic_authentication_enabled.setter
    def ftp_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ftp_publish_basic_authentication_enabled", value)

    @property
    @pulumi.getter(name="functionsExtensionVersion")
    def functions_extension_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The runtime version associated with the Function App. Defaults to `~4`.
        """
        return pulumi.get(self, "functions_extension_version")

    @functions_extension_version.setter
    def functions_extension_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "functions_extension_version", value)

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Can the Function App only be accessed via HTTPS?. Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['WindowsFunctionAppIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['WindowsFunctionAppIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyVaultReferenceIdentityId")
    def key_vault_reference_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        """
        return pulumi.get(self, "key_vault_reference_identity_id")

    @key_vault_reference_identity_id.setter
    def key_vault_reference_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_reference_identity_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Windows Function App. Changing this forces a new Windows Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should public network access be enabled for the Function App. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="stickySettings")
    def sticky_settings(self) -> Optional[pulumi.Input['WindowsFunctionAppStickySettingsArgs']]:
        """
        A `sticky_settings` block as defined below.
        """
        return pulumi.get(self, "sticky_settings")

    @sticky_settings.setter
    def sticky_settings(self, value: Optional[pulumi.Input['WindowsFunctionAppStickySettingsArgs']]):
        pulumi.set(self, "sticky_settings", value)

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access key which will be used to access the backend storage account for the Function App. Conflicts with `storage_uses_managed_identity`.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The backend storage account name which will be used by this Function App.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_name", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppStorageAccountArgs']]]]:
        """
        One or more `storage_account` blocks as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @property
    @pulumi.getter(name="storageKeyVaultSecretId")
    def storage_key_vault_secret_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.

        > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.

        > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        """
        return pulumi.get(self, "storage_key_vault_secret_id")

    @storage_key_vault_secret_id.setter
    def storage_key_vault_secret_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_key_vault_secret_id", value)

    @property
    @pulumi.getter(name="storageUsesManagedIdentity")
    def storage_uses_managed_identity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Function App use Managed Identity to access the storage account. Conflicts with `storage_account_access_key`.

        > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        """
        return pulumi.get(self, "storage_uses_managed_identity")

    @storage_uses_managed_identity.setter
    def storage_uses_managed_identity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "storage_uses_managed_identity", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Windows Function App.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="virtualNetworkBackupRestoreEnabled")
    def virtual_network_backup_restore_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "virtual_network_backup_restore_enabled")

    @virtual_network_backup_restore_enabled.setter
    def virtual_network_backup_restore_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "virtual_network_backup_restore_enabled", value)

    @property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @virtual_network_subnet_id.setter
    def virtual_network_subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_network_subnet_id", value)

    @property
    @pulumi.getter(name="vnetImagePullEnabled")
    def vnet_image_pull_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.

        > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for app running in the App Service Environment.
        """
        return pulumi.get(self, "vnet_image_pull_enabled")

    @vnet_image_pull_enabled.setter
    def vnet_image_pull_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "vnet_image_pull_enabled", value)

    @property
    @pulumi.getter(name="webdeployPublishBasicAuthenticationEnabled")
    def webdeploy_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.

        > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        """
        return pulumi.get(self, "webdeploy_publish_basic_authentication_enabled")

    @webdeploy_publish_basic_authentication_enabled.setter
    def webdeploy_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "webdeploy_publish_basic_authentication_enabled", value)

    @property
    @pulumi.getter(name="zipDeployFile")
    def zip_deploy_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The local path and filename of the Zip packaged application to deploy to this Windows Function App.

        > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        return pulumi.get(self, "zip_deploy_file")

    @zip_deploy_file.setter
    def zip_deploy_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zip_deploy_file", value)


@pulumi.input_type
class _WindowsFunctionAppState:
    def __init__(__self__, *,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input['WindowsFunctionAppAuthSettingsArgs']] = None,
                 auth_settings_v2: Optional[pulumi.Input['WindowsFunctionAppAuthSettingsV2Args']] = None,
                 backup: Optional[pulumi.Input['WindowsFunctionAppBackupArgs']] = None,
                 builtin_logging_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppConnectionStringArgs']]]] = None,
                 content_share_force_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_domain_verification_id: Optional[pulumi.Input[builtins.str]] = None,
                 daily_memory_time_quota: Optional[pulumi.Input[builtins.int]] = None,
                 default_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 functions_extension_version: Optional[pulumi.Input[builtins.str]] = None,
                 hosting_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 https_only: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['WindowsFunctionAppIdentityArgs']] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 outbound_ip_addresses: Optional[pulumi.Input[builtins.str]] = None,
                 possible_outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 possible_outbound_ip_addresses: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 site_config: Optional[pulumi.Input['WindowsFunctionAppSiteConfigArgs']] = None,
                 site_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppSiteCredentialArgs']]]] = None,
                 sticky_settings: Optional[pulumi.Input['WindowsFunctionAppStickySettingsArgs']] = None,
                 storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppStorageAccountArgs']]]] = None,
                 storage_key_vault_secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_uses_managed_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_network_backup_restore_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 vnet_image_pull_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 zip_deploy_file: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WindowsFunctionApp resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_settings: A map of key-value pairs for [App
               Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        :param pulumi.Input['WindowsFunctionAppAuthSettingsArgs'] auth_settings: A `auth_settings` block as defined below.
        :param pulumi.Input['WindowsFunctionAppAuthSettingsV2Args'] auth_settings_v2: A `auth_settings_v2` block as defined below.
        :param pulumi.Input['WindowsFunctionAppBackupArgs'] backup: A `backup` block as defined below.
        :param pulumi.Input[builtins.bool] builtin_logging_enabled: Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        :param pulumi.Input[builtins.bool] client_certificate_enabled: Should the function app use Client Certificates.
        :param pulumi.Input[builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[builtins.str] client_certificate_mode: The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppConnectionStringArgs']]] connection_strings: One or more `connection_string` blocks as defined below.
        :param pulumi.Input[builtins.bool] content_share_force_disabled: Should Content Share Settings be disabled. Defaults to `false`.
        :param pulumi.Input[builtins.str] custom_domain_verification_id: The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        :param pulumi.Input[builtins.int] daily_memory_time_quota: The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan. Defaults to `0`.
        :param pulumi.Input[builtins.str] default_hostname: The default hostname of the Windows Function App.
        :param pulumi.Input[builtins.bool] enabled: Is the Function App enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] ftp_publish_basic_authentication_enabled: Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] functions_extension_version: The runtime version associated with the Function App. Defaults to `~4`.
        :param pulumi.Input[builtins.str] hosting_environment_id: The ID of the App Service Environment used by Function App.
        :param pulumi.Input[builtins.bool] https_only: Can the Function App only be accessed via HTTPS?. Defaults to `false`.
        :param pulumi.Input['WindowsFunctionAppIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.str] key_vault_reference_identity_id: The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        :param pulumi.Input[builtins.str] kind: The Kind value for this Windows Function App.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Windows Function App. Changing this forces a new Windows Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] outbound_ip_address_lists: A list of outbound IP addresses. For example `["52.23.25.3", "52.143.43.12"]`
        :param pulumi.Input[builtins.str] outbound_ip_addresses: A comma separated list of outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] possible_outbound_ip_address_lists: A list of possible outbound IP addresses, not all of which are necessarily in use. This is a superset of `outbound_ip_address_list`. For example `["52.23.25.3", "52.143.43.12"]`.
        :param pulumi.Input[builtins.str] possible_outbound_ip_addresses: A comma separated list of possible outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12,52.143.43.17`. This is a superset of `outbound_ip_addresses`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Should public network access be enabled for the Function App. Defaults to `true`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        :param pulumi.Input[builtins.str] service_plan_id: The ID of the App Service Plan within which to create this Function App.
        :param pulumi.Input['WindowsFunctionAppSiteConfigArgs'] site_config: A `site_config` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppSiteCredentialArgs']]] site_credentials: A `site_credential` block as defined below.
        :param pulumi.Input['WindowsFunctionAppStickySettingsArgs'] sticky_settings: A `sticky_settings` block as defined below.
        :param pulumi.Input[builtins.str] storage_account_access_key: The access key which will be used to access the backend storage account for the Function App. Conflicts with `storage_uses_managed_identity`.
        :param pulumi.Input[builtins.str] storage_account_name: The backend storage account name which will be used by this Function App.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppStorageAccountArgs']]] storage_accounts: One or more `storage_account` blocks as defined below.
        :param pulumi.Input[builtins.str] storage_key_vault_secret_id: The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.
               
               > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.
               
               > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        :param pulumi.Input[builtins.bool] storage_uses_managed_identity: Should the Function App use Managed Identity to access the storage account. Conflicts with `storage_account_access_key`.
               
               > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Windows Function App.
        :param pulumi.Input[builtins.bool] virtual_network_backup_restore_enabled: Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] vnet_image_pull_enabled: Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.
               
               > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for app running in the App Service Environment.
        :param pulumi.Input[builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
               
               > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        :param pulumi.Input[builtins.str] zip_deploy_file: The local path and filename of the Zip packaged application to deploy to this Windows Function App.
               
               > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auth_settings is not None:
            pulumi.set(__self__, "auth_settings", auth_settings)
        if auth_settings_v2 is not None:
            pulumi.set(__self__, "auth_settings_v2", auth_settings_v2)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if builtin_logging_enabled is not None:
            pulumi.set(__self__, "builtin_logging_enabled", builtin_logging_enabled)
        if client_certificate_enabled is not None:
            pulumi.set(__self__, "client_certificate_enabled", client_certificate_enabled)
        if client_certificate_exclusion_paths is not None:
            pulumi.set(__self__, "client_certificate_exclusion_paths", client_certificate_exclusion_paths)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if content_share_force_disabled is not None:
            pulumi.set(__self__, "content_share_force_disabled", content_share_force_disabled)
        if custom_domain_verification_id is not None:
            pulumi.set(__self__, "custom_domain_verification_id", custom_domain_verification_id)
        if daily_memory_time_quota is not None:
            pulumi.set(__self__, "daily_memory_time_quota", daily_memory_time_quota)
        if default_hostname is not None:
            pulumi.set(__self__, "default_hostname", default_hostname)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ftp_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "ftp_publish_basic_authentication_enabled", ftp_publish_basic_authentication_enabled)
        if functions_extension_version is not None:
            pulumi.set(__self__, "functions_extension_version", functions_extension_version)
        if hosting_environment_id is not None:
            pulumi.set(__self__, "hosting_environment_id", hosting_environment_id)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_reference_identity_id is not None:
            pulumi.set(__self__, "key_vault_reference_identity_id", key_vault_reference_identity_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_ip_address_lists is not None:
            pulumi.set(__self__, "outbound_ip_address_lists", outbound_ip_address_lists)
        if outbound_ip_addresses is not None:
            pulumi.set(__self__, "outbound_ip_addresses", outbound_ip_addresses)
        if possible_outbound_ip_address_lists is not None:
            pulumi.set(__self__, "possible_outbound_ip_address_lists", possible_outbound_ip_address_lists)
        if possible_outbound_ip_addresses is not None:
            pulumi.set(__self__, "possible_outbound_ip_addresses", possible_outbound_ip_addresses)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_plan_id is not None:
            pulumi.set(__self__, "service_plan_id", service_plan_id)
        if site_config is not None:
            pulumi.set(__self__, "site_config", site_config)
        if site_credentials is not None:
            pulumi.set(__self__, "site_credentials", site_credentials)
        if sticky_settings is not None:
            pulumi.set(__self__, "sticky_settings", sticky_settings)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if storage_key_vault_secret_id is not None:
            pulumi.set(__self__, "storage_key_vault_secret_id", storage_key_vault_secret_id)
        if storage_uses_managed_identity is not None:
            pulumi.set(__self__, "storage_uses_managed_identity", storage_uses_managed_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_backup_restore_enabled is not None:
            pulumi.set(__self__, "virtual_network_backup_restore_enabled", virtual_network_backup_restore_enabled)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)
        if vnet_image_pull_enabled is not None:
            pulumi.set(__self__, "vnet_image_pull_enabled", vnet_image_pull_enabled)
        if webdeploy_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "webdeploy_publish_basic_authentication_enabled", webdeploy_publish_basic_authentication_enabled)
        if zip_deploy_file is not None:
            pulumi.set(__self__, "zip_deploy_file", zip_deploy_file)

    @property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key-value pairs for [App
        Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "app_settings", value)

    @property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> Optional[pulumi.Input['WindowsFunctionAppAuthSettingsArgs']]:
        """
        A `auth_settings` block as defined below.
        """
        return pulumi.get(self, "auth_settings")

    @auth_settings.setter
    def auth_settings(self, value: Optional[pulumi.Input['WindowsFunctionAppAuthSettingsArgs']]):
        pulumi.set(self, "auth_settings", value)

    @property
    @pulumi.getter(name="authSettingsV2")
    def auth_settings_v2(self) -> Optional[pulumi.Input['WindowsFunctionAppAuthSettingsV2Args']]:
        """
        A `auth_settings_v2` block as defined below.
        """
        return pulumi.get(self, "auth_settings_v2")

    @auth_settings_v2.setter
    def auth_settings_v2(self, value: Optional[pulumi.Input['WindowsFunctionAppAuthSettingsV2Args']]):
        pulumi.set(self, "auth_settings_v2", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['WindowsFunctionAppBackupArgs']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['WindowsFunctionAppBackupArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="builtinLoggingEnabled")
    def builtin_logging_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        """
        return pulumi.get(self, "builtin_logging_enabled")

    @builtin_logging_enabled.setter
    def builtin_logging_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "builtin_logging_enabled", value)

    @property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the function app use Client Certificates.
        """
        return pulumi.get(self, "client_certificate_enabled")

    @client_certificate_enabled.setter
    def client_certificate_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "client_certificate_enabled", value)

    @property
    @pulumi.getter(name="clientCertificateExclusionPaths")
    def client_certificate_exclusion_paths(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Paths to exclude when using client certificates, separated by ;
        """
        return pulumi.get(self, "client_certificate_exclusion_paths")

    @client_certificate_exclusion_paths.setter
    def client_certificate_exclusion_paths(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_exclusion_paths", value)

    @property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @client_certificate_mode.setter
    def client_certificate_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_mode", value)

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppConnectionStringArgs']]]]:
        """
        One or more `connection_string` blocks as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @property
    @pulumi.getter(name="contentShareForceDisabled")
    def content_share_force_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should Content Share Settings be disabled. Defaults to `false`.
        """
        return pulumi.get(self, "content_share_force_disabled")

    @content_share_force_disabled.setter
    def content_share_force_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "content_share_force_disabled", value)

    @property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @custom_domain_verification_id.setter
    def custom_domain_verification_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_domain_verification_id", value)

    @property
    @pulumi.getter(name="dailyMemoryTimeQuota")
    def daily_memory_time_quota(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan. Defaults to `0`.
        """
        return pulumi.get(self, "daily_memory_time_quota")

    @daily_memory_time_quota.setter
    def daily_memory_time_quota(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "daily_memory_time_quota", value)

    @property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default hostname of the Windows Function App.
        """
        return pulumi.get(self, "default_hostname")

    @default_hostname.setter
    def default_hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_hostname", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the Function App enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="ftpPublishBasicAuthenticationEnabled")
    def ftp_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ftp_publish_basic_authentication_enabled")

    @ftp_publish_basic_authentication_enabled.setter
    def ftp_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ftp_publish_basic_authentication_enabled", value)

    @property
    @pulumi.getter(name="functionsExtensionVersion")
    def functions_extension_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The runtime version associated with the Function App. Defaults to `~4`.
        """
        return pulumi.get(self, "functions_extension_version")

    @functions_extension_version.setter
    def functions_extension_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "functions_extension_version", value)

    @property
    @pulumi.getter(name="hostingEnvironmentId")
    def hosting_environment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the App Service Environment used by Function App.
        """
        return pulumi.get(self, "hosting_environment_id")

    @hosting_environment_id.setter
    def hosting_environment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hosting_environment_id", value)

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Can the Function App only be accessed via HTTPS?. Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['WindowsFunctionAppIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['WindowsFunctionAppIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyVaultReferenceIdentityId")
    def key_vault_reference_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        """
        return pulumi.get(self, "key_vault_reference_identity_id")

    @key_vault_reference_identity_id.setter
    def key_vault_reference_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_reference_identity_id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kind value for this Windows Function App.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Windows Function App. Changing this forces a new Windows Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outboundIpAddressLists")
    def outbound_ip_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of outbound IP addresses. For example `["52.23.25.3", "52.143.43.12"]`
        """
        return pulumi.get(self, "outbound_ip_address_lists")

    @outbound_ip_address_lists.setter
    def outbound_ip_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "outbound_ip_address_lists", value)

    @property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comma separated list of outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12`.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @outbound_ip_addresses.setter
    def outbound_ip_addresses(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outbound_ip_addresses", value)

    @property
    @pulumi.getter(name="possibleOutboundIpAddressLists")
    def possible_outbound_ip_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of possible outbound IP addresses, not all of which are necessarily in use. This is a superset of `outbound_ip_address_list`. For example `["52.23.25.3", "52.143.43.12"]`.
        """
        return pulumi.get(self, "possible_outbound_ip_address_lists")

    @possible_outbound_ip_address_lists.setter
    def possible_outbound_ip_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "possible_outbound_ip_address_lists", value)

    @property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comma separated list of possible outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12,52.143.43.17`. This is a superset of `outbound_ip_addresses`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @possible_outbound_ip_addresses.setter
    def possible_outbound_ip_addresses(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "possible_outbound_ip_addresses", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should public network access be enabled for the Function App. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="servicePlanId")
    def service_plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the App Service Plan within which to create this Function App.
        """
        return pulumi.get(self, "service_plan_id")

    @service_plan_id.setter
    def service_plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_plan_id", value)

    @property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> Optional[pulumi.Input['WindowsFunctionAppSiteConfigArgs']]:
        """
        A `site_config` block as defined below.
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: Optional[pulumi.Input['WindowsFunctionAppSiteConfigArgs']]):
        pulumi.set(self, "site_config", value)

    @property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppSiteCredentialArgs']]]]:
        """
        A `site_credential` block as defined below.
        """
        return pulumi.get(self, "site_credentials")

    @site_credentials.setter
    def site_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppSiteCredentialArgs']]]]):
        pulumi.set(self, "site_credentials", value)

    @property
    @pulumi.getter(name="stickySettings")
    def sticky_settings(self) -> Optional[pulumi.Input['WindowsFunctionAppStickySettingsArgs']]:
        """
        A `sticky_settings` block as defined below.
        """
        return pulumi.get(self, "sticky_settings")

    @sticky_settings.setter
    def sticky_settings(self, value: Optional[pulumi.Input['WindowsFunctionAppStickySettingsArgs']]):
        pulumi.set(self, "sticky_settings", value)

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access key which will be used to access the backend storage account for the Function App. Conflicts with `storage_uses_managed_identity`.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The backend storage account name which will be used by this Function App.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_name", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppStorageAccountArgs']]]]:
        """
        One or more `storage_account` blocks as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFunctionAppStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @property
    @pulumi.getter(name="storageKeyVaultSecretId")
    def storage_key_vault_secret_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.

        > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.

        > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        """
        return pulumi.get(self, "storage_key_vault_secret_id")

    @storage_key_vault_secret_id.setter
    def storage_key_vault_secret_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_key_vault_secret_id", value)

    @property
    @pulumi.getter(name="storageUsesManagedIdentity")
    def storage_uses_managed_identity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Function App use Managed Identity to access the storage account. Conflicts with `storage_account_access_key`.

        > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        """
        return pulumi.get(self, "storage_uses_managed_identity")

    @storage_uses_managed_identity.setter
    def storage_uses_managed_identity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "storage_uses_managed_identity", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Windows Function App.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="virtualNetworkBackupRestoreEnabled")
    def virtual_network_backup_restore_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "virtual_network_backup_restore_enabled")

    @virtual_network_backup_restore_enabled.setter
    def virtual_network_backup_restore_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "virtual_network_backup_restore_enabled", value)

    @property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @virtual_network_subnet_id.setter
    def virtual_network_subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_network_subnet_id", value)

    @property
    @pulumi.getter(name="vnetImagePullEnabled")
    def vnet_image_pull_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.

        > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for app running in the App Service Environment.
        """
        return pulumi.get(self, "vnet_image_pull_enabled")

    @vnet_image_pull_enabled.setter
    def vnet_image_pull_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "vnet_image_pull_enabled", value)

    @property
    @pulumi.getter(name="webdeployPublishBasicAuthenticationEnabled")
    def webdeploy_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.

        > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        """
        return pulumi.get(self, "webdeploy_publish_basic_authentication_enabled")

    @webdeploy_publish_basic_authentication_enabled.setter
    def webdeploy_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "webdeploy_publish_basic_authentication_enabled", value)

    @property
    @pulumi.getter(name="zipDeployFile")
    def zip_deploy_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The local path and filename of the Zip packaged application to deploy to this Windows Function App.

        > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        return pulumi.get(self, "zip_deploy_file")

    @zip_deploy_file.setter
    def zip_deploy_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zip_deploy_file", value)


@pulumi.type_token("azure:appservice/windowsFunctionApp:WindowsFunctionApp")
class WindowsFunctionApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input[Union['WindowsFunctionAppAuthSettingsArgs', 'WindowsFunctionAppAuthSettingsArgsDict']]] = None,
                 auth_settings_v2: Optional[pulumi.Input[Union['WindowsFunctionAppAuthSettingsV2Args', 'WindowsFunctionAppAuthSettingsV2ArgsDict']]] = None,
                 backup: Optional[pulumi.Input[Union['WindowsFunctionAppBackupArgs', 'WindowsFunctionAppBackupArgsDict']]] = None,
                 builtin_logging_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsFunctionAppConnectionStringArgs', 'WindowsFunctionAppConnectionStringArgsDict']]]]] = None,
                 content_share_force_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 daily_memory_time_quota: Optional[pulumi.Input[builtins.int]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 functions_extension_version: Optional[pulumi.Input[builtins.str]] = None,
                 https_only: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['WindowsFunctionAppIdentityArgs', 'WindowsFunctionAppIdentityArgsDict']]] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 site_config: Optional[pulumi.Input[Union['WindowsFunctionAppSiteConfigArgs', 'WindowsFunctionAppSiteConfigArgsDict']]] = None,
                 sticky_settings: Optional[pulumi.Input[Union['WindowsFunctionAppStickySettingsArgs', 'WindowsFunctionAppStickySettingsArgsDict']]] = None,
                 storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsFunctionAppStorageAccountArgs', 'WindowsFunctionAppStorageAccountArgsDict']]]]] = None,
                 storage_key_vault_secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_uses_managed_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_network_backup_restore_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 vnet_image_pull_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 zip_deploy_file: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Windows Function App.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="windowsfunctionappsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-app-service-plan",
            resource_group_name=example.name,
            location=example.location,
            os_type="Windows",
            sku_name="Y1")
        example_windows_function_app = azure.appservice.WindowsFunctionApp("example",
            name="example-windows-function-app",
            resource_group_name=example.name,
            location=example.location,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            service_plan_id=example_service_plan.id,
            site_config={})
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01, 2023-01-01

        ## Import

        Windows Function Apps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/windowsFunctionApp:WindowsFunctionApp example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Web/sites/site1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_settings: A map of key-value pairs for [App
               Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        :param pulumi.Input[Union['WindowsFunctionAppAuthSettingsArgs', 'WindowsFunctionAppAuthSettingsArgsDict']] auth_settings: A `auth_settings` block as defined below.
        :param pulumi.Input[Union['WindowsFunctionAppAuthSettingsV2Args', 'WindowsFunctionAppAuthSettingsV2ArgsDict']] auth_settings_v2: A `auth_settings_v2` block as defined below.
        :param pulumi.Input[Union['WindowsFunctionAppBackupArgs', 'WindowsFunctionAppBackupArgsDict']] backup: A `backup` block as defined below.
        :param pulumi.Input[builtins.bool] builtin_logging_enabled: Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        :param pulumi.Input[builtins.bool] client_certificate_enabled: Should the function app use Client Certificates.
        :param pulumi.Input[builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[builtins.str] client_certificate_mode: The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsFunctionAppConnectionStringArgs', 'WindowsFunctionAppConnectionStringArgsDict']]]] connection_strings: One or more `connection_string` blocks as defined below.
        :param pulumi.Input[builtins.bool] content_share_force_disabled: Should Content Share Settings be disabled. Defaults to `false`.
        :param pulumi.Input[builtins.int] daily_memory_time_quota: The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan. Defaults to `0`.
        :param pulumi.Input[builtins.bool] enabled: Is the Function App enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] ftp_publish_basic_authentication_enabled: Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] functions_extension_version: The runtime version associated with the Function App. Defaults to `~4`.
        :param pulumi.Input[builtins.bool] https_only: Can the Function App only be accessed via HTTPS?. Defaults to `false`.
        :param pulumi.Input[Union['WindowsFunctionAppIdentityArgs', 'WindowsFunctionAppIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.str] key_vault_reference_identity_id: The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        :param pulumi.Input[builtins.str] location: The Azure Region where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Windows Function App. Changing this forces a new Windows Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Should public network access be enabled for the Function App. Defaults to `true`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        :param pulumi.Input[builtins.str] service_plan_id: The ID of the App Service Plan within which to create this Function App.
        :param pulumi.Input[Union['WindowsFunctionAppSiteConfigArgs', 'WindowsFunctionAppSiteConfigArgsDict']] site_config: A `site_config` block as defined below.
        :param pulumi.Input[Union['WindowsFunctionAppStickySettingsArgs', 'WindowsFunctionAppStickySettingsArgsDict']] sticky_settings: A `sticky_settings` block as defined below.
        :param pulumi.Input[builtins.str] storage_account_access_key: The access key which will be used to access the backend storage account for the Function App. Conflicts with `storage_uses_managed_identity`.
        :param pulumi.Input[builtins.str] storage_account_name: The backend storage account name which will be used by this Function App.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsFunctionAppStorageAccountArgs', 'WindowsFunctionAppStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` blocks as defined below.
        :param pulumi.Input[builtins.str] storage_key_vault_secret_id: The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.
               
               > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.
               
               > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        :param pulumi.Input[builtins.bool] storage_uses_managed_identity: Should the Function App use Managed Identity to access the storage account. Conflicts with `storage_account_access_key`.
               
               > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Windows Function App.
        :param pulumi.Input[builtins.bool] virtual_network_backup_restore_enabled: Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] vnet_image_pull_enabled: Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.
               
               > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for app running in the App Service Environment.
        :param pulumi.Input[builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
               
               > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        :param pulumi.Input[builtins.str] zip_deploy_file: The local path and filename of the Zip packaged application to deploy to this Windows Function App.
               
               > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WindowsFunctionAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Windows Function App.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="windowsfunctionappsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-app-service-plan",
            resource_group_name=example.name,
            location=example.location,
            os_type="Windows",
            sku_name="Y1")
        example_windows_function_app = azure.appservice.WindowsFunctionApp("example",
            name="example-windows-function-app",
            resource_group_name=example.name,
            location=example.location,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            service_plan_id=example_service_plan.id,
            site_config={})
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01, 2023-01-01

        ## Import

        Windows Function Apps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/windowsFunctionApp:WindowsFunctionApp example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Web/sites/site1
        ```

        :param str resource_name: The name of the resource.
        :param WindowsFunctionAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WindowsFunctionAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input[Union['WindowsFunctionAppAuthSettingsArgs', 'WindowsFunctionAppAuthSettingsArgsDict']]] = None,
                 auth_settings_v2: Optional[pulumi.Input[Union['WindowsFunctionAppAuthSettingsV2Args', 'WindowsFunctionAppAuthSettingsV2ArgsDict']]] = None,
                 backup: Optional[pulumi.Input[Union['WindowsFunctionAppBackupArgs', 'WindowsFunctionAppBackupArgsDict']]] = None,
                 builtin_logging_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsFunctionAppConnectionStringArgs', 'WindowsFunctionAppConnectionStringArgsDict']]]]] = None,
                 content_share_force_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 daily_memory_time_quota: Optional[pulumi.Input[builtins.int]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 functions_extension_version: Optional[pulumi.Input[builtins.str]] = None,
                 https_only: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['WindowsFunctionAppIdentityArgs', 'WindowsFunctionAppIdentityArgsDict']]] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 site_config: Optional[pulumi.Input[Union['WindowsFunctionAppSiteConfigArgs', 'WindowsFunctionAppSiteConfigArgsDict']]] = None,
                 sticky_settings: Optional[pulumi.Input[Union['WindowsFunctionAppStickySettingsArgs', 'WindowsFunctionAppStickySettingsArgsDict']]] = None,
                 storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsFunctionAppStorageAccountArgs', 'WindowsFunctionAppStorageAccountArgsDict']]]]] = None,
                 storage_key_vault_secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_uses_managed_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_network_backup_restore_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 vnet_image_pull_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 zip_deploy_file: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WindowsFunctionAppArgs.__new__(WindowsFunctionAppArgs)

            __props__.__dict__["app_settings"] = app_settings
            __props__.__dict__["auth_settings"] = auth_settings
            __props__.__dict__["auth_settings_v2"] = auth_settings_v2
            __props__.__dict__["backup"] = backup
            __props__.__dict__["builtin_logging_enabled"] = builtin_logging_enabled
            __props__.__dict__["client_certificate_enabled"] = client_certificate_enabled
            __props__.__dict__["client_certificate_exclusion_paths"] = client_certificate_exclusion_paths
            __props__.__dict__["client_certificate_mode"] = client_certificate_mode
            __props__.__dict__["connection_strings"] = connection_strings
            __props__.__dict__["content_share_force_disabled"] = content_share_force_disabled
            __props__.__dict__["daily_memory_time_quota"] = daily_memory_time_quota
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ftp_publish_basic_authentication_enabled"] = ftp_publish_basic_authentication_enabled
            __props__.__dict__["functions_extension_version"] = functions_extension_version
            __props__.__dict__["https_only"] = https_only
            __props__.__dict__["identity"] = identity
            __props__.__dict__["key_vault_reference_identity_id"] = key_vault_reference_identity_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if service_plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_plan_id'")
            __props__.__dict__["service_plan_id"] = service_plan_id
            if site_config is None and not opts.urn:
                raise TypeError("Missing required property 'site_config'")
            __props__.__dict__["site_config"] = site_config
            __props__.__dict__["sticky_settings"] = sticky_settings
            __props__.__dict__["storage_account_access_key"] = None if storage_account_access_key is None else pulumi.Output.secret(storage_account_access_key)
            __props__.__dict__["storage_account_name"] = storage_account_name
            __props__.__dict__["storage_accounts"] = storage_accounts
            __props__.__dict__["storage_key_vault_secret_id"] = storage_key_vault_secret_id
            __props__.__dict__["storage_uses_managed_identity"] = storage_uses_managed_identity
            __props__.__dict__["tags"] = tags
            __props__.__dict__["virtual_network_backup_restore_enabled"] = virtual_network_backup_restore_enabled
            __props__.__dict__["virtual_network_subnet_id"] = virtual_network_subnet_id
            __props__.__dict__["vnet_image_pull_enabled"] = vnet_image_pull_enabled
            __props__.__dict__["webdeploy_publish_basic_authentication_enabled"] = webdeploy_publish_basic_authentication_enabled
            __props__.__dict__["zip_deploy_file"] = zip_deploy_file
            __props__.__dict__["custom_domain_verification_id"] = None
            __props__.__dict__["default_hostname"] = None
            __props__.__dict__["hosting_environment_id"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["outbound_ip_address_lists"] = None
            __props__.__dict__["outbound_ip_addresses"] = None
            __props__.__dict__["possible_outbound_ip_address_lists"] = None
            __props__.__dict__["possible_outbound_ip_addresses"] = None
            __props__.__dict__["site_credentials"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["customDomainVerificationId", "siteCredentials", "storageAccountAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WindowsFunctionApp, __self__).__init__(
            'azure:appservice/windowsFunctionApp:WindowsFunctionApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            auth_settings: Optional[pulumi.Input[Union['WindowsFunctionAppAuthSettingsArgs', 'WindowsFunctionAppAuthSettingsArgsDict']]] = None,
            auth_settings_v2: Optional[pulumi.Input[Union['WindowsFunctionAppAuthSettingsV2Args', 'WindowsFunctionAppAuthSettingsV2ArgsDict']]] = None,
            backup: Optional[pulumi.Input[Union['WindowsFunctionAppBackupArgs', 'WindowsFunctionAppBackupArgsDict']]] = None,
            builtin_logging_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            client_certificate_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            client_certificate_exclusion_paths: Optional[pulumi.Input[builtins.str]] = None,
            client_certificate_mode: Optional[pulumi.Input[builtins.str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsFunctionAppConnectionStringArgs', 'WindowsFunctionAppConnectionStringArgsDict']]]]] = None,
            content_share_force_disabled: Optional[pulumi.Input[builtins.bool]] = None,
            custom_domain_verification_id: Optional[pulumi.Input[builtins.str]] = None,
            daily_memory_time_quota: Optional[pulumi.Input[builtins.int]] = None,
            default_hostname: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            functions_extension_version: Optional[pulumi.Input[builtins.str]] = None,
            hosting_environment_id: Optional[pulumi.Input[builtins.str]] = None,
            https_only: Optional[pulumi.Input[builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['WindowsFunctionAppIdentityArgs', 'WindowsFunctionAppIdentityArgsDict']]] = None,
            key_vault_reference_identity_id: Optional[pulumi.Input[builtins.str]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            outbound_ip_addresses: Optional[pulumi.Input[builtins.str]] = None,
            possible_outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            possible_outbound_ip_addresses: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            service_plan_id: Optional[pulumi.Input[builtins.str]] = None,
            site_config: Optional[pulumi.Input[Union['WindowsFunctionAppSiteConfigArgs', 'WindowsFunctionAppSiteConfigArgsDict']]] = None,
            site_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsFunctionAppSiteCredentialArgs', 'WindowsFunctionAppSiteCredentialArgsDict']]]]] = None,
            sticky_settings: Optional[pulumi.Input[Union['WindowsFunctionAppStickySettingsArgs', 'WindowsFunctionAppStickySettingsArgsDict']]] = None,
            storage_account_access_key: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_name: Optional[pulumi.Input[builtins.str]] = None,
            storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsFunctionAppStorageAccountArgs', 'WindowsFunctionAppStorageAccountArgsDict']]]]] = None,
            storage_key_vault_secret_id: Optional[pulumi.Input[builtins.str]] = None,
            storage_uses_managed_identity: Optional[pulumi.Input[builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            virtual_network_backup_restore_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            virtual_network_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            vnet_image_pull_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            zip_deploy_file: Optional[pulumi.Input[builtins.str]] = None) -> 'WindowsFunctionApp':
        """
        Get an existing WindowsFunctionApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] app_settings: A map of key-value pairs for [App
               Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        :param pulumi.Input[Union['WindowsFunctionAppAuthSettingsArgs', 'WindowsFunctionAppAuthSettingsArgsDict']] auth_settings: A `auth_settings` block as defined below.
        :param pulumi.Input[Union['WindowsFunctionAppAuthSettingsV2Args', 'WindowsFunctionAppAuthSettingsV2ArgsDict']] auth_settings_v2: A `auth_settings_v2` block as defined below.
        :param pulumi.Input[Union['WindowsFunctionAppBackupArgs', 'WindowsFunctionAppBackupArgsDict']] backup: A `backup` block as defined below.
        :param pulumi.Input[builtins.bool] builtin_logging_enabled: Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        :param pulumi.Input[builtins.bool] client_certificate_enabled: Should the function app use Client Certificates.
        :param pulumi.Input[builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[builtins.str] client_certificate_mode: The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsFunctionAppConnectionStringArgs', 'WindowsFunctionAppConnectionStringArgsDict']]]] connection_strings: One or more `connection_string` blocks as defined below.
        :param pulumi.Input[builtins.bool] content_share_force_disabled: Should Content Share Settings be disabled. Defaults to `false`.
        :param pulumi.Input[builtins.str] custom_domain_verification_id: The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        :param pulumi.Input[builtins.int] daily_memory_time_quota: The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan. Defaults to `0`.
        :param pulumi.Input[builtins.str] default_hostname: The default hostname of the Windows Function App.
        :param pulumi.Input[builtins.bool] enabled: Is the Function App enabled? Defaults to `true`.
        :param pulumi.Input[builtins.bool] ftp_publish_basic_authentication_enabled: Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] functions_extension_version: The runtime version associated with the Function App. Defaults to `~4`.
        :param pulumi.Input[builtins.str] hosting_environment_id: The ID of the App Service Environment used by Function App.
        :param pulumi.Input[builtins.bool] https_only: Can the Function App only be accessed via HTTPS?. Defaults to `false`.
        :param pulumi.Input[Union['WindowsFunctionAppIdentityArgs', 'WindowsFunctionAppIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.str] key_vault_reference_identity_id: The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        :param pulumi.Input[builtins.str] kind: The Kind value for this Windows Function App.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Windows Function App. Changing this forces a new Windows Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] outbound_ip_address_lists: A list of outbound IP addresses. For example `["52.23.25.3", "52.143.43.12"]`
        :param pulumi.Input[builtins.str] outbound_ip_addresses: A comma separated list of outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] possible_outbound_ip_address_lists: A list of possible outbound IP addresses, not all of which are necessarily in use. This is a superset of `outbound_ip_address_list`. For example `["52.23.25.3", "52.143.43.12"]`.
        :param pulumi.Input[builtins.str] possible_outbound_ip_addresses: A comma separated list of possible outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12,52.143.43.17`. This is a superset of `outbound_ip_addresses`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Should public network access be enabled for the Function App. Defaults to `true`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        :param pulumi.Input[builtins.str] service_plan_id: The ID of the App Service Plan within which to create this Function App.
        :param pulumi.Input[Union['WindowsFunctionAppSiteConfigArgs', 'WindowsFunctionAppSiteConfigArgsDict']] site_config: A `site_config` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsFunctionAppSiteCredentialArgs', 'WindowsFunctionAppSiteCredentialArgsDict']]]] site_credentials: A `site_credential` block as defined below.
        :param pulumi.Input[Union['WindowsFunctionAppStickySettingsArgs', 'WindowsFunctionAppStickySettingsArgsDict']] sticky_settings: A `sticky_settings` block as defined below.
        :param pulumi.Input[builtins.str] storage_account_access_key: The access key which will be used to access the backend storage account for the Function App. Conflicts with `storage_uses_managed_identity`.
        :param pulumi.Input[builtins.str] storage_account_name: The backend storage account name which will be used by this Function App.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsFunctionAppStorageAccountArgs', 'WindowsFunctionAppStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` blocks as defined below.
        :param pulumi.Input[builtins.str] storage_key_vault_secret_id: The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.
               
               > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.
               
               > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        :param pulumi.Input[builtins.bool] storage_uses_managed_identity: Should the Function App use Managed Identity to access the storage account. Conflicts with `storage_account_access_key`.
               
               > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Windows Function App.
        :param pulumi.Input[builtins.bool] virtual_network_backup_restore_enabled: Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] vnet_image_pull_enabled: Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.
               
               > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for app running in the App Service Environment.
        :param pulumi.Input[builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
               
               > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        :param pulumi.Input[builtins.str] zip_deploy_file: The local path and filename of the Zip packaged application to deploy to this Windows Function App.
               
               > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WindowsFunctionAppState.__new__(_WindowsFunctionAppState)

        __props__.__dict__["app_settings"] = app_settings
        __props__.__dict__["auth_settings"] = auth_settings
        __props__.__dict__["auth_settings_v2"] = auth_settings_v2
        __props__.__dict__["backup"] = backup
        __props__.__dict__["builtin_logging_enabled"] = builtin_logging_enabled
        __props__.__dict__["client_certificate_enabled"] = client_certificate_enabled
        __props__.__dict__["client_certificate_exclusion_paths"] = client_certificate_exclusion_paths
        __props__.__dict__["client_certificate_mode"] = client_certificate_mode
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["content_share_force_disabled"] = content_share_force_disabled
        __props__.__dict__["custom_domain_verification_id"] = custom_domain_verification_id
        __props__.__dict__["daily_memory_time_quota"] = daily_memory_time_quota
        __props__.__dict__["default_hostname"] = default_hostname
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ftp_publish_basic_authentication_enabled"] = ftp_publish_basic_authentication_enabled
        __props__.__dict__["functions_extension_version"] = functions_extension_version
        __props__.__dict__["hosting_environment_id"] = hosting_environment_id
        __props__.__dict__["https_only"] = https_only
        __props__.__dict__["identity"] = identity
        __props__.__dict__["key_vault_reference_identity_id"] = key_vault_reference_identity_id
        __props__.__dict__["kind"] = kind
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_ip_address_lists"] = outbound_ip_address_lists
        __props__.__dict__["outbound_ip_addresses"] = outbound_ip_addresses
        __props__.__dict__["possible_outbound_ip_address_lists"] = possible_outbound_ip_address_lists
        __props__.__dict__["possible_outbound_ip_addresses"] = possible_outbound_ip_addresses
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["service_plan_id"] = service_plan_id
        __props__.__dict__["site_config"] = site_config
        __props__.__dict__["site_credentials"] = site_credentials
        __props__.__dict__["sticky_settings"] = sticky_settings
        __props__.__dict__["storage_account_access_key"] = storage_account_access_key
        __props__.__dict__["storage_account_name"] = storage_account_name
        __props__.__dict__["storage_accounts"] = storage_accounts
        __props__.__dict__["storage_key_vault_secret_id"] = storage_key_vault_secret_id
        __props__.__dict__["storage_uses_managed_identity"] = storage_uses_managed_identity
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_network_backup_restore_enabled"] = virtual_network_backup_restore_enabled
        __props__.__dict__["virtual_network_subnet_id"] = virtual_network_subnet_id
        __props__.__dict__["vnet_image_pull_enabled"] = vnet_image_pull_enabled
        __props__.__dict__["webdeploy_publish_basic_authentication_enabled"] = webdeploy_publish_basic_authentication_enabled
        __props__.__dict__["zip_deploy_file"] = zip_deploy_file
        return WindowsFunctionApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of key-value pairs for [App
        Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
        """
        return pulumi.get(self, "app_settings")

    @property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> pulumi.Output[Optional['outputs.WindowsFunctionAppAuthSettings']]:
        """
        A `auth_settings` block as defined below.
        """
        return pulumi.get(self, "auth_settings")

    @property
    @pulumi.getter(name="authSettingsV2")
    def auth_settings_v2(self) -> pulumi.Output[Optional['outputs.WindowsFunctionAppAuthSettingsV2']]:
        """
        A `auth_settings_v2` block as defined below.
        """
        return pulumi.get(self, "auth_settings_v2")

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Output[Optional['outputs.WindowsFunctionAppBackup']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter(name="builtinLoggingEnabled")
    def builtin_logging_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        """
        return pulumi.get(self, "builtin_logging_enabled")

    @property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the function app use Client Certificates.
        """
        return pulumi.get(self, "client_certificate_enabled")

    @property
    @pulumi.getter(name="clientCertificateExclusionPaths")
    def client_certificate_exclusion_paths(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Paths to exclude when using client certificates, separated by ;
        """
        return pulumi.get(self, "client_certificate_exclusion_paths")

    @property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The mode of the Function App's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Optional[Sequence['outputs.WindowsFunctionAppConnectionString']]]:
        """
        One or more `connection_string` blocks as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @property
    @pulumi.getter(name="contentShareForceDisabled")
    def content_share_force_disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should Content Share Settings be disabled. Defaults to `false`.
        """
        return pulumi.get(self, "content_share_force_disabled")

    @property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @property
    @pulumi.getter(name="dailyMemoryTimeQuota")
    def daily_memory_time_quota(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps under the consumption plan. Defaults to `0`.
        """
        return pulumi.get(self, "daily_memory_time_quota")

    @property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> pulumi.Output[builtins.str]:
        """
        The default hostname of the Windows Function App.
        """
        return pulumi.get(self, "default_hostname")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is the Function App enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ftpPublishBasicAuthenticationEnabled")
    def ftp_publish_basic_authentication_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ftp_publish_basic_authentication_enabled")

    @property
    @pulumi.getter(name="functionsExtensionVersion")
    def functions_extension_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The runtime version associated with the Function App. Defaults to `~4`.
        """
        return pulumi.get(self, "functions_extension_version")

    @property
    @pulumi.getter(name="hostingEnvironmentId")
    def hosting_environment_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the App Service Environment used by Function App.
        """
        return pulumi.get(self, "hosting_environment_id")

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> pulumi.Output[builtins.bool]:
        """
        Can the Function App only be accessed via HTTPS?. Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.WindowsFunctionAppIdentity']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="keyVaultReferenceIdentityId")
    def key_vault_reference_identity_id(self) -> pulumi.Output[builtins.str]:
        """
        The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        """
        return pulumi.get(self, "key_vault_reference_identity_id")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[builtins.str]:
        """
        The Kind value for this Windows Function App.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Windows Function App. Changing this forces a new Windows Function App to be created. Limit the function name to 32 characters to avoid naming collisions. For more information about [Function App naming rule](https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/resource-name-rules#microsoftweb) and [Host ID Collisions](https://github.com/Azure/azure-functions-host/wiki/Host-IDs#host-id-collisions)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundIpAddressLists")
    def outbound_ip_address_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of outbound IP addresses. For example `["52.23.25.3", "52.143.43.12"]`
        """
        return pulumi.get(self, "outbound_ip_address_lists")

    @property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> pulumi.Output[builtins.str]:
        """
        A comma separated list of outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12`.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @property
    @pulumi.getter(name="possibleOutboundIpAddressLists")
    def possible_outbound_ip_address_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of possible outbound IP addresses, not all of which are necessarily in use. This is a superset of `outbound_ip_address_list`. For example `["52.23.25.3", "52.143.43.12"]`.
        """
        return pulumi.get(self, "possible_outbound_ip_address_lists")

    @property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> pulumi.Output[builtins.str]:
        """
        A comma separated list of possible outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12,52.143.43.17`. This is a superset of `outbound_ip_addresses`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should public network access be enabled for the Function App. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Windows Function App should exist. Changing this forces a new Windows Function App to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="servicePlanId")
    def service_plan_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the App Service Plan within which to create this Function App.
        """
        return pulumi.get(self, "service_plan_id")

    @property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> pulumi.Output['outputs.WindowsFunctionAppSiteConfig']:
        """
        A `site_config` block as defined below.
        """
        return pulumi.get(self, "site_config")

    @property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> pulumi.Output[Sequence['outputs.WindowsFunctionAppSiteCredential']]:
        """
        A `site_credential` block as defined below.
        """
        return pulumi.get(self, "site_credentials")

    @property
    @pulumi.getter(name="stickySettings")
    def sticky_settings(self) -> pulumi.Output[Optional['outputs.WindowsFunctionAppStickySettings']]:
        """
        A `sticky_settings` block as defined below.
        """
        return pulumi.get(self, "sticky_settings")

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The access key which will be used to access the backend storage account for the Function App. Conflicts with `storage_uses_managed_identity`.
        """
        return pulumi.get(self, "storage_account_access_key")

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The backend storage account name which will be used by this Function App.
        """
        return pulumi.get(self, "storage_account_name")

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> pulumi.Output[Optional[Sequence['outputs.WindowsFunctionAppStorageAccount']]]:
        """
        One or more `storage_account` blocks as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @property
    @pulumi.getter(name="storageKeyVaultSecretId")
    def storage_key_vault_secret_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.

        > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.

        > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        """
        return pulumi.get(self, "storage_key_vault_secret_id")

    @property
    @pulumi.getter(name="storageUsesManagedIdentity")
    def storage_uses_managed_identity(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the Function App use Managed Identity to access the storage account. Conflicts with `storage_account_access_key`.

        > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        """
        return pulumi.get(self, "storage_uses_managed_identity")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Windows Function App.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="virtualNetworkBackupRestoreEnabled")
    def virtual_network_backup_restore_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "virtual_network_backup_restore_enabled")

    @property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @property
    @pulumi.getter(name="vnetImagePullEnabled")
    def vnet_image_pull_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.

        > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for app running in the App Service Environment.
        """
        return pulumi.get(self, "vnet_image_pull_enabled")

    @property
    @pulumi.getter(name="webdeployPublishBasicAuthenticationEnabled")
    def webdeploy_publish_basic_authentication_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.

        > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        """
        return pulumi.get(self, "webdeploy_publish_basic_authentication_enabled")

    @property
    @pulumi.getter(name="zipDeployFile")
    def zip_deploy_file(self) -> pulumi.Output[builtins.str]:
        """
        The local path and filename of the Zip packaged application to deploy to this Windows Function App.

        > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://learn.microsoft.com/en-us/azure/azure-functions/functions-deployment-technologies) for further details.
        """
        return pulumi.get(self, "zip_deploy_file")

